; 03/17/2015 LBE: Created

PRO get_ace_swics_v2_2hr
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, 'A_S', 'ace_swics_v2_2hr', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
line = ''
ifwd = 0 
num_files    = n_elements(filesfound)
times        = strarr(num_files * 366 * 12)
he_vel       = fltarr(num_files * 366 * 12)
he_vth       = fltarr(num_files * 366 * 12)
he_vel_err   = fltarr(num_files * 366 * 12)
he_vth_err   = fltarr(num_files * 366 * 12)
he_qf        = fltarr(num_files * 366 * 12)
c_6_5        = fltarr(num_files * 366 * 12)
c_6_5_err    = fltarr(num_files * 366 * 12)
c_6_5_qf     = fltarr(num_files * 366 * 12)
o_7_6        = fltarr(num_files * 366 * 12)
o_7_6_err    = fltarr(num_files * 366 * 12)
o_7_6_qf     = fltarr(num_files * 366 * 12)
o_8_6        = fltarr(num_files * 366 * 12)
o_8_6_err    = fltarr(num_files * 366 * 12)
o_8_6_qf     = fltarr(num_files * 366 * 12)
fe_av_q      = fltarr(num_files * 366 * 12)
fe_av_q_err  = fltarr(num_files * 366 * 12)
fe_av_q_qf   = fltarr(num_files * 366 * 12)
fe_o         = fltarr(num_files * 366 * 12)
fe_o_err     = fltarr(num_files * 366 * 12)
fe_o_qf      = fltarr(num_files * 366 * 12)


kk = 0L

FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        openr, in_lun, filesfound[jj], /get_lun
        FOR ii = 0, 30 DO BEGIN ; read through header
            readf, in_lun, line
        ENDFOR

        finished_file = 0
        WHILE eof(in_lun) EQ 0 AND finished_file EQ 0 DO BEGIN 
            readf, in_lun, line
            parts = strsplit(line, /extract)
            doy_to_month_date, fix(parts[0]), fix(parts[1]), month, date
            temp_string = parts[0]+'-'+string(month, format = '(I2.2)')+'-'+string(date, format = '(I2.2)')+'/'
            IF strlen(parts[2]) EQ 1 THEN temp_string = temp_string+'0'
            temp_string = temp_string + parts[2]+':' ; hour
            IF strlen(parts[3]) EQ 1 THEN temp_string = temp_string+'0'
            temp_string = temp_string + parts[3]+':' ; minute
            temp_parts = strsplit(parts[4], '.', /extract)
            IF strlen(temp_parts[0]) EQ 1 THEN temp_string = temp_string+'0'
            temp_string = temp_string + temp_parts[0]+':' ; second
            times       [kk] = temp_string
            he_vel      [kk] = float(parts[08])
            he_vth      [kk] = float(parts[09])
            he_vel_err  [kk] = float(parts[10])
            he_vth_err  [kk] = float(parts[11])
            he_qf       [kk] = float(parts[12])
            c_6_5       [kk] = float(parts[13])
            c_6_5_err   [kk] = float(parts[14])
            c_6_5_qf    [kk] = float(parts[15])
            o_7_6       [kk] = float(parts[16])
            o_7_6_err   [kk] = float(parts[17])
            o_7_6_qf    [kk] = float(parts[18])
            o_8_6       [kk] = float(parts[19])
            o_8_6_err   [kk] = float(parts[20])
            o_8_6_qf    [kk] = float(parts[21])
            fe_av_q     [kk] = float(parts[22])
            fe_av_q_err [kk] = float(parts[23])
            fe_av_q_qf  [kk] = float(parts[24])
            fe_o        [kk] = float(parts[25])
            fe_o_err    [kk] = float(parts[26])
            fe_o_qf     [kk] = float(parts[27])

            kk = kk + 1
            ifwd =  ifwd + 1
        ENDWHILE 
    ENDIF
    close, in_lun
    free_lun, in_lun
ENDFOR

; take out empty elements
bad_i = where(times EQ '', bad_count, complement = good_i, ncomplement = good_count)
IF bad_count GT 0 AND good_count GT 0 THEN BEGIN
    times        = times       [good_i]
    he_vel       = he_vel      [good_i]
    he_vth       = he_vth      [good_i]
    he_vel_err   = he_vel_err  [good_i]
    he_vth_err   = he_vth_err  [good_i]
    he_qf        = he_qf       [good_i]
    c_6_5        = c_6_5       [good_i]  
    c_6_5_err    = c_6_5_err   [good_i]  
    c_6_5_qf     = c_6_5_qf    [good_i]  
    o_7_6        = o_7_6       [good_i]  
    o_7_6_err    = o_7_6_err   [good_i]  
    o_7_6_qf     = o_7_6_qf    [good_i]  
    o_8_6        = o_8_6       [good_i]  
    o_8_6_err    = o_8_6_err   [good_i]  
    o_8_6_qf     = o_8_6_qf    [good_i]  
    fe_av_q      = fe_av_q     [good_i]  
    fe_av_q_err  = fe_av_q_err [good_i]  
    fe_av_q_qf   = fe_av_q_qf  [good_i]  
    fe_o         = fe_o        [good_i]  
    fe_o_err     = fe_o_err    [good_i]  
    fe_o_qf      = fe_o_qf     [good_i]  
ENDIF 

times = time_double(times)
; take out times outside range
get_timespan, timespan
good_i = where(times GE timespan[0] AND times LE timespan[1], count)
IF count GT 0 THEN BEGIN
    times        = times       [good_i]
    he_vel       = he_vel      [good_i]
    he_vth       = he_vth      [good_i]
    he_vel_err   = he_vel_err  [good_i]
    he_vth_err   = he_vth_err  [good_i]
    he_qf        = he_qf       [good_i]
    c_6_5        = c_6_5       [good_i]  
    c_6_5_err    = c_6_5_err   [good_i]  
    c_6_5_qf     = c_6_5_qf    [good_i]  
    o_7_6        = o_7_6       [good_i]  
    o_7_6_err    = o_7_6_err   [good_i]  
    o_7_6_qf     = o_7_6_qf    [good_i]  
    o_8_6        = o_8_6       [good_i]  
    o_8_6_err    = o_8_6_err   [good_i]  
    o_8_6_qf     = o_8_6_qf    [good_i]  
    fe_av_q      = fe_av_q     [good_i]  
    fe_av_q_err  = fe_av_q_err [good_i]  
    fe_av_q_qf   = fe_av_q_qf  [good_i]  
    fe_o         = fe_o        [good_i]  
    fe_o_err     = fe_o_err    [good_i]  
    fe_o_qf      = fe_o_qf     [good_i]  
ENDIF 

; take out times where there is bad data (-9999.9)
bad_he_vel_i   = where(he_vel   LT -9999.0, bad_he_vel_count)
bad_he_vth_i   = where(he_vth   LT -9999.0, bad_he_vth_count)
bad_c_6_5_i    = where(c_6_5    LT -9999.0, bad_c_6_5_count)  
bad_o_7_6_i    = where(o_7_6    LT -9999.0, bad_o_7_6_count)  
bad_o_8_6_i    = where(o_8_6    LT -9999.0, bad_o_8_6_count)  
bad_fe_av_q_i  = where(fe_av_q  LT -9999.0, bad_fe_av_q_count)  
bad_fe_o_i     = where(fe_o     LT -9999.0, bad_fe_o_count)  
IF bad_he_vel_count   GT 0 THEN he_vel   [bad_he_vel_i  ] = !values.f_nan
IF bad_he_vth_count   GT 0 THEN he_vth   [bad_he_vth_i  ] = !values.f_nan
IF bad_c_6_5_count    GT 0 THEN c_6_5    [bad_c_6_5_i   ] = !values.f_nan  
IF bad_o_7_6_count    GT 0 THEN o_7_6    [bad_o_7_6_i   ] = !values.f_nan  
IF bad_o_8_6_count    GT 0 THEN o_8_6    [bad_o_8_6_i   ] = !values.f_nan  
IF bad_fe_av_q_count  GT 0 THEN fe_av_q  [bad_fe_av_q_i ] = !values.f_nan  
IF bad_fe_o_count     GT 0 THEN fe_o     [bad_fe_o_i    ] = !values.f_nan  

; make copy for no_err version
he_vel_no_err   = he_vel      
he_vth_no_err   = he_vth      
c_6_5_no_err    = c_6_5        
o_7_6_no_err    = o_7_6        
o_8_6_no_err    = o_8_6        
fe_av_q_no_err  = fe_av_q      
fe_o_no_err     = fe_o         

; take out times with bad quality flag
bad_he_i       = where(he_qf      GT 0, bad_he_count)
bad_c_6_5_i    = where(c_6_5_qf   GT 0, bad_c_6_5_count)  
bad_o_7_6_i    = where(o_7_6_qf   GT 0, bad_o_7_6_count)  
bad_o_8_6_i    = where(o_8_6_qf   GT 0, bad_o_8_6_count)  
bad_fe_av_q_i  = where(fe_av_q_qf GT 0, bad_fe_av_q_count)  
bad_fe_o_i     = where(fe_o_qf    GT 0, bad_fe_o_count)  
IF bad_he_count    GT 0 THEN BEGIN 
    he_vel_no_err   [bad_he_i   ] = !values.f_nan
    he_vth_no_err   [bad_he_i   ] = !values.f_nan
ENDIF 
IF bad_c_6_5_count    GT 0 THEN c_6_5_no_err  [bad_c_6_5_i   ] = !values.f_nan  
IF bad_o_7_6_count    GT 0 THEN o_7_6_no_err  [bad_o_7_6_i   ] = !values.f_nan  
IF bad_o_8_6_count    GT 0 THEN o_8_6_no_err  [bad_o_8_6_i   ] = !values.f_nan  
IF bad_fe_av_q_count  GT 0 THEN fe_av_q_no_err[bad_fe_av_q_i ] = !values.f_nan  
IF bad_fe_o_count     GT 0 THEN fe_o_no_err   [bad_fe_o_i    ] = !values.f_nan  


IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(times LT (time_double('1958-01-01')) OR $
                 times GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = 'ace_swics_'

; with error included
store_data, varstr+'alpha_velocity_v2_2hr', $
            data = {x:times, y:he_vel}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV (km s!U-1!N)'}
store_data, varstr+'alpha_v_therm_v2_2hr', $
            data = {x:times, y:he_vth}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV_Therm (km s!U-1!N)'}
store_data, varstr+'c_6_5_v2_2hr', $
            data = {x:times, y:c_6_5}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon 6/5'}
store_data, varstr+'o_7_6_v2_2hr', $
            data = {x:times, y:o_7_6}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen 7/6'}
store_data, varstr+'o_8_6_v2_2hr', $
            data = {x:times, y:o_8_6}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen 8/6'}
store_data, varstr+'fe_av_q_v2_2hr', $
            data = {x:times, y:fe_av_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron Ave. Q'}
store_data, varstr+'fe_o_v2_2hr', $
            data = {x:times, y:fe_o}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron/Oxygen'}
; no error included
store_data, varstr+'alpha_velocity_v2_2hr_no_err', $
            data = {x:times, y:he_vel_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV (km s!U-1!N)'}
store_data, varstr+'alpha_v_therm_v2_2hr_no_err', $
            data = {x:times, y:he_vth_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'alpha!C!CV_Therm (km s!U-1!N)'}
store_data, varstr+'c_6_5_v2_2hr_no_err', $
            data = {x:times, y:c_6_5_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Carbon 6/5'}
store_data, varstr+'o_7_6_v2_2hr_no_err', $
            data = {x:times, y:o_7_6_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen 7/6'}
store_data, varstr+'o_8_6_v2_2hr_no_err', $
            data = {x:times, y:o_8_6_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen 8/6'}
store_data, varstr+'fe_av_q_v2_2hr_no_err', $
            data = {x:times, y:fe_av_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron Ave. Q'}
store_data, varstr+'fe_o_v2_2hr_no_err', $
            data = {x:times, y:fe_o_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron/Oxygen'}

END
