; 11/18/2009 LBE: Created
; 01/05/2010 LBE: Properly close file.

PRO get_ace_swics_qstates
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, 'A_S', 'ace_swics_q', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
line = ''
ifwd = 0 
num_files   = n_elements(filesfound)
times       = strarr(num_files * 366 * 24)
c_q         = fltarr(num_files * 366 * 24, 3)
o_q         = fltarr(num_files * 366 * 24, 4)
NE_q        = fltarr(num_files * 366 * 24, 4)
mg_q        = fltarr(num_files * 366 * 24, 7)
si_q        = fltarr(num_files * 366 * 24, 7)
fe_q        = fltarr(num_files * 366 * 24, 15)
c_q_err     = fltarr(num_files * 366 * 24, 3)
o_q_err     = fltarr(num_files * 366 * 24, 4)
NE_q_err    = fltarr(num_files * 366 * 24, 4)
mg_q_err    = fltarr(num_files * 366 * 24, 7)
si_q_err    = fltarr(num_files * 366 * 24, 7)
fe_q_err    = fltarr(num_files * 366 * 24, 15)

kk = 0L
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        openr, in_lun, filesfound[jj], /get_lun
        FOR ii = 0, 26 DO BEGIN ; read through header
            readf, in_lun, line
        ENDFOR

        finished_file = 0
        WHILE eof(in_lun) EQ 0 AND finished_file EQ 0 DO BEGIN 
            readf, in_lun, line
            parts = strsplit(line, /extract)
            doy_to_month_date, fix(parts[0]), fix(parts[1]), month, date
            temp_string = parts[0]+'-'+string(month, format = '(I2.2)')+'-'+string(date, format = '(I2.2)')+'/'
            IF strlen(parts[2]) EQ 1 THEN temp_string = temp_string+'0'
            temp_string = temp_string + parts[2]+':' ; hour
            IF strlen(parts[3]) EQ 1 THEN temp_string = temp_string+'0'
            temp_string = temp_string + parts[3]+':' ; minute
            temp_parts = strsplit(parts[4], '.', /extract)
            IF strlen(temp_parts[0]) EQ 1 THEN temp_string = temp_string+'0'
            temp_string = temp_string + temp_parts[0]+':' ; second
            times   [kk] = temp_string
            c_q     [kk, *] = float(parts[08:10])
            o_q     [kk, *] = float(parts[11:14])
            NE_q    [kk, *] = float(parts[15:18])
            mg_q    [kk, *] = float(parts[19:25])
            si_q    [kk, *] = float(parts[26:32])
            fe_q    [kk, *] = float(parts[33:47])
            c_q_err [kk, *] = float(parts[48:50])
            o_q_err [kk, *] = float(parts[51:54])
            NE_q_err[kk, *] = float(parts[55:58])
            mg_q_err[kk, *] = float(parts[59:65])
            si_q_err[kk, *] = float(parts[66:72])
            fe_q_err[kk, *] = float(parts[72:86])

            kk = kk + 1
            ifwd =  ifwd + 1
        ENDWHILE 
    ENDIF
    close, in_lun
    free_lun, in_lun
ENDFOR

; take out empty elements
bad_i = where(times EQ '', bad_count, complement = good_i, ncomplement = good_count)
IF bad_count GT 0 AND good_count GT 0 THEN BEGIN
    times    = times   [good_i]
    c_q      = c_q     [good_i, *]
    o_q      = o_q     [good_i, *]
    ne_q     = ne_q    [good_i, *]
    mg_q     = mg_q    [good_i, *]  
    si_q     = si_q    [good_i, *]  
    fe_q     = fe_q    [good_i, *]  
    c_q_err  = c_q_err [good_i, *]
    o_q_err  = o_q_err [good_i, *]
    ne_q_err = ne_q_err[good_i, *]
    mg_q_err = mg_q_err[good_i, *]  
    si_q_err = si_q_err[good_i, *]  
    fe_q_err = fe_q_err[good_i, *]  
ENDIF 

times = time_double(times)
; take out times outside range
get_timespan, timespan
good_i = where(times GE timespan[0] AND times LE timespan[1], count)
IF count GT 0 THEN BEGIN
    times    = times   [good_i]
    c_q      = c_q     [good_i, *]
    o_q      = o_q     [good_i, *]
    ne_q     = ne_q    [good_i, *]
    mg_q     = mg_q    [good_i, *]  
    si_q     = si_q    [good_i, *]  
    fe_q     = fe_q    [good_i, *]  
    c_q_err  = c_q_err [good_i, *]
    o_q_err  = o_q_err [good_i, *]
    ne_q_err = ne_q_err[good_i, *]
    mg_q_err = mg_q_err[good_i, *]  
    si_q_err = si_q_err[good_i, *]  
    fe_q_err = fe_q_err[good_i, *]  
ENDIF 

; take out times where there is bad data (-1)
bad_c_q_i  = where(c_q  LT 0, bad_c_q_count)
bad_o_q_i  = where(o_q  LT 0, bad_o_q_count)
bad_ne_q_i = where(ne_q LT 0, bad_ne_q_count)
bad_mg_q_i = where(mg_q LT 0, bad_mg_q_count)  
bad_si_q_i = where(si_q LT 0, bad_si_q_count)  
bad_fe_q_i = where(fe_q LT 0, bad_fe_q_count)  
IF bad_c_q_count  GT 0 THEN c_q [bad_c_q_i ] = !values.f_nan
IF bad_o_q_count  GT 0 THEN o_q [bad_o_q_i ] = !values.f_nan
IF bad_ne_q_count GT 0 THEN ne_q[bad_ne_q_i] = !values.f_nan
IF bad_mg_q_count GT 0 THEN mg_q[bad_mg_q_i] = !values.f_nan  
IF bad_si_q_count GT 0 THEN si_q[bad_si_q_i] = !values.f_nan  
IF bad_fe_q_count GT 0 THEN fe_q[bad_fe_q_i] = !values.f_nan  

; make copy for no_err version
c_q_no_err  = c_q     
o_q_no_err  = o_q     
ne_q_no_err = ne_q    
mg_q_no_err = mg_q      
si_q_no_err = si_q      
fe_q_no_err = fe_q      

; take out times with bad quality flag (same dimensions as data)
bad_c_q_i  = where(c_q_err  GT 0, bad_c_q_count)
bad_o_q_i  = where(o_q_err  GT 0, bad_o_q_count)  
bad_ne_q_i = where(ne_q_err GT 0, bad_ne_q_count)  
bad_mg_q_i = where(mg_q_err GT 0, bad_mg_q_count)  
bad_si_q_i = where(si_q_err GT 0, bad_si_q_count)  
bad_fe_q_i = where(fe_q_err GT 0, bad_fe_q_count)  
IF bad_c_q_count  GT 0 THEN c_q_no_err [bad_c_q_i ] = !values.f_nan  
IF bad_o_q_count  GT 0 THEN o_q_no_err [bad_o_q_i ] = !values.f_nan  
IF bad_ne_q_count GT 0 THEN ne_q_no_err[bad_ne_q_i] = !values.f_nan  
IF bad_mg_q_count GT 0 THEN mg_q_no_err[bad_mg_q_i] = !values.f_nan  
IF bad_si_q_count GT 0 THEN si_q_no_err[bad_si_q_i] = !values.f_nan  
IF bad_fe_q_count GT 0 THEN fe_q_no_err[bad_fe_q_i] = !values.f_nan  

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(times LT (time_double('1958-01-01')) OR $
                 times GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = 'ace_swics_'

; with error included
store_data, varstr+'c_q_2hr', $
            data = {x:times, y:c_q}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Carbon Q'}
store_data, varstr+'o_q_2hr', $
            data = {x:times, y:o_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen Q'}
store_data, varstr+'ne_q_2hr', $
            data = {x:times, y:ne_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Neon Q'}
store_data, varstr+'mg_q_2hr', $
            data = {x:times, y:mg_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Magnesium Q'}
store_data, varstr+'si_q_2hr', $
            data = {x:times, y:si_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Silicon Q'}
store_data, varstr+'fe_q_2hr', $
            data = {x:times, y:fe_q}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron Q'}
; no error included
store_data, varstr+'c_q_2hr_no_err', $
            data = {x:times, y:c_q_no_err}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'Carbon Q'}
store_data, varstr+'o_q_2hr_no_err', $
            data = {x:times, y:o_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Oxygen Q'}
store_data, varstr+'ne_q_2hr_no_err', $
            data = {x:times, y:ne_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Neon Q'}
store_data, varstr+'mg_q_2hr_no_err', $
            data = {x:times, y:mg_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Magnesium Q'}
store_data, varstr+'si_q_2hr_no_err', $
            data = {x:times, y:si_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Silicon Q'}
store_data, varstr+'fe_q_2hr_no_err', $
            data = {x:times, y:fe_q_no_err}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Iron Q'}
END
