#**********************************************************************
#PATHS TO SPLAT SOFTWARE
#**********************************************************************

setenv SOFT $HOME                                                   # <-- edit

#path to splat directory
#-------------------------
setenv SPLAT /data1/Software/SPLAT_latest/splat_latest

#path to splat_user directory
#-------------------------
setenv SPLAT_USER /data1/Software/SPLAT_latest/splat_user_latest

#update idl path (assumes that idl_path is already set)
#------------------------------------------------------
setenv IDL_PATH +/usr/local/itt/idl/lib:+/usr/local/itt/idl/examples
setenv IDL_PATH $IDL_PATH':'+$SPLAT':'+$SPLAT_USER':'

#**********************************************************************
#PATHS TO DATA
#**********************************************************************

#path to level1 data
#-------------------
setenv STA_PLA_L1DATA /data1/Spacecraft_A/Level1/CDFs   # <-- edit
setenv STB_PLA_L1DATA /data2/Spacecraft_B/Level1/CDFs   # <-- edit

#path to level2 data
#-------------------
setenv STA_PLA_L2_ALPHAS_PRELIM /data1/Spacecraft_A/Level2/CDFs/Alphas/Non_valid   # <-- edit
setenv STB_PLA_L2_ALPHAS_PRELIM /data2/Spacecraft_B/Level2/CDFs/Alphas/Non_valid   # <-- edit
setenv STA_PLA_L2OBMOMDATA /data1/Spacecraft_A/Level2/CDFs/OBMoments   # <-- edit
setenv STB_PLA_L2OBMOMDATA /data2/Spacecraft_B/Level2/CDFs/OBMoments   # <-- edit
setenv STA_PLA_L2_1DMAX_VALID /data1/Spacecraft_A/Level2/CDFs/1DMax/Valid/1min   # <-- edit
setenv STB_PLA_L2_1DMAX_VALID /data2/Spacecraft_B/Level2/CDFs/1DMax/Valid/1min   # <-- edit
setenv STA_PLA_L2_1DMAX_PRELIM /data1/Spacecraft_A/Level2/CDFs/1DMax/Non_valid/1min   # <-- edit
setenv STB_PLA_L2_1DMAX_PRELIM /data2/Spacecraft_B/Level2/CDFs/1DMax/Non_valid/1min   # <-- edit

#**********************************************************************
#PATH TO CALIBRATION FILES
#**********************************************************************
setenv PLACAL /data1/Software/SPLAT_latest/cal_data/

#**********************************************************************
#AUX PATHS
#**********************************************************************
setenv WINDDATA /data1/Aux_Data/wind/
setenv ACEDATA /data1/Aux_Data/ace/
setenv STA_MAG_DATA /data1/Aux_Data/mag/
setenv STB_MAG_DATA /data1/Aux_Data/mag/

#path to temporary directory
#---------------------------
setenv SPLAT_TEMP $SPLAT_USER/tmp

#set output directory for plots
#----------------------------------------------
setenv OUT_DIR $SPLAT_USER/Plots

#splat error log file
#--------------------
setenv ERROR_LOG 'OFF'

#splat color table
#--------------------
setenv IDL_CT_FILE $SPLAT/splat_util/papco.tbl

#start idl executing splat_startup
#*******************************
setenv IDL_STARTUP splat_startup
