;+
; PROCEDURE: hk_daily
;
; PURPOSE: To create daily plots that show deflection spectra and
;          on-board moments from 'A' and 'B'
;
; INPUT: Adjust the start_time and end_time
;
; CREATED BY: C. Mouikis
;
; MODIFICATION HISTORY:
;
;   03/28/2007: The options and limits are applied only if the
;               variable exists.
;   04/02/2007: NODISPLAY keyword sends all the display activity to
;               the 'idl.ps' file
;
;-
PRO hk_daily, start_time, end_time, NODISPLAY = NODISPLAY

;start_time = '2007-05-06/00:00:00'
;end_time   = '2007-05-07/00:00:00'

ts = time_struct(start_time)
te = time_struct(end_time)

nofdays = te.daynum - ts.daynum

set_com_mon
ts = time_double(start_time)
FOR ii = 0, nofdays-1 DO BEGIN

    timespan, ts, 1, /DAYS      ; SECONDS, MINUTES, HOURS, DAYS (DEFAULT)

    IF KEYWORD_SET(NODISPLAY) THEN PS = 1 ELSE PS = 0
    sat_hk = [2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 20, 21, 23, 24, 25, 26, 27, 28, 29, 30, $
              31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 50, 51, 52, 53, 54, 55, 56, 57, $
              58, 59, 60, 61, 62, 63, 64, 65]
    sat = 'A'
    pl_plot_hk_daily_from_crib, sat_hk, PS, sat, /INST_COORD
    sat = 'B'
    pl_plot_hk_daily_from_crib, sat_hk, PS, sat, /INST_COORD
    
    ;-----------------------------------------------------------------
    ; Advance time
    ;-----------------------------------------------------------------
    ts = ts + 86400.

    ;-----------------------------------------------------------------
    ; Clear tplot variables
    ;----------------------------------------------------------------
    tplot_names, '*', names = names
    store_data, names, /DEL

ENDFOR

END
