;+
; PROCEDURE: suprathermal_event_total.pro
;
; PURPOSE: This program simply runs all of the programs used to produce the WAP non-SSD suprathermal proton (summed matrix rate 00 & 01) lists
;
; INPUT: Start time, stop time and spacecraft
;The time format for start_time and stop_time is 'YYYY-MM-DD/HH:MM:SS'
;The format for the spacecraft variable, sc, is 'A' of 'B'
;
; OUTPUT: the 4 text files produced from running this program are: New_Background_for_STA(B).txt, Suprathermal_Event_Times_STA(B), and Suprathermal_Event_Analysis_STA(B).txt 
;
; NOTE: SPLAT and Solar Soft must be sourced. 
;
; CREATED BY: J. Barry
;
;-
;EDDIT ABOVE

; 09/27/2012 LBE Edited so don't write out background lists.

pro suprathermal_event_total_mod, sc, start_time, stop_time

dir        = '/nfs/fijidata1/Web/Team/Suprathermals_Team/'
;dir        = '/home/lorna/TempPlots2/'
temp_dir   = '~/Plots/'
;temp_dir   = '~/Plots/'
file_title = 'Suprathermal_Event_Analysis_ST'+sc+'.txt'

read_suprathermal_file_beg, sc, dir, file_title, temp_dir, start_time, stop_time, in_lun, out_lun, event_num, next_line

orig_start_time = start_time
IF n_elements(in_lun) EQ 0 THEN orig_stop_time = '3000-01-01' $
  ELSE IF (eof(in_lun) EQ 1 AND next_line EQ -1) THEN orig_stop_time = '3000-01-01' $
       ELSE orig_stop_time  = stop_time

daily_background_new_mod, sc, start_time, stop_time, orig_stop_time, times, bkgd

suprathermal_event_times_mod, sc, start_time, stop_time, times, bkgd, start_times, stop_times, num_events

suprathermal_event_analysis_mod, sc, orig_start_time, orig_stop_time, start_time, stop_time, start_times, stop_times, num_events, out_lun, event_num, next_line

write_suprathermal_file_end, in_lun, out_lun, event_num, next_line

path      = dir+file_title
temp_path = temp_dir+'temp_'+file_title
cmd = 'cp '+temp_path+' '+path
spawn, cmd
cmd = 'rm '+temp_path
spawn, cmd

END
