;+
;PROCEDURE: create_ob_mom_cdfs
;PURPOSE:
;   Take tplot variables with ob moments in them. Check for when
;   entrance system is off (and exclude that data). Put data in cdfs.
;
;   NOTE: Must be run in SPLAT.
;
;CREATED BY: L. Ellis
;
;MODIFICATION HISTORY:
;    03/23/2009 Created.
;    05/11/2009 Added sat keyword
;    05/20/2009 Added ascii
;    10/20/2010 Change skeleton name.
;    10/21/2010 Add Non_valid to directory tree.
;    10/22/2010 Put "nonvalid" in filenames.
;    10/29/2010 When entrance system off, set poor stats = -1
;    05/27/2015 Check for closed entrance system first; so don't update efficiency ratios.
;    11/02/2015 Change version for STB.
;    12/19/2015 Add no_display keyword.
;    12/23/2015 Change check on entrance system for solar conjunction
;    04/10/2020 Check for sweeping with dacm_esa_ctl. Lower esa_cm_dc limit.
;    04/27/2020 Fix bug where didn't carry over ratios on new year when no data.
;    05/06/2020 Fix bug in checking for entrance system.
;    05/07/2020 LBE Change in update_ratios because on 4/9/2020 we
;                   changed the trigger mode to trigger on position.
;    06/25/2020 For 2020, only keep vel and den.
;               Remove data when den < .1 or vel < 220
;    08/26/2020 Change vel < 220 to vel < 250
;-

PRO create_ob_mom_cdfs, start_time, stop_time, sat = sat
compile_opt strictarrsubs
tab = string(9B)

out_a_dir_base = '/data1/' ; maui
out_b_dir_base = '/data2/' ; maui
ascii_out_dir_base='/nfs/oahudata2/Ascii/Level2/OBMoments/Non_valid/' ; maui		
;out_a_dir_base = '~/Temp/'
;out_b_dir_base = '~/Temp/'
;ascii_out_dir_base ='~/Temp/'

;skeleton_name = '~/Lorna/Level2/SKT/PLA_L2_1DMAX_00000000_'+version ; daisy

;start_time = '2008-01-01/00:00:00'
;stop_time  = '2008-01-02/00:00:00'

IF keyword_set(sat) THEN sats = [sat] ELSE sats = ['A', 'B']

ts = time_struct(start_time)
te = time_struct(stop_time)

nofdays = te.daynum - ts.daynum
set_com
set_com_mom
FOR ii = 0, n_elements(sats)-1 DO BEGIN 
    ts = time_double(start_time)
    sat = sats[ii]
    IF sat EQ 'A' THEN version = 'V02' ELSE version = 'V03'
    skeleton_name       = '~/Level2/SKT/PLA_L2_OBMOM_1min_nonvalid_'+version ; maui
    prod = [sat+'_D']
    FOR jj = 0, nofdays-1 DO BEGIN

        timespan, ts, 1, /DAYS  ; SECONDS, MINUTES, HOURS, DAYS (DEFAULT)
        ts_struct = time_struct(ts)
        time_string = time_string(ts)
        get_timespan, tt

        IF sat EQ 'A' THEN out_dir_base = out_a_dir_base ELSE out_dir_base = out_b_dir_base

        esa_cm_dc           = 'ST'+sat+'_Analog_HK_esa_cm_dc_eng'
        dacm_esa_ctl        = 'ST'+sat+'_Digital_HK_dacm_esa_ctl'
        error               = sat+'_obmom_error'
        look_up_vel         = sat+'_obmom_look_up_vel'
        svalid_ratrig       = sat+'_obmom_svalid_ratrig'
        ra_eff              = sat+'_obmom_ra_eff'
        pri0_ratio          = sat+'_obmom_pri0_ratio'
        vel_sdev            = sat+'_obmom_vel_sdev'
        poor_stats          = sat+'_obmom_poor_stats'
        density             = sat+'_obmom_density'
        bulk_speed_inst     = sat+'_obmom_bulk_speed_inst'
        vx_inst             = sat+'_obmom_vx_inst'
        vy_inst             = sat+'_obmom_vy_inst'
        vz_inst             = sat+'_obmom_vz_inst'
        ns_inst             = sat+'_obmom_ns_inst'
        ew_inst             = sat+'_obmom_ew_inst'
        bulk_speed_spcrft   = sat+'_obmom_bulk_speed_spcrft'
        vx_spcrft           = sat+'_obmom_vx_spcrft'
        vy_spcrft           = sat+'_obmom_vy_spcrft'
        vz_spcrft           = sat+'_obmom_vz_spcrft'
        ns_spcrft           = sat+'_obmom_ns_spcrft'
        ew_spcrft           = sat+'_obmom_ew_spcrft'
        bulk_speed_hertn    = sat+'_obmom_bulk_speed_hertn'
        vr_hertn            = sat+'_obmom_vr_hertn'
        vt_hertn            = sat+'_obmom_vt_hertn'
        vn_hertn            = sat+'_obmom_vn_hertn'
        ns_hertn            = sat+'_obmom_ns_hertn'
        ew_hertn            = sat+'_obmom_ew_hertn'
        bulk_speed_rtn      = sat+'_obmom_bulk_speed_rtn'
        vr_rtn              = sat+'_obmom_vr_rtn'
        vt_rtn              = sat+'_obmom_vt_rtn'
        vn_rtn              = sat+'_obmom_vn_rtn'
        ns_rtn              = sat+'_obmom_ns_rtn'
        ew_rtn              = sat+'_obmom_ew_rtn'
        pressure_xx_inst    = sat+'_obmom_pressure_xx_inst'
        pressure_xy_inst    = sat+'_obmom_pressure_xy_inst'
        pressure_xz_inst    = sat+'_obmom_pressure_xz_inst'
        pressure_yy_inst    = sat+'_obmom_pressure_yy_inst'
        pressure_yz_inst    = sat+'_obmom_pressure_yz_inst'
        pressure_zz_inst    = sat+'_obmom_pressure_zz_inst'
        temperature_xx_inst = sat+'_obmom_temperature_xx_inst'
        temperature_xy_inst = sat+'_obmom_temperature_xy_inst'
        temperature_xz_inst = sat+'_obmom_temperature_xz_inst'
        temperature_yy_inst = sat+'_obmom_temperature_yy_inst'
        temperature_yz_inst = sat+'_obmom_temperature_yz_inst'
        temperature_zz_inst = sat+'_obmom_temperature_zz_inst'
        energy_flux_x_inst  = sat+'_obmom_energy_flux_x_inst'
        energy_flux_y_inst  = sat+'_obmom_energy_flux_y_inst'
        energy_flux_z_inst  = sat+'_obmom_energy_flux_z_inst'

                ; get hk data (to check entrance system)
        sat_hk = ['esa_cm_dc_eng','dacm_esa_ctl']
        get_pla_hk, sat, sat_hk
        get_data, esa_cm_dc,     hk_t,    esa_cm_dc_d
        get_data, dacm_esa_ctl, dig_t, dacm_esa_ctl_d

                ; Check for closed entrance system
        bad_ana_i = where((esa_cm_dc_d LT 5) OR $ ; doy 230 (2014) - 319(2015) for solar conjunction
                          ((finite(esa_cm_dc_d) EQ 0) AND (ts_struct.year LT 2014)) OR $
                          ((finite(esa_cm_dc_d) EQ 0) AND (ts_struct.year EQ 2014) AND (ts_struct.doy LT 230)) OR $
                          ((finite(esa_cm_dc_d) EQ 0) AND (ts_struct.year EQ 2015) AND (ts_struct.doy GT 319)) OR $
                          ((finite(esa_cm_dc_d) EQ 0) AND (ts_struct.year GT 2015)), bad_count)

        bad_dig_i = where(dacm_esa_ctl_d NE 0xFF, bad_dig_count)

        IF ((ts_struct.year EQ 2014) AND (ts_struct.doy GT 351)) OR $ ; turned off
           ((ts_struct.year EQ 2015) AND (ts_struct.doy LT 190)) THEN have_data = 0
        IF (bad_count EQ n_elements(esa_cm_dc_d)) OR (bad_dig_count EQ n_elements(dacm_esa_ctl_d)) THEN BEGIN ; no good data
           have_data = 0
        ENDIF ELSE BEGIN 
            IF bad_count GT 0 THEN closed_entrance = 1 ELSE closed_entrance = 0
                                ; get ob data 
            pl_plot_obmom_from_crib, prod, /INST_COORD, closed_entrance = closed_entrance, /no_display

            get_data, error,               ob_t, error_d 
            get_data, look_up_vel,         ob_t, look_up_vel_d 
            get_data, svalid_ratrig,       ob_t, svalid_ratrig_d 
            get_data, ra_eff,              ob_t, ra_eff_d 
            get_data, pri0_ratio,          ob_t, pri0_ratio_d 
            get_data, vel_sdev,            ob_t, vel_sdev_d 
            get_data, poor_stats,          ob_t, poor_stats_d 
            get_data, bulk_speed_inst,     ob_t, bulk_speed_inst_d
            get_data, vx_inst,             ob_t, vx_inst_d
            get_data, vy_inst,             ob_t, vy_inst_d
            get_data, vz_inst,             ob_t, vz_inst_d
            get_data, ns_inst,             ob_t, ns_inst_d
            get_data, ew_inst,             ob_t, ew_inst_d
            get_data, bulk_speed_spcrft,   ob_t, bulk_speed_spcrft_d
            get_data, vx_spcrft,           ob_t, vx_spcrft_d
            get_data, vy_spcrft,           ob_t, vy_spcrft_d
            get_data, vz_spcrft,           ob_t, vz_spcrft_d
            get_data, ns_spcrft,           ob_t, ns_spcrft_d
            get_data, ew_spcrft,           ob_t, ew_spcrft_d
            get_data, bulk_speed_hertn,    ob_t, bulk_speed_hertn_d
            get_data, vr_hertn,            ob_t, vr_hertn_d
            get_data, vt_hertn,            ob_t, vt_hertn_d
            get_data, vn_hertn,            ob_t, vn_hertn_d
            get_data, ns_hertn,            ob_t, ns_hertn_d
            get_data, ew_hertn,            ob_t, ew_hertn_d
            get_data, bulk_speed_rtn,      ob_t, bulk_speed_rtn_d
            get_data, vr_rtn,              ob_t, vr_rtn_d
            get_data, vt_rtn,              ob_t, vt_rtn_d
            get_data, vn_rtn,              ob_t, vn_rtn_d
            get_data, ns_rtn,              ob_t, ns_rtn_d
            get_data, ew_rtn,              ob_t, ew_rtn_d
            get_data, density,             ob_t, density_d
            get_data, pressure_xx_inst,    ob_t, pressure_xx_inst_d
            get_data, pressure_xy_inst,    ob_t, pressure_xy_inst_d
            get_data, pressure_xz_inst,    ob_t, pressure_xz_inst_d
            get_data, pressure_yy_inst,    ob_t, pressure_yy_inst_d
            get_data, pressure_yz_inst,    ob_t, pressure_yz_inst_d
            get_data, pressure_zz_inst,    ob_t, pressure_zz_inst_d
            get_data, temperature_xx_inst, ob_t, temperature_xx_inst_d
            get_data, temperature_xy_inst, ob_t, temperature_xy_inst_d
            get_data, temperature_xz_inst, ob_t, temperature_xz_inst_d
            get_data, temperature_yy_inst, ob_t, temperature_yy_inst_d
            get_data, temperature_yz_inst, ob_t, temperature_yz_inst_d
            get_data, temperature_zz_inst, ob_t, temperature_zz_inst_d
            get_data, energy_flux_x_inst,  ob_t, energy_flux_x_inst_d
            get_data, energy_flux_y_inst,  ob_t, energy_flux_y_inst_d
            get_data, energy_flux_z_inst,  ob_t, energy_flux_z_inst_d

            ;; Only want density and velocity when high background
            if ts_struct.year ge 2020 then begin
               pressure_xx_inst_d   [*] = !values.f_nan
               pressure_xy_inst_d   [*] = !values.f_nan
               pressure_xz_inst_d   [*] = !values.f_nan
               pressure_yy_inst_d   [*] = !values.f_nan
               pressure_yz_inst_d   [*] = !values.f_nan
               pressure_zz_inst_d   [*] = !values.f_nan
               temperature_xx_inst_d[*] = !values.f_nan
               temperature_xy_inst_d[*] = !values.f_nan
               temperature_xz_inst_d[*] = !values.f_nan
               temperature_yy_inst_d[*] = !values.f_nan
               temperature_yz_inst_d[*] = !values.f_nan
               temperature_zz_inst_d[*] = !values.f_nan
               energy_flux_x_inst_d [*] = !values.f_nan
               energy_flux_y_inst_d [*] = !values.f_nan
               energy_flux_z_inst_d [*] = !values.f_nan
               bad_i = where((bulk_speed_inst_d lt 250) or (density_d lt .1), bad_c)
               if bad_c gt 0 then begin
                  bulk_speed_inst_d  [bad_i] = !values.f_nan
                  vx_inst_d          [bad_i] = !values.f_nan
                  vy_inst_d          [bad_i] = !values.f_nan
                  vz_inst_d          [bad_i] = !values.f_nan
                  ns_inst_d          [bad_i] = !values.f_nan
                  ew_inst_d          [bad_i] = !values.f_nan
                  bulk_speed_spcrft_d[bad_i] = !values.f_nan
                  vx_spcrft_d        [bad_i] = !values.f_nan
                  vy_spcrft_d        [bad_i] = !values.f_nan
                  vz_spcrft_d        [bad_i] = !values.f_nan
                  ns_spcrft_d        [bad_i] = !values.f_nan
                  ew_spcrft_d        [bad_i] = !values.f_nan
                  bulk_speed_hertn_d [bad_i] = !values.f_nan
                  vr_hertn_d         [bad_i] = !values.f_nan
                  vt_hertn_d         [bad_i] = !values.f_nan
                  vn_hertn_d         [bad_i] = !values.f_nan
                  ns_hertn_d         [bad_i] = !values.f_nan
                  ew_hertn_d         [bad_i] = !values.f_nan
                  bulk_speed_rtn_d   [bad_i] = !values.f_nan
                  vr_rtn_d           [bad_i] = !values.f_nan
                  vt_rtn_d           [bad_i] = !values.f_nan
                  vn_rtn_d           [bad_i] = !values.f_nan
                  ns_rtn_d           [bad_i] = !values.f_nan
                  ew_rtn_d           [bad_i] = !values.f_nan
                  density_d          [bad_i] = !values.f_nan
               endif 
            endif

            IF bad_count GT 0 THEN BEGIN
                FOR kk = 0L, bad_count-1 DO BEGIN
                    remove_i = where(ob_t EQ hk_t[bad_ana_i[kk]], remove_count)
                    IF remove_count GT 0 THEN BEGIN 
                        error_d              [remove_i] = 1
                        poor_stats_d         [remove_i] = -1
                        look_up_vel_d        [remove_i] = !values.f_nan
                        svalid_ratrig_d      [remove_i] = !values.f_nan 
                        ra_eff_d             [remove_i] = !values.f_nan
                        pri0_ratio_d         [remove_i] = !values.f_nan
                        vel_sdev_d           [remove_i] = !values.f_nan
                        density_d            [remove_i] = !values.f_nan 
                        bulk_speed_inst_d    [remove_i] = !values.f_nan 
                        vx_inst_d            [remove_i] = !values.f_nan 
                        vy_inst_d            [remove_i] = !values.f_nan 
                        vz_inst_d            [remove_i] = !values.f_nan 
                        ns_inst_d            [remove_i] = !values.f_nan 
                        ew_inst_d            [remove_i] = !values.f_nan 
                        bulk_speed_spcrft_d  [remove_i] = !values.f_nan 
                        vx_spcrft_d          [remove_i] = !values.f_nan 
                        vy_spcrft_d          [remove_i] = !values.f_nan 
                        vz_spcrft_d          [remove_i] = !values.f_nan 
                        ns_spcrft_d          [remove_i] = !values.f_nan 
                        ew_spcrft_d          [remove_i] = !values.f_nan 
                        bulk_speed_hertn_d   [remove_i] = !values.f_nan 
                        vr_hertn_d           [remove_i] = !values.f_nan 
                        vt_hertn_d           [remove_i] = !values.f_nan 
                        vn_hertn_d           [remove_i] = !values.f_nan 
                        ns_hertn_d           [remove_i] = !values.f_nan 
                        ew_hertn_d           [remove_i] = !values.f_nan 
                        bulk_speed_rtn_d     [remove_i] = !values.f_nan 
                        vr_rtn_d             [remove_i] = !values.f_nan 
                        vt_rtn_d             [remove_i] = !values.f_nan 
                        vn_rtn_d             [remove_i] = !values.f_nan 
                        ns_rtn_d             [remove_i] = !values.f_nan 
                        ew_rtn_d             [remove_i] = !values.f_nan 
                        pressure_xx_inst_d   [remove_i] = !values.f_nan 
                        pressure_xy_inst_d   [remove_i] = !values.f_nan 
                        pressure_xz_inst_d   [remove_i] = !values.f_nan 
                        pressure_yy_inst_d   [remove_i] = !values.f_nan 
                        pressure_yz_inst_d   [remove_i] = !values.f_nan 
                        pressure_zz_inst_d   [remove_i] = !values.f_nan 
                        temperature_xx_inst_d[remove_i] = !values.f_nan 
                        temperature_xy_inst_d[remove_i] = !values.f_nan 
                        temperature_xz_inst_d[remove_i] = !values.f_nan 
                        temperature_yy_inst_d[remove_i] = !values.f_nan 
                        temperature_yz_inst_d[remove_i] = !values.f_nan 
                        temperature_zz_inst_d[remove_i] = !values.f_nan 
                        energy_flux_x_inst_d [remove_i] = !values.f_nan 
                        energy_flux_y_inst_d [remove_i] = !values.f_nan 
                        energy_flux_z_inst_d [remove_i] = !values.f_nan 
                    ENDIF
                ENDFOR
                store_data, dacm_esa_ctl,        data = {x: dig_t, y: dacm_esa_ctl_d}
                store_data, esa_cm_dc,           data = {x: hk_t, y: esa_cm_dc_d}
                store_data, error,               data = {x: ob_t, y: error_d} 
                store_data, look_up_vel,         data = {x: ob_t, y: look_up_vel_d} 
                store_data, svalid_ratrig,       data = {x: ob_t, y: svalid_ratrig_d} 
                store_data, ra_eff,              data = {x: ob_t, y: ra_eff_d} 
                store_data, pri0_ratio,          data = {x: ob_t, y: pri0_ratio_d} 
                store_data, vel_sdev,            data = {x: ob_t, y: vel_sdev_d} 
                store_data, poor_stats,          data = {x: ob_t, y: poor_stats_d} 
                store_data, bulk_speed_inst,     data = {x: ob_t, y: bulk_speed_inst_d}
                store_data, vx_inst,             data = {x: ob_t, y: vx_inst_d}
                store_data, vy_inst,             data = {x: ob_t, y: vy_inst_d}
                store_data, vz_inst,             data = {x: ob_t, y: vz_inst_d}
                store_data, ns_inst,             data = {x: ob_t, y: ns_inst_d}
                store_data, ew_inst,             data = {x: ob_t, y: ew_inst_d}
                store_data, bulk_speed_spcrft,   data = {x: ob_t, y: bulk_speed_spcrft_d}
                store_data, vx_spcrft,           data = {x: ob_t, y: vx_spcrft_d}
                store_data, vy_spcrft,           data = {x: ob_t, y: vy_spcrft_d}
                store_data, vz_spcrft,           data = {x: ob_t, y: vz_spcrft_d}
                store_data, ns_spcrft,           data = {x: ob_t, y: ns_spcrft_d}
                store_data, ew_spcrft,           data = {x: ob_t, y: ew_spcrft_d}
                store_data, bulk_speed_hertn,    data = {x: ob_t, y: bulk_speed_hertn_d}
                store_data, vr_hertn,            data = {x: ob_t, y: vr_hertn_d}
                store_data, vt_hertn,            data = {x: ob_t, y: vt_hertn_d}
                store_data, vn_hertn,            data = {x: ob_t, y: vn_hertn_d}
                store_data, ns_hertn,            data = {x: ob_t, y: ns_hertn_d}
                store_data, ew_hertn,            data = {x: ob_t, y: ew_hertn_d}
                store_data, bulk_speed_rtn,      data = {x: ob_t, y: bulk_speed_rtn_d}
                store_data, vr_rtn,              data = {x: ob_t, y: vr_rtn_d}
                store_data, vt_rtn,              data = {x: ob_t, y: vt_rtn_d}
                store_data, vn_rtn,              data = {x: ob_t, y: vn_rtn_d}
                store_data, ns_rtn,              data = {x: ob_t, y: ns_rtn_d}
                store_data, ew_rtn,              data = {x: ob_t, y: ew_rtn_d}
                store_data, density,             data = {x: ob_t, y: density_d}
                store_data, pressure_xx_inst,    data = {x: ob_t, y: pressure_xx_inst_d}
                store_data, pressure_xy_inst,    data = {x: ob_t, y: pressure_xy_inst_d}
                store_data, pressure_xz_inst,    data = {x: ob_t, y: pressure_xz_inst_d}
                store_data, pressure_yy_inst,    data = {x: ob_t, y: pressure_yy_inst_d}
                store_data, pressure_yz_inst,    data = {x: ob_t, y: pressure_yz_inst_d}
                store_data, pressure_zz_inst,    data = {x: ob_t, y: pressure_zz_inst_d}
                store_data, temperature_xx_inst, data = {x: ob_t, y: temperature_xx_inst_d}
                store_data, temperature_xy_inst, data = {x: ob_t, y: temperature_xy_inst_d}
                store_data, temperature_xz_inst, data = {x: ob_t, y: temperature_xz_inst_d}
                store_data, temperature_yy_inst, data = {x: ob_t, y: temperature_yy_inst_d}
                store_data, temperature_yz_inst, data = {x: ob_t, y: temperature_yz_inst_d}
                store_data, temperature_zz_inst, data = {x: ob_t, y: temperature_zz_inst_d}
                store_data, energy_flux_x_inst,  data = {x: ob_t, y: energy_flux_x_inst_d}
                store_data, energy_flux_y_inst,  data = {x: ob_t, y: energy_flux_y_inst_d}
                store_data, energy_flux_z_inst,  data = {x: ob_t, y: energy_flux_z_inst_d}
            ENDIF 

            IF bad_dig_count GT 0 THEN BEGIN
                FOR kk = 0L, bad_dig_count-1 DO BEGIN
                    remove_i = where(abs(ob_t - dig_t[bad_dig_i[kk]]) lt 30, remove_count)
                    IF remove_count GT 0 THEN BEGIN 
                        error_d              [remove_i] = 1
                        poor_stats_d         [remove_i] = -1
                        look_up_vel_d        [remove_i] = !values.f_nan
                        svalid_ratrig_d      [remove_i] = !values.f_nan 
                        ra_eff_d             [remove_i] = !values.f_nan
                        pri0_ratio_d         [remove_i] = !values.f_nan
                        vel_sdev_d           [remove_i] = !values.f_nan
                        density_d            [remove_i] = !values.f_nan 
                        bulk_speed_inst_d    [remove_i] = !values.f_nan 
                        vx_inst_d            [remove_i] = !values.f_nan 
                        vy_inst_d            [remove_i] = !values.f_nan 
                        vz_inst_d            [remove_i] = !values.f_nan 
                        ns_inst_d            [remove_i] = !values.f_nan 
                        ew_inst_d            [remove_i] = !values.f_nan 
                        bulk_speed_spcrft_d  [remove_i] = !values.f_nan 
                        vx_spcrft_d          [remove_i] = !values.f_nan 
                        vy_spcrft_d          [remove_i] = !values.f_nan 
                        vz_spcrft_d          [remove_i] = !values.f_nan 
                        ns_spcrft_d          [remove_i] = !values.f_nan 
                        ew_spcrft_d          [remove_i] = !values.f_nan 
                        bulk_speed_hertn_d   [remove_i] = !values.f_nan 
                        vr_hertn_d           [remove_i] = !values.f_nan 
                        vt_hertn_d           [remove_i] = !values.f_nan 
                        vn_hertn_d           [remove_i] = !values.f_nan 
                        ns_hertn_d           [remove_i] = !values.f_nan 
                        ew_hertn_d           [remove_i] = !values.f_nan 
                        bulk_speed_rtn_d     [remove_i] = !values.f_nan 
                        vr_rtn_d             [remove_i] = !values.f_nan 
                        vt_rtn_d             [remove_i] = !values.f_nan 
                        vn_rtn_d             [remove_i] = !values.f_nan 
                        ns_rtn_d             [remove_i] = !values.f_nan 
                        ew_rtn_d             [remove_i] = !values.f_nan 
                        pressure_xx_inst_d   [remove_i] = !values.f_nan 
                        pressure_xy_inst_d   [remove_i] = !values.f_nan 
                        pressure_xz_inst_d   [remove_i] = !values.f_nan 
                        pressure_yy_inst_d   [remove_i] = !values.f_nan 
                        pressure_yz_inst_d   [remove_i] = !values.f_nan 
                        pressure_zz_inst_d   [remove_i] = !values.f_nan 
                        temperature_xx_inst_d[remove_i] = !values.f_nan 
                        temperature_xy_inst_d[remove_i] = !values.f_nan 
                        temperature_xz_inst_d[remove_i] = !values.f_nan 
                        temperature_yy_inst_d[remove_i] = !values.f_nan 
                        temperature_yz_inst_d[remove_i] = !values.f_nan 
                        temperature_zz_inst_d[remove_i] = !values.f_nan 
                        energy_flux_x_inst_d [remove_i] = !values.f_nan 
                        energy_flux_y_inst_d [remove_i] = !values.f_nan 
                        energy_flux_z_inst_d [remove_i] = !values.f_nan 
                    ENDIF
                ENDFOR
                store_data, dacm_esa_ctl,        data = {x: dig_t, y: dacm_esa_ctl_d}
                store_data, esa_cm_dc,           data = {x: hk_t, y: esa_cm_dc_d}
                store_data, error,               data = {x: ob_t, y: error_d} 
                store_data, look_up_vel,         data = {x: ob_t, y: look_up_vel_d} 
                store_data, svalid_ratrig,       data = {x: ob_t, y: svalid_ratrig_d} 
                store_data, ra_eff,              data = {x: ob_t, y: ra_eff_d} 
                store_data, pri0_ratio,          data = {x: ob_t, y: pri0_ratio_d} 
                store_data, vel_sdev,            data = {x: ob_t, y: vel_sdev_d} 
                store_data, poor_stats,          data = {x: ob_t, y: poor_stats_d} 
                store_data, bulk_speed_inst,     data = {x: ob_t, y: bulk_speed_inst_d}
                store_data, vx_inst,             data = {x: ob_t, y: vx_inst_d}
                store_data, vy_inst,             data = {x: ob_t, y: vy_inst_d}
                store_data, vz_inst,             data = {x: ob_t, y: vz_inst_d}
                store_data, ns_inst,             data = {x: ob_t, y: ns_inst_d}
                store_data, ew_inst,             data = {x: ob_t, y: ew_inst_d}
                store_data, bulk_speed_spcrft,   data = {x: ob_t, y: bulk_speed_spcrft_d}
                store_data, vx_spcrft,           data = {x: ob_t, y: vx_spcrft_d}
                store_data, vy_spcrft,           data = {x: ob_t, y: vy_spcrft_d}
                store_data, vz_spcrft,           data = {x: ob_t, y: vz_spcrft_d}
                store_data, ns_spcrft,           data = {x: ob_t, y: ns_spcrft_d}
                store_data, ew_spcrft,           data = {x: ob_t, y: ew_spcrft_d}
                store_data, bulk_speed_hertn,    data = {x: ob_t, y: bulk_speed_hertn_d}
                store_data, vr_hertn,            data = {x: ob_t, y: vr_hertn_d}
                store_data, vt_hertn,            data = {x: ob_t, y: vt_hertn_d}
                store_data, vn_hertn,            data = {x: ob_t, y: vn_hertn_d}
                store_data, ns_hertn,            data = {x: ob_t, y: ns_hertn_d}
                store_data, ew_hertn,            data = {x: ob_t, y: ew_hertn_d}
                store_data, bulk_speed_rtn,      data = {x: ob_t, y: bulk_speed_rtn_d}
                store_data, vr_rtn,              data = {x: ob_t, y: vr_rtn_d}
                store_data, vt_rtn,              data = {x: ob_t, y: vt_rtn_d}
                store_data, vn_rtn,              data = {x: ob_t, y: vn_rtn_d}
                store_data, ns_rtn,              data = {x: ob_t, y: ns_rtn_d}
                store_data, ew_rtn,              data = {x: ob_t, y: ew_rtn_d}
                store_data, density,             data = {x: ob_t, y: density_d}
                store_data, pressure_xx_inst,    data = {x: ob_t, y: pressure_xx_inst_d}
                store_data, pressure_xy_inst,    data = {x: ob_t, y: pressure_xy_inst_d}
                store_data, pressure_xz_inst,    data = {x: ob_t, y: pressure_xz_inst_d}
                store_data, pressure_yy_inst,    data = {x: ob_t, y: pressure_yy_inst_d}
                store_data, pressure_yz_inst,    data = {x: ob_t, y: pressure_yz_inst_d}
                store_data, pressure_zz_inst,    data = {x: ob_t, y: pressure_zz_inst_d}
                store_data, temperature_xx_inst, data = {x: ob_t, y: temperature_xx_inst_d}
                store_data, temperature_xy_inst, data = {x: ob_t, y: temperature_xy_inst_d}
                store_data, temperature_xz_inst, data = {x: ob_t, y: temperature_xz_inst_d}
                store_data, temperature_yy_inst, data = {x: ob_t, y: temperature_yy_inst_d}
                store_data, temperature_yz_inst, data = {x: ob_t, y: temperature_yz_inst_d}
                store_data, temperature_zz_inst, data = {x: ob_t, y: temperature_zz_inst_d}
                store_data, energy_flux_x_inst,  data = {x: ob_t, y: energy_flux_x_inst_d}
                store_data, energy_flux_y_inst,  data = {x: ob_t, y: energy_flux_y_inst_d}
                store_data, energy_flux_z_inst,  data = {x: ob_t, y: energy_flux_z_inst_d}
            ENDIF 

                ; Check for hand-written bad times -- not implemented (see create_ra_mom_cdfs)
            IF n_elements(ob_t) GT 1 THEN have_data = 1 ELSE have_data = 0

                ; adjust decimal places -- not implemented
                ; create string
            error_st                = string(error_d,                format = '(I2  )')
            poor_stats_st           = string(poor_stats_d,           format = '(I2  )')
            look_up_vel_st          = string(look_up_vel_d,          format = '(F0.1)')
            svalid_ratrig_st        = string(svalid_ratrig_d,        format = '(E10.2)')
            ra_eff_st               = string(ra_eff_d,               format = '(F0.1)')
            pri0_ratio_st           = string(pri0_ratio_d,           format = '(F0.1)')
            vel_sdev_st             = string(vel_sdev_d,             format = '(F0.1)')
            density_st              = string(density_d,              format = '(F0.1)')
            bulk_speed_inst_st      = string(bulk_speed_inst_d,      format = '(F0.1)')
            vx_inst_st              = string(vx_inst_d,              format = '(F0.1)')
            vy_inst_st              = string(vy_inst_d,              format = '(F0.1)')
            vz_inst_st              = string(vz_inst_d,              format = '(F0.1)')
            ns_inst_st              = string(ns_inst_d,              format = '(F0.1)')
            ew_inst_st              = string(ew_inst_d,              format = '(F0.1)')
            bulk_speed_spcrft_st    = string(bulk_speed_spcrft_d,    format = '(F0.1)')
            vx_spcrft_st            = string(vx_spcrft_d,            format = '(F0.1)')
            vy_spcrft_st            = string(vy_spcrft_d,            format = '(F0.1)')
            vz_spcrft_st            = string(vz_spcrft_d,            format = '(F0.1)')
            ns_spcrft_st            = string(ns_spcrft_d,            format = '(E10.2)')
            ew_spcrft_st            = string(ew_spcrft_d,            format = '(E10.2)')
            bulk_speed_hertn_st     = string(bulk_speed_hertn_d,     format = '(F0.1)')
            vr_hertn_st             = string(vr_hertn_d,             format = '(F0.1)')
            vt_hertn_st             = string(vt_hertn_d,             format = '(F0.1)')
            vn_hertn_st             = string(vn_hertn_d,             format = '(F0.1)')
            ns_hertn_st             = string(ns_hertn_d,             format = '(F0.1)')
            ew_hertn_st             = string(ew_hertn_d,             format = '(F0.1)')
            bulk_speed_rtn_st       = string(bulk_speed_rtn_d,       format = '(F0.1)')
            vr_rtn_st               = string(vr_rtn_d,               format = '(F0.1)')
            vt_rtn_st               = string(vt_rtn_d,               format = '(F0.1)')
            vn_rtn_st               = string(vn_rtn_d,               format = '(F0.1)')
            ns_rtn_st               = string(ns_rtn_d,               format = '(F0.1)')
            ew_rtn_st               = string(ew_rtn_d,               format = '(F0.1)')
            pressure_xx_inst_st     = string(pressure_xx_inst_d,     format = '(E10.2)')
            pressure_xy_inst_st     = string(pressure_xy_inst_d,     format = '(E10.2)')
            pressure_xz_inst_st     = string(pressure_xz_inst_d,     format = '(E10.2)')
            pressure_yy_inst_st     = string(pressure_yy_inst_d,     format = '(E10.2)')
            pressure_yz_inst_st     = string(pressure_yz_inst_d,     format = '(E10.2)')
            pressure_zz_inst_st     = string(pressure_zz_inst_d,     format = '(E10.2)')
            temperature_xx_inst_st  = string(temperature_xx_inst_d,  format = '(F0.1)')
            temperature_xy_inst_st  = string(temperature_xy_inst_d,  format = '(F0.1)')
            temperature_xz_inst_st  = string(temperature_xz_inst_d,  format = '(F0.1)')
            temperature_yy_inst_st  = string(temperature_yy_inst_d,  format = '(F0.1)')
            temperature_yz_inst_st  = string(temperature_yz_inst_d,  format = '(F0.1)')
            temperature_zz_inst_st  = string(temperature_zz_inst_d,  format = '(F0.1)')
            energy_flux_x_inst_st   = string(energy_flux_x_inst_d,   format = '(E10.2)')
            energy_flux_y_inst_st   = string(energy_flux_y_inst_d,   format = '(E10.2)')
            energy_flux_z_inst_st   = string(energy_flux_z_inst_d,   format = '(E10.2)')

                ; find NaN values
            bad_look_up_vel_i         = where(finite(look_up_vel_d)         NE 1, bad_look_up_vel_c)
            bad_svalid_ratrig_i       = where(finite(svalid_ratrig_d)       NE 1, bad_svalid_ratrig_c)
            bad_ra_eff_i              = where(finite(ra_eff_d)              NE 1, bad_ra_eff_c)
            bad_pri0_ratio_i          = where(finite(pri0_ratio_d)          NE 1, bad_pri0_ratio_c)
            bad_vel_sdev_i            = where(finite(vel_sdev_d)            NE 1, bad_vel_sdev_c)
            bad_density_i             = where(finite(density_d)             NE 1, bad_density_c)
            bad_bulk_speed_inst_i     = where(finite(bulk_speed_inst_d)     NE 1, bad_bulk_speed_inst_c)
            bad_vx_inst_i             = where(finite(vx_inst_d)             NE 1, bad_vx_inst_c)
            bad_vy_inst_i             = where(finite(vy_inst_d)             NE 1, bad_vy_inst_c)
            bad_vz_inst_i             = where(finite(vz_inst_d)             NE 1, bad_vz_inst_c)
            bad_ns_inst_i             = where(finite(ns_inst_d)             NE 1, bad_ns_inst_c)
            bad_ew_inst_i             = where(finite(ew_inst_d)             NE 1, bad_ew_inst_c)
            bad_bulk_speed_spcrft_i   = where(finite(bulk_speed_spcrft_d)   NE 1, bad_bulk_speed_spcrft_c)
            bad_vx_spcrft_i           = where(finite(vx_spcrft_d)           NE 1, bad_vx_spcrft_c)
            bad_vy_spcrft_i           = where(finite(vy_spcrft_d)           NE 1, bad_vy_spcrft_c)
            bad_vz_spcrft_i           = where(finite(vz_spcrft_d)           NE 1, bad_vz_spcrft_c)
            bad_ns_spcrft_i           = where(finite(ns_spcrft_d)           NE 1, bad_ns_spcrft_c)
            bad_ew_spcrft_i           = where(finite(ew_spcrft_d)           NE 1, bad_ew_spcrft_c)
            bad_bulk_speed_hertn_i    = where(finite(bulk_speed_hertn_d)    NE 1, bad_bulk_speed_hertn_c)
            bad_vr_hertn_i            = where(finite(vr_hertn_d)            NE 1, bad_vr_hertn_c)
            bad_vt_hertn_i            = where(finite(vt_hertn_d)            NE 1, bad_vt_hertn_c)
            bad_vn_hertn_i            = where(finite(vn_hertn_d)            NE 1, bad_vn_hertn_c)
            bad_ns_hertn_i            = where(finite(ns_hertn_d)            NE 1, bad_ns_hertn_c)
            bad_ew_hertn_i            = where(finite(ew_hertn_d)            NE 1, bad_ew_hertn_c)
            bad_bulk_speed_rtn_i      = where(finite(bulk_speed_rtn_d)      NE 1, bad_bulk_speed_rtn_c)
            bad_vr_rtn_i              = where(finite(vr_rtn_d)              NE 1, bad_vr_rtn_c)
            bad_vt_rtn_i              = where(finite(vt_rtn_d)              NE 1, bad_vt_rtn_c)
            bad_vn_rtn_i              = where(finite(vn_rtn_d)              NE 1, bad_vn_rtn_c)
            bad_ns_rtn_i              = where(finite(ns_rtn_d)              NE 1, bad_ns_rtn_c)
            bad_ew_rtn_i              = where(finite(ew_rtn_d)              NE 1, bad_ew_rtn_c)
            bad_pressure_xx_inst_i    = where(finite(pressure_xx_inst_d)    NE 1, bad_pressure_xx_inst_c)
            bad_pressure_xy_inst_i    = where(finite(pressure_xy_inst_d)    NE 1, bad_pressure_xy_inst_c)
            bad_pressure_xz_inst_i    = where(finite(pressure_xz_inst_d)    NE 1, bad_pressure_xz_inst_c)
            bad_pressure_yy_inst_i    = where(finite(pressure_yy_inst_d)    NE 1, bad_pressure_yy_inst_c)
            bad_pressure_yz_inst_i    = where(finite(pressure_yz_inst_d)    NE 1, bad_pressure_yz_inst_c)
            bad_pressure_zz_inst_i    = where(finite(pressure_zz_inst_d)    NE 1, bad_pressure_zz_inst_c)
            bad_temperature_xx_inst_i = where(finite(temperature_xx_inst_d) NE 1, bad_temperature_xx_inst_c)
            bad_temperature_xy_inst_i = where(finite(temperature_xy_inst_d) NE 1, bad_temperature_xy_inst_c)
            bad_temperature_xz_inst_i = where(finite(temperature_xz_inst_d) NE 1, bad_temperature_xz_inst_c)
            bad_temperature_yy_inst_i = where(finite(temperature_yy_inst_d) NE 1, bad_temperature_yy_inst_c)
            bad_temperature_yz_inst_i = where(finite(temperature_yz_inst_d) NE 1, bad_temperature_yz_inst_c)
            bad_temperature_zz_inst_i = where(finite(temperature_zz_inst_d) NE 1, bad_temperature_zz_inst_c)
            bad_energy_flux_x_inst_i  = where(finite(energy_flux_x_inst_d)  NE 1, bad_energy_flux_x_inst_c)
            bad_energy_flux_y_inst_i  = where(finite(energy_flux_y_inst_d)  NE 1, bad_energy_flux_y_inst_c)
            bad_energy_flux_z_inst_i  = where(finite(energy_flux_z_inst_d)  NE 1, bad_energy_flux_z_inst_c)
                        
                ; replace with fill
            IF bad_look_up_vel_c         GT 0 THEN BEGIN 
                look_up_vel_d         [bad_look_up_vel_i]         = -1e31
                look_up_vel_st        [bad_look_up_vel_i]         = '-1.0E+31'
            END 
            IF bad_svalid_ratrig_c       GT 0 THEN BEGIN 
                svalid_ratrig_d       [bad_svalid_ratrig_i]       = -1e31
                svalid_ratrig_st      [bad_svalid_ratrig_i]       = '-1.0E+31'
            END 
            IF bad_ra_eff_c              GT 0 THEN BEGIN 
                ra_eff_d              [bad_ra_eff_i]              = -1e31
                ra_eff_st             [bad_ra_eff_i]              = '-1.0E+31'
            END 
            IF bad_pri0_ratio_c          GT 0 THEN BEGIN 
                pri0_ratio_d          [bad_pri0_ratio_i]          = -1e31
                pri0_ratio_st         [bad_pri0_ratio_i]          = '-1.0E+31'
            END 
            IF bad_vel_sdev_c            GT 0 THEN BEGIN 
                vel_sdev_d            [bad_vel_sdev_i]            = -1e31
                vel_sdev_st           [bad_vel_sdev_i]            = '-1.0E+31'
            END 
            IF bad_density_c             GT 0 THEN BEGIN 
                density_d             [bad_density_i]             = -1e31
                density_st            [bad_density_i]             = '-1.0E+31'
            END 
            IF bad_bulk_speed_inst_c     GT 0 THEN BEGIN 
                bulk_speed_inst_d     [bad_bulk_speed_inst_i]     = -1e31
                bulk_speed_inst_st    [bad_bulk_speed_inst_i]     = '-1.0E+31'
            END 
            IF bad_vx_inst_c             GT 0 THEN BEGIN 
                vx_inst_d             [bad_vx_inst_i]             = -1e31
                vx_inst_st            [bad_vx_inst_i]             = '-1.0E+31'
            END 
            IF bad_vy_inst_c             GT 0 THEN BEGIN 
                vy_inst_d             [bad_vy_inst_i]             = -1e31
                vy_inst_st            [bad_vy_inst_i]             = '-1.0E+31'
            END 
            IF bad_vz_inst_c             GT 0 THEN BEGIN 
                vz_inst_d             [bad_vz_inst_i]             = -1e31
                vz_inst_st            [bad_vz_inst_i]             = '-1.0E+31'
            END 
            IF bad_ns_inst_c             GT 0 THEN BEGIN 
                ns_inst_d             [bad_ns_inst_i]             = -1e31
                ns_inst_st            [bad_ns_inst_i]             = '-1.0E+31'
            END 
            IF bad_ew_inst_c             GT 0 THEN BEGIN 
                ew_inst_d             [bad_ew_inst_i]             = -1e31
                ew_inst_st            [bad_ew_inst_i]             = '-1.0E+31'
            END 
            IF bad_bulk_speed_spcrft_c   GT 0 THEN BEGIN 
                bulk_speed_spcrft_d   [bad_bulk_speed_spcrft_i]   = -1e31
                bulk_speed_spcrft_st  [bad_bulk_speed_spcrft_i]   = '-1.0E+31'
            END 
            IF bad_vx_spcrft_c           GT 0 THEN BEGIN 
                vx_spcrft_d           [bad_vx_spcrft_i]           = -1e31
                vx_spcrft_st          [bad_vx_spcrft_i]           = '-1.0E+31'
            END 
            IF bad_vy_spcrft_c           GT 0 THEN BEGIN 
                vy_spcrft_d           [bad_vy_spcrft_i]           = -1e31
                vy_spcrft_st          [bad_vy_spcrft_i]           = '-1.0E+31'
            END 
            IF bad_vz_spcrft_c           GT 0 THEN BEGIN 
                vz_spcrft_d           [bad_vz_spcrft_i]           = -1e31
                vz_spcrft_st          [bad_vz_spcrft_i]           = '-1.0E+31'
            END 
            IF bad_ns_spcrft_c           GT 0 THEN BEGIN 
                ns_spcrft_d           [bad_ns_spcrft_i]           = -1e31
                ns_spcrft_st          [bad_ns_spcrft_i]           = '-1.0E+31'
            END 
            IF bad_ew_spcrft_c           GT 0 THEN BEGIN 
                ew_spcrft_d           [bad_ew_spcrft_i]           = -1e31
                ew_spcrft_st          [bad_ew_spcrft_i]           = '-1.0E+31'
            END 
            IF bad_bulk_speed_hertn_c    GT 0 THEN BEGIN 
                bulk_speed_hertn_d    [bad_bulk_speed_hertn_i]    = -1e31
                bulk_speed_hertn_st   [bad_bulk_speed_hertn_i]    = '-1.0E+31'
            END 
            IF bad_vr_hertn_c            GT 0 THEN BEGIN 
                vr_hertn_d            [bad_vr_hertn_i]            = -1e31
                vr_hertn_st           [bad_vr_hertn_i]            = '-1.0E+31'
            END 
            IF bad_vt_hertn_c            GT 0 THEN BEGIN 
                vt_hertn_d            [bad_vt_hertn_i]            = -1e31
                vt_hertn_st           [bad_vt_hertn_i]            = '-1.0E+31'
            END 
            IF bad_vn_hertn_c            GT 0 THEN BEGIN 
                vn_hertn_d            [bad_vn_hertn_i]            = -1e31
                vn_hertn_st           [bad_vn_hertn_i]            = '-1.0E+31'
            END 
            IF bad_ns_hertn_c            GT 0 THEN BEGIN 
                ns_hertn_d            [bad_ns_hertn_i]            = -1e31
                ns_hertn_st           [bad_ns_hertn_i]            = '-1.0E+31'
            END 
            IF bad_ew_hertn_c            GT 0 THEN BEGIN 
                ew_hertn_d            [bad_ew_hertn_i]            = -1e31
                ew_hertn_st           [bad_ew_hertn_i]            = '-1.0E+31'
            END 
            IF bad_bulk_speed_rtn_c      GT 0 THEN BEGIN 
                bulk_speed_rtn_d      [bad_bulk_speed_rtn_i]      = -1e31
                bulk_speed_rtn_st     [bad_bulk_speed_rtn_i]      = '-1.0E+31'
            END 
            IF bad_vr_rtn_c              GT 0 THEN BEGIN 
                vr_rtn_d              [bad_vr_rtn_i]              = -1e31
                vr_rtn_st             [bad_vr_rtn_i]              = '-1.0E+31'
            END 
            IF bad_vt_rtn_c              GT 0 THEN BEGIN 
                vt_rtn_d              [bad_vt_rtn_i]              = -1e31
                vt_rtn_st             [bad_vt_rtn_i]              = '-1.0E+31'
            END 
            IF bad_vn_rtn_c              GT 0 THEN BEGIN 
                vn_rtn_d              [bad_vn_rtn_i]              = -1e31
                vn_rtn_st             [bad_vn_rtn_i]              = '-1.0E+31'
            END 
            IF bad_ns_rtn_c              GT 0 THEN BEGIN 
                ns_rtn_d              [bad_ns_rtn_i]              = -1e31
                ns_rtn_st             [bad_ns_rtn_i]              = '-1.0E+31'
            END 
            IF bad_ew_rtn_c              GT 0 THEN BEGIN 
                ew_rtn_d              [bad_ew_rtn_i]              = -1e31
                ew_rtn_st             [bad_ew_rtn_i]              = '-1.0E+31'
            END 
            IF bad_pressure_xx_inst_c    GT 0 THEN BEGIN 
                pressure_xx_inst_d    [bad_pressure_xx_inst_i]    = -1e31
                pressure_xx_inst_st   [bad_pressure_xx_inst_i]    = '-1.0E+31'
            END 
            IF bad_pressure_xy_inst_c    GT 0 THEN BEGIN 
                pressure_xy_inst_d    [bad_pressure_xy_inst_i]    = -1e31
                pressure_xy_inst_st   [bad_pressure_xy_inst_i]    = '-1.0E+31'
            END 
            IF bad_pressure_xz_inst_c    GT 0 THEN BEGIN 
                pressure_xz_inst_d    [bad_pressure_xz_inst_i]    = -1e31
                pressure_xz_inst_st   [bad_pressure_xz_inst_i]    = '-1.0E+31'
            END 
            IF bad_pressure_yy_inst_c    GT 0 THEN BEGIN 
                pressure_yy_inst_d    [bad_pressure_yy_inst_i]    = -1e31
                pressure_yy_inst_st   [bad_pressure_yy_inst_i]    = '-1.0E+31'
            END 
            IF bad_pressure_yz_inst_c    GT 0 THEN BEGIN 
                pressure_yz_inst_d    [bad_pressure_yz_inst_i]    = -1e31
                pressure_yz_inst_st   [bad_pressure_yz_inst_i]    = '-1.0E+31'
            END 
            IF bad_pressure_zz_inst_c    GT 0 THEN BEGIN 
                pressure_zz_inst_d    [bad_pressure_zz_inst_i]    = -1e31
                pressure_zz_inst_st   [bad_pressure_zz_inst_i]    = '-1.0E+31'
            END 
            IF bad_temperature_xx_inst_c GT 0 THEN BEGIN 
                temperature_xx_inst_d [bad_temperature_xx_inst_i] = -1e31
                temperature_xx_inst_st[bad_temperature_xx_inst_i] = '-1.0E+31'
            END 
            IF bad_temperature_xy_inst_c GT 0 THEN BEGIN 
                temperature_xy_inst_d [bad_temperature_xy_inst_i] = -1e31
                temperature_xy_inst_st[bad_temperature_xy_inst_i] = '-1.0E+31'
            END 
            IF bad_temperature_xz_inst_c GT 0 THEN BEGIN 
                temperature_xz_inst_d [bad_temperature_xz_inst_i] = -1e31
                temperature_xz_inst_st[bad_temperature_xz_inst_i] = '-1.0E+31'
            END 
            IF bad_temperature_yy_inst_c GT 0 THEN BEGIN 
                temperature_yy_inst_d [bad_temperature_yy_inst_i] = -1e31
                temperature_yy_inst_st[bad_temperature_yy_inst_i] = '-1.0E+31'
            END 
            IF bad_temperature_yz_inst_c GT 0 THEN BEGIN 
                temperature_yz_inst_d [bad_temperature_yz_inst_i] = -1e31
                temperature_yz_inst_st[bad_temperature_yz_inst_i] = '-1.0E+31'
            END 
            IF bad_temperature_zz_inst_c GT 0 THEN BEGIN 
                temperature_zz_inst_d [bad_temperature_zz_inst_i] = -1e31
                temperature_zz_inst_st[bad_temperature_zz_inst_i] = '-1.0E+31'
            END 
            IF bad_energy_flux_x_inst_c  GT 0 THEN BEGIN 
                energy_flux_x_inst_d  [bad_energy_flux_x_inst_i]  = -1e31
                energy_flux_x_inst_st [bad_energy_flux_x_inst_i]  = '-1.0E+31'
            END 
            IF bad_energy_flux_y_inst_c  GT 0 THEN BEGIN 
                energy_flux_y_inst_d  [bad_energy_flux_y_inst_i]  = -1e31
                energy_flux_y_inst_st [bad_energy_flux_y_inst_i]  = '-1.0E+31'
            END 
            IF bad_energy_flux_z_inst_c  GT 0 THEN BEGIN 
                energy_flux_z_inst_d  [bad_energy_flux_z_inst_i]  = -1e31
                energy_flux_z_inst_st [bad_energy_flux_z_inst_i]  = '-1.0E+31'
             END
         ENDELSE 

                ; write ascii files
                ; 1 min.
        get_timespan, temp_t
        label_time  = time_struct(temp_t[0])
        label_year  = STRING(label_time.year, FORMAT = '(I04)')
        label_month = STRING(label_time.month, FORMAT = '(I02)')
        label_day   = STRING(label_time.date, FORMAT = '(I02)')
        outfile     = ascii_out_dir_base+'/1min/'+sat+'/'+string(ts_struct.year, format = '(I4.4)')+'/'+'ST'+sat+$
                      '_L2_PLA_OBMom_1min_nonvalid_'+$
                      label_year+label_month+label_day+'_'+string(label_time.doy, format = '(I3.3)')+'_'+version+'.txt'
        openw, out_lun, outfile, /GET_LUN 
        temp_string = 'On-Board Proton Moments for Spacecraft '+sat
        printf, out_lun, temp_string
        temp_string = 'YEAR'+tab+'DOY'+tab+'hour'+tab+'min'+tab+'sec'+tab+'millisec'+tab+$
                      'date and time'+tab+$
                      'Np [1/cc]'+tab+$
                      'Bulk Speed HERTN [km/s]'+tab+$
                      'Vr HERTN [km/s]'+tab+$
                      'Vt HERTN [km/s]'+tab+$
                      'Vn HERTN [km/s]'+tab+$
                      'N/S HERTN [deg]'+tab+$
                      'E/W HERTN [deg]'+tab+$
                      'Bulk Speed RTN [km/s]'+tab+$
                      'Vr RTN [km/s]'+tab+$
                      'Vt RTN [km/s]'+tab+$
                      'Vn RTN [km/s]'+tab+$
                      'N/S RTN [deg]'+tab+$
                      'E/W RTN [deg]'+tab+$
                      'Bulk Speed Inst. [km/s]'+tab+$
                      'Vx Inst. [km/s]'+tab+$
                      'Vy Inst. [km/s]'+tab+$
                      'Vz Inst. [km/s]'+tab+$
                      'N/S Inst. [deg]'+tab+$
                      'E/W Inst. [deg]'+tab+$
                      'Temperature_xx Inst. [K]'+tab+$
                      'Temperature_xy Inst. [K]'+tab+$
                      'Temperature_xz Inst. [K]'+tab+$
                      'Temperature_yy Inst. [K]'+tab+$
                      'Temperature_yz Inst. [K]'+tab+$
                      'Temperature_zz Inst. [K]'+tab+$
                      'Pressure_xx Inst. [K]'+tab+$
                      'Pressure_xy Inst. [K]'+tab+$
                      'Pressure_xz Inst. [K]'+tab+$
                      'Pressure_yy Inst. [K]'+tab+$
                      'Pressure_yz Inst. [K]'+tab+$
                      'Pressure_zz Inst. [K]'+tab+$
                      'Energy Flux_x Inst. [K]'+tab+$
                      'Energy Flux_y Inst. [K]'+tab+$
                      'Energy Flux_z Inst. [K]'+tab+$
                      'Bulk Speed Spcrft. [km/s]'+tab+$
                      'Vx Spcrft. [km/s]'+tab+$
                      'Vy Spcrft. [km/s]'+tab+$
                      'Vz Spcrft. [km/s]'+tab+$
                      'N/S Spcrft. [deg]'+tab+$
                      'E/W Spcrft. [deg]'+tab+$
                      'Error'+tab+'Error: Poor Stats.'+tab+$
                      'Look-up Vel. [km/s]'+tab+'S_Valid/RA_Trig'+tab+'RA Efficiency'+tab+$
                      'Pri 0 Ratio'+tab+'Velocity Standard Dev. [km/s]'
        printf, out_lun, temp_string
        IF have_data EQ 1 THEN BEGIN 
            ob_t_struct = time_struct(ob_t)
            ob_t_string = time_string(ob_t)
            FOR kk = 0L, N_ELEMENTS(ob_t) - 1 DO BEGIN
                temp_string = string(ob_t_struct[kk].year, format = '(I4.4)')+tab+$
                              string(ob_t_struct[kk].doy,  format = '(I3.3)')+tab+$
                              string(ob_t_struct[kk].hour, format = '(I2.2)')+tab+$
                              string(ob_t_struct[kk].min,  format = '(I2.2)')+tab+$
                              string(ob_t_struct[kk].sec,  format = '(I2.2)')+tab+$
                              string(ob_t_struct[kk].fsec, format = '(F0.3)')+tab+$
                              ob_t_string           [kk]+tab+$
                              density_st            [kk]+tab+$
                              bulk_speed_hertn_st   [kk]+tab+$ 
                              vr_hertn_st           [kk]+tab+$
                              vt_hertn_st           [kk]+tab+$
                              vn_hertn_st           [kk]+tab+$
                              ns_hertn_st           [kk]+tab+$
                              ew_hertn_st           [kk]+tab+$
                              bulk_speed_rtn_st     [kk]+tab+$ 
                              vr_rtn_st             [kk]+tab+$
                              vt_rtn_st             [kk]+tab+$
                              vn_rtn_st             [kk]+tab+$
                              ns_rtn_st             [kk]+tab+$
                              ew_rtn_st             [kk]+tab+$
                              bulk_speed_inst_st    [kk]+tab+$ 
                              vx_inst_st            [kk]+tab+$
                              vy_inst_st            [kk]+tab+$
                              vz_inst_st            [kk]+tab+$
                              ns_inst_st            [kk]+tab+$
                              ew_inst_st            [kk]+tab+$
                              temperature_xx_inst_st[kk]+tab+$
                              temperature_xy_inst_st[kk]+tab+$
                              temperature_xz_inst_st[kk]+tab+$
                              temperature_yy_inst_st[kk]+tab+$
                              temperature_yz_inst_st[kk]+tab+$
                              temperature_zz_inst_st[kk]+tab+$
                              pressure_xx_inst_st   [kk]+tab+$
                              pressure_xy_inst_st   [kk]+tab+$
                              pressure_xz_inst_st   [kk]+tab+$
                              pressure_yy_inst_st   [kk]+tab+$
                              pressure_yz_inst_st   [kk]+tab+$
                              pressure_zz_inst_st   [kk]+tab+$
                              energy_flux_x_inst_st [kk]+tab+$
                              energy_flux_y_inst_st [kk]+tab+$
                              energy_flux_z_inst_st [kk]+tab+$
                              bulk_speed_spcrft_st  [kk]+tab+$ 
                              vx_spcrft_st          [kk]+tab+$
                              vy_spcrft_st          [kk]+tab+$
                              vz_spcrft_st          [kk]+tab+$
                              ns_spcrft_st          [kk]+tab+$
                              ew_spcrft_st          [kk]+tab+$
                              error_st              [kk]+tab+$
                              poor_stats_st         [kk]+tab+$
                              look_up_vel_st        [kk]+tab+$
                              svalid_ratrig_st      [kk]+tab+$
                              ra_eff_st             [kk]+tab+$
                              pri0_ratio_st         [kk]+tab+$
                              vel_sdev_st           [kk]
                printf, out_lun, temp_string
            ENDFOR
        ENDIF 
        close, out_lun
        free_lun, out_lun

                ; put in CDF
        out_dir = out_dir_base+'Spacecraft_'+sat+'/Level2/CDFs/OBMoments/Non_valid/'+string(ts_struct.year, format = '(I4.4)')+'/'
        out_file = 'ST'+sat+'_L2_PLA_OBMom_1min_nonvalid_'+string(ts_struct.year, format = '(I4.4)')+$
                   string(ts_struct.month, format = '(I2.2)')+$
                   string(ts_struct.date, format = '(I2.2)')+'_'+version
        out_path = out_dir+out_file
        command = '$SKELETONCDF -cdf '+out_path+' -delete -fillval '+skeleton_name
        spawn, command
        temp_out_name = out_path+'.cdf'
        cdf_id = cdf_open(temp_out_name)
        date = systime()
        WHILE strlen(date) LT 32 DO BEGIN
            date = date+' '
        ENDWHILE 
                                ; load into cdf
        cdf_varput,     cdf_id, 'processing_date',              date,                       /zvariable
        IF have_data EQ 1 THEN BEGIN 
                                ; convert epoch
            epoch_d = time_epoch(ob_t)
            cdf_varput, cdf_id, 'epoch',                        epoch_d,                    /zvariable
            cdf_varput, cdf_id, 'error',                        error_d,                    /zvariable 
            cdf_varput, cdf_id, 'look_up_vel',                  look_up_vel_d,              /zvariable 
            cdf_varput, cdf_id, 'svalid_ratrig',                svalid_ratrig_d,            /zvariable 
            cdf_varput, cdf_id, 'ra_eff',                       ra_eff_d,                   /zvariable 
            cdf_varput, cdf_id, 'pri0_ratio',                   pri0_ratio_d,               /zvariable 
            cdf_varput, cdf_id, 'velocity_sdev',                vel_sdev_d,                 /zvariable 
            cdf_varput, cdf_id, 'error_poor_stats',             poor_stats_d,               /zvariable 
            cdf_varput, cdf_id, 'proton_density',               density_d,                  /zvariable
            cdf_varput, cdf_id, 'proton_bulk_speed_inst',       bulk_speed_inst_d,          /zvariable
            cdf_varput, cdf_id, 'proton_Vx_inst',               vx_inst_d,                  /zvariable
            cdf_varput, cdf_id, 'proton_Vy_inst',               vy_inst_d,                  /zvariable
            cdf_varput, cdf_id, 'proton_Vz_inst',               vz_inst_d,                  /zvariable
            cdf_varput, cdf_id, 'proton_n_s_flow_angle_inst',   ns_inst_d,                  /zvariable
            cdf_varput, cdf_id, 'proton_e_w_flow_angle_inst',   ew_inst_d,                  /zvariable
            cdf_varput, cdf_id, 'proton_temperature_xx_inst',   temperature_xx_inst_d,      /zvariable
            cdf_varput, cdf_id, 'proton_temperature_xy_inst',   temperature_xy_inst_d,      /zvariable
            cdf_varput, cdf_id, 'proton_temperature_xz_inst',   temperature_xz_inst_d,      /zvariable
            cdf_varput, cdf_id, 'proton_temperature_yy_inst',   temperature_yy_inst_d,      /zvariable
            cdf_varput, cdf_id, 'proton_temperature_yz_inst',   temperature_yz_inst_d,      /zvariable
            cdf_varput, cdf_id, 'proton_temperature_zz_inst',   temperature_zz_inst_d,      /zvariable
            cdf_varput, cdf_id, 'proton_pressure_xx_inst',      pressure_xx_inst_d,         /zvariable
            cdf_varput, cdf_id, 'proton_pressure_xy_inst',      pressure_xy_inst_d,         /zvariable
            cdf_varput, cdf_id, 'proton_pressure_xz_inst',      pressure_xz_inst_d,         /zvariable
            cdf_varput, cdf_id, 'proton_pressure_yy_inst',      pressure_yy_inst_d,         /zvariable
            cdf_varput, cdf_id, 'proton_pressure_yz_inst',      pressure_yz_inst_d,         /zvariable
            cdf_varput, cdf_id, 'proton_pressure_zz_inst',      pressure_zz_inst_d,         /zvariable
            cdf_varput, cdf_id, 'proton_energy_flux_x_inst',    energy_flux_x_inst_d,       /zvariable
            cdf_varput, cdf_id, 'proton_energy_flux_y_inst',    energy_flux_y_inst_d,       /zvariable
            cdf_varput, cdf_id, 'proton_energy_flux_z_inst',    energy_flux_z_inst_d,       /zvariable
            cdf_varput, cdf_id, 'proton_bulk_speed_spcrft',     bulk_speed_spcrft_d,        /zvariable
            cdf_varput, cdf_id, 'proton_Vx_spcrft',             vx_spcrft_d,                /zvariable
            cdf_varput, cdf_id, 'proton_Vy_spcrft',             vy_spcrft_d,                /zvariable
            cdf_varput, cdf_id, 'proton_Vz_spcrft',             vz_spcrft_d,                /zvariable
            cdf_varput, cdf_id, 'proton_n_s_flow_angle_spcrft', ns_spcrft_d,                /zvariable
            cdf_varput, cdf_id, 'proton_e_w_flow_angle_spcrft', ew_spcrft_d,                /zvariable
            cdf_varput, cdf_id, 'proton_bulk_speed_HERTN',      reform(bulk_speed_hertn_d), /zvariable
            cdf_varput, cdf_id, 'proton_Vr_HERTN',              reform(vr_hertn_d),         /zvariable
            cdf_varput, cdf_id, 'proton_Vt_HERTN',              reform(vt_hertn_d),         /zvariable
            cdf_varput, cdf_id, 'proton_Vn_HERTN',              reform(vn_hertn_d),         /zvariable
            cdf_varput, cdf_id, 'proton_n_s_flow_angle_HERTN',  reform(ns_hertn_d),         /zvariable
            cdf_varput, cdf_id, 'proton_e_w_flow_angle_HERTN',  reform(ew_hertn_d),         /zvariable
            cdf_varput, cdf_id, 'proton_bulk_speed_RTN',        reform(bulk_speed_rtn_d),   /zvariable
            cdf_varput, cdf_id, 'proton_Vr_RTN',                reform(vr_rtn_d),           /zvariable
            cdf_varput, cdf_id, 'proton_Vt_RTN',                reform(vt_rtn_d),           /zvariable
            cdf_varput, cdf_id, 'proton_Vn_RTN',                reform(vn_rtn_d),           /zvariable
            cdf_varput, cdf_id, 'proton_n_s_flow_angle_RTN',    reform(ns_rtn_d),           /zvariable
            cdf_varput, cdf_id, 'proton_e_w_flow_angle_RTN',    reform(ew_rtn_d),           /zvariable
        ENDIF 
        cdf_close, cdf_id

        ; update efficiency files if no data
        IF have_data EQ 0 THEN BEGIN
            read_ratios, sat, ts_struct.year, svalid_ratio, pri0_ratio
            IF ts_struct.doy GT 1 THEN BEGIN 
                svalid_ratio[ts_struct.doy-1, *] = svalid_ratio[ts_struct.doy-2, *]
                pri0_ratio  [ts_struct.doy-1, *] = pri0_ratio  [ts_struct.doy-2, *]
            ENDIF ELSE BEGIN 
                read_ratios, sat, ts_struct.year-1, old_svalid_ratio, old_pri0_ratio
                IF (ts_struct.year-1) MOD 4 EQ 0 THEN BEGIN ; leap year
                    svalid_ratio[0, *] = old_svalid_ratio[365, *]
                    pri0_ratio  [0, *] = old_pri0_ratio  [365, *]
                ENDIF ELSE BEGIN 
                    svalid_ratio[0, *] = old_svalid_ratio[364, *]
                    pri0_ratio  [0, *] = old_pri0_ratio  [364, *]
                ENDELSE 
            ENDELSE 
            update_ratios, ts_struct.year, sat, svalid_ratio, pri0_ratio
        ENDIF 
        print, "Finished ", out_file
        tplot_names, '*', names = names
        store_data, names, /DEL
        ts = ts + 86400.
     ENDFOR 
 ENDFOR 
print, "Done"

END 
