; Lorna Ellis
; 09/03/2010
; create_alpha_ra_1hr_cdfs_yearly.pro

; This program reads an ascii file (as provided by Kristin and creates a CDF file from it.

PRO create_alpha_ra_1hr_cdfs_yearly, version, sat, year
compile_opt strictarrsubs

version = string(version, format = '(I2.2)')
base = 'ST'+sat+'_L2_PLA_Alpha_RA_1DMax_1hr_'+string(year, format = '(I4.4)')+'_V'+version
ascii_dir = '/nfs/fijidata1/Ascii/Level2/Alphas/Valid/1hr/'
out_a_dir_base = '/data1/' ; guam
out_b_dir_base = '/data2/' ; guam
skt_version = 'V04'  ; version of skeleton file

times   = strarr(366*24)
den     = fltarr(366*24)
vel     = fltarr(366*24)
vth     = fltarr(366*24)
na_np   = fltarr(366*24)
va_vp   = fltarr(366*24)
cyc_na  = fltarr(366*24)
cyc_va  = fltarr(366*24)
cyc_nv  = fltarr(366*24)
caution = fltarr(366*24)

; read ascii file
infile = ascii_dir+base+'.txt'
line = ''
openr, in_lun, infile, /get_lun
readf, in_lun, line ; header
index = 0
WHILE eof(in_lun) EQ 0 DO BEGIN
    readf, in_lun, line        
    parts = strsplit(line, /extract)
    times  [index] =       parts[3]
    den    [index] = float(parts[4])
    vel    [index] = float(parts[5])
    vth    [index] = float(parts[6])
    na_np  [index] = float(parts[7])
    va_vp  [index] = float(parts[8])
    IF parts[09] EQ -1 THEN cyc_na[index] = -1E31 ELSE cyc_na[index] = float(parts[09])
    IF parts[10] EQ -1 THEN cyc_va[index] = -1E31 ELSE cyc_va[index] = float(parts[10])
    IF parts[11] EQ -1 THEN cyc_nv[index] = -1E31 ELSE cyc_nv[index] = float(parts[11])
    caution[index] = float(parts[12])
    index = index + 1
ENDWHILE
close, in_lun
free_lun, in_lun
good_i  = where(times NE '', good_count)
times   = times  [good_i]
den     = den    [good_i]
vel     = vel    [good_i]
vth     = vth    [good_i]
na_np   = na_np  [good_i]
va_vp   = va_vp  [good_i]
cyc_na  = cyc_na [good_i]
cyc_va  = cyc_va [good_i]
cyc_nv  = cyc_nv [good_i]
caution = caution[good_i]
epoch  = time_epoch(times)

; open CDF
skeleton_name = '~/Level2/SKT/ST'+sat+'_L2_PLA_Alpha_RA_1DMax_1hr_00000000_'+skt_version ; guam
IF sat EQ 'A' THEN out_dir_base = out_a_dir_base ELSE out_dir_base = out_b_dir_base
out_dir = out_dir_base+'Spacecraft_'+sat+'/Level2/CDFs/Alphas/Non_valid/1hr/'
out_path = out_dir+base
command = '$SKELETONCDF -cdf '+out_path+' -delete -fillval '+skeleton_name
spawn, command
temp_out_name = out_path+'.cdf'
cdf_id = cdf_open(temp_out_name)
date = systime()
WHILE strlen(date) LT 32 DO BEGIN
    date = date+' '
ENDWHILE 

; load into cdf
cdf_varput, cdf_id, 'processing_date',      date,    /zvariable
cdf_varput, cdf_id, 'epoch',                epoch,   /zvariable
cdf_varput, cdf_id, 'alpha_density',        den,     /zvariable
cdf_varput, cdf_id, 'alpha_bulk_speed',     vel,     /zvariable
cdf_varput, cdf_id, 'alpha_thermal_speed',  vth,     /zvariable
cdf_varput, cdf_id, 'Na_Np',                na_np,   /zvariable
cdf_varput, cdf_id, 'Va_Vp',                va_vp,   /zvariable
cdf_varput, cdf_id, 'alpha_cycles_den_vth', cyc_na,  /zvariable
cdf_varput, cdf_id, 'alpha_cycles_vel',     cyc_va,  /zvariable
cdf_varput, cdf_id, 'alpha_cycles_na_np',   cyc_nv,  /zvariable
cdf_varput, cdf_id, 'alpha_caution',        caution, /zvariable
cdf_close, cdf_id
print, "Finished ", base

END 
