;+
; PROCEDURE: obmoments_ab_comparison
;
; PURPOSE: To create daily on-board moments plots for 'A' and 'B'
;
; INPUT: Adjust the start_time and end_time
;
; CREATED BY: C. Mouikis
;
; MODIFICATION HISTORY:
;
;-
PRO obmoments_ab_comparison


start_time = '2007-01-20/00:00:00'
end_time   = '2007-02-27/00:00:00'

ts = time_struct(start_time)
te = time_struct(end_time)

nofdays = te.daynum - ts.daynum

ts = time_double(start_time)
FOR ii = 0, nofdays-1 DO BEGIN


    timespan, ts, 1, /DAYS      ; SECONDS, MINUTES, HOURS, DAYS (DEFAULT)




    sat_moment = ['A_D', 'B_D']


    set_com
    set_com_mom
    pl_plot_obmom_from_crib, sat_moment, /INST_COORD
    

    p1a = 'A_mom_density'
    p2a = 'A_mom_velocity_inst_x'
    p3a = 'A_mom_velocity_inst_y'
    p4a = 'A_mom_velocity_inst_z'
    p5a = 'A_mom_temp_inst_xx'
    p6a = 'A_mom_temp_inst_yy'
    p7a = 'A_mom_temp_inst_zz'

    p1b = 'B_mom_density'
    p2b = 'B_mom_velocity_inst_x'
    p3b = 'B_mom_velocity_inst_y'
    p4b = 'B_mom_velocity_inst_z'
    p5b = 'B_mom_temp_inst_xx'
    p6b = 'B_mom_temp_inst_yy'
    p7b = 'B_mom_temp_inst_zz'

    options, [p1b, p2b, p3b, p4b, p5b, p6b, p7b], 'color', 2

    ylim, [p1a, p1b], 0.01, 1e2, 1
    ylim, [p2a, p2b], 0, 800, 0
    ylim, [p3a, p3b], -300, 300, 0
    ylim, [p4a, p4b], -100, 100, 0
    ylim, [p5a, p6a, p7a, p5b, p6b, p7b], 1e2, 1e7, 1

    options, [p1a, p2a, p3a, p4a, p5a, p6a, p7a, p1b, p2b, p3b, p4b, p5b, p6b, p7b],  'thick', 2

    yr = STRMID(time_string(ts), 0, 4)
    mo = STRMID(time_string(ts), 5, 2)
    da = STRMID(time_string(ts), 8, 2)
    ofn = 'PLA_page_moments_' + yr + mo + da 
    popen, ofn
    tplot,  [p1a, p2a, p3a, p4a, p5a, p6a, p7a]
    tplot_panel,  v = p1a, o = p1b
    tplot_panel,  v = p2a, o = p2b
    tplot_panel,  v = p3a, o = p3b
    tplot_panel,  v = p4a, o = p4b
    tplot_panel,  v = p5a, o = p5b
    tplot_panel,  v = p6a, o = p6b
    tplot_panel,  v = p7a, o = p7b

    yline,  [p2a, p3a, p4a]

    pclose

    ts = ts + 86400.

    tplot_names, '*', names = names
    store_data, names, /DEL


ENDFOR












END
