;+
; PROCEDURE: mon_rates
;
; PURPOSE: To create daily rates plots
;
; INPUT: Adjust the start_time and end_time
;
; CREATED BY: C. Mouikis
;
; MODIFICATION HISTORY:
;
;-
FUNCTION get_total_counts, tvar

get_data, tvar, data = data

RETURN, TOTAL(data.y, /NaN)

END

PRO mon_rates


start_time = '2007-01-20/00:00:00'
end_time   = '2007-03-05/00:00:00'

ts = time_struct(start_time)
te = time_struct(end_time)

nofdays = te.daynum - ts.daynum

a_accum_time = DBLARR(nofdays)
a_accum_s_valid = FLTARR(nofdays)
a_accum_ssd_sw = FLTARR(nofdays)
a_accum_sf0 = FLTARR(nofdays)
a_accum_sfr0 = FLTARR(nofdays)
a_accum_ra_trig = FLTARR(nofdays)
a_accum_w_valid = FLTARR(nofdays)
a_accum_sf2 = FLTARR(nofdays)
a_accum_sfr2 = FLTARR(nofdays)
a_accum_pos2_3 = FLTARR(nofdays)
a_accum_sum_pos = FLTARR(nofdays)

b_accum_time = DBLARR(nofdays)
b_accum_s_valid = FLTARR(nofdays)
b_accum_ssd_sw = FLTARR(nofdays)
b_accum_sf0 = FLTARR(nofdays)
b_accum_sfr0 = FLTARR(nofdays)
b_accum_ra_trig = FLTARR(nofdays)
b_accum_w_valid = FLTARR(nofdays)
b_accum_sf2 = FLTARR(nofdays)
b_accum_sfr2 = FLTARR(nofdays)
b_accum_pos2_3 = FLTARR(nofdays)
b_accum_sum_pos = FLTARR(nofdays)

ts = time_double(start_time)
FOR ii = 0, nofdays-1 DO BEGIN


    timespan, ts, 1, /DAYS      ; SECONDS, MINUTES, HOURS, DAYS (DEFAULT)

    ;-----------------------------------------------------------------
    ; Load the data
    ;-----------------------------------------------------------------
    sat = 'A' &  HZ = 0 & NO_ENG = 0 & E_step = [32]
    sat_mon = ['s_valid','ssd_sw','sf0','sfr0','ra_trig','stop0', $
               'w_valid', 'sf2', 'sfr2', 'stop2', $
               'pos2_0', 'pos2_1', 'pos2_2', 'pos2_3', $
               'pos3_0', 'pos3_1', 'pos3_2', 'pos3_3']

    set_com_mon
    pl_plot_mon_from_crib, sat_mon, E_step, HZ, NO_ENG, sat, /INST_COORD


    sat = 'B' &  HZ = 0 & NO_ENG = 0 & E_step = [32]
    sat_mon = ['s_valid','ssd_sw','sf0','sfr0','ra_trig','stop0', $
               'w_valid', 'sf2', 'sfr2', 'stop2', $
               'pos2_0', 'pos2_1', 'pos2_2', 'pos2_3', $
               'pos3_0', 'pos3_1', 'pos3_2', 'pos3_3']

    set_com_mon
    pl_plot_mon_from_crib, sat_mon, E_step, HZ, NO_ENG, sat, /INST_COORD

    
    ;-----------------------------------------------------------------
    ; Create abreviated names for the variables
    ;-----------------------------------------------------------------
    ; STA - SCI
    p01as = 'A_Monitor_Rate_s_valid_sci_32'
    p02as = 'A_Monitor_Rate_ssd_sw_sci_32'
    p03as = 'A_Monitor_Rate_sf0_sci_32'
    p04as = 'A_Monitor_Rate_sfr0_sci_32'
    p05as = 'A_Monitor_Rate_ra_trig_sci_32'
    p06as = 'A_Monitor_Rate_stop0_sci_32'
    p07as = 'A_Monitor_Rate_w_valid_sci_32'
    p08as = 'A_Monitor_Rate_sf2_sci_32'
    p09as = 'A_Monitor_Rate_sfr2_sci_32'
    p10as = 'A_Monitor_Rate_stop2_sci_32'
    p11as = 'A_Monitor_Rate_pos2_0_sci_32'
    p12as = 'A_Monitor_Rate_pos2_1_sci_32'
    p13as = 'A_Monitor_Rate_pos2_2_sci_32'
    p14as = 'A_Monitor_Rate_pos2_3_sci_32'
    p15as = 'A_Monitor_Rate_pos3_0_sci_32'
    p16as = 'A_Monitor_Rate_pos3_1_sci_32'
    p17as = 'A_Monitor_Rate_pos3_2_sci_32'
    p18as = 'A_Monitor_Rate_pos3_3_sci_32'
    p19as = 'A_Monitor_Rate_sf0_ra_trig_sci_32'
    p20as = 'A_Monitor_Rate_s_valid_ra_trig_sci_32'
    p21as = 'A_Monitor_Rate_sum_pos_sci_32'
    p22as = 'A_Monitor_Rate_ratios_sci_32'
    p23as = 'A_Monitor_Rate_sfr0_sf0_sci_32'
    p24as = 'A_Monitor_Rate_sfr2_sf2_sci_32'

    ; STA - ENG
    p01ae = 'A_Monitor_Rate_s_valid_eng_32'
    p02ae = 'A_Monitor_Rate_ssd_sw_eng_32'
    p03ae = 'A_Monitor_Rate_sf0_eng_32'
    p04ae = 'A_Monitor_Rate_sfr0_eng_32'
    p05ae = 'A_Monitor_Rate_ra_trig_eng_32'
    p06ae = 'A_Monitor_Rate_stop0_eng_32'
    p07ae = 'A_Monitor_Rate_w_valid_eng_32'
    p08ae = 'A_Monitor_Rate_sf2_eng_32'
    p09ae = 'A_Monitor_Rate_sfr2_eng_32'
    p10ae = 'A_Monitor_Rate_stop2_eng_32'
    p11ae = 'A_Monitor_Rate_pos2_0_eng_32'
    p12ae = 'A_Monitor_Rate_pos2_1_eng_32'
    p13ae = 'A_Monitor_Rate_pos2_2_eng_32'
    p14ae = 'A_Monitor_Rate_pos2_3_eng_32'
    p15ae = 'A_Monitor_Rate_pos3_0_eng_32'
    p16ae = 'A_Monitor_Rate_pos3_1_eng_32'
    p17ae = 'A_Monitor_Rate_pos3_2_eng_32'
    p18ae = 'A_Monitor_Rate_pos3_3_eng_32'
    p19ae = 'A_Monitor_Rate_sf0_ra_trig_eng_32'
    p20ae = 'A_Monitor_Rate_s_valid_ra_trig_eng_32'
    p21ae = 'A_Monitor_Rate_sum_pos_eng_32'
    p22ae = 'A_Monitor_Rate_ratios_eng_32'
    p23ae = 'A_Monitor_Rate_sfr0_sf0_eng_32'
    p24ae = 'A_Monitor_Rate_sfr2_sf2_eng_32'

    ; STB - SCI
    p01bs = 'B_Monitor_Rate_s_valid_sci_32'
    p02bs = 'B_Monitor_Rate_ssd_sw_sci_32'
    p03bs = 'B_Monitor_Rate_sf0_sci_32'
    p04bs = 'B_Monitor_Rate_sfr0_sci_32'
    p05bs = 'B_Monitor_Rate_ra_trig_sci_32'
    p06bs = 'B_Monitor_Rate_stop0_sci_32'
    p07bs = 'B_Monitor_Rate_w_valid_sci_32'
    p08bs = 'B_Monitor_Rate_sf2_sci_32'
    p09bs = 'B_Monitor_Rate_sfr2_sci_32'
    p10bs = 'B_Monitor_Rate_stop2_sci_32'
    p11bs = 'B_Monitor_Rate_pos2_0_sci_32'
    p12bs = 'B_Monitor_Rate_pos2_1_sci_32'
    p13bs = 'B_Monitor_Rate_pos2_2_sci_32'
    p14bs = 'B_Monitor_Rate_pos2_3_sci_32'
    p15bs = 'B_Monitor_Rate_pos3_0_sci_32'
    p16bs = 'B_Monitor_Rate_pos3_1_sci_32'
    p17bs = 'B_Monitor_Rate_pos3_2_sci_32'
    p18bs = 'B_Monitor_Rate_pos3_3_sci_32'
    p19bs = 'B_Monitor_Rate_sf0_ra_trig_sci_32'
    p20bs = 'B_Monitor_Rate_s_valid_ra_trig_sci_32'
    p21bs = 'B_Monitor_Rate_sum_pos_sci_32'
    p22bs = 'B_Monitor_Rate_ratios_sci_32'
    p23bs = 'B_Monitor_Rate_sfr0_sf0_sci_32'
    p24bs = 'B_Monitor_Rate_sfr2_sf2_sci_32'

    ; STB - ENG
    p01be = 'B_Monitor_Rate_s_valid_eng_32'
    p02be = 'B_Monitor_Rate_ssd_sw_eng_32'
    p03be = 'B_Monitor_Rate_sf0_eng_32'
    p04be = 'B_Monitor_Rate_sfr0_eng_32'
    p05be = 'B_Monitor_Rate_ra_trig_eng_32'
    p06be = 'B_Monitor_Rate_stop0_eng_32'
    p07be = 'B_Monitor_Rate_w_valid_eng_32'
    p08be = 'B_Monitor_Rate_sf2_eng_32'
    p09be = 'B_Monitor_Rate_sfr2_eng_32'
    p10be = 'B_Monitor_Rate_stop2_eng_32'
    p11be = 'B_Monitor_Rate_pos2_0_eng_32'
    p12be = 'B_Monitor_Rate_pos2_1_eng_32'
    p13be = 'B_Monitor_Rate_pos2_2_eng_32'
    p14be = 'B_Monitor_Rate_pos2_3_eng_32'
    p15be = 'B_Monitor_Rate_pos3_0_eng_32'
    p16be = 'B_Monitor_Rate_pos3_1_eng_32'
    p17be = 'B_Monitor_Rate_pos3_2_eng_32'
    p18be = 'B_Monitor_Rate_pos3_3_eng_32'
    p19be = 'B_Monitor_Rate_sf0_ra_trig_eng_32'
    p20be = 'B_Monitor_Rate_s_valid_ra_trig_eng_32'
    p21be = 'B_Monitor_Rate_sum_pos_eng_32'
    p22be = 'B_Monitor_Rate_ratios_eng_32'
    p23be = 'B_Monitor_Rate_sfr0_sf0_eng_32'
    p24be = 'B_Monitor_Rate_sfr2_sf2_eng_32'

    ;-----------------------------------------------------------------
    ; Calculate ratios / sums
    ;-----------------------------------------------------------------
    ;Calculate sfr0/sf0
    ;STA/SCI
    get_data, p04as, data = data, dlim = dlim, lim = lim
    sfr0_sf0 = data.y
    get_data, p03as, data = data
    sfr0_sf0 = sfr0_sf0 / data.y

    store_data, p23as, data = {x:data.x, y:sfr0_sf0}, dlim = dlim, lim = lim

    ;STA/ENG
    get_data, p04ae, data = data, dlim = dlim, lim = lim
    sfr0_sf0 = data.y
    get_data, p03ae, data = data
    sfr0_sf0 = sfr0_sf0 / data.y

    store_data, p23ae, data = {x:data.x, y:sfr0_sf0}, dlim = dlim, lim = lim

    ;STB/SCI
    get_data, p04bs, data = data, dlim = dlim, lim = lim
    sfr0_sf0 = data.y
    get_data, p03bs, data = data
    sfr0_sf0 = sfr0_sf0 / data.y

    store_data, p23bs, data = {x:data.x, y:sfr0_sf0}, dlim = dlim, lim = lim
    
    ;STB/ENG
    get_data, p04be, data = data, dlim = dlim, lim = lim
    sfr0_sf0 = data.y
    get_data, p03be, data = data
    sfr0_sf0 = sfr0_sf0 / data.y

    store_data, p23be, data = {x:data.x, y:sfr0_sf0}, dlim = dlim, lim = lim
    
    ;Calculate sf0/ra_trig
    ;STA/SCI
    get_data, p03as, data = data, dlim = dlim, lim = lim
    sf0_ra_trig = data.y
    get_data, p05as, data = data
    sf0_ra_trig = sf0_ra_trig / data.y

    store_data, p19as, data = {x:data.x, y:sf0_ra_trig}, dlim = dlim, lim = lim

    ;STA/ENG
    get_data, p03ae, data = data, dlim = dlim, lim = lim
    sf0_ra_trig = data.y
    get_data, p05ae, data = data
    sf0_ra_trig = sf0_ra_trig / data.y

    store_data, p19ae, data = {x:data.x, y:sf0_ra_trig}, dlim = dlim, lim = lim

    ;STB/SCI
    get_data, p03bs, data = data, dlim = dlim, lim = lim
    sf0_ra_trig = data.y
    get_data, p05bs, data = data
    sf0_ra_trig = sf0_ra_trig / data.y

    store_data, p19bs, data = {x:data.x, y:sf0_ra_trig}, dlim = dlim, lim = lim

    ;STB/ENG
    get_data, p03be, data = data, dlim = dlim, lim = lim
    sf0_ra_trig = data.y
    get_data, p05be, data = data
    sf0_ra_trig = sf0_ra_trig / data.y

    store_data, p19be, data = {x:data.x, y:sf0_ra_trig}, dlim = dlim, lim = lim


    ;Calculate s_valid/ra_trig
    ;STA/SCI
    get_data, p01as, data = data, dlim = dlim, lim = lim
    s_valid_ra_trig = data.y
    get_data, p05as, data = data
    s_valid_ra_trig = s_valid_ra_trig / data.y

    store_data, p20as, data = {x:data.x, y:s_valid_ra_trig}, dlim = dlim, lim = lim

    ;STA/ENG
    get_data, p01ae, data = data, dlim = dlim, lim = lim
    s_valid_ra_trig = data.y
    get_data, p05ae, data = data
    s_valid_ra_trig = s_valid_ra_trig / data.y

    store_data, p20ae, data = {x:data.x, y:s_valid_ra_trig}, dlim = dlim, lim = lim

    ;STB/SCI
    get_data, p01bs, data = data, dlim = dlim, lim = lim
    s_valid_ra_trig = data.y
    get_data, p05bs, data = data
    s_valid_ra_trig = s_valid_ra_trig / data.y

    store_data, p20bs, data = {x:data.x, y:s_valid_ra_trig}, dlim = dlim, lim = lim

    ;STB/ENG
    get_data, p01be, data = data, dlim = dlim, lim = lim
    s_valid_ra_trig = data.y
    get_data, p05be, data = data
    s_valid_ra_trig = s_valid_ra_trig / data.y

    store_data, p20be, data = {x:data.x, y:s_valid_ra_trig}, dlim = dlim, lim = lim


    ;Calculate sfr2/sf2
    ;STA/SCI
    get_data, p04as, data = data, dlim = dlim, lim = lim
    sfr2_sf2 = data.y
    get_data, p03as, data = data
    sfr2_sf2 = sfr2_sf2 / data.y

    store_data, p24as, data = {x:data.x, y:sfr2_sf2}, dlim = dlim, lim = lim

    ;STA/ENG
    get_data, p04ae, data = data, dlim = dlim, lim = lim
    sfr2_sf2 = data.y
    get_data, p03ae, data = data
    sfr2_sf2 = sfr2_sf2 / data.y

    store_data, p24ae, data = {x:data.x, y:sfr2_sf2}, dlim = dlim, lim = lim

    ;STB/SCI
    get_data, p04bs, data = data, dlim = dlim, lim = lim
    sfr2_sf2 = data.y
    get_data, p03bs, data = data
    sfr2_sf2 = sfr2_sf2 / data.y

    store_data, p24bs, data = {x:data.x, y:sfr2_sf2}, dlim = dlim, lim = lim
    
    ;STB/ENG
    get_data, p04be, data = data, dlim = dlim, lim = lim
    sfr2_sf2 = data.y
    get_data, p03be, data = data
    sfr2_sf2 = sfr2_sf2 / data.y

    store_data, p24be, data = {x:data.x, y:sfr2_sf2}, dlim = dlim, lim = lim
    

    ;Calculate sum of all position rates
    ;STA/SCI
    get_data, p11as, data = data, dlim = dlim, lim = lim
    sum_pos = data.y
    get_data, p12as, data = data
    sum_pos = sum_pos + data.y
    get_data, p13as, data = data
    sum_pos = sum_pos + data.y
    get_data, p14as, data = data
    sum_pos = sum_pos + data.y
    get_data, p15as, data = data
    sum_pos = sum_pos + data.y
    get_data, p16as, data = data
    sum_pos = sum_pos + data.y
    get_data, p17as, data = data
    sum_pos = sum_pos + data.y
    get_data, p18as, data = data
    sum_pos = sum_pos + data.y

    store_data, p21as, data = {x:data.x, y:sum_pos}, dlim = dlim, lim = lim

    ;STA/ENG
    get_data, p11ae, data = data, dlim = dlim, lim = lim
    sum_pos = data.y
    get_data, p12ae, data = data
    sum_pos = sum_pos + data.y
    get_data, p13ae, data = data
    sum_pos = sum_pos + data.y
    get_data, p14ae, data = data
    sum_pos = sum_pos + data.y
    get_data, p15ae, data = data
    sum_pos = sum_pos + data.y
    get_data, p16ae, data = data
    sum_pos = sum_pos + data.y
    get_data, p17ae, data = data
    sum_pos = sum_pos + data.y
    get_data, p18ae, data = data
    sum_pos = sum_pos + data.y

    store_data, p21ae, data = {x:data.x, y:sum_pos}, dlim = dlim, lim = lim

    ;STB/SCI
    get_data, p11bs, data = data, dlim = dlim, lim = lim
    sum_pos = data.y
    get_data, p12bs, data = data
    sum_pos = sum_pos + data.y
    get_data, p13bs, data = data
    sum_pos = sum_pos + data.y
    get_data, p14bs, data = data
    sum_pos = sum_pos + data.y
    get_data, p15bs, data = data
    sum_pos = sum_pos + data.y
    get_data, p16bs, data = data
    sum_pos = sum_pos + data.y
    get_data, p17bs, data = data
    sum_pos = sum_pos + data.y
    get_data, p18bs, data = data
    sum_pos = sum_pos + data.y

    store_data, p21bs, data = {x:data.x, y:sum_pos}, dlim = dlim, lim = lim

    ;STB/ENG
    get_data, p11be, data = data, dlim = dlim, lim = lim
    sum_pos = data.y
    get_data, p12be, data = data
    sum_pos = sum_pos + data.y
    get_data, p13be, data = data
    sum_pos = sum_pos + data.y
    get_data, p14be, data = data
    sum_pos = sum_pos + data.y
    get_data, p15be, data = data
    sum_pos = sum_pos + data.y
    get_data, p16be, data = data
    sum_pos = sum_pos + data.y
    get_data, p17be, data = data
    sum_pos = sum_pos + data.y
    get_data, p18be, data = data
    sum_pos = sum_pos + data.y

    store_data, p21be, data = {x:data.x, y:sum_pos}, dlim = dlim, lim = lim

    ;Put sfr0/sf0, sf0/ra_trig, s_valid/ra_trig in one plot
    ;STA / SCI
    get_data, p23as, data = d1
    get_data, p19as, data = d2
    get_data, p20as, data = d3

    labels = ['sfr0/sf0', 'sf0/ra_trig', 's_valid/ra_trig']
    store_data, p22as, data = {x:d1.x, y:[[d1.y], [d2.y], [d3.y]]}, dlim = {labels:labels, panel_size:2}

    ;STA / ENG
    get_data, p23ae, data = d1
    get_data, p19ae, data = d2
    get_data, p20ae, data = d3

    labels = ['sfr0/sf0', 'sf0/ra_trig', 's_valid/ra_trig']
    store_data, p22ae, data = {x:d1.x, y:[[d1.y], [d2.y], [d3.y]]}, dlim = {labels:labels, panel_size:2}

    ;STB / SCI
    get_data, p23bs, data = d1
    get_data, p19bs, data = d2
    get_data, p20bs, data = d3

    labels = ['sfr0/sf0', 'sf0/ra_trig', 's_valid/ra_trig']
    store_data, p22bs, data = {x:d1.x, y:[[d1.y], [d2.y], [d3.y]]}, dlim = {labels:labels, panel_size:2}

    ;STB / ENG
    get_data, p23be, data = d1
    get_data, p19be, data = d2
    get_data, p20be, data = d3

    labels = ['sfr0/sf0', 'sf0/ra_trig', 's_valid/ra_trig']
    store_data, p22be, data = {x:d1.x, y:[[d1.y], [d2.y], [d3.y]]}, dlim = {labels:labels, panel_size:2}

    ;-----------------------------------------------------------------
    ; Set attributes
    ;-----------------------------------------------------------------
    options, p01as, 'ytitle', 's_valid'
    options, p02as, 'ytitle', 'ssd_sw'
    options, p03as, 'ytitle', 'sf0'
    options, p04as, 'ytitle', 'sfr0'
    options, p05as, 'ytitle', 'ra_trig'
    options, p06as, 'ytitle', 'stop0'
    options, p07as, 'ytitle', 'w_valid'
    options, p08as, 'ytitle', 'sf2'
    options, p09as, 'ytitle', 'sfr2'
    options, p10as, 'ytitle', 'stop2'
    options, p11as, 'ytitle', 'pos2_0'
    options, p12as, 'ytitle', 'pos2_1'
    options, p13as, 'ytitle', 'pos2_2'
    options, p14as, 'ytitle', 'pos2_3'
    options, p15as, 'ytitle', 'pos3_0'
    options, p16as, 'ytitle', 'pos3_1'
    options, p17as, 'ytitle', 'pos3_2'
    options, p18as, 'ytitle', 'pos3_3'
    options, p19as, 'ytitle', 'sf0/ra_trig'
    options, p20as, 'ytitle', 's_valid/ra_trig'
    options, p21as, 'ytitle', 'sum pos'
    options, p22as, 'ytitle', 'Ratio'
    options, p23as, 'ytitle', 'sfr0/sf0'
    options, p24as, 'ytitle', 'sfr2/sf2'

    options, p01bs, 'ytitle', 's_valid'
    options, p02bs, 'ytitle', 'ssd_sw'
    options, p03bs, 'ytitle', 'sf0'
    options, p04bs, 'ytitle', 'sfr0'
    options, p05bs, 'ytitle', 'ra_trig'
    options, p06bs, 'ytitle', 'stop0'
    options, p07bs, 'ytitle', 'w_valid'
    options, p08bs, 'ytitle', 'sf2'
    options, p09bs, 'ytitle', 'sfr2'
    options, p10bs, 'ytitle', 'stop2'
    options, p11bs, 'ytitle', 'pos2_0'
    options, p12bs, 'ytitle', 'pos2_1'
    options, p13bs, 'ytitle', 'pos2_2'
    options, p14bs, 'ytitle', 'pos2_3'
    options, p15bs, 'ytitle', 'pos3_0'
    options, p16bs, 'ytitle', 'pos3_1'
    options, p17bs, 'ytitle', 'pos3_2'
    options, p18bs, 'ytitle', 'pos3_3'
    options, p19bs, 'ytitle', 'sf0/ra_trig'
    options, p20bs, 'ytitle', 's_valid/ra_trig'
    options, p21bs, 'ytitle', 'sum pos'
    options, p22bs, 'ytitle', 'Ratio'
    options, p23bs, 'ytitle', 'sfr0/sf0'
    options, p24bs, 'ytitle', 'sfr2/sf2'

    ylim, p01as, 1e3, 1e6, 1
    ylim, p02as, 1e3, 1e6, 1
    ylim, p03as, 1e4, 1e7, 1
    ylim, p04as, 1e3, 1e6, 1
    ylim, p05as, 1e4, 1e8, 1
    ylim, p07as, 1e2, 1e6, 1
    ylim, p08as, 1e4, 1e7, 1
    ylim, p09as, 1e3, 1e6, 1
    ylim, p14as, 1e3, 1e6, 1
    ylim, p21as, 1e4, 1e7, 1
    ylim, p22as, 0.001, 1, 1
    ylim, p24as, 0.001, 1, 1

    ylim, p01bs, 1e3, 1e6, 1
    ylim, p02bs, 1e3, 1e6, 1
    ylim, p03bs, 1e4, 1e7, 1
    ylim, p04bs, 1e3, 1e6, 1
    ylim, p05bs, 1e4, 1e8, 1
    ylim, p07bs, 1e2, 1e6, 1
    ylim, p08bs, 1e4, 1e7, 1
    ylim, p09bs, 1e3, 1e6, 1
    ylim, p14bs, 1e3, 1e6, 1
    ylim, p21bs, 1e4, 1e7, 1
    ylim, p22bs, 0.001, 1, 1
    ylim, p24bs, 0.001, 1, 1

    options, '*',  'thick', 2

    ;-----------------------------------------------------------------
    ; Calculate total counts - set in label
    ;-----------------------------------------------------------------

    options, p01as, 'labels', STRING(get_total_counts(p01as), FORMAT = '(e10.1)')
    options, p02as, 'labels', STRING(get_total_counts(p02as), FORMAT = '(e10.1)')
    options, p03as, 'labels', STRING(get_total_counts(p03as), FORMAT = '(e10.1)')
    options, p04as, 'labels', STRING(get_total_counts(p04as), FORMAT = '(e10.1)')
    options, p05as, 'labels', STRING(get_total_counts(p05as), FORMAT = '(e10.1)')

    options, p07as, 'labels', STRING(get_total_counts(p07as), FORMAT = '(e10.1)')
    options, p08as, 'labels', STRING(get_total_counts(p08as), FORMAT = '(e10.1)')
    options, p09as, 'labels', STRING(get_total_counts(p09as), FORMAT = '(e10.1)')
    options, p14as, 'labels', STRING(get_total_counts(p14as), FORMAT = '(e10.1)')
    options, p21as, 'labels', STRING(get_total_counts(p21as), FORMAT = '(e10.1)')

    options, p01bs, 'labels', STRING(get_total_counts(p01bs), FORMAT = '(e10.1)')
    options, p02bs, 'labels', STRING(get_total_counts(p02bs), FORMAT = '(e10.1)')
    options, p03bs, 'labels', STRING(get_total_counts(p03bs), FORMAT = '(e10.1)')
    options, p04bs, 'labels', STRING(get_total_counts(p04bs), FORMAT = '(e10.1)')
    options, p05bs, 'labels', STRING(get_total_counts(p05bs), FORMAT = '(e10.1)')

    options, p07bs, 'labels', STRING(get_total_counts(p07bs), FORMAT = '(e10.1)')
    options, p08bs, 'labels', STRING(get_total_counts(p08bs), FORMAT = '(e10.1)')
    options, p09bs, 'labels', STRING(get_total_counts(p09bs), FORMAT = '(e10.1)')
    options, p14bs, 'labels', STRING(get_total_counts(p14bs), FORMAT = '(e10.1)')
    options, p21bs, 'labels', STRING(get_total_counts(p21bs), FORMAT = '(e10.1)')

    ;-----------------------------------------------------------------
    ; Calculate accumulative counts
    ;-----------------------------------------------------------------
    get_timespan, tt

    a_accum_time(ii)    = time_double(tt(1))
    a_accum_s_valid(ii) = get_total_counts(p01as)
    a_accum_ssd_sw(ii)  = get_total_counts(p02as)
    a_accum_sf0(ii)     = get_total_counts(p03as)
    a_accum_sfr0(ii)    = get_total_counts(p04as)
    a_accum_ra_trig(ii) = get_total_counts(p05as)
    a_accum_w_valid(ii) = get_total_counts(p07as)
    a_accum_sf2(ii)     = get_total_counts(p08as)
    a_accum_sfr2(ii)    = get_total_counts(p09as)
    a_accum_pos2_3(ii)  = get_total_counts(p14as)
    a_accum_sum_pos(ii) = get_total_counts(p21as)

    b_accum_time(ii)    = time_double(tt(1))
    b_accum_s_valid(ii) = get_total_counts(p01bs)
    b_accum_ssd_sw(ii)  = get_total_counts(p02bs)
    b_accum_sf0(ii)     = get_total_counts(p03bs)
    b_accum_sfr0(ii)    = get_total_counts(p04bs)
    b_accum_ra_trig(ii) = get_total_counts(p05bs)
    b_accum_w_valid(ii) = get_total_counts(p07bs)
    b_accum_sf2(ii)     = get_total_counts(p08bs)
    b_accum_sfr2(ii)    = get_total_counts(p09bs)
    b_accum_pos2_3(ii)  = get_total_counts(p14bs)
    b_accum_sum_pos(ii) = get_total_counts(p21bs)

    ;-----------------------------------------------------------------
    ; Plot
    ;-----------------------------------------------------------------
    tplot, [p01as, p02as, p03as, p04as, p05as, p22as]

    yr = STRMID(time_string(ts), 0, 4)
    mo = STRMID(time_string(ts), 5, 2)
    da = STRMID(time_string(ts), 8, 2)
    ofn = 'STA_PLA_mon_rates_' + yr + mo + da + '_page1'

    popen,  ofn
    tplot, [p01as, p02as, p03as, p04as, p05as, p22as], title='STA/PLA Mon. Rates SW/WAP SSD'
    tplot_panel,  v = p01as, o = p01ae
    tplot_panel,  v = p02as, o = p02ae
    tplot_panel,  v = p03as, o = p03ae
    tplot_panel,  v = p04as, o = p04ae
    tplot_panel,  v = p05as, o = p05ae
    tplot_panel,  v = p22as, o = p22ae
    pclose

    ofn = 'STB_PLA_mon_rates_' + yr + mo + da + '_page1'

    popen,  ofn
    tplot, [p01bs, p02bs, p03bs, p04bs, p05bs, p22bs], title='STB/PLA Mon. Rates SW/WAP SSD'
    tplot_panel,  v = p01bs, o = p01be
    tplot_panel,  v = p02bs, o = p02be
    tplot_panel,  v = p03bs, o = p03be
    tplot_panel,  v = p04bs, o = p04be
    tplot_panel,  v = p05bs, o = p05be
    tplot_panel,  v = p22bs, o = p22be
    pclose

    ofn = 'STA_PLA_mon_rates_' + yr + mo + da + '_page2'
    popen, ofn
    tplot, [p07as, p08as, p09as, p14as, p21as, p24as], title='STA/PLA Mon. Rates WAP NO SSD'
    tplot_panel,  v = p07as, o = p07ae
    tplot_panel,  v = p08as, o = p08ae
    tplot_panel,  v = p09as, o = p09ae
    tplot_panel,  v = p14as, o = p14ae
    tplot_panel,  v = p21as, o = p21ae
    tplot_panel,  v = p24as, o = p24ae
    pclose

    ofn = 'STB_PLA_mon_rates_' + yr + mo + da + '_page2'
    popen, ofn
    tplot, [p07bs, p08bs, p09bs, p14bs, p21bs, p24bs], title='STB/PLA Mon. Rates WAP NO SSD'
    tplot_panel,  v = p07bs, o = p07be
    tplot_panel,  v = p08bs, o = p08be
    tplot_panel,  v = p09bs, o = p09be
    tplot_panel,  v = p14bs, o = p14be
    tplot_panel,  v = p21bs, o = p21be
    tplot_panel,  v = p24bs, o = p24be
    pclose

    ;-----------------------------------------------------------------
    ; Advance time
    ;-----------------------------------------------------------------
    ts = ts + 86400.

    ;-----------------------------------------------------------------
    ; Clear tplot variables
    ;----------------------------------------------------------------
    tplot_names, '*', names = names
    store_data, names, /DEL


ENDFOR

store_data, 'a_accum_s_valid', data = {x:a_accum_time, y:a_accum_s_valid}
store_data, 'a_accum_ssd_sw',  data = {x:a_accum_time, y:a_accum_ssd_sw}
store_data, 'a_accum_sf0',     data = {x:a_accum_time, y:a_accum_sf0}
store_data, 'a_accum_sfr0',    data = {x:a_accum_time, y:a_accum_sfr0}
store_data, 'a_accum_ra_trig', data = {x:a_accum_time, y:a_accum_ra_trig}
store_data, 'a_accum_w_valid', data = {x:a_accum_time, y:a_accum_w_valid}
store_data, 'a_accum_sf2',     data = {x:a_accum_time, y:a_accum_sf2}
store_data, 'a_accum_sfr2',    data = {x:a_accum_time, y:a_accum_sfr2}
store_data, 'a_accum_pos2_3',  data = {x:a_accum_time, y:a_accum_pos2_3}
store_data, 'a_accum_sum_pos', data = {x:a_accum_time, y:a_accum_sum_pos}

store_data, 'b_accum_s_valid', data = {x:b_accum_time, y:b_accum_s_valid}
store_data, 'b_accum_ssd_sw',  data = {x:b_accum_time, y:b_accum_ssd_sw}
store_data, 'b_accum_sf0',     data = {x:b_accum_time, y:b_accum_sf0}
store_data, 'b_accum_sfr0',    data = {x:b_accum_time, y:b_accum_sfr0}
store_data, 'b_accum_ra_trig', data = {x:b_accum_time, y:b_accum_ra_trig}
store_data, 'b_accum_w_valid', data = {x:b_accum_time, y:b_accum_w_valid}
store_data, 'b_accum_sf2',     data = {x:b_accum_time, y:b_accum_sf2}
store_data, 'b_accum_sfr2',    data = {x:b_accum_time, y:b_accum_sfr2}
store_data, 'b_accum_pos2_3',  data = {x:b_accum_time, y:b_accum_pos2_3}
store_data, 'b_accum_sum_pos', data = {x:b_accum_time, y:b_accum_sum_pos}

tplot_save, f = 'accum'

END
