; K.D.C. Simunac
; 22 May, 2008
; time_shift_wind_to_stereo.pro

; This is based on time_shift_wind.pro. It adjusts a time range
; for WIND so that we can compare with PLASTIC.

; input : sat         : 'A' or 'B'
;         time_range  : array of doubles with tplot times
; output: shifted_time: array of doubles with shifted tplot times
;
; last modified: 22 May,  2008 
;                27 May,  2008: LBE: Changed so call Wind crib
;                19 June, 2008: LBE: Put cast to double into new_speed equation
;                31 July, 2008: LBE: Added check for if there are tplot vars before saving.
;                                    Added check for if only one time needed.
;                04 Dec., 2009: LBE: Go to slower route if less than 75% of data found.
;                18 May,  2010: LBE: Change temp filename.
;                01 Dec., 2010: LBE: Look for closest value (min_i)
;                17 Feb., 2014: LBE: Check for nothing in time_range.
;                05 Jan., 2016: LBE: Go opposite way after solar conjunction.

PRO time_shift_wind_to_stereo, sat, time_range, shifted_time
compile_opt strictarrsubs
tplot_names, names = names
saved_vars = 0
IF keyword_set(names) THEN BEGIN 
    saved_vars = 1
    tplot_save, filename = 'temp_time_shift_wind_to_stereo' ; save existing tplot variable so can restore later
    tplot_names, '*', names = names
    store_data, names, /DEL
ENDIF 
have_data = 1
IF n_elements(time_range) EQ 1 THEN BEGIN
    IF time_range[0] EQ 0 THEN have_data = 0
ENDIF 
IF have_data EQ 1 THEN BEGIN 
    good_i          = where(finite(time_range) EQ 1)
    temp_time_range = time_range[good_i]
    start_t         = temp_time_range[0]
    stop_t          = temp_time_range[n_elements(temp_time_range)-1]
    start_t_struct  = time_struct(start_t)
    stop_t_struct   = time_struct(stop_t)
    start_year      = start_t_struct.year
    start_doy       = start_t_struct.doy
    stop_year       = stop_t_struct.year
    stop_doy        = stop_t_struct.doy
    num_records     = n_elements(temp_time_range)

; load wind data
    timespan, start_t, (stop_t-start_t+1), /seconds
    plot_wind_swe, /All 

    get_data, 'WIND_SWE_V_GSE_X', speed_t, Vx 
    get_data, 'WIND_SWE_V_GSE_Y', speed_t, Vy 
    get_data, 'WIND_SWE_V_GSE_Z', speed_t, Vz 

    new_speed_t         = dblarr(num_records)
    new_speed_d         = dblarr(num_records)
    delta_long_pla_wind = fltarr(num_records)
    temp_shifted_time   = dblarr(num_records)

    FOR ii = 0L, num_records-1 DO BEGIN
        IF ii MOD 10000 EQ 0 THEN print, 'time shift wind1', ii, ' ', num_records
        min = min(abs(speed_t - temp_time_range[ii]), min_i, /nan)
        IF min LT 120 THEN BEGIN ; two minutes
            new_speed_t[ii] = speed_t[min_i]
            new_speed_d[ii] = SQRT(double(Vx[min_i])^2.0+Vy[min_i]^2.0+Vz[min_i]^2.0)
        ENDIF ELSE BEGIN
            new_speed_t[ii] = !values.f_nan
            new_speed_d[ii] = !values.f_nan
        ENDELSE 
    ENDFOR 

; if have few matching times
    temp_good_i = where(finite(new_speed_t) EQ 1, temp_good_count)
    max_i = n_elements(speed_t)-1
    IF temp_good_count LT (num_records/4*3) THEN BEGIN ; look for 75%
        FOR ii = 0L, num_records-1 DO BEGIN 
            IF ii MOD 10000 EQ 0 THEN print, 'time shift wind2', ii, ' ', num_records
            IF finite(new_speed_t[ii]) EQ 0 AND temp_time_range[ii] LT speed_t[0] THEN BEGIN 
                new_speed_t[ii] = speed_t[0]
                new_speed_d[ii] = SQRT(double(Vx[0])^2.0+Vy[0]^2.0+Vz[0]^2.0)
            ENDIF ELSE IF finite(new_speed_t[ii]) EQ 0 AND temp_time_range[ii] GT speed_t[max_i] THEN BEGIN 
                new_speed_t[ii] = speed_t[max_i]
                new_speed_d[ii] = SQRT(double(Vx[max_i])^2.0+Vy[max_i]^2.0+Vz[max_i]^2.0)
            ENDIF ELSE IF finite(new_speed_t[ii]) EQ 0 THEN BEGIN ; take next time
                temp_i = where(temp_time_range[ii] LE speed_t, count)
                IF count GT 0 THEN BEGIN
                    new_speed_t[ii] = speed_t[temp_i[0]]
                    new_speed_d[ii] = SQRT(double(Vx[temp_i[0]])^2.0+Vy[temp_i[0]]^2.0+Vz[temp_i[0]]^2.0)
                ENDIF
            ENDIF 
        ENDFOR 
    ENDIF     

; GET LOCATION OF STEREO, and WIND
    now_time_pla        = TIME_STRING(temp_time_range)
    now_time_formatted  = strmid(now_time_pla, 0, 10)+'T'+strmid(now_time_pla, 11, 8)
    v_sw_WIND           = new_speed_d
    location_wind       = GET_STEREO_LONLAT(now_time_formatted, 'Earth') ; longitude and latitude in radians
    r_distance_wind_pla = 0.99*location_wind[0, *] ; km
    long_wind_pla       = location_wind[1, *]       
    
    location_pla   = GET_STEREO_LONLAT(now_time_formatted, sat) ; longtidue and latitude in radians
    r_distance_pla = location_pla[0, *] ; km
    long_pla       = location_pla[1, *]
    
flip_time = time_double('2015-06-01') ; go behind sun
old_times = where(new_speed_t LT flip_time, old_count)
new_times = where(new_speed_t GT flip_time, new_count)

IF old_count GT 0 THEN BEGIN 
    IF sat EQ 'A' THEN delta_long_pla_wind[old_times] = long_pla     [old_times] - long_wind_pla[old_times] $ ; radians
    ELSE               delta_long_pla_wind[old_times] = long_wind_pla[old_times] - long_pla     [old_times]
ENDIF 
IF new_count GT 0 THEN BEGIN 
    IF sat EQ 'B' THEN delta_long_pla_wind[new_times] = long_pla     [new_times] - long_wind_pla[new_times] $ ; radians
    ELSE               delta_long_pla_wind[new_times] = long_wind_pla[new_times] - long_pla     [new_times]
ENDIF 
    temp_i = where(delta_long_pla_wind LT 0, temp_count)
    IF temp_count GT 0 THEN delta_long_pla_wind[temp_i] = delta_long_pla_wind[temp_i]+DOUBLE(2.0*!PI)
    delta_r_pla_wind = r_distance_wind_pla - r_distance_pla ; km (should be a negative number ONLY if sat is B!)
    
; Shift WIND data to line up with PLASTIC in time
IF old_count GT 0 THEN BEGIN 
    IF sat EQ 'A' THEN temp_shifted_time[old_times] = temp_time_range[old_times] + $
      (delta_long_pla_wind[old_times]/(2.905E-6)) - (delta_r_pla_wind[old_times]/v_sw_WIND[old_times]) $
    ELSE               temp_shifted_time[old_times] = temp_time_range[old_times] - $
      (delta_long_pla_wind[old_times]/(2.905E-6)) - (delta_r_pla_wind[old_times]/v_sw_WIND[old_times])
ENDIF 
IF new_count GT 0 THEN BEGIN 
    IF sat EQ 'B' THEN temp_shifted_time[new_times] = temp_time_range[new_times] + $
      (delta_long_pla_wind[new_times]/(2.905E-6)) - (delta_r_pla_wind[new_times]/v_sw_WIND[new_times]) $
    ELSE               temp_shifted_time[new_times] = temp_time_range[new_times] - $
      (delta_long_pla_wind[new_times]/(2.905E-6)) - (delta_r_pla_wind[new_times]/v_sw_WIND[new_times])
ENDIF 
    shifted_time = dblarr(n_elements(time_range))
    shifted_time[*] = !values.f_nan
    shifted_time[good_i] = temp_shifted_time
    tplot_names, '*', names = names
    store_data, names, /DEL
ENDIF 
IF saved_vars EQ 1 THEN tplot_restore, filename = 'temp_time_shift_wind_to_stereo.tplot' ; restore old tplot variables

END 
