; Lorna Ellis
; 05/06/2008
; time_shift_wind.pro

; This is based on Kristin's Time_Shift.pro. It adjusts a time range
; for A or B to the equivalent Wind time so that we can compare with
; Wind.

; input : sat         : 'A' or 'B'
;         time_range  : array of doubles with tplot times
; output: shifted_time: array of doubles with shifted tplot times
;
; last modified: 8 May, 2008 (K. Simunac)
;	
; 08 May,  2008:  changed sign from minus to plus in A time shift equation to 
;	        correct (K. Simunac's) algebra mistake
; 20 June, 2008: LBE: Added check for if there are tplot vars before saving. 
;                     Added check for if only one time needed.
; 05 Dec., 2008: LBE: changed so get bulk data from cdf.
; 16 Jan., 2009: LBE: Only check for orig_ts if variables have been saved.
; 04 Apr., 2009: LBE: Changed velocity_bulk to bulk_speed
; 01 Dec., 2010: LBE: Look for closest value (min_i)
; 23 Nov., 2012: LBE: Fix bug when invalid vel at beginning of time.
; 10 Dec., 2012: LBE: Check when before RA data (STA).
; 20 Dec., 2012: LBE: Check when before RA data (STB).
; 04 Jan., 2016: LBE: Go opposite way after solar conjunction.
PRO time_shift_wind, sat, time_range, shifted_time
compile_opt strictarrsubs
; save old data
tplot_names, names = names
saved_vars = 0
IF keyword_set(names) THEN BEGIN 
    saved_vars = 1
    tplot_save, filename = 'temp' ; save existing tplot variable so can restore later
    tplot_names, '*', names = names
    store_data, names, /DEL
    get_timespan, orig_ts
ENDIF

; set new timespan
num_days = ((time_range[n_elements(time_range)-1]-time_range[0]+1)/86400) + 1
start_string = time_string(time_range[0])
strput, start_string, '00:00:00', 11
start_time = time_double(start_string)

timespan, start_time, num_days, /days

; load ra data
pl_plot_l2_1dmax, sat, order = 3
good_i          = where(finite(time_range) EQ 1) ; I assume some valid times
temp_time_range = time_range[good_i]
start_t         = temp_time_range[0]
stop_t          = temp_time_range[n_elements(temp_time_range)-1]
start_t_struct  = time_struct(start_t)
stop_t_struct   = time_struct(stop_t)
start_year      = start_t_struct.year
start_doy       = start_t_struct.doy
stop_year       = stop_t_struct.year
stop_doy        = stop_t_struct.doy
num_records     = n_elements(temp_time_range)
vel = sat+'_l2_1dmax_proton_bulk_speed'
get_data, vel, vel_t, vel_d

IF sat EQ 'A' THEN BEGIN 
    IF start_string LT '2007-02-14' THEN BEGIN
        get_pla_l2obmom,  sat, order = 2
        ob_speed = sat+'_l2_obmom_bulk_speed'
        get_data, ob_speed, ob_t, ob_d
        new_i = where(ob_t LT time_double('2007-02-14'), count)
        IF count GT 0 THEN BEGIN
            speed_t = [ob_t[new_i], vel_t]
            speed_d = [ob_d[new_i], vel_d]
        ENDIF ELSE stop  ; problem
    ENDIF ELSE BEGIN
        get_data, vel, speed_t, speed_d
    ENDELSE
    vel = 'new_speed'
    store_data, vel, data = {x:speed_t, y:speed_d}
    vel_t = speed_t
    vel_d = speed_d
ENDIF ELSE BEGIN 
    IF start_string LT '2007-03-01' THEN BEGIN
        get_pla_l2obmom,  sat, order = 2
        ob_speed = sat+'_l2_obmom_bulk_speed'
        get_data, ob_speed, ob_t, ob_d
        new_i = where(ob_t LT time_double('2007-03-01'), count)
        IF count GT 0 THEN BEGIN
            speed_t = [ob_t[new_i], vel_t]
            speed_d = [ob_d[new_i], vel_d]
        ENDIF ELSE stop  ; problem
    ENDIF ELSE BEGIN
        get_data, vel, speed_t, speed_d
    ENDELSE
    vel = 'new_speed'
    store_data, vel, data = {x:speed_t, y:speed_d}
    vel_t = speed_t
    vel_d = speed_d
ENDELSE 

new_vel_t = dblarr(num_records)
new_vel_d = dblarr(num_records)
FOR ii = 0L, num_records-1 DO BEGIN
    min = min(abs(vel_t - temp_time_range[ii]), min_i, /nan)
    IF min LT 120 THEN BEGIN ; two minutes
        new_vel_t[ii] = vel_t[min_i]
        new_vel_d[ii] = vel_d[min_i]
    ENDIF ELSE BEGIN
        new_vel_t[ii] = !values.f_nan
        new_vel_d[ii] = !values.f_nan
    ENDELSE 
ENDFOR 
; if have no matching time (for when only have one time)
IF num_records EQ 1 THEN BEGIN
    IF (finite(new_vel_t) EQ 0 AND temp_time_range[0] LT vel_t[0]) AND (finite(vel_d[0]) EQ 1) THEN BEGIN 
        new_vel_t[0] = vel_t[0]
        new_vel_d[0] = vel_d[0]
    ENDIF ELSE IF finite(new_vel_t) EQ 0 OR finite(new_vel_d) EQ 0 THEN BEGIN ; take next time
        temp_i = where((temp_time_range[0] LE vel_t) AND (finite(vel_d) EQ 1), count)
        IF count GT 0 THEN BEGIN
            new_vel_t[0] = vel_t[temp_i[0]]
            new_vel_d[0] = vel_d[temp_i[0]]
        ENDIF
    ENDIF 
ENDIF     

; GET LOCATION OF STEREO, and WIND
now_time_pla        = TIME_STRING(temp_time_range)
now_time_formatted  = strmid(now_time_pla, 0, 10)+'T'+strmid(now_time_pla, 11, 8)
v_sw_pla            = new_vel_d
location_wind       = GET_STEREO_LONLAT(now_time_formatted, 'Earth') ; longitude and latitude in radians
r_distance_wind_pla = 0.99*location_wind[0, *]; km
long_wind_pla       = location_wind[1, *]       
	
location_pla        = GET_STEREO_LONLAT(now_time_formatted, sat) ; longtidue and latitude in radians
r_distance_pla      = location_pla[0, *]; km
long_pla            = location_pla[1, *]
delta_long_pla_wind = fltarr(num_records)
temp_shifted_time   = dblarr(num_records)

flip_time = time_double('2015-06-01') ; go behind sun
old_times = where(temp_time_range LT flip_time, old_count)
new_times = where(temp_time_range GT flip_time, new_count)

IF old_count GT 0 THEN BEGIN 
    IF sat EQ 'A' THEN delta_long_pla_wind[old_times] = long_pla     [old_times] - long_wind_pla[old_times] $ ; radians
    ELSE               delta_long_pla_wind[old_times] = long_wind_pla[old_times] - long_pla     [old_times]
ENDIF 
IF new_count GT 0 THEN BEGIN 
    IF sat EQ 'B' THEN delta_long_pla_wind[new_times] = long_pla     [new_times] - long_wind_pla[new_times] $ ; radians
    ELSE               delta_long_pla_wind[new_times] = long_wind_pla[new_times] - long_pla     [new_times]
ENDIF 
temp_i = where(delta_long_pla_wind LT 0, temp_count)
IF temp_count GT 0 THEN delta_long_pla_wind[temp_i] = delta_long_pla_wind[temp_i]+DOUBLE(2.0*!PI)
delta_r_pla_wind = r_distance_wind_pla - r_distance_pla ; km (should be a negative number ONLY if sat is B!)

; Shift plastic data to line up with WIND in Time
IF old_count GT 0 THEN BEGIN 
    IF sat EQ 'A' THEN temp_shifted_time[old_times] = temp_time_range[old_times] - $
      (delta_long_pla_wind[old_times]/(2.905E-6)) + (delta_r_pla_wind[old_times]/v_sw_pla[old_times]) $
    ELSE               temp_shifted_time[old_times] = temp_time_range[old_times] + $
      (delta_long_pla_wind[old_times]/(2.905E-6)) + (delta_r_pla_wind[old_times]/v_sw_pla[old_times])
ENDIF 
IF new_count GT 0 THEN BEGIN 
    IF sat EQ 'B' THEN temp_shifted_time[new_times] = temp_time_range[new_times] - $
      (delta_long_pla_wind[new_times]/(2.905E-6)) + (delta_r_pla_wind[new_times]/v_sw_pla[new_times]) $
    ELSE               temp_shifted_time[new_times] = temp_time_range[new_times] + $
      (delta_long_pla_wind[new_times]/(2.905E-6)) + (delta_r_pla_wind[new_times]/v_sw_pla[new_times])
ENDIF 
shifted_time = dblarr(n_elements(time_range))
shifted_time[*] = !values.f_nan
shifted_time[good_i] = temp_shifted_time
tplot_names, '*', names = names
store_data, names, /DEL
IF saved_vars EQ 1 THEN BEGIN 
    tplot_restore, filename = 'temp.tplot' ; restore old tplot variables
    timespan, orig_ts[0], (orig_ts[1]-orig_ts[0]+1), /seconds
    command = 'rm temp.tplot'
    spawn, command
ENDIF 
END 
