; Lorna Ellis
; 12/03/2010
; time_shift_stereo_to_earth.pro

; This is based on time_shift_wind_to_stereo.pro. 

; input : sat         : 'A' or 'B'
;         time_range  : array of doubles with tplot times
; output: shifted_time: array of doubles with shifted tplot times
;
; last modified: 
;   12/03/2010 LBE Created
;   01/03/2016 LBE Go opposite way after solar conjunction.

PRO time_shift_stereo_to_earth, sat, time_range, shifted_time
compile_opt strictarrsubs
tplot_names, names = names
saved_vars = 0
IF keyword_set(names) THEN BEGIN 
    saved_vars = 1
    tplot_save, filename = 'temp_time_shift_stereo_to_earth' ; save existing tplot variable so can restore later
    tplot_names, '*', names = names
    store_data, names, /DEL
ENDIF 

good_i = where(finite(time_range) EQ 1)

temp_time_range = time_range[good_i]
start_t         = temp_time_range[0]
stop_t          = temp_time_range[n_elements(temp_time_range)-1]
start_t_struct  = time_struct(start_t)
stop_t_struct   = time_struct(stop_t)
start_year      = start_t_struct.year
start_doy       = start_t_struct.doy
stop_year       = stop_t_struct.year
stop_doy        = stop_t_struct.doy
num_records     = n_elements(temp_time_range)

; load data
timespan, start_t, (stop_t-start_t+1), /seconds

get_pla_l2_1dmax, sat, order = 2 ; valid first, then prelim
speed = sat+'_l2_1dmax_proton_bulk_speed'
get_data, speed, speed_t, speed_d
new_speed_t       = dblarr(num_records)
new_speed_d       = dblarr(num_records)
delta_long        = fltarr(num_records)
temp_shifted_time = dblarr(num_records)

FOR ii = 0L, num_records-1 DO BEGIN
    IF ii MOD 10000 EQ 0 THEN print, 'time ', ii, ' ', num_records
    min = min(abs(speed_t - temp_time_range[ii]), min_i, /nan)
    IF min LT 120 THEN BEGIN ; two minutes
        new_speed_t[ii] = speed_t[min_i]
        new_speed_d[ii] = speed_d[min_i]
    ENDIF ELSE BEGIN
        new_speed_t[ii] = !values.f_nan
        new_speed_d[ii] = !values.f_nan
    ENDELSE 
ENDFOR 

; GET LOCATION OF STEREO, and EARTH
now_time_pla = TIME_STRING(temp_time_range)
now_time_formatted = strmid(now_time_pla, 0, 10)+'T'+strmid(now_time_pla, 11, 8)
location_earth = GET_STEREO_LONLAT(now_time_formatted, 'Earth') ; longitude and latitude in radians
rad_earth = location_earth[0, *]; km
lon_earth = location_earth[1, *]       

location_pla = GET_STEREO_LONLAT(now_time_formatted, sat) ; longtidue and latitude in radians
rad_pla = location_pla[0, *]; km
lon_pla = location_pla[1, *]

flip_time = time_double('2015-06-01') ; go behind sun
old_times = where(new_speed_t LT flip_time, old_count)
new_times = where(new_speed_t GT flip_time, new_count)

IF old_count GT 0 THEN BEGIN 
    IF sat EQ 'A' THEN delta_long[old_times] = lon_pla  [old_times] - lon_earth[old_times] $ ; radians
    ELSE               delta_long[old_times] = lon_earth[old_times] - lon_pla  [old_times] 
ENDIF 
IF new_count GT 0 THEN BEGIN 
    IF sat EQ 'B' THEN delta_long[new_times] = lon_pla  [new_times] - lon_earth[new_times] $ ; radians
    ELSE               delta_long[new_times] = lon_earth[new_times] - lon_pla  [new_times] 
ENDIF 
temp_i = where(delta_long LT 0, temp_count)
IF temp_count GT 0 THEN delta_long[temp_i] = delta_long[temp_i]+DOUBLE(2.0*!PI)
delta_rad = rad_earth - rad_pla ; km (should be a negative number ONLY if sat is B!)

; Shift ACE data to line up with PLASTIC in time
IF old_count GT 0 THEN BEGIN 
    IF sat EQ 'A' THEN temp_shifted_time[old_times] = temp_time_range[old_times] - $
      (delta_long[old_times]/(2.905E-6)) + (delta_rad[old_times]/new_speed_d[old_times]) $
    ELSE temp_shifted_time[old_times] = temp_time_range[old_times] + $
      (delta_long[old_times]/(2.905E-6)) + (delta_rad[old_times]/new_speed_d[old_times])
ENDIF 
IF new_count GT 0 THEN BEGIN 
    IF sat EQ 'B' THEN temp_shifted_time[new_times] = temp_time_range[new_times] - $
      (delta_long[new_times]/(2.905E-6)) + (delta_rad[new_times]/new_speed_d[new_times]) $
    ELSE temp_shifted_time[new_times] = temp_time_range[new_times] + $
      (delta_long[new_times]/(2.905E-6)) + (delta_rad[new_times]/new_speed_d[new_times])
ENDIF 
shifted_time = dblarr(n_elements(time_range))
shifted_time[*] = !values.f_nan
shifted_time[good_i] = temp_shifted_time

tplot_names, '*', names = names
store_data, names, /DEL
IF saved_vars EQ 1 THEN tplot_restore, filename = 'temp_time_shift_stereo_to_earth.tplot' ; restore old tplot variables

END 
