; Lorna Ellis
; 12/02/2010
; time_shift_ace_swepam_realtime_to_stereo.pro

; This is based on time_shift_wind_to_stereo.pro. It adjusts a time range
; for ACE so that we can compare with PLASTIC. Need this in addition
; to time_shift_wind_to_stereo for times when there is no wind data.

; input : sat         : 'A' or 'B'
;         time_range  : array of doubles with tplot times
; output: shifted_time: array of doubles with shifted tplot times
;
; last modified: 
;   12/02/2010 LBE Created
;   12/23/2015 LBE Go opposite way after solar conjunction.

PRO time_shift_ace_swepam_realtime_to_stereo, sat, time_range, shifted_time
compile_opt strictarrsubs
tplot_names, names = names
saved_vars = 0
IF keyword_set(names) THEN BEGIN 
    saved_vars = 1
    tplot_save, filename = 'temp_time_shift_ace_swepam_realtime_to_stereo' ; save existing tplot variable so can restore later
    tplot_names, '*', names = names
    store_data, names, /DEL
ENDIF 

good_i = where(finite(time_range) EQ 1)

temp_time_range = time_range[good_i]
start_t         = temp_time_range[0]
stop_t          = temp_time_range[n_elements(temp_time_range)-1]
start_t_struct  = time_struct(start_t)
stop_t_struct   = time_struct(stop_t)
start_year      = start_t_struct.year
start_doy       = start_t_struct.doy
stop_year       = stop_t_struct.year
stop_doy        = stop_t_struct.doy
num_records     = n_elements(temp_time_range)

; load ace data
timespan, start_t, (stop_t-start_t+1), /seconds

plot_ace_swepam, real_time = 1

get_data, 'ACE_REAL_TIME_velo', speed_t, speed_d
new_speed_t        = dblarr(num_records)
new_speed_d        = dblarr(num_records)
delta_long_pla_ace = fltarr(num_records)
temp_shifted_time  = dblarr(num_records)

FOR ii = 0L, num_records-1 DO BEGIN
    IF ii MOD 10000 EQ 0 THEN print, 'time ace1 ', ii, ' ', num_records
    min = min(abs(speed_t - temp_time_range[ii]), min_i, /nan)
    IF min LT 120 THEN BEGIN ; two minutes
        new_speed_t[ii] = speed_t[min_i]
        new_speed_d[ii] = speed_d[min_i]
    ENDIF ELSE BEGIN
        new_speed_t[ii] = !values.f_nan
        new_speed_d[ii] = !values.f_nan
    ENDELSE 
ENDFOR 

; GET LOCATION OF STEREO, and ACE
now_time_pla       = TIME_STRING(temp_time_range)
now_time_formatted = strmid(now_time_pla, 0, 10)+'T'+strmid(now_time_pla, 11, 8)
v_sw_ACE           = new_speed_d
location_ace       = GET_STEREO_LONLAT(now_time_formatted, 'Earth') ; longitude and latitude in radians
r_distance_ace_pla = 0.99*location_ace[0, *]; km
long_ace_pla       = location_ace[1, *]       

location_pla   = GET_STEREO_LONLAT(now_time_formatted, sat) ; longtidue and latitude in radians
r_distance_pla = location_pla[0, *]; km
long_pla       = location_pla[1, *]

flip_time = time_double('2015-06-01') ; go behind sun
old_times = where(new_speed_t LT flip_time, old_count)
new_times = where(new_speed_t GT flip_time, new_count)

IF old_count GT 0 THEN BEGIN 
    IF sat EQ 'A' THEN delta_long_pla_ace[old_times] = long_pla    [old_times] - long_ace_pla[old_times] $ ; radians
    ELSE               delta_long_pla_ace[old_times] = long_ace_pla[old_times] - long_pla    [old_times]
ENDIF 
IF new_count GT 0 THEN BEGIN 
    IF sat EQ 'B' THEN delta_long_pla_ace[new_times] = long_pla    [new_times] - long_ace_pla[new_times] $ ; radians
    ELSE               delta_long_pla_ace[new_times] = long_ace_pla[new_times] - long_pla    [new_times]
ENDIF 
temp_i = where(delta_long_pla_ace LT 0, temp_count)
IF temp_count GT 0 THEN delta_long_pla_ace[temp_i] = delta_long_pla_ace[temp_i]+DOUBLE(2.0*!PI)
delta_r_pla_ace = r_distance_ace_pla - r_distance_pla ; km (should be a negative number ONLY if sat is B!)

; Shift ACE data to line up with PLASTIC in time
IF old_count GT 0 THEN BEGIN 
    IF sat EQ 'A' THEN temp_shifted_time[old_times] = temp_time_range[old_times] + $
      (delta_long_pla_ace[old_times]/(2.905E-6)) - (delta_r_pla_ace[old_times]/v_sw_ACE[old_times]) $
    ELSE temp_shifted_time[old_times] = temp_time_range[old_times] - $
      (delta_long_pla_ace[old_times]/(2.905E-6)) - (delta_r_pla_ace[old_times]/v_sw_ACE[old_times])
ENDIF 
IF new_count GT 0 THEN BEGIN 
    IF sat EQ 'B' THEN temp_shifted_time[new_times] = temp_time_range[new_times] + $
      (delta_long_pla_ace[new_times]/(2.905E-6)) - (delta_r_pla_ace[new_times]/v_sw_ACE[new_times]) $
    ELSE temp_shifted_time[new_times] = temp_time_range[new_times] - $
      (delta_long_pla_ace[new_times]/(2.905E-6)) - (delta_r_pla_ace[new_times]/v_sw_ACE[new_times])
ENDIF 
shifted_time         = dblarr(n_elements(time_range))
shifted_time[*]      = !values.f_nan
shifted_time[good_i] = temp_shifted_time

tplot_names, '*', names = names
store_data, names, /DEL
IF saved_vars EQ 1 THEN tplot_restore, filename = 'temp_time_shift_ace_swepam_realtime_to_stereo.tplot' ; restore old tplot variables

END 
