;+
; PROCEDURE read_cdf
;
; Purpose: to read cdf files and put data into a tplot structure
;
; Input: 
;	in_file: path+name of file to be read
;
; Created By: 	Dimple P. Patel
;		University of New Hampshire	 
;		Space Science Group
;		dpatel@teams.sr.unh.edu
; Date: 2/11/99
; Version: 1.2
; Last Modification: 8/26/99
; Modification History:
;	2/17/99 - added tag - coord(coordinate sys) - to tplot structure
;	2/18/99 - added tag - units - to tplot structure
;       5/6/99 - shortened name of out_data name
;       5/12/99 - added keyword 'TIME_RANGE' and transpose
;                 data before saving 
;       8/26/99 - able to handle getting magnetic field data for
;                 multiple days
;      11/19/14 - Check for rec=0 (LBE)
;-

PRO read_cdf, IN_FILE = in_file, VAR = var, EPOCH = epoch, $
              OUT_DATA = out_data, TIME_RANGE = time_range
  
  FOR ii = 0, N_ELEMENTS(in_file) - 1 DO BEGIN
; open cdf file    
    id = CDF_OPEN(in_file(ii))
; get info on file
    idinfo = CDF_INQUIRE(id)
; get number of records
    CDF_CONTROL, id, GET_VAR_INFO = recinfo, VAR = var
    rec = recinfo.maxrecs
; get data
    IF rec GT 0 THEN BEGIN 
        CDF_VARGET, id, var, yvar, REC_COUNT = rec
;	yvar=swap_endian(yvar)
        CDF_ATTGET, id, 'UNITS', var, attvalue
        CDF_VARGET, id, epoch, eptime, REC_COUNT = rec

;	eptime=swap_endian(eptime)
        CDF_CLOSE, id
; Convert epoch time to second since 1970
        time = time_double(eptime, /EPOCH)
; create tplot structure
        co = STRPOS(var, 'gse')
        coord = ''
        IF co GT -1 THEN coord = 'GSE'
        r = STRPOS(var, 'sc_r_')
        IF r GT -1 THEN BEGIN
            yvar = yvar/6380.
;	yvar = yvar/6378.
            attvalue = 'earth'	
        ENDIF

        IF KEYWORD_SET(time_range) THEN BEGIN
            a = WHERE(time GE time_range(0) AND time LE time_range(1), ac)
            IF ac GT 0 THEN BEGIN
                yvar = yvar(*, a)
                time = time(a)
            ENDIF
        ENDIF
        yvar = transpose(yvar)
        IF ii EQ 0 OR n_elements(out_data) EQ 0 THEN BEGIN
            dat = {data_name: var,    $
                   coord:	coord,  $
                   units:	attvalue, $
                   x:		REFORM(time),   $
                   y:		yvar}
            nvar = STR_SEP(var, '%')
            out_data = STRCOMPRESS(nvar(0), /REMOVE_ALL)
            store_data, out_data, data = dat
        ENDIF ELSE BEGIN
            get_data, out_data, data = dat
            store_data, out_data, /DELETE
            y1 = TRANSPOSE(dat.y)
            y2 = TRANSPOSE(yvar)
            y = [[y1], [y2]]
            new = {data_name: var,    $
                   coord:	coord,  $
                   units:	attvalue, $
                   x:		[dat.x, REFORM(time)], $
                   y:	        TRANSPOSE(y)}
            nvar = STR_SEP(var, '%')
            out_data = STRCOMPRESS(nvar(0), /REMOVE_ALL)
            store_data, out_data, data = new
        ENDELSE
    ENDIF ELSE CDF_CLOSE, id
  ENDFOR
END
