; Lorna Ellis
; 05/18/2010
; convert_ace_swics_qstates.pro

; This creates an ascii file for the ace swics 2 hr Q data which
; time-shifts the data.

PRO convert_ace_swics_qstates, year, sat, num_days = num_days
compile_opt strictarrsubs

out_dir = '~/TempPlots2/'
out_file = 'ACE_SWICS_QdistData_'+string(year, format = '(I4.4)')+'_adj_'+sat+'.txt'
out_path = out_dir+out_file

start = string(year, format = '(I4.4)')+'-01-01/00:00:00'
ts = time_double(start)
IF keyword_set(num_days) EQ 0 THEN $
  IF year MOD 4 EQ 0 THEN num_days = 366 ELSE num_days = 365
timespan, ts, num_days

get_ace_swics_qstates
c_q         = 'ace_swics_c_q_2hr'
o_q         = 'ace_swics_o_q_2hr'
ne_q        = 'ace_swics_ne_q_2hr'
mg_q        = 'ace_swics_mg_q_2hr'
si_q        = 'ace_swics_si_q_2hr'
fe_q        = 'ace_swics_fe_q_2hr'
c_q_no_err  = 'ace_swics_c_q_2hr_no_err'
o_q_no_err  = 'ace_swics_o_q_2hr_no_err'
ne_q_no_err = 'ace_swics_ne_q_2hr_no_err'
mg_q_no_err = 'ace_swics_mg_q_2hr_no_err'
si_q_no_err = 'ace_swics_si_q_2hr_no_err'
fe_q_no_err = 'ace_swics_fe_q_2hr_no_err'

get_data, c_q,         c_q_t,         c_q_d    
get_data, o_q,         o_q_t,         o_q_d    
get_data, ne_q,        ne_q_t,        ne_q_d    
get_data, mg_q,        mg_q_t,        mg_q_d    
get_data, si_q,        si_q_t,        si_q_d    
get_data, fe_q,        fe_q_t,        fe_q_d     
get_data, c_q_no_err,  c_q_no_err_t,  c_q_no_err_d    
get_data, o_q_no_err,  o_q_no_err_t,  o_q_no_err_d    
get_data, ne_q_no_err, ne_q_no_err_t, ne_q_no_err_d    
get_data, mg_q_no_err, mg_q_no_err_t, mg_q_no_err_d    
get_data, si_q_no_err, si_q_no_err_t, si_q_no_err_d    
get_data, fe_q_no_err, fe_q_no_err_t, fe_q_no_err_d     

IF array_equal(o_q_t,         c_q_t) NE 1 THEN stop    
IF array_equal(ne_q_t,        c_q_t) NE 1 THEN stop    
IF array_equal(mg_q_t,        c_q_t) NE 1 THEN stop    
IF array_equal(si_q_t,        c_q_t) NE 1 THEN stop    
IF array_equal(fe_q_t,        c_q_t) NE 1 THEN stop     
IF array_equal(c_q_no_err_t,  c_q_t) NE 1 THEN stop
IF array_equal(o_q_no_err_t,  c_q_t) NE 1 THEN stop    
IF array_equal(ne_q_no_err_t, c_q_t) NE 1 THEN stop    
IF array_equal(mg_q_no_err_t, c_q_t) NE 1 THEN stop    
IF array_equal(si_q_no_err_t, c_q_t) NE 1 THEN stop    
IF array_equal(fe_q_no_err_t, c_q_t) NE 1 THEN stop     

time_shift_aceswics_2hr_to_stereo, sat, c_q_t, new_ace_t

; create strings
c_q_d_st          = string(c_q_d) 
o_q_d_st          = string(o_q_d) 
ne_q_d_st         = string(ne_q_d) 
mg_q_d_st         = string(mg_q_d) 
si_q_d_st         = string(si_q_d)           
fe_q_d_st         = string(fe_q_d)            
c_q_no_err_d_st   = string(c_q_no_err_d)    
o_q_no_err_d_st   = string(o_q_no_err_d)    
ne_q_no_err_d_st  = string(ne_q_no_err_d)    
mg_q_no_err_d_st  = string(mg_q_no_err_d)    
si_q_no_err_d_st  = string(si_q_no_err_d)    
fe_q_no_err_d_st  = string(fe_q_no_err_d)     
bad_c_q_i         = where(finite(c_q_d        ) EQ 0, c_q_count)    
bad_o_q_i         = where(finite(o_q_d        ) EQ 0, o_q_count)    
bad_ne_q_i        = where(finite(ne_q_d       ) EQ 0, ne_q_count)    
bad_mg_q_i        = where(finite(mg_q_d       ) EQ 0, mg_q_count)    
bad_si_q_i        = where(finite(si_q_d       ) EQ 0, si_q_count)    
bad_fe_q_i        = where(finite(fe_q_d       ) EQ 0, fe_q_count)     
bad_c_q_no_err_i  = where(finite(c_q_no_err_d ) EQ 0, c_q_no_err_count)    
bad_o_q_no_err_i  = where(finite(o_q_no_err_d ) EQ 0, o_q_no_err_count)    
bad_ne_q_no_err_i = where(finite(ne_q_no_err_d) EQ 0, ne_q_no_err_count)    
bad_mg_q_no_err_i = where(finite(mg_q_no_err_d) EQ 0, mg_q_no_err_count)    
bad_si_q_no_err_i = where(finite(si_q_no_err_d) EQ 0, si_q_no_err_count)    
bad_fe_q_no_err_i = where(finite(fe_q_no_err_d) EQ 0, fe_q_no_err_count)     
IF c_q_count         GT 0 THEN c_q_d_st        [bad_c_q_i        ] = '-1.00E+31'    
IF o_q_count         GT 0 THEN o_q_d_st        [bad_o_q_i        ] = '-1.00E+31'    
IF ne_q_count        GT 0 THEN ne_q_d_st       [bad_ne_q_i       ] = '-1.00E+31'    
IF mg_q_count        GT 0 THEN mg_q_d_st       [bad_mg_q_i       ] = '-1.00E+31'    
IF si_q_count        GT 0 THEN si_q_d_st       [bad_si_q_i       ] = '-1.00E+31'    
IF fe_q_count        GT 0 THEN fe_q_d_st       [bad_fe_q_i       ] = '-1.00E+31'     
IF c_q_no_err_count  GT 0 THEN c_q_no_err_d_st [bad_c_q_no_err_i ] = '-1.00E+31'    
IF o_q_no_err_count  GT 0 THEN o_q_no_err_d_st [bad_o_q_no_err_i ] = '-1.00E+31'    
IF ne_q_no_err_count GT 0 THEN ne_q_no_err_d_st[bad_ne_q_no_err_i] = '-1.00E+31'    
IF mg_q_no_err_count GT 0 THEN mg_q_no_err_d_st[bad_mg_q_no_err_i] = '-1.00E+31'    
IF si_q_no_err_count GT 0 THEN si_q_no_err_d_st[bad_si_q_no_err_i] = '-1.00E+31'    
IF fe_q_no_err_count GT 0 THEN fe_q_no_err_d_st[bad_fe_q_no_err_i] = '-1.00E+31'     
      

; write out data
openw, out_lun, out_path, /get_lun
printf, out_lun, out_file
header = 'Adjusted by time and radial distance'
printf, out_lun, header
tab = string(9B)
header = 'ACE Time'+tab+'ST'+sat+' Adj. Time'
FOR ii = 4, 6 DO BEGIN
    header = header+tab+'C_'+string(ii, format = '(I1.1)')
ENDFOR 
FOR ii = 5, 8 DO BEGIN
    header = header+tab+'O_'+string(ii, format = '(I1.1)')
ENDFOR 
FOR ii = 6, 9 DO BEGIN
    header = header+tab+'Ne_'+string(ii, format = '(I1.1)')
ENDFOR 
FOR ii = 6, 12 DO BEGIN
    header = header+tab+'Mg_'+string(ii, format = '(I2.2)')
ENDFOR 
FOR ii = 6, 12 DO BEGIN
    header = header+tab+'Si_'+string(ii, format = '(I2.2)')
ENDFOR 
FOR ii = 6, 20 DO BEGIN
    header = header+tab+'Fe_'+string(ii, format = '(I2.2)')
ENDFOR 
FOR ii = 4, 6 DO BEGIN
    header = header+tab+'C_'+string(ii, format = '(I1.1)')+'_no_err'
ENDFOR 
FOR ii = 5, 8 DO BEGIN
    header = header+tab+'O_'+string(ii, format = '(I1.1)')+'_no_err'
ENDFOR 
FOR ii = 6, 9 DO BEGIN
    header = header+tab+'Ne_'+string(ii, format = '(I1.1)')+'_no_err'
ENDFOR 
FOR ii = 6, 12 DO BEGIN
    header = header+tab+'Mg_'+string(ii, format = '(I2.2)')+'_no_err'
ENDFOR 
FOR ii = 6, 12 DO BEGIN
    header = header+tab+'Si_'+string(ii, format = '(I2.2)')+'_no_err'
ENDFOR 
FOR ii = 6, 20 DO BEGIN
    header = header+tab+'Fe_'+string(ii, format = '(I2.2)')+'_no_err'
ENDFOR 
printf, out_lun, header
FOR ii = 0, n_elements(new_ace_t)-1 DO BEGIN
    temp_string = time_string(c_q_t[ii])+tab+time_string(new_ace_t[ii])
    FOR jj = 0, 2 DO BEGIN
        temp_string = temp_string+tab+c_q_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 3 DO BEGIN
        temp_string = temp_string+tab+o_q_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 3 DO BEGIN
        temp_string = temp_string+tab+ne_q_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 6 DO BEGIN
        temp_string = temp_string+tab+mg_q_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 6 DO BEGIN
        temp_string = temp_string+tab+si_q_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 14 DO BEGIN
        temp_string = temp_string+tab+fe_q_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 2 DO BEGIN
        temp_string = temp_string+tab+c_q_no_err_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 3 DO BEGIN
        temp_string = temp_string+tab+o_q_no_err_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 3 DO BEGIN
        temp_string = temp_string+tab+ne_q_no_err_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 6 DO BEGIN
        temp_string = temp_string+tab+mg_q_no_err_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 6 DO BEGIN
        temp_string = temp_string+tab+si_q_no_err_d_st[ii, jj]
    ENDFOR 
    FOR jj = 0, 14 DO BEGIN
        temp_string = temp_string+tab+fe_q_no_err_d_st[ii, jj]
    ENDFOR 
    printf, out_lun, temp_string
ENDFOR 
close, out_lun
free_lun, out_lun

END

