; Lorna Ellis
; 05/17/2010
; convert_ace_swics_2hr.pro

; This creates an ascii file for the ace swics 2 hr data which
; time-shifts the data and adjusts for radial distance.

; 06/07/2011 Check for when null times.
; 02/04/2015 LBE: Update for new version of data files.

PRO convert_ace_swics_2hr, year, sat, num_days = num_days
compile_opt strictarrsubs

out_dir = '~/TempPlots2/'
out_file = 'ACE_SWICS_Data_'+string(year, format = '(I4.4)')+'_2hr_adj_'+sat+'.txt'
out_path = out_dir+out_file

start = string(year, format = '(I4.4)')+'-01-01/00:00:00'
ts = time_double(start)
IF keyword_set(num_days) EQ 0 THEN $
  IF year MOD 4 EQ 0 THEN num_days = 366 ELSE num_days = 365
timespan, ts, num_days

get_ace_swics_2hr
he_den   = 'ace_swics_alpha_density_2hr'
he_vel   = 'ace_swics_alpha_velocity_2hr'
he_vth   = 'ace_swics_alpha_v_therm_2hr'
c5_vel   = 'ace_swics_c5_vel_2hr'
c5_vth   = 'ace_swics_c5_vth_2hr'
o6_vel   = 'ace_swics_o6_vel_2hr'
o6_vth   = 'ace_swics_o6_vth_2hr'
fe10_vel = 'ace_swics_fe10_vel_2hr'
fe10_vth = 'ace_swics_fe10_vth_2hr'
c_6_4    = 'ace_swics_c_6_4_2hr'
c_6_5    = 'ace_swics_c_6_5_2hr'
o_7_6    = 'ace_swics_o_7_6_2hr'
c_av_q   = 'ace_swics_c_av_q_2hr'
o_av_q   = 'ace_swics_o_av_q_2hr'
fe_av_q  = 'ace_swics_fe_av_q_2hr'
mg_av_q  = 'ace_swics_mg_av_q_2hr'
si_av_q  = 'ace_swics_si_av_q_2hr'
sw_type  = 'ace_swics_sw_type_2hr'
fe_o     = 'ace_swics_fe_o_2hr'
he_o     = 'ace_swics_he_o_2hr'
c_o      = 'ace_swics_c_o_2hr'
ne_o     = 'ace_swics_ne_o_2hr'
mq_o     = 'ace_swics_mg_o_2hr'
si_o     = 'ace_swics_si_o_2hr'
he_den_no_err   = 'ace_swics_alpha_density_2hr_no_err'
he_vel_no_err   = 'ace_swics_alpha_velocity_2hr_no_err'
he_vth_no_err   = 'ace_swics_alpha_v_therm_2hr_no_err'
c5_vel_no_err   = 'ace_swics_c5_vel_2hr_no_err'
c5_vth_no_err   = 'ace_swics_c5_vth_2hr_no_err'
o6_vel_no_err   = 'ace_swics_o6_vel_2hr_no_err'
o6_vth_no_err   = 'ace_swics_o6_vth_2hr_no_err'
fe10_vel_no_err = 'ace_swics_fe10_vel_2hr_no_err'
fe10_vth_no_err = 'ace_swics_fe10_vth_2hr_no_err'
c_6_4_no_err    = 'ace_swics_c_6_4_2hr_no_err'
c_6_5_no_err    = 'ace_swics_c_6_5_2hr_no_err'
o_7_6_no_err    = 'ace_swics_o_7_6_2hr_no_err'
c_av_q_no_err   = 'ace_swics_c_av_q_2hr_no_err'
o_av_q_no_err   = 'ace_swics_o_av_q_2hr_no_err'
fe_av_q_no_err  = 'ace_swics_fe_av_q_2hr_no_err'
mg_av_q_no_err  = 'ace_swics_mg_av_q_2hr_no_err'
si_av_q_no_err  = 'ace_swics_si_av_q_2hr_no_err'
sw_type_no_err  = 'ace_swics_sw_type_2hr_no_err'
fe_o_no_err     = 'ace_swics_fe_o_2hr_no_err'
he_o_no_err     = 'ace_swics_he_o_2hr_no_err'
c_o_no_err      = 'ace_swics_c_o_2hr_no_err'
ne_o_no_err     = 'ace_swics_ne_o_2hr_no_err'
mq_o_no_err     = 'ace_swics_mg_o_2hr_no_err'
si_o_no_err     = 'ace_swics_si_o_2hr_no_err'

get_data, he_den,           he_den_t,           he_den_d    
get_data, he_vel,           he_vel_t,           he_vel_d    
get_data, he_vth,           he_vth_t,           he_vth_d    
get_data, c5_vel,           c5_vel_t,           c5_vel_d    
get_data, c5_vth,           c5_vth_t,           c5_vth_d    
get_data, o6_vel,           o6_vel_t,           o6_vel_d    
get_data, o6_vth,           o6_vth_t,           o6_vth_d    
get_data, fe10_vel,         fe10_vel_t,         fe10_vel_d  
get_data, fe10_vth,         fe10_vth_t,         fe10_vth_d  
get_data, c_6_4,            c_6_4_t,            c_6_4_d     
get_data, c_6_5,            c_6_5_t,            c_6_5_d     
get_data, o_7_6,            o_7_6_t,            o_7_6_d     
get_data, c_av_q,           c_av_q_t,           c_av_q_d    
get_data, o_av_q,           o_av_q_t,           o_av_q_d    
get_data, fe_av_q,          fe_av_q_t,          fe_av_q_d   
get_data, mg_av_q,          mg_av_q_t,          mg_av_q_d   
get_data, si_av_q,          si_av_q_t,          si_av_q_d   
get_data, sw_type,          sw_type_t,          sw_type_d   
get_data, fe_o,             fe_o_t,             fe_o_d      
get_data, he_o,             he_o_t,             he_o_d      
get_data, c_o,              c_o_t,              c_o_d       
get_data, ne_o,             ne_o_t,             ne_o_d      
get_data, mq_o,             mq_o_t,             mq_o_d      
get_data, si_o,             si_o_t,             si_o_d      
get_data, he_den_no_err,    he_den_no_err_t,    he_den_no_err_d    
get_data, he_vel_no_err,    he_vel_no_err_t,    he_vel_no_err_d    
get_data, he_vth_no_err,    he_vth_no_err_t,    he_vth_no_err_d    
get_data, c5_vel_no_err,    c5_vel_no_err_t,    c5_vel_no_err_d    
get_data, c5_vth_no_err,    c5_vth_no_err_t,    c5_vth_no_err_d    
get_data, o6_vel_no_err,    o6_vel_no_err_t,    o6_vel_no_err_d    
get_data, o6_vth_no_err,    o6_vth_no_err_t,    o6_vth_no_err_d    
get_data, fe10_vel_no_err,  fe10_vel_no_err_t,  fe10_vel_no_err_d  
get_data, fe10_vth_no_err,  fe10_vth_no_err_t,  fe10_vth_no_err_d  
get_data, c_6_4_no_err,     c_6_4_no_err_t,     c_6_4_no_err_d     
get_data, c_6_5_no_err,     c_6_5_no_err_t,     c_6_5_no_err_d     
get_data, o_7_6_no_err,     o_7_6_no_err_t,     o_7_6_no_err_d     
get_data, c_av_q_no_err,    c_av_q_no_err_t,    c_av_q_no_err_d    
get_data, o_av_q_no_err,    o_av_q_no_err_t,    o_av_q_no_err_d    
get_data, fe_av_q_no_err,   fe_av_q_no_err_t,   fe_av_q_no_err_d   
get_data, mg_av_q_no_err,   mg_av_q_no_err_t,   mg_av_q_no_err_d   
get_data, si_av_q_no_err,   si_av_q_no_err_t,   si_av_q_no_err_d   
get_data, sw_type_no_err,   sw_type_no_err_t,   sw_type_no_err_d   
get_data, fe_o_no_err,      fe_o_no_err_t,      fe_o_no_err_d      
get_data, he_o_no_err,      he_o_no_err_t,      he_o_no_err_d      
get_data, c_o_no_err,       c_o_no_err_t,       c_o_no_err_d       
get_data, ne_o_no_err,      ne_o_no_err_t,      ne_o_no_err_d      
get_data, mq_o_no_err,      mq_o_no_err_t,      mq_o_no_err_d      
get_data, si_o_no_err,      si_o_no_err_t,      si_o_no_err_d      

IF array_equal(he_vel_t,          he_den_t) NE 1 THEN stop    
IF array_equal(he_vth_t,          he_den_t) NE 1 THEN stop    
IF array_equal(c5_vel_t,          he_den_t) NE 1 THEN stop    
IF array_equal(c5_vth_t,          he_den_t) NE 1 THEN stop    
IF array_equal(o6_vel_t,          he_den_t) NE 1 THEN stop    
IF array_equal(o6_vth_t,          he_den_t) NE 1 THEN stop    
IF array_equal(fe10_vel_t,        he_den_t) NE 1 THEN stop  
IF array_equal(fe10_vth_t,        he_den_t) NE 1 THEN stop  
IF array_equal(c_6_4_t,           he_den_t) NE 1 THEN stop     
IF array_equal(c_6_5_t,           he_den_t) NE 1 THEN stop     
IF array_equal(o_7_6_t,           he_den_t) NE 1 THEN stop     
IF array_equal(c_av_q_t,          he_den_t) NE 1 THEN stop    
IF array_equal(o_av_q_t,          he_den_t) NE 1 THEN stop    
IF array_equal(fe_av_q_t,         he_den_t) NE 1 THEN stop   
IF array_equal(mg_av_q_t,         he_den_t) NE 1 THEN stop   
IF array_equal(si_av_q_t,         he_den_t) NE 1 THEN stop   
IF array_equal(sw_type_t,         he_den_t) NE 1 THEN stop   
IF array_equal(fe_o_t,            he_den_t) NE 1 THEN stop      
IF array_equal(he_o_t,            he_den_t) NE 1 THEN stop      
IF array_equal(c_o_t,             he_den_t) NE 1 THEN stop       
IF array_equal(ne_o_t,            he_den_t) NE 1 THEN stop      
IF array_equal(mq_o_t,            he_den_t) NE 1 THEN stop      
IF array_equal(si_o_t,            he_den_t) NE 1 THEN stop      
IF array_equal(he_den_no_err_t,   he_den_t) NE 1 THEN stop
IF array_equal(he_vel_no_err_t,   he_den_t) NE 1 THEN stop    
IF array_equal(he_vth_no_err_t,   he_den_t) NE 1 THEN stop    
IF array_equal(c5_vel_no_err_t,   he_den_t) NE 1 THEN stop    
IF array_equal(c5_vth_no_err_t,   he_den_t) NE 1 THEN stop    
IF array_equal(o6_vel_no_err_t,   he_den_t) NE 1 THEN stop    
IF array_equal(o6_vth_no_err_t,   he_den_t) NE 1 THEN stop    
IF array_equal(fe10_vel_no_err_t, he_den_t) NE 1 THEN stop  
IF array_equal(fe10_vth_no_err_t, he_den_t) NE 1 THEN stop  
IF array_equal(c_6_4_no_err_t,    he_den_t) NE 1 THEN stop     
IF array_equal(c_6_5_no_err_t,    he_den_t) NE 1 THEN stop     
IF array_equal(o_7_6_no_err_t,    he_den_t) NE 1 THEN stop     
IF array_equal(c_av_q_no_err_t,   he_den_t) NE 1 THEN stop    
IF array_equal(o_av_q_no_err_t,   he_den_t) NE 1 THEN stop    
IF array_equal(fe_av_q_no_err_t,  he_den_t) NE 1 THEN stop   
IF array_equal(mg_av_q_no_err_t,  he_den_t) NE 1 THEN stop   
IF array_equal(si_av_q_no_err_t,  he_den_t) NE 1 THEN stop   
IF array_equal(sw_type_no_err_t,  he_den_t) NE 1 THEN stop   
IF array_equal(fe_o_no_err_t,     he_den_t) NE 1 THEN stop      
IF array_equal(he_o_no_err_t,     he_den_t) NE 1 THEN stop      
IF array_equal(c_o_no_err_t,      he_den_t) NE 1 THEN stop       
IF array_equal(ne_o_no_err_t,     he_den_t) NE 1 THEN stop      
IF array_equal(mq_o_no_err_t,     he_den_t) NE 1 THEN stop      
IF array_equal(si_o_no_err_t,     he_den_t) NE 1 THEN stop      

time_shift_aceswics_2hr_to_stereo, sat, he_den_t, new_ace_t

; ace radial distance
get_ace_ancillary
get_data, 'ace_sp_d_hs', ace_rad_t, ace_rad_d
;time_shift_ace_to_stereo, sat, ace_rad_t, new_ace_rad_t, /ancillary
time_shift_aceswics_2hr_to_stereo, sat, ace_rad_t, new_ace_rad_t
bad_i = where(finite(new_ace_rad_t) EQ 0, bad_count, complement = good_i, ncomplement = good_count)
WHILE bad_count GT 0 DO BEGIN 
    temp_time = new_ace_rad_t[good_i]
    temp_i    = 0
    wanted_i  = bad_i[temp_i]
    temp_i    = temp_i + 1
    WHILE temp_i LT bad_count DO BEGIN 
        IF bad_i[temp_i] EQ wanted_i[n_elements(wanted_i)-1]+1 THEN BEGIN 
            wanted_i = [wanted_i, bad_i[temp_i]] 
            temp_i   = temp_i + 1
        ENDIF ELSE temp_i = bad_count
    ENDWHILE 
    temp_count = n_elements(wanted_i)
    step1 = indgen(temp_count)+1
    step2 = step1*(1.0/(temp_count+1))
    step3 = bad_i[0]-1+step2
    new_times = interpolate(temp_time, step3)
    new_ace_rad_t[wanted_i] = new_times
    bad_i = where(finite(new_ace_rad_t) EQ 0, bad_count, complement = good_i, ncomplement = good_count)
ENDWHILE 
store_data, 'ace_sp_d_hs', data = {x:new_ace_rad_t, y:ace_rad_d}

; stereo radial distance
temp_time = time_string(new_ace_rad_t)
strput, temp_time, 'T', 10      ; change time string format for SolarSoft
IF sat EQ 'A' THEN state = get_stereo_coord(temp_time, 'A', system = 'HERTN', target = 'STEREO Ahead') ELSE $
  state = get_stereo_coord(temp_time, 'B', system = 'HERTN', target = 'STEREO Behind')
stereo_rad_d = reform(state[0, *])

; adjust by radial distance
FOR doy = 1, num_days DO BEGIN 
    wanted_i = where(new_ace_t GE new_ace_rad_t[doy-1] AND new_ace_t LT (new_ace_rad_t[doy-1] + 86400), count)
    IF count GT 0 THEN BEGIN 
        he_den_d         [wanted_i] = he_den_d         [wanted_i] *      (ace_rad_d[doy-1]/stereo_rad_d[doy-1])
        he_vth_d         [wanted_i] = he_vth_d         [wanted_i] * sqrt((ace_rad_d[doy-1]/stereo_rad_d[doy-1]))
        c5_vth_d         [wanted_i] = c5_vth_d         [wanted_i] * sqrt((ace_rad_d[doy-1]/stereo_rad_d[doy-1]))
        o6_vth_d         [wanted_i] = o6_vth_d         [wanted_i] * sqrt((ace_rad_d[doy-1]/stereo_rad_d[doy-1]))
        fe10_vth_d       [wanted_i] = fe10_vth_d       [wanted_i] * sqrt((ace_rad_d[doy-1]/stereo_rad_d[doy-1]))
        he_den_no_err_d  [wanted_i] = he_den_no_err_d  [wanted_i] *      (ace_rad_d[doy-1]/stereo_rad_d[doy-1])
        he_vth_no_err_d  [wanted_i] = he_vth_no_err_d  [wanted_i] * sqrt((ace_rad_d[doy-1]/stereo_rad_d[doy-1]))
        c5_vth_no_err_d  [wanted_i] = c5_vth_no_err_d  [wanted_i] * sqrt((ace_rad_d[doy-1]/stereo_rad_d[doy-1]))
        o6_vth_no_err_d  [wanted_i] = o6_vth_no_err_d  [wanted_i] * sqrt((ace_rad_d[doy-1]/stereo_rad_d[doy-1]))
        fe10_vth_no_err_d[wanted_i] = fe10_vth_no_err_d[wanted_i] * sqrt((ace_rad_d[doy-1]/stereo_rad_d[doy-1]))
    ENDIF 
ENDFOR 

; create strings
he_den_d_st          = string(           he_den_d) 
he_vel_d_st          = string(           he_vel_d) 
he_vth_d_st          = string(           he_vth_d) 
c5_vel_d_st          = string(           c5_vel_d)           
c5_vth_d_st          = string(           c5_vth_d)           
o6_vel_d_st          = string(           o6_vel_d) 
o6_vth_d_st          = string(           o6_vth_d)           
fe10_vel_d_st        = string(         fe10_vel_d)         
fe10_vth_d_st        = string(         fe10_vth_d)         
c_6_4_d_st           = string(            c_6_4_d)            
c_6_5_d_st           = string(            c_6_5_d)            
o_7_6_d_st           = string(            o_7_6_d)            
c_av_q_d_st          = string(           c_av_q_d)           
o_av_q_d_st          = string(           o_av_q_d)           
fe_av_q_d_st         = string(          fe_av_q_d)          
mg_av_q_d_st         = string(          mg_av_q_d)          
si_av_q_d_st         = string(          si_av_q_d)          
sw_type_d_st         = string(          sw_type_d)          
fe_o_d_st            = string(             fe_o_d)             
he_o_d_st            = string(             he_o_d)             
c_o_d_st             = string(              c_o_d)              
ne_o_d_st            = string(             ne_o_d)             
mq_o_d_st            = string(             mq_o_d)             
si_o_d_st            = string(             si_o_d)             
he_den_no_err_d_st   = string(    he_den_no_err_d)    
he_vel_no_err_d_st   = string(    he_vel_no_err_d)    
he_vth_no_err_d_st   = string(    he_vth_no_err_d)    
c5_vel_no_err_d_st   = string(    c5_vel_no_err_d)    
c5_vth_no_err_d_st   = string(    c5_vth_no_err_d)    
o6_vel_no_err_d_st   = string(    o6_vel_no_err_d)    
o6_vth_no_err_d_st   = string(    o6_vth_no_err_d)    
fe10_vel_no_err_d_st = string(  fe10_vel_no_err_d)  
fe10_vth_no_err_d_st = string(  fe10_vth_no_err_d)  
c_6_4_no_err_d_st    = string(     c_6_4_no_err_d)     
c_6_5_no_err_d_st    = string(     c_6_5_no_err_d)     
o_7_6_no_err_d_st    = string(     o_7_6_no_err_d)     
c_av_q_no_err_d_st   = string(    c_av_q_no_err_d)    
o_av_q_no_err_d_st   = string(    o_av_q_no_err_d)    
fe_av_q_no_err_d_st  = string(   fe_av_q_no_err_d)   
mg_av_q_no_err_d_st  = string(   mg_av_q_no_err_d)   
si_av_q_no_err_d_st  = string(   si_av_q_no_err_d)   
sw_type_no_err_d_st  = string(   sw_type_no_err_d)   
fe_o_no_err_d_st     = string(      fe_o_no_err_d)      
he_o_no_err_d_st     = string(      he_o_no_err_d)      
c_o_no_err_d_st      = string(       c_o_no_err_d)       
ne_o_no_err_d_st     = string(      ne_o_no_err_d)      
mq_o_no_err_d_st     = string(      mq_o_no_err_d)      
si_o_no_err_d_st     = string(      si_o_no_err_d)
bad_he_den_i          = where(finite(           he_den_d) EQ 0,           he_den_count)    
bad_he_vel_i          = where(finite(           he_vel_d) EQ 0,           he_vel_count)    
bad_he_vth_i          = where(finite(           he_vth_d) EQ 0,           he_vth_count)    
bad_c5_vel_i          = where(finite(           c5_vel_d) EQ 0,           c5_vel_count)    
bad_c5_vth_i          = where(finite(           c5_vth_d) EQ 0,           c5_vth_count)    
bad_o6_vel_i          = where(finite(           o6_vel_d) EQ 0,           o6_vel_count)    
bad_o6_vth_i          = where(finite(           o6_vth_d) EQ 0,           o6_vth_count)    
bad_fe10_vel_i        = where(finite(         fe10_vel_d) EQ 0,         fe10_vel_count)  
bad_fe10_vth_i        = where(finite(         fe10_vth_d) EQ 0,         fe10_vth_count)  
bad_c_6_4_i           = where(finite(            c_6_4_d) EQ 0,            c_6_4_count)     
bad_c_6_5_i           = where(finite(            c_6_5_d) EQ 0,            c_6_5_count)     
bad_o_7_6_i           = where(finite(            o_7_6_d) EQ 0,            o_7_6_count)     
bad_c_av_q_i          = where(finite(           c_av_q_d) EQ 0,           c_av_q_count)    
bad_o_av_q_i          = where(finite(           o_av_q_d) EQ 0,           o_av_q_count)    
bad_fe_av_q_i         = where(finite(          fe_av_q_d) EQ 0,          fe_av_q_count)   
bad_mg_av_q_i         = where(finite(          mg_av_q_d) EQ 0,          mg_av_q_count)   
bad_si_av_q_i         = where(finite(          si_av_q_d) EQ 0,          si_av_q_count)   
bad_sw_type_i         = where(finite(          sw_type_d) EQ 0,          sw_type_count)   
bad_fe_o_i            = where(finite(             fe_o_d) EQ 0,             fe_o_count)      
bad_he_o_i            = where(finite(             he_o_d) EQ 0,             he_o_count)      
bad_c_o_i             = where(finite(              c_o_d) EQ 0,              c_o_count)       
bad_ne_o_i            = where(finite(             ne_o_d) EQ 0,             ne_o_count)      
bad_mq_o_i            = where(finite(             mq_o_d) EQ 0,             mq_o_count)      
bad_si_o_i            = where(finite(             si_o_d) EQ 0,             si_o_count)      
bad_he_den_no_err_i   = where(finite(    he_den_no_err_d) EQ 0,    he_den_no_err_count)    
bad_he_vel_no_err_i   = where(finite(    he_vel_no_err_d) EQ 0,    he_vel_no_err_count)    
bad_he_vth_no_err_i   = where(finite(    he_vth_no_err_d) EQ 0,    he_vth_no_err_count)    
bad_c5_vel_no_err_i   = where(finite(    c5_vel_no_err_d) EQ 0,    c5_vel_no_err_count)    
bad_c5_vth_no_err_i   = where(finite(    c5_vth_no_err_d) EQ 0,    c5_vth_no_err_count)    
bad_o6_vel_no_err_i   = where(finite(    o6_vel_no_err_d) EQ 0,    o6_vel_no_err_count)    
bad_o6_vth_no_err_i   = where(finite(    o6_vth_no_err_d) EQ 0,    o6_vth_no_err_count)    
bad_fe10_vel_no_err_i = where(finite(  fe10_vel_no_err_d) EQ 0,  fe10_vel_no_err_count)  
bad_fe10_vth_no_err_i = where(finite(  fe10_vth_no_err_d) EQ 0,  fe10_vth_no_err_count)  
bad_c_6_4_no_err_i    = where(finite(     c_6_4_no_err_d) EQ 0,     c_6_4_no_err_count)     
bad_c_6_5_no_err_i    = where(finite(     c_6_5_no_err_d) EQ 0,     c_6_5_no_err_count)     
bad_o_7_6_no_err_i    = where(finite(     o_7_6_no_err_d) EQ 0,     o_7_6_no_err_count)     
bad_c_av_q_no_err_i   = where(finite(    c_av_q_no_err_d) EQ 0,    c_av_q_no_err_count)    
bad_o_av_q_no_err_i   = where(finite(    o_av_q_no_err_d) EQ 0,    o_av_q_no_err_count)    
bad_fe_av_q_no_err_i  = where(finite(   fe_av_q_no_err_d) EQ 0,   fe_av_q_no_err_count)   
bad_mg_av_q_no_err_i  = where(finite(   mg_av_q_no_err_d) EQ 0,   mg_av_q_no_err_count)   
bad_si_av_q_no_err_i  = where(finite(   si_av_q_no_err_d) EQ 0,   si_av_q_no_err_count)   
bad_sw_type_no_err_i  = where(finite(   sw_type_no_err_d) EQ 0,   sw_type_no_err_count)   
bad_fe_o_no_err_i     = where(finite(      fe_o_no_err_d) EQ 0,      fe_o_no_err_count)      
bad_he_o_no_err_i     = where(finite(      he_o_no_err_d) EQ 0,      he_o_no_err_count)      
bad_c_o_no_err_i      = where(finite(       c_o_no_err_d) EQ 0,       c_o_no_err_count)       
bad_ne_o_no_err_i     = where(finite(      ne_o_no_err_d) EQ 0,      ne_o_no_err_count)      
bad_mq_o_no_err_i     = where(finite(      mq_o_no_err_d) EQ 0,      mq_o_no_err_count)      
bad_si_o_no_err_i     = where(finite(      si_o_no_err_d) EQ 0,      si_o_no_err_count)      
IF he_den_count          GT 0 THEN            he_den_d_st[bad_he_den_i         ] = '-1.00E+31'    
IF he_vel_count          GT 0 THEN            he_vel_d_st[bad_he_vel_i         ] = '-1.00E+31'    
IF he_vth_count          GT 0 THEN            he_vth_d_st[bad_he_vth_i         ] = '-1.00E+31'    
IF c5_vel_count          GT 0 THEN            c5_vel_d_st[bad_c5_vel_i         ] = '-1.00E+31'    
IF c5_vth_count          GT 0 THEN            c5_vth_d_st[bad_c5_vth_i         ] = '-1.00E+31'    
IF o6_vel_count          GT 0 THEN            o6_vel_d_st[bad_o6_vel_i         ] = '-1.00E+31'    
IF o6_vth_count          GT 0 THEN            o6_vth_d_st[bad_o6_vth_i         ] = '-1.00E+31'    
IF fe10_vel_count        GT 0 THEN          fe10_vel_d_st[bad_fe10_vel_i       ] = '-1.00E+31'  
IF fe10_vth_count        GT 0 THEN          fe10_vth_d_st[bad_fe10_vth_i       ] = '-1.00E+31'  
IF c_6_4_count           GT 0 THEN             c_6_4_d_st[bad_c_6_4_i          ] = '-1.00E+31'     
IF c_6_5_count           GT 0 THEN             c_6_5_d_st[bad_c_6_5_i          ] = '-1.00E+31'     
IF o_7_6_count           GT 0 THEN             o_7_6_d_st[bad_o_7_6_i          ] = '-1.00E+31'     
IF c_av_q_count          GT 0 THEN            c_av_q_d_st[bad_c_av_q_i         ] = '-1.00E+31'    
IF o_av_q_count          GT 0 THEN            o_av_q_d_st[bad_o_av_q_i         ] = '-1.00E+31'    
IF fe_av_q_count         GT 0 THEN           fe_av_q_d_st[bad_fe_av_q_i        ] = '-1.00E+31'   
IF mg_av_q_count         GT 0 THEN           mg_av_q_d_st[bad_mg_av_q_i        ] = '-1.00E+31'   
IF si_av_q_count         GT 0 THEN           si_av_q_d_st[bad_si_av_q_i        ] = '-1.00E+31'   
IF sw_type_count         GT 0 THEN           sw_type_d_st[bad_sw_type_i        ] = '-1.00E+31'   
IF fe_o_count            GT 0 THEN              fe_o_d_st[bad_fe_o_i           ] = '-1.00E+31'      
IF he_o_count            GT 0 THEN              he_o_d_st[bad_he_o_i           ] = '-1.00E+31'      
IF c_o_count             GT 0 THEN               c_o_d_st[bad_c_o_i            ] = '-1.00E+31'       
IF ne_o_count            GT 0 THEN              ne_o_d_st[bad_ne_o_i           ] = '-1.00E+31'      
IF mq_o_count            GT 0 THEN              mq_o_d_st[bad_mq_o_i           ] = '-1.00E+31'      
IF si_o_count            GT 0 THEN              si_o_d_st[bad_si_o_i           ] = '-1.00E+31'      
IF he_den_no_err_count   GT 0 THEN     he_den_no_err_d_st[bad_he_den_no_err_i  ] = '-1.00E+31'    
IF he_vel_no_err_count   GT 0 THEN     he_vel_no_err_d_st[bad_he_vel_no_err_i  ] = '-1.00E+31'    
IF he_vth_no_err_count   GT 0 THEN     he_vth_no_err_d_st[bad_he_vth_no_err_i  ] = '-1.00E+31'    
IF c5_vel_no_err_count   GT 0 THEN     c5_vel_no_err_d_st[bad_c5_vel_no_err_i  ] = '-1.00E+31'    
IF c5_vth_no_err_count   GT 0 THEN     c5_vth_no_err_d_st[bad_c5_vth_no_err_i  ] = '-1.00E+31'    
IF o6_vel_no_err_count   GT 0 THEN     o6_vel_no_err_d_st[bad_o6_vel_no_err_i  ] = '-1.00E+31'    
IF o6_vth_no_err_count   GT 0 THEN     o6_vth_no_err_d_st[bad_o6_vth_no_err_i  ] = '-1.00E+31'    
IF fe10_vel_no_err_count GT 0 THEN   fe10_vel_no_err_d_st[bad_fe10_vel_no_err_i] = '-1.00E+31'  
IF fe10_vth_no_err_count GT 0 THEN   fe10_vth_no_err_d_st[bad_fe10_vth_no_err_i] = '-1.00E+31'  
IF c_6_4_no_err_count    GT 0 THEN      c_6_4_no_err_d_st[bad_c_6_4_no_err_i   ] = '-1.00E+31'     
IF c_6_5_no_err_count    GT 0 THEN      c_6_5_no_err_d_st[bad_c_6_5_no_err_i   ] = '-1.00E+31'     
IF o_7_6_no_err_count    GT 0 THEN      o_7_6_no_err_d_st[bad_o_7_6_no_err_i   ] = '-1.00E+31'     
IF c_av_q_no_err_count   GT 0 THEN     c_av_q_no_err_d_st[bad_c_av_q_no_err_i  ] = '-1.00E+31'    
IF o_av_q_no_err_count   GT 0 THEN     o_av_q_no_err_d_st[bad_o_av_q_no_err_i  ] = '-1.00E+31'    
IF fe_av_q_no_err_count  GT 0 THEN    fe_av_q_no_err_d_st[bad_fe_av_q_no_err_i ] = '-1.00E+31'   
IF mg_av_q_no_err_count  GT 0 THEN    mg_av_q_no_err_d_st[bad_mg_av_q_no_err_i ] = '-1.00E+31'   
IF si_av_q_no_err_count  GT 0 THEN    si_av_q_no_err_d_st[bad_si_av_q_no_err_i ] = '-1.00E+31'   
IF sw_type_no_err_count  GT 0 THEN    sw_type_no_err_d_st[bad_sw_type_no_err_i ] = '-1.00E+31'   
IF fe_o_no_err_count     GT 0 THEN       fe_o_no_err_d_st[bad_fe_o_no_err_i    ] = '-1.00E+31'      
IF he_o_no_err_count     GT 0 THEN       he_o_no_err_d_st[bad_he_o_no_err_i    ] = '-1.00E+31'      
IF c_o_no_err_count      GT 0 THEN        c_o_no_err_d_st[bad_c_o_no_err_i     ] = '-1.00E+31'       
IF ne_o_no_err_count     GT 0 THEN       ne_o_no_err_d_st[bad_ne_o_no_err_i    ] = '-1.00E+31'      
IF mq_o_no_err_count     GT 0 THEN       mq_o_no_err_d_st[bad_mq_o_no_err_i    ] = '-1.00E+31'      
IF si_o_no_err_count     GT 0 THEN       si_o_no_err_d_st[bad_si_o_no_err_i    ] = '-1.00E+31'      
      

; write out data
openw, out_lun, out_path, /get_lun
printf, out_lun, out_file
header = 'Adjusted by time and radial distance'
printf, out_lun, header
tab = string(9B)
header = 'ACE Time'+tab+'ST'+sat+' Adj. Time'+tab+$
         he_den   +tab+$ 
         he_vel   +tab+$ 
         he_vth   +tab+$ 
         c5_vel   +tab+$ 
         c5_vth   +tab+$ 
         o6_vel   +tab+$ 
         o6_vth   +tab+$ 
         fe10_vel +tab+$ 
         fe10_vth +tab+$ 
         c_6_4    +tab+$ 
         c_6_5    +tab+$ 
         o_7_6    +tab+$ 
         c_av_q   +tab+$ 
         o_av_q   +tab+$ 
         fe_av_q  +tab+$ 
         mg_av_q  +tab+$ 
         si_av_q  +tab+$ 
         sw_type  +tab+$ 
         fe_o     +tab+$ 
         he_o     +tab+$ 
         c_o      +tab+$ 
         ne_o     +tab+$ 
         mq_o     +tab+$ 
         si_o     +tab+$ 
         he_den_no_err   +tab+$ 
         he_vel_no_err   +tab+$ 
         he_vth_no_err   +tab+$ 
         c5_vel_no_err   +tab+$ 
         c5_vth_no_err   +tab+$ 
         o6_vel_no_err   +tab+$ 
         o6_vth_no_err   +tab+$ 
         fe10_vel_no_err +tab+$ 
         fe10_vth_no_err +tab+$ 
         c_6_4_no_err    +tab+$ 
         c_6_5_no_err    +tab+$ 
         o_7_6_no_err    +tab+$ 
         c_av_q_no_err   +tab+$ 
         o_av_q_no_err   +tab+$ 
         fe_av_q_no_err  +tab+$ 
         mg_av_q_no_err  +tab+$ 
         si_av_q_no_err  +tab+$ 
         sw_type_no_err  +tab+$ 
         fe_o_no_err     +tab+$ 
         he_o_no_err     +tab+$ 
         c_o_no_err      +tab+$ 
         ne_o_no_err     +tab+$ 
         mq_o_no_err     +tab+$ 
         si_o_no_err     
printf, out_lun, header
FOR ii = 0, n_elements(new_ace_t)-1 DO BEGIN
    temp_string = time_string(he_den_t [ii])+tab+$
                  time_string(new_ace_t[ii])+tab+$
                  he_den_d_st          [ii]+tab+$ 
                  he_vel_d_st          [ii]+tab+$ 
                  he_vth_d_st          [ii]+tab+$ 
                  c5_vel_d_st          [ii]+tab+$ 
                  c5_vth_d_st          [ii]+tab+$ 
                  o6_vel_d_st          [ii]+tab+$ 
                  o6_vth_d_st          [ii]+tab+$ 
                  fe10_vel_d_st        [ii]+tab+$ 
                  fe10_vth_d_st        [ii]+tab+$ 
                  c_6_4_d_st           [ii]+tab+$ 
                  c_6_5_d_st           [ii]+tab+$ 
                  o_7_6_d_st           [ii]+tab+$ 
                  c_av_q_d_st          [ii]+tab+$ 
                  o_av_q_d_st          [ii]+tab+$ 
                  fe_av_q_d_st         [ii]+tab+$ 
                  mg_av_q_d_st         [ii]+tab+$ 
                  si_av_q_d_st         [ii]+tab+$ 
                  sw_type_d_st         [ii]+tab+$ 
                  fe_o_d_st            [ii]+tab+$ 
                  he_o_d_st            [ii]+tab+$ 
                  c_o_d_st             [ii]+tab+$ 
                  ne_o_d_st            [ii]+tab+$ 
                  mq_o_d_st            [ii]+tab+$ 
                  si_o_d_st            [ii]+tab+$ 
                  he_den_no_err_d_st   [ii]+tab+$ 
                  he_vel_no_err_d_st   [ii]+tab+$ 
                  he_vth_no_err_d_st   [ii]+tab+$ 
                  c5_vel_no_err_d_st   [ii]+tab+$ 
                  c5_vth_no_err_d_st   [ii]+tab+$ 
                  o6_vel_no_err_d_st   [ii]+tab+$ 
                  o6_vth_no_err_d_st   [ii]+tab+$ 
                  fe10_vel_no_err_d_st [ii]+tab+$ 
                  fe10_vth_no_err_d_st [ii]+tab+$ 
                  c_6_4_no_err_d_st    [ii]+tab+$ 
                  c_6_5_no_err_d_st    [ii]+tab+$ 
                  o_7_6_no_err_d_st    [ii]+tab+$ 
                  c_av_q_no_err_d_st   [ii]+tab+$ 
                  o_av_q_no_err_d_st   [ii]+tab+$ 
                  fe_av_q_no_err_d_st  [ii]+tab+$ 
                  mg_av_q_no_err_d_st  [ii]+tab+$ 
                  si_av_q_no_err_d_st  [ii]+tab+$ 
                  sw_type_no_err_d_st  [ii]+tab+$ 
                  fe_o_no_err_d_st     [ii]+tab+$ 
                  he_o_no_err_d_st     [ii]+tab+$ 
                  c_o_no_err_d_st      [ii]+tab+$ 
                  ne_o_no_err_d_st     [ii]+tab+$ 
                  mq_o_no_err_d_st     [ii]+tab+$ 
                  si_o_no_err_d_st     [ii]     
    printf, out_lun, temp_string
ENDFOR 
close, out_lun
free_lun, out_lun

END

