;+
;Name: libs
;Purpose:
;  Displays location of source files.
;
;Usage:
;  libs,string  ; string is the name of an IDL source file.
;                 It may contain wildcard characters
;Restrictions:
;   UNIX only
;-

pro libs,name

if !version.os_family eq 'unix' then begin
   sep = ':'
   slash = '/'
endif
if !version.os_family eq 'Windows' then begin
   sep = ';'
   slash = '\'
endif

dirs = ['.',strsplit(!path,sep,/extract)]
if n_elements(name) eq 0 then begin
   print,transpose(dirs)
   return
endif

files = dirs+slash+name+'.pro'
for i=0,n_elements(dirs)-1 do  begin
  f = findfile(files[i])
  if keyword_set(f) then  print,transpose(f)
endfor
end
