; Lorna Ellis
; 10/01/2007
; update_ratios.pro

; This procedure updates in the necessary calibration ratios. It updates
; all days of specified years.

; 05/26/2009 Put in splat environment. Changed arguments.

PRO create_svalid_ratio_string, year, doy, temp_string, svalid_ratio
compile_opt strictarrsubs
COMMON share1
tab = STRING(9B)
temp_string = string(year, format = '(I4.4)')+tab+string(doy+1, format = '(I3.3)')
FOR jj = 0, 31 DO BEGIN 
    IF finite(svalid_ratio[doy, jj]) EQ 1 THEN temp_string = temp_string+tab+string(svalid_ratio[doy, jj]) $
      ELSE temp_string = temp_string+tab+string(0)
ENDFOR
END 

PRO create_pri0_ratio_string, year, doy, temp_string, pri0_ratio
compile_opt strictarrsubs
COMMON share1
tab = STRING(9B)
temp_string = string(year, format = '(I4.4)')+tab+string(doy+1, format = '(I3.3)')
FOR jj = 0, 127 DO BEGIN 
    IF finite(pri0_ratio[doy, jj]) EQ 1 THEN temp_string = temp_string+tab+string(pri0_ratio[doy, jj]) $
      ELSE temp_string = temp_string+tab+string(0)
ENDFOR
END 

PRO update_ratios, year, sat, svalid_ratio, pri0_ratio
compile_opt strictarrsubs

calibration_path = getenv('PLACAL')

; update s_valid/ra_trig ratio (32 for each day -- based on energy)
cal_file = 'ST'+sat+'_svalid_ratrig_ratio_'+string(year, format = '(I4.4)')+'.tab'
cal_path = calibration_path+cal_file

; read old header
openr, cal_lun, cal_path, /get_lun
line = ' '
lines = strarr(3)
FOR ii = 0, 2 DO BEGIN          ; 3 header lines
    readf, cal_lun, line
    lines[ii] = line
ENDFOR 
close, cal_lun
free_lun, cal_lun
; write
openw, cal_lun, cal_path, /get_lun
FOR ii = 0, 2 DO BEGIN          ; 3 header lines
    printf, cal_lun, lines[ii]
ENDFOR 
FOR ii = 0, 365 DO BEGIN        ; doy
    create_svalid_ratio_string, year, ii, temp_string, svalid_ratio
    printf, cal_lun, temp_string
ENDFOR 
close, cal_lun
free_lun, cal_lun

; update sw pri 0/sw pri 0:3 ratio (128 for each day -- based on energy)
ii = 0
cal_file = 'ST'+sat+'_pri_ratio_'+string(year, format = '(I4.4)')+'.tab'
cal_path = calibration_path+cal_file
; read old header
openr, cal_lun, cal_path, /get_lun
lines = strarr(2)
FOR ii = 0, 1 DO BEGIN          ; 2 header lines
    readf, cal_lun, line
    lines[ii] = line
ENDFOR 
close, cal_lun
free_lun, cal_lun
; write
openw, cal_lun, cal_path, /get_lun
FOR ii = 0, 1 DO BEGIN          ; 2 header lines
    printf, cal_lun, lines[ii]
ENDFOR 
FOR ii = 0, 365 DO BEGIN        ; doy
    create_pri0_ratio_string, year, ii, temp_string, pri0_ratio
    printf, cal_lun, temp_string
ENDFOR 
close, cal_lun
free_lun, cal_lun

END 
