;+
;PROCEDURE: set_plot_attributes_dig_hk
;PURPOSE: Set the plot attributes for different products
;
;PARAMETERS:   sat : 'A' or 'B'
;              prod: array of product names
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 09/21/2006
;
;MODIFICATION HISTORY:
;    09/21/2006 Created
;	18 January, 2007:  modified for digital housekeeping
;-
PRO set_plot_attributes_dig_hk, sat, sat_dig_hk, inst_coord
compile_opt strictarrsubs

CASE inst_coord OF
    1: inst_string = 'INST_COORD'
ENDCASE 

prefix = ' '

IF (sat EQ 'A') THEN prefix = 'A_DIG_HK_'
IF (sat EQ 'B') THEN prefix = 'B_DIG_HK_'


FOR ii = 0, n_elements(sat_dig_hk)-1 DO BEGIN 
    CASE sat_dig_hk[ii] OF

	1:  BEGIN ;'dpu_sw_version':  BEGIN
		yt = sat+' dpu_sw_version'
		name = prefix+'dpu_sw_version'
		END
	2:  BEGIN; 'cmd_rcvd_cnt':  BEGIN
		yt = sat+' cmd_rcvd_cnt'
		name = prefix+'cmd_rcvd_cnt'
		END
	3:  BEGIN; 'cmd_exec_cnt':  BEGIN
		yt = sat+' cmd_exec_cnt'
		name = prefix+'cmd_exec_cnt'
		END
	4:  BEGIN; 'cmd_total_err_cnt':  BEGIN
		yt = sat+' cmd_total_err_cnt'
		name = prefix+'cmd_total_err_cnt'
		END
	5:  BEGIN; 'cmd_parity_err_cnt':  BEGIN
		yt = sat+' cmd_parity_err_cnt'
		name = prefix+'cmd_parity_err_cnt'
		END
	6:  BEGIN ;'cmd_frame_err_cnt':  BEGIN
		yt = sat+' cmd_frame_err_cnt'
		name = prefix+'cmd_frame_err_cnt'
		END
	7:  BEGIN ;'cmd_illegal_err_cnt':  BEGIN
		yt = sat+' cmd_illegal_err_cnt'
		name = prefix+'cmd_illegal_err_cnt'
		END
	8:  BEGIN; 'ic_status_reg':  BEGIN
		yt = sat+' ic_status_reg'
		name = prefix+'ic_status_reg'
		END
	9:  BEGIN; 'ic_ctl_reg':  BEGIN
		yt = sat+' ic_ctl_reg'
		name = prefix+'ic_ctl_reg'
		END
	10:  BEGIN; 'lbc_reset_ctl':  BEGIN
		yt = sat+' lbc_reset_ctl'
		name = prefix+'lbc_reset_ctl'
		END
	11:  BEGIN; 'lbc_mode_ctl':  BEGIN
		yt = sat+' lbc_mode_ctl'
		name = prefix+'lbc_mode_ctl'
		END
	12:  BEGIN; 'lbc_logic_ctl_a':  BEGIN
		yt = sat+' lbc_logic_ctl_a'
		name = prefix+'lbc_logic_ctl_a'
		END
	13:  BEGIN; 'lbc_logic_ctl_b':  BEGIN
		yt = sat+' lbc_logic_ctl_b'
		name = prefix+'lbc_logic_ctl_b'
		END
	14:  BEGIN; 'lbc_tac_pwr_ctl':  BEGIN
		yt = sat+' lbc_tac_pwr_ctl'
		name = prefix+'lbc_tac_pwr_ctl'
		END
	15:  BEGIN; 'lbc_reg_seq':  BEGIN
		yt = sat+' lbc_reg_seq'
		name = prefix+'lbc_reg_seq'
		END
	16:  BEGIN; 'lbc_event_ctl':  BEGIN
		yt = sat+' lbc_event_ctl'
		name = prefix+'lbc_event_ctl'
		END
	17:  BEGIN; 'lbc_rlim_ch':  BEGIN
		yt = sat+' lbc_rlim_ch'
		name = prefix+'lbc_rlim_ch'
		END
	18:  BEGIN; 'lbc_rlim_hi':  BEGIN
		yt = sat+' lbc_rlim_hi'
		name = prefix+'lbc_rlim_hi'
		END
	19:  BEGIN; 'lbc_rlim_lo':  BEGIN
		yt = sat+' lbc_rlim_lo'
		name = prefix+'lbc_rlim_lo'
		END
	20:  BEGIN; 'lbe_pos_ctrl':  BEGIN
		yt = sat+' lbe_pos_ctrl'
		name = prefix+'lbe_pos_ctrl'
		END
	21:  BEGIN; 'lbe_pos_disable0':  BEGIN
		yt = sat+' lbe_pos_disable0'
		name = prefix+'lbe_pos_disable0'
		END
	22:  BEGIN; 'lbe_pos_disable2':  BEGIN
		yt = sat+' lbe_pos_disable2'
		name = prefix+'lbe_pos_disable2'
		END
	23:  BEGIN; 'lbe_tac0_ctrl':  BEGIN
		yt = sat+' lbe_tac0_ctrl'
		name = prefix+'lbe_tac0_ctrl'
		END
	24:  BEGIN; 'lbe_tac0_dac':  BEGIN
		yt = sat+' lbe_tac0_dac'
		name = prefix+'lbe_tac0_dac'
		END
	25:  BEGIN; 'lbe_tac2_ctrl':  BEGIN
		yt = sat+' lbe_tac2_ctrl'
		name = prefix+'lbe_tac2_ctrl'
		END
	26:  BEGIN; 'lbe_tac2_dac':  BEGIN
		yt = sat+' lbe_tac2_dac'
		name = prefix+'lbe_tac2_dac'
		END
	27:  BEGIN; 'lbe_tac0_under_hi':  BEGIN
		yt = sat+' lbe_tac0_under_hi'
		name = prefix+'lbe_tac0_under_hi'
		END
	28:  BEGIN; 'lbe_tac0_under_lo':  BEGIN
		yt = sat+' lbe_tac0_under_lo'
		name = prefix+'lbe_tac0_under_lo'
		END
	29:  BEGIN; 'lbe_tac0_over_hi':  BEGIN
		yt = sat+' lbe_tac0_over_hi'
		name = prefix+'lbe_tac0_over_hi'
		END
	30:  BEGIN; 'lbe_tac0_over_lo':  BEGIN
		yt = sat+' lbe_tac0_over_lo'
		name = prefix+'lbe_tac0_over_lo'
		END
	31:  BEGIN; 'lbe_tac2_under_hi':  BEGIN
		yt = sat+' lbe_tac2_under_hi'
		name = prefix+'lbe_tac2_under_hi'
		END
	32:  BEGIN; 'lbe_tac2_under_lo':  BEGIN
		yt = sat+' lbe_tac2_under_lo'
		name = prefix+'lbe_tac2_under_lo'
		END
	33:  BEGIN; 'lbe_tac2_over_hi':  BEGIN
		yt = sat+' lbe_tac2_over_hi'
		name = prefix+'lbe_tac2_over_hi'
		END
	34:  BEGIN; 'lbe_tac2_over_lo':  BEGIN
		yt = sat+' lbe_tac2_over_lo'
		name = prefix+'lbe_tac2_over_lo'
		END
	35:  BEGIN; 'lbe_ssd_ctrl':  BEGIN
		yt = sat+' lbe_ssd_ctrl'
		name = prefix+'lbe_ssd_ctrl'
		END
	36:  BEGIN; 'lbe_ssd_cmd_h':  BEGIN
		yt = sat+' lbe_ssd_cmd_h'
		name = prefix+'lbe_ssd_cmd_h'
		END
	37:  BEGIN; 'lbe_ssd_cmd_l':  BEGIN
		yt = sat+' lbe_ssd_cmd_l'
		name = prefix+'lbe_ssd_cmd_l'
		END
	38:  BEGIN; 'lbe_ssd_dis':  BEGIN
		yt = sat+' lbe_ssd_dis'
		name = prefix+'lbe_ssd_dis'
		END
	39:  BEGIN; 'lbe_ssd_under_hi':  BEGIN
		yt = sat+' lbe_ssd_under_hi'
		name = prefix+'lbe_ssd_under_hi'
		END
	40:  BEGIN; 'lbe_ssd_under_lo':  BEGIN
		yt = sat+' lbe_ssd_under_lo'
		name = prefix+'lbe_ssd_under_lo'
		END
	41:  BEGIN; 'lbe_ssd_over_hi':  BEGIN
		yt = sat+' lbe_ssd_over_hi'
		name = prefix+'lbe_ssd_over_hi'
		END
	42:  BEGIN; 'lbe_ssd_over_lo':  BEGIN
		yt = sat+' lbe_ssd_over_lo'
		name = prefix+'lbe_ssd_over_lo'
		END
	43:  BEGIN; 'lbe_sel_ctrl':  BEGIN
		yt = sat+' lbe_sel_ctrl'
		name = prefix+'lbe_sel_ctrl'
		END
	44:  BEGIN; 'lbe_trig_mode':  BEGIN
		yt = sat+' lbe_trig_mode'
		name = prefix+'lbe_trig_mode'
		END
	45:  BEGIN; 'lbe_esa_step':  BEGIN
		yt = sat+' lbe_esa_step'
		name = prefix+'lbe_esa_step'
		END
	46:  BEGIN; 'lbe_defl_step':  BEGIN
		yt = sat+' lbe_defl_step'
		name = prefix+'lbe_defl_step'
		END
	47:  BEGIN; 'lbe_ssd_offset0':  BEGIN
		yt = sat+' lbe_ssd_offset0'
		name = prefix+'lbe_ssd_offset0'
		END
	48:  BEGIN; 'lbe_ssd_offset1':  BEGIN
		yt = sat+' lbe_ssd_offset1'
		name = prefix+'lbe_ssd_offset1'
		END
	49:  BEGIN; 'lbe_ssd_offset2':  BEGIN
		yt = sat+' lbe_ssd_offset2'
		name = prefix+'lbe_ssd_offset2'
		END
	50:  BEGIN; 'lbe_ssd_offset3':  BEGIN
		yt = sat+' lbe_ssd_offset3'
		name = prefix+'lbe_ssd_offset3'
		END
	51:  BEGIN; 'lbe_ssd_offset4':  BEGIN
		yt = sat+' lbe_ssd_offset4'
		name = prefix+'lbe_ssd_offset4'
		END
	52:  BEGIN; 'lbe_ssd_offset5':  BEGIN
		yt = sat+' lbe_ssd_offset5'
		name = prefix+'lbe_ssd_offset5'
		END
	53:  BEGIN; 'lbe_ssd_offset6':  BEGIN
		yt = sat+' lbe_ssd_offset6'
		name = prefix+'lbe_ssd_offset6'
		END
	54:  BEGIN; 'lbe_ssd_offset7':  BEGIN
		yt = sat+' lbe_ssd_offset7'
		name = prefix+'lbe_ssd_offset7'
		END
	55:  BEGIN; 'lbe_stim_enable':  BEGIN
		yt = sat+' lbe_stim_enable'
		name = prefix+'lbe_stim_enable'
		END
	56:  BEGIN; 'lbe_stim_freq_hi':  BEGIN
		yt = sat+' lbe_stim_freq_hi'
		name = prefix+'lbe_stim_freq_hi'
		END
	57:  BEGIN; 'lbe_stim_freq_lo':  BEGIN
		yt = sat+' lbe_stim_freq_lo'
		name = prefix+'lbe_stim_freq_lo'
		END
	58:  BEGIN; 'lbe_sel0_window':  BEGIN
		yt = sat+' lbe_sel0_window'
		name = prefix+'lbe_sel0_window'
		END
	59:  BEGIN; 'lbe_sel2_window':  BEGIN
		yt = sat+' lbe_sel2_window'
		name = prefix+'lbe_sel2_window'
		END
	60:  BEGIN; 'lbe_ssd_offset8':  BEGIN
		yt = sat+' lbe_ssd_offset8'
		name = prefix+'lbe_ssd_offset8'
		END
	61:  BEGIN; 'lbe_ssd_offset9':  BEGIN
		yt = sat+' lbe_ssd_offset9'
		name = prefix+'lbe_ssd_offset9'
		END
	62:  BEGIN; 'lbe_ssd_offset10':  BEGIN
		yt = sat+' lbe_ssd_offset10'
		name = prefix+'lbe_ssd_offset10'
		END
	63:  BEGIN; 'lbe_ssd_offset11':  BEGIN
		yt = sat+' lbe_ssd_offset11'
		name = prefix+'lbe_ssd_offset11'
		END
	64:  BEGIN; 'lbe_ssd_offset12':  BEGIN
		yt = sat+' lbe_ssd_offset12'
		name = prefix+'lbe_ssd_offset12'
		END
	65:  BEGIN; 'lbe_ssd_offset13':  BEGIN
		yt = sat+' lbe_ssd_offset13'
		name = prefix+'lbe_ssd_offset13'
		END
	66:  BEGIN; 'lbe_ssd_offset14':  BEGIN
		yt = sat+' lbe_ssd_offset14'
		name = prefix+'lbe_ssd_offset14'
		END
	67:  BEGIN; 'lbe_ssd_offset15':  BEGIN
		yt = sat+' lbe_ssd_offset15'
		name = prefix+'lbe_ssd_offset15'
		END
	68:  BEGIN; 'lbe_pos_ra':  BEGIN
		yt = sat+' lbe_pos_ra'
		name = prefix+'lbe_pos_ra'
		END
	69:  BEGIN; 'dacm_pac_mcp_ssd_ctl_mcp_limit':  BEGIN
		yt = sat+' dacm_pac_mcp_ssd_ctl_mcp_limit'
		name = prefix+'dacm_pac_mcp_ssd_ctl_mcp_limit'
		END
	70:  BEGIN; 'dacm_pac_limit':  BEGIN
		yt = sat+' dacm_pac_limit'
		name = prefix+'dacm_pac_limit'
		END
	71:  BEGIN; 'dacm_esa_ctl':  BEGIN
		yt = sat+' dacm_esa_ctl'
		name = prefix+'dacm_esa_ctl'
		END
	72:  BEGIN; 'dacm_s_ch_ctl':  BEGIN
		yt = sat+' dacm_s_ch_ctl'
		name = prefix+'dacm_s_ch_ctl'
		END
	73:  BEGIN; 'dacm_dfl_1_ctl':  BEGIN
		yt = sat+' dacm_dfl_1_ctl'
		name = prefix+'dacm_dfl_1_ctl'
		END
	74:  BEGIN; 'dacm_dfl_2_ctl':  BEGIN
		yt = sat+' dacm_dfl_2_ctl'
		name = prefix+'dacm_dfl_2_ctl'
		END
	75:  BEGIN; 'dacm_control':  BEGIN
		yt = sat+' dacm_control'
		name = prefix+'dacm_control'
		END
	76:  BEGIN; 'dacm_status':  BEGIN
		yt = sat+' dacm_status'
		name = prefix+'dacm_status'
		END
	77:  BEGIN; 'dacm_adc_lu_ctr':  BEGIN
		yt = sat+' dacm_adc_lu_ctr'
		name = prefix+'dacm_adc_lu_ctr'
		END
	78:  BEGIN; 'dacm_dfl_1_offset':  BEGIN
		yt = sat+' dacm_dfl_1_offset'
		name = prefix+'dacm_dfl_1_offset'
		END
	79:  BEGIN; 'dacm_dfl_2_offset':  BEGIN
		yt = sat+' dacm_dfl_2_offset'
		name = prefix+'dacm_dfl_2_offset'
		END
	80:  BEGIN; 'dacm_pac_coarse':  BEGIN
		yt = sat+' dacm_pac_coarse'
		name = prefix+'dacm_pac_coarse'
		END
	81:  BEGIN; 'dacm_pac_fine':  BEGIN
		yt = sat+' dacm_pac_fine'
		name = prefix+'dacm_pac_fine'
		END
	82:  BEGIN; 'dacm_pac_cm_fs_coarse':  BEGIN
		yt = sat+' dacm_pac_cm_fs_coarse'
		name = prefix+'dacm_pac_cm_fs_coarse'
		END
	83:  BEGIN; 'dacm_pac_cm_fs_fine':  BEGIN
		yt = sat+' dacm_pac_cm_fs_fine'
		name = prefix+'dacm_pac_cm_fs_fine'
		END
	84:  BEGIN; 'dacm_mcp_coarse':  BEGIN
		yt = sat+' dacm_mcp_coarse'
		name = prefix+'dacm_mcp_coarse'
		END
	85:  BEGIN; 'dacm_mcp_fine':  BEGIN
		yt = sat+' dacm_mcp_fine'
		name = prefix+'dacm_mcp_fine'
		END
	86:  BEGIN; 'dacm_mcp_cm_fs_coarse':  BEGIN
		yt = sat+' dacm_mcp_cm_fs_coarse'
		name = prefix+'dacm_mcp_cm_fs_coarse'
		END
	87:  BEGIN; 'dacm_mcp_cm_fs_fine':  BEGIN
		yt = sat+' dacm_mcp_cm_fs_fine'
		name = prefix+'dacm_mcp_cm_fs_fine'
		END
	88:  BEGIN; 'dacm_ssd_coarse':  BEGIN
		yt = sat+' dacm_ssd_coarse'
		name = prefix+'dacm_ssd_coarse'
		END
	89:  BEGIN; 'dacm_ssd_fine':  BEGIN
		yt = sat+' dacm_ssd_fine'
		name = prefix+'dacm_ssd_fine'
		END
	90:  BEGIN; 'dacm_esa_coarse':  BEGIN
		yt = sat+' dacm_esa_coarse'
		name = prefix+'dacm_esa_coarse'
		END
	91:  BEGIN; 'dacm_esa_fine':  BEGIN
		yt = sat+' dacm_esa_fine'
		name = prefix+'dacm_esa_fine'
		END
	92:  BEGIN; 'dacm_s_ch_coarse':  BEGIN
		yt = sat+' dacm_s_ch_coarse'
		name = prefix+'dacm_s_ch_coarse'
		END
	93:  BEGIN; 'dacm_s_ch_fine':  BEGIN
		yt = sat+' dacm_s_ch_fine'
		name = prefix+'dacm_s_ch_fine'
		END
	94:  BEGIN; 'dacm_s_ch_tap_coarse':  BEGIN
		yt = sat+' dacm_s_ch_tap_coarse'
		name = prefix+'dacm_s_ch_tap_coarse'
		END
	95:  BEGIN; 'dacm_s_ch_tap_fine':  BEGIN
		yt = sat+' dacm_s_ch_tap_fine'
		name = prefix+'dacm_s_ch_tap_fine'
		END
	96:  BEGIN; 'dacm_dfl_1_coarse':  BEGIN
		yt = sat+' dacm_dfl_1_coarse'
		name = prefix+'dacm_dfl_1_coarse'
		END
	97:  BEGIN; 'dacm_dfl_1_fine':  BEGIN
		yt = sat+' dacm_dfl_1_fine'
		name = prefix+'dacm_dfl_1_fine'
		END
	98:  BEGIN; 'dacm_dfl_1_dfine':  BEGIN
		yt = sat+' dacm_dfl_1_dfine'
		name = prefix+'dacm_dfl_1_dfine'
		END
	99:  BEGIN; 'dacm_dfl_2_coarse':  BEGIN
		yt = sat+' dacm_dfl_2_coarse'
		name = prefix+'dacm_dfl_2_coarse'
		END
	100:  BEGIN; 'dacm_dfl_2_fine':  BEGIN
		yt = sat+' dacm_dfl_2_fine'
		name = prefix+'dacm_dfl_2_fine'
		END
	101:  BEGIN; 'dacm_dfl_2_dfine':  BEGIN
		yt = sat+' dacm_dfl_2_dfine'
		name = prefix+'dacm_dfl_2_dfine'
		END
	102:  BEGIN; 'dacr_pac_mcp_ssd_ctl_mcp_limit':  BEGIN
		yt = sat+' dacr_pac_mcp_ssd_ctl_mcp_limit'
		name = prefix+'dacr_pac_mcp_ssd_ctl_mcp_limit'
		END
	103:  BEGIN; 'dacr_pac_limit':  BEGIN
		yt = sat+' dacr_pac_limit'
		name = prefix+'dacr_pac_limit'
		END
	104:  BEGIN; 'dacr_esa_ctl':  BEGIN
		yt = sat+' dacr_esa_ctl'
		name = prefix+'dacr_esa_ctl'
		END
	105:  BEGIN; 'dacr_s_ch_ctl':  BEGIN
		yt = sat+' dacr_s_ch_ctl'
		name = prefix+'dacr_s_ch_ctl'
		END
	106:  BEGIN; 'dacr_dfl_1_ctl':  BEGIN
		yt = sat+' dacr_dfl_1_ctl'
		name = prefix+'dacr_dfl_1_ctl'
		END
	107:  BEGIN; 'dacr_dfl_2_ctl':  BEGIN
		yt = sat+' dacr_dfl_2_ctl'
		name = prefix+'dacr_dfl_2_ctl'
		END
	108:  BEGIN; 'dacr_control':  BEGIN
		yt = sat+' dacr_control'
		name = prefix+'dacr_control'
		END
	109:  BEGIN; 'dacr_status':  BEGIN
		yt = sat+' dacr_status'
		name = prefix+'dacr_status'
		END
	110:  BEGIN; 'dacr_adc_lu_ctr':  BEGIN
		yt = sat+' dacr_adc_lu_ctr'
		name = prefix+'dacr_adc_lu_ctr'
		END
	111:  BEGIN; 'dacr_dfl_1_offset':  BEGIN
		yt = sat+' dacr_dfl_1_offset'
		name = prefix+'dacr_dfl_1_offset'
		END
	112:  BEGIN; 'dacr_dfl_2_offset':  BEGIN
		yt = sat+' dacr_dfl_2_offset'
		name = prefix+'dacr_dfl_2_offset'
		END
	113:  BEGIN; 'dacr_c_pac_coarse':  BEGIN
		yt = sat+' dacr_c_pac_coarse'
		name = prefix+'dacr_c_pac_coarse'
		END
	114:  BEGIN; 'dacr_c_pac_fine':  BEGIN
		yt = sat+' dacr_c_pac_fine'
		name = prefix+'dacr_c_pac_fine'
		END
	115:  BEGIN; 'dacr_c_pac_cm_fs_coarse':  BEGIN
		yt = sat+' dacr_c_pac_cm_fs_coarse'
		name = prefix+'dacr_c_pac_cm_fs_coarse'
		END
	116:  BEGIN; 'dacr_c_pac_cm_fs_fine':  BEGIN
		yt = sat+' dacr_c_pac_cm_fs_fine'
		name = prefix+'dacr_c_pac_cm_fs_fine'
		END
	117:  BEGIN; 'dacr_c_mcp_coarse':  BEGIN
		yt = sat+' dacr_c_mcp_coarse'
		name = prefix+'dacr_c_mcp_coarse'
		END
	118:  BEGIN; 'dacr_c_mcp_fine':  BEGIN
		yt = sat+' dacr_c_mcp_fine'
		name = prefix+'dacr_c_mcp_fine'
		END
	119:  BEGIN; 'dacr_c_mcp_cm_fs_coarse':  BEGIN
		yt = sat+' dacr_c_mcp_cm_fs_coarse'
		name = prefix+'dacr_c_mcp_cm_fs_coarse'
		END
	120:  BEGIN; 'dacr_c_mcp_cm_fs_fine':  BEGIN
		yt = sat+' dacr_c_mcp_cm_fs_fine'
		name = prefix+'dacr_c_mcp_cm_fs_fine'
		END
	121:  BEGIN; 'dacr_c_ssd_coarse':  BEGIN
		yt = sat+' dacr_c_ssd_coarse'
		name = prefix+'dacr_c_ssd_coarse'
		END
	122:  BEGIN; 'dacr_c_ssd_fine':  BEGIN
		yt = sat+' dacr_c_ssd_fine'
		name = prefix+'dacr_c_ssd_fine'
		END
	123:  BEGIN; 'dacr_c_esa_coarse':  BEGIN
		yt = sat+' dacr_c_esa_coarse'
		name = prefix+'dacr_c_esa_coarse'
		END
	124:  BEGIN; 'dacr_c_esa_fine':  BEGIN
		yt = sat+' dacr_c_esa_fine'
		name = prefix+'dacr_c_esa_fine'
		END
	125:  BEGIN; 'dacr_c_s_ch_coarse':  BEGIN
		yt = sat+' dacr_c_s_ch_coarse'
		name = prefix+'dacr_c_s_ch_coarse'
		END
	126:  BEGIN; 'dacr_c_s_ch_fine':  BEGIN
		yt = sat+' dacr_c_s_ch_fine'
		name = prefix+'dacr_c_s_ch_fine'
		END
	127:  BEGIN; 'dacr_c_s_ch_tap_coarse':  BEGIN
		yt = sat+' dacr_c_s_ch_tap_coarse'
		name = prefix+'dacr_c_s_ch_tap_coarse'
		END
	128:  BEGIN; 'dacr_c_s_ch_tap_fine':  BEGIN
		yt = sat+' dacr_c_s_ch_tap_fine'
		name = prefix+'dacr_c_s_ch_tap_fine'
		END
	129:  BEGIN; 'dacr_dfl_1_coarse':  BEGIN
		yt = sat+' dacr_dfl_1_coarse'
		name = prefix+'dacr_dfl_1_coarse'
		END
	130:  BEGIN; 'dacr_dfl_1_fine':  BEGIN
		yt = sat+' dacr_dfl_1_fine'
		name = prefix+'dacr_dfl_1_fine'
		END
	131:  BEGIN; 'dacr_dfl_1_dfine':  BEGIN
		yt = sat+' dacr_dfl_1_dfine'
		name = prefix+'dacr_dfl_1_dfine'
		END
	132:  BEGIN; 'dacr_dfl_2_coarse':  BEGIN
		yt = sat+' dacr_dfl_2_coarse'
		name = prefix+'dacr_dfl_2_coarse'
		END
	133:  BEGIN; 'dacr_dfl_2_fine':  BEGIN
		yt = sat+' dacr_dfl_2_fine'
		name = prefix+'dacr_dfl_2_fine'
		END
	134:  BEGIN; 'dacr_dfl_2_dfine':  BEGIN
		yt = sat+' dacr_dfl_2_dfine'
		name = prefix+'dacr_dfl_2_dfine'
		END
	135:  BEGIN; 'sw_status1':  BEGIN
		yt = sat+' sw_status1'
		name = prefix+'sw_status1'
		END
	136:  BEGIN; 'sw_hv_ramp_status':  BEGIN
		yt = sat+' sw_hv_ramp_status'
		name = prefix+'sw_hv_ramp_status'
		END
	137:  BEGIN; 'sw_hv_enable_status':  BEGIN
		yt = sat+' sw_hv_enable_status'
		name = prefix+'sw_hv_enable_status'
		END
	138:  BEGIN; 'sw_hv_limit_status':  BEGIN
		yt = sat+' sw_hv_limit_status'
		name = prefix+'sw_hv_limit_status'
		END
	139:  BEGIN; 'sw_eepromchksum':  BEGIN
		yt = sat+' sw_eepromchksum'
		name = prefix+'sw_eepromchksum'
		END
	140:  BEGIN; 'hkp_sampletime':  BEGIN
		yt = sat+' hkp_sampletime'
		name = prefix+'hkp_sampletime'
		END
	141:  BEGIN; 'pac_discharge_status':  BEGIN
		yt = sat+' pac_discharge_status'
		name = prefix+'pac_discharge_status'
		END
	142:  BEGIN; 'pac_discharge_cnt':  BEGIN
		yt = sat+' pac_discharge_cnt'
		name = prefix+'pac_discharge_cnt'
		END
	143:  BEGIN; 'pac_discharge_conseccntr':  BEGIN
		yt = sat+' pac_discharge_conseccntr'
		name = prefix+'pac_discharge_conseccntr'
		END
	144:  BEGIN; 'pac_discharge_safe_att':  BEGIN
		yt = sat+' pac_discharge_safe_att'
		name = prefix+'pac_discharge_safe_att'
		END
	145:  BEGIN; 'analog_limit_status':  BEGIN
		yt = sat+' analog_limit_status'
		name = prefix+'analog_limit_status'
		END
	146:  BEGIN; 'analog_lim_pt1_status':  BEGIN
		yt = sat+' analog_lim_pt1_status'
		name = prefix+'analog_lim_pt1_status'
		END
	147:  BEGIN; 'analog_lim_pt1_id':  BEGIN
		yt = sat+' analog_lim_pt1_id'
		name = prefix+'analog_lim_pt1_id'
		END
	148:  BEGIN; 'analog_lim_pt1_red':  BEGIN
		yt = sat+' analog_lim_pt1_red'
		name = prefix+'analog_lim_pt1_red'
		END
	149:  BEGIN; 'analog_lim_pt2_status':  BEGIN
		yt = sat+' analog_lim_pt2_status'
		name = prefix+'analog_lim_pt2_status'
		END
	150:  BEGIN; 'analog_lim_pt2_id':  BEGIN
		yt = sat+' analog_lim_pt2_id'
		name = prefix+'analog_lim_pt2_id'
		END
	151:  BEGIN; 'analog_lim_pt2_red':  BEGIN
		yt = sat+' analog_lim_pt2_red'
		name = prefix+'analog_lim_pt2_red'
		END
	152:  BEGIN; 'analog_lim_pt3_status':  BEGIN
		yt = sat+' analog_lim_pt3_status'
		name = prefix+'analog_lim_pt3_status'
		END
	153:  BEGIN; 'analog_lim_pt3_id':  BEGIN
		yt = sat+' analog_lim_pt3_id'
		name = prefix+'analog_lim_pt3_id'
		END
	154:  BEGIN; 'analog_lim_pt3_red':  BEGIN
		yt = sat+' analog_lim_pt3_red'
		name = prefix+'analog_lim_pt3_red'
		END
	155:  BEGIN; 'analog_lim_pt4_status':  BEGIN
		yt = sat+' analog_lim_pt4_status'
		name = prefix+'analog_lim_pt4_status'
		END
	156:  BEGIN; 'analog_lim_pt4_id':  BEGIN
		yt = sat+' analog_lim_pt4_id'
		name = prefix+'analog_lim_pt4_id'
		END
	157:  BEGIN; 'analog_lim_pt4_red':  BEGIN
		yt = sat+' analog_lim_pt4_red'
		name = prefix+'analog_lim_pt4_red'
		END
	158:  BEGIN; 'analog_lim_pt5_status':  BEGIN
		yt = sat+' analog_lim_pt5_status'
		name = prefix+'analog_lim_pt5_status'
		END
	159:  BEGIN; 'analog_lim_pt5_id':  BEGIN
		yt = sat+' analog_lim_pt5_id'
		name = prefix+'analog_lim_pt5_id'
		END
	160:  BEGIN; 'analog_lim_pt5_red':  BEGIN
		yt = sat+' analog_lim_pt5_red'
		name = prefix+'analog_lim_pt5_red'
		END
	161:  BEGIN; 'analog_lim_pt6_status':  BEGIN
		yt = sat+' analog_lim_pt6_status'
		name = prefix+'analog_lim_pt6_status'
		END
	162:  BEGIN; 'analog_lim_pt6_id':  BEGIN
		yt = sat+' analog_lim_pt6_id'
		name = prefix+'analog_lim_pt6_id'
		END
	163:  BEGIN; 'analog_lim_pt6_red':  BEGIN
		yt = sat+' analog_lim_pt6_red'
		name = prefix+'analog_lim_pt6_red'
		END
	164:  BEGIN; 'analog_lim_pt7_status':  BEGIN
		yt = sat+' analog_lim_pt7_status'
		name = prefix+'analog_lim_pt7_status'
		END
	165:  BEGIN; 'analog_lim_pt7_id':  BEGIN
		yt = sat+' analog_lim_pt7_id'
		name = prefix+'analog_lim_pt7_id'
		END
	166:  BEGIN; 'analog_lim_pt7_red':  BEGIN
		yt = sat+' analog_lim_pt7_red'
		name = prefix+'analog_lim_pt7_red'
		END
	167:  BEGIN; 'analog_lim_pt8_status':  BEGIN
		yt = sat+' analog_lim_pt8_status'
		name = prefix+'analog_lim_pt8_status'
		END
	168:  BEGIN; 'analog_lim_pt8_id':  BEGIN
		yt = sat+' analog_lim_pt8_id'
		name = prefix+'analog_lim_pt8_id'
		END
	169:  BEGIN; 'analog_lim_pt8_red':  BEGIN
		yt = sat+' analog_lim_pt8_red'
		name = prefix+'analog_lim_pt8_red'
		END
	170:  BEGIN; 'analog_lim_pt9_status':  BEGIN
		yt = sat+' analog_lim_pt9_status'
		name = prefix+'analog_lim_pt9_status'
		END
	171:  BEGIN; 'analog_lim_pt9_id':  BEGIN
		yt = sat+' analog_lim_pt9_id'
		name = prefix+'analog_lim_pt9_id'
		END
	172:  BEGIN; 'analog_lim_pt9_red':  BEGIN
		yt = sat+' analog_lim_pt9_red'
		name = prefix+'analog_lim_pt9_red'
		END
	173:  BEGIN; 'analog_lim_pt10_status':  BEGIN
		yt = sat+' analog_lim_pt10_status'
		name = prefix+'analog_lim_pt10_status'
		END
	174:  BEGIN; 'analog_lim_pt10_id':  BEGIN
		yt = sat+' analog_lim_pt10_id'
		name = prefix+'analog_lim_pt10_id'
		END
	175:  BEGIN; 'analog_lim_pt10_red':  BEGIN
		yt = sat+' analog_lim_pt10_red'
		name = prefix+'analog_lim_pt10_red'
		END
	176:  BEGIN; 'analog_lim_pt11_status':  BEGIN
		yt = sat+' analog_lim_pt11_status'
		name = prefix+'analog_lim_pt11_status'
		END
	177:  BEGIN; 'analog_lim_pt11_id':  BEGIN
		yt = sat+' analog_lim_pt11_id'
		name = prefix+'analog_lim_pt11_id'
		END
	178:  BEGIN; 'analog_lim_pt11_red':  BEGIN
		yt = sat+' analog_lim_pt11_red'
		name = prefix+'analog_lim_pt11_red'
		END
	179:  BEGIN; 'analog_lim_pt12_status':  BEGIN
		yt = sat+' analog_lim_pt12_status'
		name = prefix+'analog_lim_pt12_status'
		END
	180:  BEGIN; 'analog_lim_pt12_id':  BEGIN
		yt = sat+' analog_lim_pt12_id'
		name = prefix+'analog_lim_pt12_id'
		END
	181:  BEGIN; 'analog_lim_pt12_red':  BEGIN
		yt = sat+' analog_lim_pt12_red'
		name = prefix+'analog_lim_pt12_red'
		END
	182:  BEGIN; 'analog_lim_pt13_status':  BEGIN
		yt = sat+' analog_lim_pt13_status'
		name = prefix+'analog_lim_pt13_status'
		END
	183:  BEGIN; 'analog_lim_pt13_id':  BEGIN
		yt = sat+' analog_lim_pt13_id'
		name = prefix+'analog_lim_pt13_id'
		END
	184:  BEGIN; 'analog_lim_pt13_red':  BEGIN
		yt = sat+' analog_lim_pt13_red'
		name = prefix+'analog_lim_pt13_red'
		END
	185:  BEGIN; 'analog_lim_pt14_status':  BEGIN
		yt = sat+' analog_lim_pt14_status'
		name = prefix+'analog_lim_pt14_status'
		END
	186:  BEGIN; 'analog_lim_pt14_id':  BEGIN
		yt = sat+' analog_lim_pt14_id'
		name = prefix+'analog_lim_pt14_id'
		END
	187:  BEGIN; 'analog_lim_pt14_red':  BEGIN
		yt = sat+' analog_lim_pt14_red'
		name = prefix+'analog_lim_pt14_red'
		END
	188:  BEGIN; 'analog_lim_pt15_status':  BEGIN
		yt = sat+' analog_lim_pt15_status'
		name = prefix+'analog_lim_pt15_status'
		END
	189:  BEGIN; 'analog_lim_pt15_id':  BEGIN
		yt = sat+' analog_lim_pt15_id'
		name = prefix+'analog_lim_pt15_id'
		END
	190:  BEGIN; 'analog_lim_pt15_red':  BEGIN
		yt = sat+' analog_lim_pt15_red'
		name = prefix+'analog_lim_pt15_red'
		END
	191:  BEGIN; 'opmode':  BEGIN
		yt = sat+' opmode'
		name = prefix+'opmode'
		END
	192:  BEGIN; 'sw_mode':  BEGIN
		yt = sat+' sw_mode'
		name = prefix+'sw_mode'
		END
	193:  BEGIN; 'proton_mode':  BEGIN
		yt = sat+' proton_mode'
		name = prefix+'proton_mode'
		END
	194:  BEGIN; 'active_supplyid':  BEGIN
		yt = sat+' active_supplyid'
		name = prefix+'active_supplyid'
		END
	195:  BEGIN; 'supply_coarse_rb':  BEGIN
		yt = sat+' supply_coarse_rb'
		name = prefix+'supply_coarse_rb'
		END
	196:  BEGIN; 'supply_fine_rb':  BEGIN
		yt = sat+' supply_fine_rb'
		name = prefix+'supply_fine_rb'
		END
	197:  BEGIN; 'swmaint_supplystat':  BEGIN
		yt = sat+' swmaint_supplystat'
		name = prefix+'swmaint_supplystat'
		END
	198:  BEGIN; 'swmaint_pac_coarse':  BEGIN
		yt = sat+' swmaint_pac_coarse'
		name = prefix+'swmaint_pac_coarse'
		END
	199:  BEGIN; 'swmaint_pac_fine':  BEGIN
		yt = sat+' swmaint_pac_fine'		
		name = prefix+'swmaint_pac_fine'
		END

    ENDCASE
          
    options, name, 'ytitle', yt
          

ENDFOR 

END 
