;+
;PROCEDURE: set_com_mom
;PURPOSE: Set up common variables for moments variables
;    
;
;INPUT
;PARAMETERS:   none
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 01/12/07
;
;MODIFICATION HISTORY:
;    01/12/2007 Created
;    06/25/2007 Added mom_eff (plan to get rid of
;               sw_h_eff and sw_all_eff when I'm sure this is working)
;    07/24/2007 Added pri_ratio_a/b
;    09/10/2007 Added vel_groups, removed mom_eff
;-
PRO set_com_mom
compile_opt strictarrsubs
COMMON com_moment, mom_meta_a, mom_meta_b, mom_density_main_a, mom_density_main_b, mom_density_s_a, mom_density_s_b, mom_velocity_main_a, mom_velocity_main_b, mom_velocity_s_a, mom_velocity_s_b, mom_heat_flux_main_a, mom_heat_flux_main_b, mom_heat_flux_s_a, mom_heat_flux_s_b, mom_temperature_main_a, mom_temperature_main_b, mom_temperature_s_a, mom_temperature_s_b, step_var_a, step_var_b, table_norm_a, table_norm_b, geom_a, geom_b, mom_cal_start_a, mom_cal_start_b, mom_cal_stop_a, mom_cal_stop_b, doys_a, doys_b, years_a, years_b, pri_ratio_a, pri_ratio_b, ra_trig_eff_a, ra_trig_eff_b, svalid_ratrig_a, svalid_ratrig_b, vel_groups_a, vel_groups_b, swpri_ratio_a, swpri_ratio_b
; mom_meta_a/b [Emin, Emax, Schan conversion factor, Array(0=SW-all, 1=SW-H)][record]
; mom_density_m/s_a/b [record]
; mom_velocity_m/s_a/b [x,y,z][record]
; mom_heat_flux_m/s_a/b [x,y,z][record]
; mom_temperature_m/s_a/b [xx,xy,xz,,yy,yz,zz][record]
; step_var_a/b [one element for each relevant calibration file]
; table_norm_a/b [file][D,V,P,H]
; geom_a/b [file][M,S channel]
; mom_cal_start/stop_a/b [file] -- for each file, start time and stop
;                                  time (as double) -- -1=no limit
; doys_a/b -- gives day-of-year for each day in timespan, needed for ra efficience
; years_a/b -- gives years for each day in timespan
; pri_ratio_a/b [128, num_days], one ratio per day sw pri 0/ sw pri 0:3
; swpri_ratio_a/b [128, num_days], one ratio per day sum(sw_pri)/(sum(sw_pri)+sum(wap_ssd_pri))
; ra_trig_eff_a/b [file][128][esa step, Kristin velocity, table velociy,efficiency]
; svalid_ratrig_a/b [32 esa groups][num_days] -- daily ratio
; vel_groups_a/b [file][32 esa groups] -- average for each set of 4 velocities

END 
