; Lorna Ellis
; 05/11/2010
; set_bad_alpha_den_tem.pro

; This procedure checks for outliers and removes density and temperature data from
; the pri alphas.

; input  : times_st: array of times as strings
;          density : alpha density values
;          temp_k  : alpha temperature values
;          v_th    : alpha thermal vel values
;          sat     : 'A' or 'B'
;          year    : year to check (as int)
;          month   : month to check (as int)
; output : temp_k  : alpha temperature values

PRO set_bad_alpha_den_tem, times_st, density, temp_k, v_th, sat, year, month
compile_opt strictarrsubs

CASE sat OF 
    'A': BEGIN 
        CASE year OF 
            2007: BEGIN
                CASE month OF 
                    02: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-02-26/06:04:35' OR $
                                times_st EQ '2007-02-26/07:04:35' OR $
                                times_st EQ '2007-02-27/11:04:35' OR $
                                times_st EQ '2007-02-27/15:04:35', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    03: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-03-06/07:01:34' OR $
                                times_st EQ '2007-03-06/10:01:34' OR $
                                times_st EQ '2007-03-06/12:01:34' OR $
                                times_st EQ '2007-03-06/21:01:34' OR $
                                times_st EQ '2007-03-07/10:01:34' OR $
                                times_st EQ '2007-03-12/00:01:33' OR $
                                times_st EQ '2007-03-12/13:01:33' OR $
                                times_st EQ '2007-03-12/14:01:33' OR $
                                times_st EQ '2007-03-12/16:01:33' OR $
                                times_st EQ '2007-03-12/22:01:33' OR $
                                times_st EQ '2007-03-25/06:01:30' OR $
                                times_st EQ '2007-03-25/21:01:30' OR $
                                times_st EQ '2007-03-27/09:01:29' OR $
                                times_st EQ '2007-03-27/20:01:29' OR $
                                times_st EQ '2007-03-28/00:01:29' OR $
                                times_st EQ '2007-03-30/04:01:29', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    04: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-04-01/04:01:28' OR $
                                times_st EQ '2007-04-01/09:01:28' OR $
                                times_st EQ '2007-04-01/19:01:28' OR $
                                times_st EQ '2007-04-01/20:01:28' OR $
                                times_st EQ '2007-04-02/07:01:28' OR $
                                times_st EQ '2007-04-02/09:01:28' OR $
                                times_st EQ '2007-04-10/16:03:26' OR $
                                times_st EQ '2007-04-22/17:02:26' OR $
                                times_st EQ '2007-04-22/18:02:26' OR $
                                times_st EQ '2007-04-22/19:02:26' OR $
                                times_st EQ '2007-04-24/23:02:25' OR $
                                times_st EQ '2007-04-27/17:03:25', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                       ENDIF 
                    END 
                    05: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-05-07/15:03:23' OR $
                                times_st EQ '2007-05-07/17:03:23' OR $
                                times_st EQ '2007-05-07/18:03:23' OR $
                                times_st EQ '2007-05-07/19:03:23' OR $
                                times_st EQ '2007-05-07/20:03:23' OR $
                                times_st EQ '2007-05-07/21:03:23' OR $
                                times_st EQ '2007-05-07/23:03:23' OR $
                                times_st EQ '2007-05-08/01:03:23' OR $
                                times_st EQ '2007-05-08/06:03:23' OR $
                                times_st EQ '2007-05-08/07:03:23' OR $
                                times_st EQ '2007-05-08/14:03:23' OR $
                                times_st EQ '2007-05-08/18:03:23' OR $
                                times_st EQ '2007-05-08/19:03:23' OR $
                                times_st EQ '2007-05-18/16:03:21' OR $
                                times_st EQ '2007-05-18/17:03:21' OR $
                                times_st EQ '2007-05-18/18:03:21' OR $
                                times_st EQ '2007-05-22/03:03:21' OR $
                                times_st EQ '2007-05-24/14:00:21' OR $
                                times_st EQ '2007-05-24/16:00:21' OR $
                                times_st EQ '2007-05-24/17:00:21', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    06: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-06-04/17:00:20' OR $
                                times_st EQ '2007-06-04/18:00:20' OR $
                                times_st EQ '2007-06-04/19:00:20' OR $
                                times_st EQ '2007-06-04/20:00:20' OR $
                                times_st EQ '2007-06-08/12:00:20' OR $
                                times_st EQ '2007-06-10/00:00:19' OR $
                                times_st EQ '2007-06-10/01:00:19' OR $
                                times_st EQ '2007-06-10/02:00:19' OR $
                                times_st EQ '2007-06-10/08:00:19' OR $
                                times_st EQ '2007-06-10/10:00:19' OR $
                                times_st EQ '2007-06-10/12:00:19' OR $
                                times_st EQ '2007-06-14/15:00:18' OR $
                                times_st EQ '2007-06-15/00:00:18' OR $
                                times_st EQ '2007-06-15/01:00:18' OR $
                                times_st EQ '2007-06-15/02:00:18' OR $
                                times_st EQ '2007-06-15/03:00:18' OR $
                                times_st EQ '2007-06-30/09:04:55' OR $
                                times_st EQ '2007-06-30/10:04:55' OR $
                                times_st EQ '2007-06-30/11:04:55' OR $
                                times_st EQ '2007-06-30/14:04:55' OR $
                                times_st EQ '2007-06-30/15:04:55' OR $
                                times_st EQ '2007-06-30/16:04:55', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    07: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-07-04/13:04:55' OR $
                                times_st EQ '2007-07-04/14:04:55' OR $
                                times_st EQ '2007-07-04/17:04:55' OR $
                                times_st EQ '2007-07-04/18:04:55' OR $
                                times_st EQ '2007-07-11/13:01:54' OR $
                                times_st EQ '2007-07-11/15:01:54' OR $
                                times_st EQ '2007-07-11/16:01:54' OR $
                                times_st EQ '2007-07-11/17:01:54' OR $
                                times_st EQ '2007-07-11/18:01:54' OR $
                                times_st EQ '2007-07-11/19:01:54' OR $
                                times_st EQ '2007-07-11/20:01:54' OR $
                                times_st EQ '2007-07-15/04:01:54' OR $
                                times_st EQ '2007-07-15/07:01:54' OR $
                                times_st EQ '2007-07-22/00:01:53' OR $
                                times_st EQ '2007-07-29/12:01:52' OR $
                                times_st EQ '2007-07-29/13:01:52' OR $
                                times_st EQ '2007-07-29/14:01:52' OR $
                                times_st EQ '2007-07-29/15:01:52', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    08: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-08-01/00:01:51' OR $
                                times_st EQ '2007-08-01/01:01:51' OR $
                                times_st EQ '2007-08-07/07:01:50' OR $
                                times_st EQ '2007-08-07/08:01:50' OR $
                                times_st EQ '2007-08-07/09:01:50' OR $
                                times_st EQ '2007-08-11/08:01:49' OR $
                                times_st EQ '2007-08-26/19:03:48' OR $
                                times_st EQ '2007-08-26/20:03:48' OR $
                                times_st EQ '2007-08-26/21:03:48' OR $
                                times_st EQ '2007-08-27/08:03:48' OR $
                                times_st EQ '2007-08-27/11:03:48' OR $
                                times_st EQ '2007-08-27/16:03:48', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    09: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-09-02/17:03:47' OR $
                                times_st EQ '2007-09-03/04:03:47' OR $
                                times_st EQ '2007-09-03/05:03:47' OR $
                                times_st EQ '2007-09-03/07:03:47' OR $
                                times_st EQ '2007-09-03/08:03:47' OR $
                                times_st EQ '2007-09-03/09:03:47' OR $
                                times_st EQ '2007-09-03/10:03:47' OR $
                                times_st EQ '2007-09-07/21:03:46' OR $
                                times_st EQ '2007-09-15/08:03:45' OR $
                                times_st EQ '2007-09-15/09:03:45' OR $
                                times_st EQ '2007-09-15/10:03:45' OR $
                                times_st EQ '2007-09-15/11:03:45' OR $
                                times_st EQ '2007-09-15/12:03:45' OR $
                                times_st EQ '2007-09-15/13:03:45' OR $
                                times_st EQ '2007-09-15/14:03:45' OR $
                                times_st EQ '2007-09-15/15:03:45' OR $
                                times_st EQ '2007-09-21/23:03:44' OR $
                                times_st EQ '2007-09-22/00:03:44' OR $
                                times_st EQ '2007-09-23/03:03:44' OR $
                                times_st EQ '2007-09-23/05:03:44' OR $
                                times_st EQ '2007-09-23/06:03:44' OR $
                                times_st EQ '2007-09-23/09:03:44' OR $
                                times_st EQ '2007-09-23/10:03:44' OR $
                                times_st EQ '2007-09-29/20:00:43' OR $
                                times_st EQ '2007-09-30/00:00:43' OR $
                                times_st EQ '2007-09-30/04:00:43' OR $
                                times_st EQ '2007-09-30/09:00:43', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    10: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-10-19/02:02:40' OR $
                                times_st EQ '2007-10-19/03:02:40' OR $
                                times_st EQ '2007-10-25/23:02:38' OR $
                                times_st EQ '2007-10-26/02:02:38' OR $
                                times_st EQ '2007-10-26/03:02:38', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    11: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-11-11/02:00:37' OR $
                                times_st EQ '2007-11-11/03:00:37' OR $
                                times_st EQ '2007-11-11/04:00:37' OR $
                                times_st EQ '2007-11-11/09:00:37' OR $
                                times_st EQ '2007-11-14/10:00:36' OR $
                                times_st EQ '2007-11-14/11:00:36' OR $
                                times_st EQ '2007-11-14/12:00:36' OR $
                                times_st EQ '2007-11-14/13:00:36' OR $
                                times_st EQ '2007-11-14/14:00:36' OR $
                                times_st EQ '2007-11-14/15:00:36' OR $
                                times_st EQ '2007-11-21/04:00:36' OR $
                                times_st EQ '2007-11-21/05:00:36' OR $
                                times_st EQ '2007-11-21/06:00:36' OR $
                                times_st EQ '2007-11-21/07:00:36' OR $
                                times_st EQ '2007-11-21/08:00:36' OR $
                                times_st EQ '2007-11-21/09:00:36' OR $
                                times_st EQ '2007-11-21/10:00:36', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    12: BEGIN 
                        bad_i = where($
                                times_st EQ '2007-12-12/17:00:31' OR $
                                times_st EQ '2007-12-12/19:00:31' OR $
                                times_st EQ '2007-12-12/20:00:31' OR $
                                times_st EQ '2007-12-13/00:00:31' OR $
                                times_st EQ '2007-12-13/02:00:31' OR $
                                times_st EQ '2007-12-19/00:00:30' OR $
                                times_st EQ '2007-12-19/01:00:30', $
                                bad_count)
                        IF bad_count GT 0 THEN BEGIN 
                            density[bad_i] = !values.f_nan
                            temp_k [bad_i] = !values.f_nan
                            v_th   [bad_i] = !values.f_nan
                        ENDIF 
                    END 
                    ELSE: stop  ; invalid
                ENDCASE
            END 
            ELSE: dummy = dummy ; none set past 2007 yet
        ENDCASE
    END
    ELSE: dummy = dummy ; none set for B yet
ENDCASE 
END 
