;+
;PROCEDURE: replace_mon_norm_overflow
;PURPOSE:  Replace any empty values (as shown by NaN) with the average
; of the surrounding valid values (from surrounding esas).
;
;INPUT
;PARAMETERS: data :  array of data values [time, 32]
;
;OUTPUT
;PARAMETERS: data :  array of data values [time, 32] -- modified by program
;
;CREATED BY: L. Ellis
;
;MODIFICATION HISTORY:
;    11/07/2008: LBE: Created by copying Marissa's code from svalid_ratrig_ratio.pro.
;-

PRO replace_mon_norm_overflow, data
compile_opt strictarrsubs

bad_i = where(finite(data) EQ 0, bad_count)
IF bad_count GT 0 THEN BEGIN 
    new_bad_i = array_indices(data, bad_i)
    new_bad_i_sz = SIZE(new_bad_i, /DIMENSIONS)
    FOR ii = 0, bad_count-1 DO BEGIN
   
        IF new_bad_i[1, ii] EQ 31 THEN BEGIN ; end case 
                      
            jj = new_bad_i[1, ii]
            kk = 31 
            z = 1 
            WHILE ( jj EQ kk ) DO BEGIN
              IF (ii - z) LT 0 THEN BEGIN
                kk--
                BREAK
              ENDIF
              IF new_bad_i[0, ii] EQ new_bad_i[0, (ii - z)] THEN BEGIN
                jj = new_bad_i[1, (ii - z)]
                kk--
              ENDIF
              z++
            ENDWHILE            
            IF kk LT 0 THEN BEGIN
              data[bad_i[ii]]  = !values.f_nan 
            ENDIF ELSE data[bad_i[ii]] = data[new_bad_i[0, ii], kk]       
            
        ENDIF ELSE IF new_bad_i[1, ii] EQ 0 THEN BEGIN ; end case
        
            jj = new_bad_i[1, ii]
            kk = 0  
            z = 1   
            IF bad_count EQ 1 THEN BEGIN
              data[bad_i[ii]] = data[new_bad_i[0, ii], 1]
            ENDIF ELSE BEGIN    
              WHILE ( jj EQ kk ) DO BEGIN
                IF (ii + z) GT (new_bad_i_sz(1)-1) THEN BEGIN
                  kk++
                  BREAK
                ENDIF
                IF new_bad_i[0, ii] EQ new_bad_i[0, (ii + z)] THEN BEGIN
                  jj = new_bad_i[1, (ii + z)]
                  kk++
                ENDIF
                z++
              ENDWHILE            
              IF kk GT 31 THEN BEGIN
                data[bad_i[ii]]  = !values.f_nan    
              ENDIF ELSE data[bad_i[ii]] = data[new_bad_i[0, ii], kk]   
            ENDELSE         
            
        ENDIF ELSE BEGIN ; middle case -- need to average
            a = -1 ;will be the first good data value after the overflow
            b = -1 ;will be the first good data value before the overflow
                       
            ;check before
            jj = new_bad_i[1, ii]
            kk = new_bad_i[1, ii] 
            z = 1        
            WHILE ( jj EQ kk ) DO BEGIN
              IF (ii - z) LT 0 THEN BEGIN
                kk--
                BREAK 
              ENDIF
              IF new_bad_i[0, ii] EQ new_bad_i[0, (ii - z)] THEN BEGIN
                jj = new_bad_i[1, (ii - z)]
                kk--
              ENDIF
              z++
            ENDWHILE                      
            IF kk LT 0 THEN BEGIN
              b = -1
            ENDIF ELSE b = data[new_bad_i[0, ii], kk]
                     
            ; check after
            jj = new_bad_i[1, ii]
            kk = new_bad_i[1, ii]
            z = 1 
            IF bad_count EQ 1 THEN BEGIN
              a = data[new_bad_i[0, ii], (kk+1)]
            ENDIF ELSE BEGIN
              WHILE ( jj EQ kk ) DO BEGIN
                IF (ii + z) GT (new_bad_i_sz(1)-1) THEN BEGIN
                  kk++
                  BREAK
                ENDIF
                IF new_bad_i[0, ii] EQ new_bad_i[0, (ii + z)] THEN BEGIN
                  jj = new_bad_i[1, (ii + z)]
                  kk++             
                ENDIF
                z++
              ENDWHILE           
              IF kk GT 31 THEN BEGIN
                a = -1
              ENDIF ELSE a = data[new_bad_i[0, ii], kk]
            ENDELSE
                                       
            IF a NE -1 AND b NE -1 THEN data[bad_i[ii]] = (a+b)/2
            IF a EQ -1 AND b NE -1 THEN data[bad_i[ii]] = b
            IF a NE -1 AND b EQ -1 THEN data[bad_i[ii]] = a
            IF a EQ -1 AND b EQ -1 THEN data[bad_i[ii]] = !values.f_nan
                      
            a = -1 
            b = -1
        ENDELSE 
    ENDFOR
ENDIF 

END 
