; Lorna Ellis
; 09/26/2007
; read_ratios.pro

; This procedure reads in the necessary calibration ratios. It reads
; all days of specified years.

; 05/26/2009 Put in splat environment. Change input parameters.

PRO read_ratios, sat, year, svalid_ratio, pri0_ratio
compile_opt strictarrsubs

line = ' '
svalid_ratio = fltarr(366,  32) ;  32 energy groups
pri0_ratio   = fltarr(366, 128) ; 128 energy steps

calibration_path = getenv('PLACAL')

    ; read s_valid/ra_trig ratio (32 for each day -- based on energy)
ii = 0
cal_file = 'ST'+sat+'_svalid_ratrig_ratio_'+string(year, format = '(I4.4)')+'.tab'
cal_path = calibration_path+cal_file
openr, cal_lun, cal_path, /get_lun
readf, cal_lun, line
readf, cal_lun, line
readf, cal_lun, line            ; 3 header lines
finished_year = 0
missing_doy = 0
WHILE ii LT 367 AND finished_year EQ 0 DO BEGIN 
    IF missing_doy EQ 0 THEN BEGIN 
        IF eof(cal_lun) EQ 0 THEN BEGIN 
            readf, cal_lun, line
            parts = strsplit(line, /extract)
            temp_year = fix(parts[0])
            temp_doy = fix(parts[1])
        ENDIF ELSE finished_year = 1
    ENDIF 
    IF temp_year NE year THEN printf, log_lun, 'Error in read_ratios: wrong year for svalid/ratrig' $
    ELSE IF temp_year EQ year AND temp_doy LT ii+1 THEN dummy = 0 $ ; not yet at right day
         ELSE IF temp_year EQ year AND temp_doy EQ ii+1 THEN BEGIN ; found it!
        FOR jj = 0, 31 DO BEGIN
            svalid_ratio[ii, jj] = float(parts[2+jj])
        ENDFOR 
        ii = ii+1
        missing_doy = 0
    ENDIF ELSE BEGIN
        ii = ii+1
        missing_doy = 1
    ENDELSE 
ENDWHILE 
close, cal_lun
free_lun, cal_lun

    ; read sw pri 0/sw pri 0:3 ratio (128 for each day -- based on energy)
ii = 0
cal_file = 'ST'+sat+'_pri_ratio_'+string(year, format = '(I4.4)')+'.tab'
cal_path = calibration_path+cal_file
openr, cal_lun, cal_path, /get_lun
readf, cal_lun, line
readf, cal_lun, line            ; 2 header lines
finished_year = 0
missing_day = 0
WHILE ii LT 367 AND finished_year EQ 0 DO BEGIN 
    IF missing_doy EQ 0 THEN BEGIN 
        IF eof(cal_lun) EQ 0 THEN BEGIN 
            readf, cal_lun, line
            parts = strsplit(line, /extract)
            temp_year = fix(parts[0])
            temp_doy = fix(parts[1])
        ENDIF ELSE finished_year = 1
    ENDIF 
    IF temp_year LT year THEN printf, log_lun, 'Error in read_ratios: wrong year for pri 0 ratio' $
    ELSE IF temp_year EQ year AND temp_doy LT ii+1 THEN dummy = 0 $ ; not yet at right day
         ELSE IF temp_year EQ year AND temp_doy EQ ii+1 THEN BEGIN ; found it!
        FOR jj = 0, 127 DO BEGIN
            pri0_ratio[ii, jj] = float(parts[2+jj])
        ENDFOR 
        ii = ii+1
        missing_day = 0
    ENDIF ELSE BEGIN
        ii = ii+1
        missing_day = 1
    ENDELSE 
ENDWHILE 
close, cal_lun
free_lun, cal_lun

END 
