;+
;PROCEDURE: plot_set_mon_ps
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 10/13/2006
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;    04/16/2008 LBE: Added slash to filename. Changed conversion to.png.
;    07/06/2009 LBE: Changed .0 to -0 for use on guam instead of maui.
;    12/11/2013 LBE: Change to make 2 separate files (due to new version of convert)
;-
PRO plot_set_mon_ps, prod_mon, num_files_a, num_files_b, E_step, HZ,sat, time
compile_opt strictarrsubs

COMMON tplot_com1
COMMON share1_mon
COMMON com_mon

prefix_a = 'A_Monitor_Rate_'
prefix_b = 'B_Monitor_Rate_'
fm = ' '

IF (sat EQ 'A') THEN fm = 'A_'
IF (sat EQ 'B') THEN fm = 'B_'

tplot_options,'title',sat+' (black:35-40 keV/q, red:4.3-5 keV/q, green:1.35-1.5 keV/q)'
tplot_options,'ymargin',[6,6]

; Get the time associated with the first file to label plots
; and out put files

start_year=' '
start_month=' '
start_day=' '
start_year=strmid(time,0,4)
start_month=strmid(time,5,2)
start_day=strmid(time,8,2)

;  0 black
; 50 blue
;100 cyan
;150 green
;200 orange
;250 red
;255 white

options, fm+'sf0_sci',     'charthick', 4
options, fm+'sfr0_sci',    'charthick', 4
options, fm+'stp0_sci',    'charthick', 4
options, fm+'stop0_sci',   'charthick', 4
options, fm+'ra_trig_sci', 'charthick', 4
options, fm+'ssd_sw_sci',  'charthick', 4
options, fm+'sf2_sci',     'charthick', 4
options, fm+'sfr2_sci',    'charthick', 4
options, fm+'stp2_sci',    'charthick', 4
options, fm+'stop2_sci',   'charthick', 4
options, fm+'pos2_sci',    'charthick', 4
options, fm+'pos3_sci',    'charthick', 4
options, fm+'sf0_sci',     'thick', 4
options, fm+'sfr0_sci',    'thick', 4
options, fm+'stp0_sci',    'thick', 4
options, fm+'stop0_sci',   'thick', 4
options, fm+'ra_trig_sci', 'thick', 4
options, fm+'ssd_sw_sci',  'thick', 4
options, fm+'sf2_sci',     'thick', 4
options, fm+'sfr2_sci',    'thick', 4
options, fm+'stp2_sci',    'thick', 4
options, fm+'stop2_sci',   'thick', 4
options, fm+'pos2_sci',    'thick', 4
options, fm+'pos3_sci',    'thick', 4
options, fm+'sf0_sci',     'xthick', 4
options, fm+'sfr0_sci',    'xthick', 4
options, fm+'stp0_sci',    'xthick', 4
options, fm+'stop0_sci',   'xthick', 4
options, fm+'ra_trig_sci', 'xthick', 4
options, fm+'ssd_sw_sci',  'xthick', 4
options, fm+'sf2_sci',     'xthick', 4
options, fm+'sfr2_sci',    'xthick', 4
options, fm+'stp2_sci',    'xthick', 4
options, fm+'stop2_sci',   'xthick', 4
options, fm+'pos2_sci',    'xthick', 4
options, fm+'pos3_sci',    'xthick', 4 
options, fm+'sf0_sci',     'ythick', 4
options, fm+'sfr0_sci',    'ythick', 4
options, fm+'stp0_sci',    'ythick', 4
options, fm+'stop0_sci',   'ythick', 4
options, fm+'ra_trig_sci', 'ythick', 4
options, fm+'ssd_sw_sci',  'ythick', 4
options, fm+'sf2_sci',     'ythick', 4
options, fm+'sfr2_sci',    'ythick', 4
options, fm+'stp2_sci',    'ythick', 4
options, fm+'stop2_sci',   'ythick', 4
options, fm+'pos2_sci',    'ythick', 4
options, fm+'pos3_sci',    'ythick', 4

; SSD 
ThisDevice = !D.Name
SET_PLOT,'PS'
base = getenv('OUT_DIR')+'/'+sat+'_'+start_year+'_'+start_month+'_'+start_day+'_rates_v2_ssd_side'
filename = base+'.ps'
DEVICE, FILENAME = filename, XSIZE=8.5, YSIZE =11.0, /INCHES, $
/COLOR, Bits_Per_Pixel = 8, PORTRAIT = 1, XOFFSET = 0.25, YOFFSET = 0
LOADCT, 39, NCOLORS=256
tplot,[fm+'sf0_sci',fm+'sfr0_sci',fm+'stp0_sci',fm+'stop0_sci',fm+'ra_trig_sci',fm+'ssd_sw_sci']
CASE sat OF
    'A': IF (TOTAL(error5_mon_a, /NAN) GT 0) THEN tplot, ['A_error5_mon']
    'B': IF (TOTAL(error5_mon_b, /NAN) GT 0) THEN tplot, ['B_error5_mon']
ENDCASE
DEVICE,/Close_File
SET_PLOT,ThisDevice
command_string = 'convert -flatten -density 288 -geometry 25% -sharpen 3 '+base + '.ps ' + base+'.png'
spawn, command_string
command_string = 'rm -f ' + base+'.ps'
spawn, command_string 

; Non-SSD 
ThisDevice = !D.Name
SET_PLOT,'PS'
base = getenv('OUT_DIR')+'/'+sat+'_'+start_year+'_'+start_month+'_'+start_day+'_rates_v2_nossd_side'
filename = base+'.ps'
DEVICE, FILENAME = filename, XSIZE=8.5, YSIZE =11.0, /INCHES, $
/COLOR, Bits_Per_Pixel = 8, PORTRAIT = 1, XOFFSET = 0.25, YOFFSET = 0
LOADCT, 39, NCOLORS=256
tplot_options,'ymargin',[6,6]
tplot,[fm+'sf2_sci',fm+'sfr2_sci',fm+'stp2_sci',fm+'stop2_sci',fm+'pos2_sci',fm+'pos3_sci']
CASE sat OF
    'A': IF (TOTAL(error5_mon_a, /NAN) GT 0) THEN tplot, ['A_error5_mon']
    'B': IF (TOTAL(error5_mon_b, /NAN) GT 0) THEN tplot, ['B_error5_mon']
ENDCASE
DEVICE,/Close_File
SET_PLOT,ThisDevice
command_string = 'convert -flatten -density 288 -geometry 25% -sharpen 3 '+base + '.ps ' + base+'.png'
spawn, command_string
command_string = 'rm -f ' + base+'.ps'
spawn, command_string 

END 
