;+
;PROCEDURE: plot_sc_hk
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;	3 July, 2007	calls share1_mon variables
;-
PRO plot_sc_hk, sat_sc_hk, num_files_a, num_files_b, sat
compile_opt strictarrsubs

LOADCT, 39, NCOLORS=256
!P.BACKGROUND = 255

COMMON tplot_com1
COMMON share1_mon
prefix_a = 'SC_HK_'
prefix_b = 'SC_HK_'
prod = ' '

FOR ii = 0, n_elements(sat_sc_hk)-1 DO BEGIN 
CASE sat_sc_hk(ii) OF
	
	1: prod = 'pl_ebox_tmp'
	2: prod = 'pl_inst_msg_pwr_dwn_req'
	3: prod = 'pl_pwr_cur'
	4: prod = 'pl_pwr_tt'
	5: prod = 'pl_surv_pwr_cur'
	6: prod = 'pl_surv_pwr_tt'
	7: prod = 'pl_tof_tmp'
	8: prod = 'pl_pwr_vt'
	9: prod = 'pl_surv_pwr_vt'

		ENDCASE


    IF sat EQ 'A' THEN prefix = prefix_a ELSE prefix = prefix_b
    temp_prod = prod
    IF n_elements(names) EQ 0 THEN names = [prefix+temp_prod] ELSE names = [names, prefix+temp_prod]
ENDFOR

options,'SC_HK_pl_ebox_tmp','ytitle','pl_ebox_tmp [deg C]'
ylim, 'SC_HK_pl_ebox_tmp',-20,20,0
options,'SC_HK_pl_ebox_tmp','panel_size',2
options,'SC_HK_pl_pwr_cur','ytitle','pl_pwr_cur [Amps]'
options,'SC_HK_pl_pwr_cur','panel_size',2
options,'SC_HK_pl_surv_pwr_cur','ytitle','pl_surv_pwr_cur [Amps]'
options,'SC_HK_pl_surv_pwr_cur','panel_size',2
options,'SC_HK_pl_tof_tmp','ytitle','pl_tof_tmp [deg C]'
ylim, 'SC_HK_pl_tof_tmp',-20,20,0
options,'SC_HK_pl_tof_tmp','panel_size',2
options,'SC_HK_pl_pwr_vt','ytitle','pl_pwr_vt [Volts]'
options,'SC_HK_pl_pwr_vt','panel_size',2
options,'SC_HK_pl_surv_pwr_vt','ytitle','pl_surv_pwr_vt [Volts]'
options,'SC_HK_pl_surv_pwr_vt','panel_size',2


tplot_options,'color',0
tplot_options,'psym',2
tplot_options,'symsize',0.5
tplot_options,'title', sat+' Spacecraft Housekeeping'
IF n_elements(names) GT 0 THEN tplot, names

!P.BACKGROUND = 0
tplot_options, 'color',255

END 
