;+
;PROCEDURE: plot_moments
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 10/13/2006
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;    12/18/2015 Updated
;-
PRO plot_moments, prod, num_files_a, num_files_b
compile_opt strictarrsubs
COMMON tplot_com1
COMMON share1
FOR ii = 0, n_elements(prod)-1 DO BEGIN 
    IF strmid(prod[ii], 0, 1) EQ 'A' THEN sat = 'A' ELSE sat = 'B'
    temp_prod = strmid(prod[ii], 2, strlen(prod[ii])-2)
    CASE temp_prod OF 
        'D'      : temp_name = sat+'_obmom_density'
        'VX'     : temp_name = sat+'_obmom_vx_inst'
        'VY'     : temp_name = sat+'_obmom_vy_inst'
        'VZ'     : temp_name = sat+'_obmom_vz_inst'
        'VT'     : temp_name = sat+'_obmom_bulk_speed_inst'
        'TXX'    : temp_name = sat+'_obmom_temperature_xx_inst'
        'TYY'    : temp_name = sat+'_obmom_temperature_yy_inst'
        'TZZ'    : temp_name = sat+'_obmom_temperature_zz_inst'
        'PXX'    : temp_name = sat+'_obmom_pressure_xx_inst'
        'PYY'    : temp_name = sat+'_obmom_pressure_yy_inst'
        'PZZ'    : temp_name = sat+'_obmom_pressure_zz_inst'
        ELSE: print, 'product not found in plot_moments'
    ENDCASE
    IF n_elements(names) EQ 0 THEN names = [temp_name] ELSE names = [names, temp_name]
ENDFOR
IF n_elements(names) GT 0 THEN tplot, names
END 
