;
;PROCEDURE: plot_hk_ps_daily
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;
;CREATED BY: L. Ellis (plot_moments)
;
;LAST MODIFICATION: 01/18/2007
;
;MODIFICATION HISTORY:
;    10/13/2006 Created
;	November  2006:  K. Simunac modifies for analog housekeeping
;	18 Jan,   2007	prefixes modified for sat A and sat B
;       21 July   2007  Revised to print 4 files to fiji (LBE)
;       05 August 2007  Added line to clear title before starting (LBE)
;       11 May    2009  Made titles multi-line (LBE)
;       20 May    2009  Added blank popen to make lines darker (LBE)
;       29 April  2013  Updeated limits (LBE)
;       18 Dec.   2014  Change limit for dfl_cmdc (LBE)
;-
PRO plot_hk_ps_daily_20141217, sat_hk, num_files_a, num_files_b, sat
compile_opt strictarrsubs

tplot_options, 'title', ' ' ; remove old title
;filename = getenv('OUT_DIR')+'daily_analog_hk.ps'
get_timespan, time
ts = time_struct(time)
fileprefix = 'ST'+sat+'_PLA_hk_'+string(ts[0].year, format = '(I4.4)')+string(ts[0].month, format = '(I2.2)')+$
           string(ts[0].date, format = '(I2.2)')+'_'
filesuffix = ['LVC', 'ESA_DFL_SCHAN', 'PAC_MCP_SSD', 'Temps']


COMMON tplot_com1
COMMON share1_mon
prefix_a = 'STA_Analog_HK_'
prefix_b = 'STB_Analog_HK_'

set_plot, 'PS'
popen, 'temp.ps'
pclose

IF sat EQ 'A' THEN prefix = prefix_a ELSE prefix = prefix_b

store_data, 'LVC_voltages', data = [prefix+'lvc_+12v', prefix+'lvc_-12v', $
					prefix+'lvc_+5v',prefix+'lvc_-5v', prefix+'lvc_+2.5v_a',prefix+'lvc_+2.5v_b']
options, 'LVC_voltages','title', 'LVC (black +12V/red -12V/purple +5V/orange -5V/green +2.5Va/cyan +2.5Vb)'
options, 'LVC_voltages','ytitle', sat+'!C!CLVC Voltages!C!C[V]'
ylim, 'LVC_voltages',-15,15,0
options, 'LVC_voltages','panel_size',2
options, 'LVC_voltages', 'xticklen', .05
options, 'LVC_voltages', /noclip

store_data, 'LVC_1', data = ['empty',prefix+'lvc_+12v_imon']
options, 'LVC_1', 'ytitle', sat+'!C!CLVC +12v!C!C[mA]'
;ylim,    'LVC_1',  0, 600, 0
ylim,    'LVC_1',  350, 500, 0 ; lbe
options, 'LVC_1', 'yticks', 3
options, 'LVC_1', 'yminor', 3
options, 'LVC_1', 'xticklen', .05
options, 'LVC_1', /noclip

store_data, 'LVC_2', data = ['empty',prefix+'lvc_-12v_imon']
options, 'LVC_2', 'ytitle', sat+'!C!CLVC -12v!C!C[mA]'
;ylim,    'LVC_2',  0,600,0
ylim,    'LVC_2',  60, 70,0 ; lbe
options, 'LVC_2', 'yticks', 3
options, 'LVC_2', 'yminor', 3
options, 'LVC_2', 'xticklen', .05
options, 'LVC_2', /noclip

store_data, 'LVC_3', data = ['empty',prefix+'lvc_+5v_imon']
options, 'LVC_3', 'ytitle', sat+'!C!CLVC +5v!C!C[mA]'
;ylim,    'LVC_3',  0,600
ylim,    'LVC_3',  200, 450, 0 ; lbe
options, 'LVC_3', 'yticks', 3
options, 'LVC_3', 'yminor', 3
options, 'LVC_3', 'xticklen', .05
options, 'LVC_3', /noclip

store_data, 'LVC_4', data = ['empty', prefix+'lvc_-5v_imon']
options, 'LVC_4', 'ytitle',sat+'!C!CLVC -5v!C!C[mA]'
ylim,    'LVC_4',  75,90, 0 ; lbe
;ylim,    'LVC_4',  0,600,0
options, 'LVC_4', 'yticks', 3
options, 'LVC_4', 'yminor', 3
options, 'LVC_4', 'xticklen', .05
options, 'LVC_4', /noclip

store_data, 'LVC_5',data = ['empty',prefix+'lvc_+2.5v_a_imon']
options, 'LVC_5', 'ytitle',sat+'!C!CLVC +2.5_a!C!C[mA]'
ylim,    'LVC_5',  280,300,0 ; lbe
options, 'LVC_5', 'yticks', 3
options, 'LVC_5', 'yminor', 3
options, 'LVC_5', 'xticklen', .05
options, 'LVC_5', /noclip

store_data, 'LVC_6',data= ['empty', prefix+'lvc_+2.5v_b_imon']
options, 'LVC_6', 'ytitle',sat+'!C!CLVC +2.5_b!C!C[mA]'
ylim,    'LVC_6',  300,320,0 ; lbe
options, 'LVC_6', 'yticks', 3
options, 'LVC_6', 'yminor', 3
options, 'LVC_6', 'xticklen', .05
options, 'LVC_6', /noclip

store_data, 'ESA_voltages', data = [prefix+'esa_vm_pos',prefix+'esa_vm_neg']
options, 'ESA_voltages','title','ESA (black +, red -), DFL(black 1, green 2), and S Channel'
options,'ESA_voltages','ytitle', sat+'!C!CESA Voltages!C!C[V]'
options,'ESA_voltages','panel_size',2
ylim, 'ESA_voltages',-6000, 6000, 0
;ylim, 'ESA_voltages',-10000,10000,0 ; lbe
options, 'ESA_voltages', 'xticklen', .05
options, 'ESA_voltages', /noclip

options, prefix+'esa_cm_dc', 'ytitle', sat+'!C!CESA CM DC!C!C[mA]!C!C'
ylim, prefix+'esa_cm_dc', 0, 100, 0
options, prefix+'esa_cm_dc', 'xticklen', .05
options, prefix+'esa_cm_dc', /noclip

store_data, 'DFL_vm', data = [prefix+'dfl_1_vm',prefix+'dfl_2_vm']
options, 'DFL_vm', 'ytitle',sat+'!C!CDFL Vm!C!C[V]!C'
ylim, 'DFL_vm',10,10000,1
options, 'DFL_vm','panel_size',2
options, 'DFL_vm', 'xticklen', .05
options, 'DFL_vm', /noclip

store_data, 'DFL_tap', data=[prefix+'dfl_1_tap',prefix+'dfl_2_tap']
options,'DFL_tap','ytitle',sat+'!C!CDFL Tap!C!C[V]!C'
ylim,'DFL_tap',10,10000,1
options,'DFL_tap','panel_size',2
options, 'DFL_tap', 'xticklen', .05
options, 'DFL_tap', /noclip

store_data, 'DFL_cmdc', data = [prefix+'dfl_1_cm_dc', prefix+'dfl_2_cm_dc']
options,'DFL_cmdc','ytitle',sat+'!C!CDFL CM_DC!C!C[mA]!C!C!C'
ylim, 'DFL_cmdc',0,20,0
options,'DFL_cmdc','panel_size',2
options, 'DFL_cmdc', 'xticklen', .05
options, 'DFL_cmdc', /noclip

options, prefix+'s_ch_vm', 'ytitle', sat+'!C!CS ch VM!C!C[V]!C!C'
ylim, prefix+'s_ch_vm', -5, 10, 0
options, prefix+'s_ch_vm', 'xticklen', .05
options, prefix+'s_ch_vm', /noclip

options, prefix+'s_ch_vm_tap', 'ytitle', sat+'!C!CS ch VM tap!C!C[V]!C!C'
ylim, prefix+'s_ch_vm_tap', 0, 15, 0
options, prefix+'s_ch_vm_tap', 'xticklen', .05
options, prefix+'s_ch_vm_tap', /noclip

options, prefix+'s_ch_cm_dc', 'ytitle', sat+'!C!CS ch CM DC!C!C[mA]!C!C!C'
;ylim, prefix+'s_ch_cm_dc', 0, 14, 0
ylim, prefix+'s_ch_cm_dc', 1, 10, 1 ; lbe
options, prefix+'s_ch_cm_dc', 'xticklen', .05
options, prefix+'s_ch_cm_dc', /noclip

store_data, 'TAC_temps', data = [prefix+'tac0_tsp',prefix+'tac2_tsp']
options, 'TAC_temps','ytitle',sat+'!C!CTAC!C!C[deg C]'
options, 'TAC_temps', 'title','Temperature Plots (Item_0: Black, Item_1: Red, Item_2: Green)'
ylim,'TAC_temps', 15, 25,0
options, 'TAC_temps','panel_size',2
options, 'TAC_temps', 'xticklen', .05
options, 'TAC_temps', /noclip

store_data, 'TOF_hv_temps', data=[prefix+'tof_hv0_tsp',prefix+'tof_hv1_tsp']
options, 'TOF_hv_temps','ytitle',sat+'!C!CTOF HV!C!C[deg C]'
ylim, 'TOF_hv_temps', 5, 15,0
options, 'TOF_hv_temps','panel_size',2
options, 'TOF_hv_temps', 'xticklen', .05
options, 'TOF_hv_temps', /noclip

store_data, 'SC_temps', data=[prefix+'s_c_0_tsp',prefix,'s_c_1_tsp']
options, 'SC_temps','ytitle',sat+'!C!CSC!C!C[deg C]'
ylim, 'SC_temps',0, 10,0
options, 'SC_temps','panel_size',2
options, 'SC_temps', 'xticklen', .05
options, 'SC_temps', /noclip

store_data, 'LVC_temps',data=[prefix+'lvc0_tsp', prefix+'lvc1_tsp']
options, 'LVC_temps', 'ytitle', sat+'!C!CLVC!C!C[deg C]'
ylim, 'LVC_temps',5, 15,0
options, 'LVC_temps', 'panel_size',2
options, 'LVC_temps', 'xticklen', .05
options, 'LVC_temps', /noclip

store_data, 'SSD_temps', data = [prefix+'ssd_tc0', prefix+'ssd_tc1', prefix+'ssd_tc2']
options, 'SSD_temps', 'ytitle', sat+'!C!CSSD!C!C[deg C]'
ylim, 'SSD_temps', 10, 20, 0
options, 'SSD_temps', 'panel_size', 2
options, 'SSD_temps', 'xticklen', .05
options, 'SSD_temps', /noclip

options, prefix+'pac_vm'          , 'title', 'PAC, MCP, and SSD'
options, prefix+'pac_vm'          , 'ytitle', sat+'!CPAC VM!C[V]'
options, prefix+'pac_cm_dc'       , 'ytitle', sat+'!C!CPAC!C!CCM DC!C!C[mA]!C'
options, prefix+'mcp_vm'          , 'ytitle', sat+'!C!CMCP!C!CVM!C!C[V]'
options, prefix+'mcp_cm_dc'       , 'ytitle', sat+'!C!CMCP!C!CCM DC!C!C[mA]!C'
options, prefix+'ssd_vm'          , 'ytitle', sat+'!C!CSSD!C!CVM!C!C[V]'
options, prefix+'ssd_hv_bias'     , 'ytitle', sat+'!C!CSSD!C!CHV BIAS!C!C[V]'
options, prefix+'ssd_v_pos_analog', 'ytitle', sat+'!C!CSSD!C!CPOS ANALOG!C!C[V]!C'
options, prefix+'ssd_v_neg_analog', 'ytitle', sat+'!C!CSSD!C!CNEG ANALOG!C!C[V]'
options, prefix+'ssd_v_pos_dig'   , 'ytitle', sat+'!C!CSSD!C!CPOS DIG!C!C[V]!C'
options, prefix+'pac_vm'          , /noclip
options, prefix+'pac_cm_dc'       , /noclip
options, prefix+'mcp_vm'          , /noclip
options, prefix+'mcp_cm_dc'       , /noclip
options, prefix+'ssd_vm'          , /noclip
options, prefix+'ssd_hv_bias'     , /noclip
options, prefix+'ssd_v_pos_analog', /noclip
options, prefix+'ssd_v_neg_analog', /noclip
options, prefix+'ssd_v_pos_dig'   , /noclip
name = prefix+'pac_vm'
ylim, prefix+'pac_vm',         -20000, -19800, 0
ylim, prefix+'pac_cm_dc',          25,     35, 0
ylim, prefix+'mcp_vm',           3000,   3300, 0
ylim, prefix+'mcp_cm_dc',          45,     55, 0
ylim, prefix+'ssd_vm',             60,     70, 0
ylim, prefix+'ssd_hv_bias',        95,    105, 0
ylim, prefix+'ssd_v_pos_analog',    6,      7, 0
ylim, prefix+'ssd_v_neg_analog',   -7,     -6, 0
ylim, prefix+'ssd_v_pos_dig',       5,      6, 0
options, prefix+'pac_cm_dc',   'yticks', 3
options, prefix+'pac_cm_dc',   'yminor', 2
options, prefix+'pac_cm_dc',   'xticklen', .05
options, prefix+'mcp_cm_dc',   'yticks', 3
options, prefix+'mcp_cm_dc',   'yminor', 2
options, prefix+'mcp_cm_dc',    'xticklen', .05
options, prefix+'ssd_vm',      'yticks', 3
options, prefix+'ssd_vm',      'yminor', 2
options, prefix+'ssd_vm', 'xticklen', .05
options, prefix+'ssd_hv_bias', 'yticks', 3
options, prefix+'ssd_hv_bias', 'yminor', 2
options, prefix+'ssd_hv_bias', 'xticklen', .05


;options, prefix+'lvc_+12v_imon','color',0 ; black
;options, prefix+'lvc_-12v_imon','color',250 ; red
;options, prefix+'lvc_+5v_imon', 'color', 50 ; purple blue
;options, prefix+'lvc_-5v_imon', 'color', 200 ;orange
;options, prefix+'lvc_+2.5v_a_imon','color', 150 ; green
;options, prefix+'lvc_+2.5v_b_imon','color', 100 ; cyan blue

tplot_options, 'ymargin', [6, 6]
tplot_options, 'thick', 3.0
ThisDevice = !D.Name
SET_PLOT, 'PS'
FOR ii = 0, 3 DO BEGIN 
    filename = fileprefix+filesuffix[ii]
    filepath = getenv('OUT_DIR')+'/'+filename
    ps_file = filepath+'.ps'
    DEVICE, FILENAME = ps_file, XSIZE = 8.5, YSIZE = 11.0, /INCHES, $
            /COLOR, Bits_Per_Pixel = 8, PORTRAIT = 1, XOFFSET = 0.25, YOFFSET = 0
    
    LOADCT, 39, NCOLORS = 256

    CASE ii OF
        0:BEGIN 
            tplot, ['LVC_voltages', 'LVC_1', 'LVC_2', 'LVC_3', 'LVC_4', 'LVC_5', 'LVC_6']
            tplot_panel, v = 'LVC_voltages',       o = 'LVC_voltages',       psym = 3
            tplot_panel, v = 'LVC_1',              o = 'LVC_1',              psym = 3
            tplot_panel, v = 'LVC_2',              o = 'LVC_2',              psym = 3
            tplot_panel, v = 'LVC_3',              o = 'LVC_3',              psym = 3
            tplot_panel, v = 'LVC_4',              o = 'LVC_4',              psym = 3
            tplot_panel, v = 'LVC_5',              o = 'LVC_5',              psym = 3
            tplot_panel, v = 'LVC_6',              o = 'LVC_6',              psym = 3
        END 
        1:BEGIN 
            tplot, ['ESA_voltages', prefix+'esa_cm_dc', 'DFL_vm', 'DFL_tap', 'DFL_cmdc', $
                    prefix+'s_ch_vm', prefix+'s_ch_vm_tap', prefix+'s_ch_cm_dc']
            tplot_panel, v = prefix+'esa_cm_dc',   o = prefix+'esa_cm_dc',   psym = 3
            tplot_panel, v = 'DFL_vm',             o = 'DFL_vm',             psym = 3
            tplot_panel, v = 'DFL_tap',            o = 'DFL_tap',            psym = 3
            tplot_panel, v = 'DFL_cmdc',           o = 'DFL_cmdc',           psym = 3
            tplot_panel, v = prefix+'s_ch_vm',     o = prefix+'s_ch_vm',     psym = 3
            tplot_panel, v = prefix+'s_ch_vm_tap', o = prefix+'s_ch_vm_tap', psym = 3
            tplot_panel, v = prefix+'s_ch_cm_dc',  o = prefix+'s_ch_cm_dc',  psym = 3
            yline, prefix+'s_ch_vm_tap', col = 2 ; lbe
        END 
        2:BEGIN 
            tplot, [prefix+'pac_vm', prefix+'pac_cm_dc', prefix+'mcp_vm', prefix+'mcp_cm_dc', $
                    prefix+'ssd_vm', prefix+'ssd_hv_bias', prefix+'ssd_v_pos_analog', $
                    prefix+'ssd_v_neg_analog', prefix+'ssd_v_pos_dig']
            tplot_panel, v = prefix+'pac_vm',           o = prefix+'pac_vm',           psym = 3
            tplot_panel, v = prefix+'pac_cm_dc',        o = prefix+'pac_cm_dc',        psym = 3
            tplot_panel, v = prefix+'mcp_vm',           o = prefix+'mcp_vm',           psym = 3
            tplot_panel, v = prefix+'mcp_cm_dc',        o = prefix+'mcp_cm_dc',        psym = 3
            tplot_panel, v = prefix+'ssd_vm',           o = prefix+'ssd_vm',           psym = 3
            tplot_panel, v = prefix+'ssd_hv_bias',      o = prefix+'ssd_hv_bias',      psym = 3
            tplot_panel, v = prefix+'ssd_v_pos_analog', o = prefix+'ssd_v_pos_analog', psym = 3
            tplot_panel, v = prefix+'ssd_v_neg_analog', o = prefix+'ssd_v_neg_analog', psym = 3
            tplot_panel, v = prefix+'ssd_v_pos_dig',    o = prefix+'ssd_v_pos_dig',    psym = 3
        END 
        3:BEGIN
            tplot, ['TAC_temps', 'TOF_hv_temps', 'SC_temps', 'LVC_temps', 'SSD_temps']
            tplot_panel, v = 'TAC_temps',             o = 'TAC_temps',            psym = 3
            tplot_panel, v = 'TOF_hv_temps',          o = 'TOF_hv_temps',         psym = 3
            tplot_panel, v = 'SC_temps',              o = 'SC_temps',             psym = 3
            tplot_panel, v = 'LVC_temps',             o = 'LVC_temps',            psym = 3
            tplot_panel, v = 'SSD_temps',             o = 'SSD_temps',            psym = 3
        END 
    ENDCASE 
    ;timebar, '2014-12-17/19:50:00'
    ;timebar, '2014-12-17/20:03:00'
    ;timebar, '2014-12-17/20:05:00'
    ;timebar, '2014-12-17/20:20:00'
    ;timebar, '2014-12-17/20:35:00'
    ;xyouts, .85, .85, /normal, 'Commands:'
    ;xyouts, .85, .83, /normal, 'Mode 0 (pt 2)'
    ;xyouts, .85, .81, /normal, 'Mode 0'
    ;xyouts, .85, .79, /normal, 'Tabledump'
    ;xyouts, .85, .77, /normal, 'Dis.Sw.Op.'
    ;xyouts, .85, .75, /normal, 'Mode 3'

    timebar, '2014-05-08/19:52:00'
    timebar, '2014-05-08/20:05:00'
    timebar, '2014-05-08/20:20:00'
    timebar, '2014-05-08/21:20:00'
    timebar, '2014-05-08/21:30:00'
    timebar, '2014-05-08/21:40:00'
    timebar, '2014-05-09/18:01:00'
    timebar, '2014-05-09/18:35:14'
    timebar, '2014-05-09/19:14:20'
    timebar, '2014-05-09/19:15:48'
    timebar, '2014-05-09/20:15:29'
    timebar, '2014-05-09/20:50:11'
    timebar, '2014-05-09/21:00:32'
    xyouts, .85, .85, /normal, 'Commands:'
    xyouts, .85, .83, /normal, 'Mode 0'
    xyouts, .85, .81, /normal, 'Dis.Sw.Op.'
    xyouts, .85, .79, /normal, 'Mode 3'
    xyouts, .85, .77, /normal, 'Mode 0'
    xyouts, .85, .75, /normal, 'SlowEn.Sweep'
    xyouts, .85, .73, /normal, 'Mode 3'
    xyouts, .85, .71, /normal, ' '
    ;xyouts, .85, .69, /normal, 'RT Commands:'
    ;xyouts, .85, .67, /normal, 'Mode 0'
    ;xyouts, .85, .65, /normal, 'RampUpMCP'
    ;xyouts, .85, .63, /normal, 'Dis.Sw.Op.'
    ;xyouts, .85, .61, /normal, 'Mode 3'
    ;xyouts, .85, .59, /normal, 'Mode 0'
    ;xyouts, .85, .57, /normal, 'SlowEn.Sweep'
    ;xyouts, .85, .55, /normal, 'Mode 3'
    DEVICE, /Close_File

                                ; Convert to png format
    command_string = 'convert -flatten -density 288 -geometry 25% -sharpen 3 ' + filepath + '.ps ' + filepath + '.png'
    spawn, command_string
    command_string = 'rm -f ' + filepath + '.ps'
    spawn, command_string
    ;command_string = 'scp '+filepath+'.png lorna@fiji:"/data1/Plots/HK_Daily/'+filesuffix[ii]+'"'
    ;spawn, command_string
    ;command_string = 'rm '+filepath+'.png'
    ;spawn, command_string
ENDFOR 
SET_PLOT, ThisDevice
loadct2, 41
END 
