;+
;PROCEDURE: plot_hk_ps
;PURPOSE: Plot the products.
;
;PARAMETERS:   prod: array of product names 
;              num_files_a: number of files for sat a
;              num_files_b: number of files for sat b
;              cadence    : int: 0=monthly, 1=yearly
;
;CREATED BY: L. Ellis (plot_moments)
;
;MODIFICATION HISTORY:
;  02/19/2014 LBE Created from plot_hk_ps_daily.pro
;  12/16/2014 LBE Change limit for dfl_cmdc
;-
PRO plot_hk_ps, sat_hk, num_files_a, num_files_b, sat, cadence
compile_opt strictarrsubs

tplot_options, 'title', ' ' ; remove old title
;filename = getenv('OUT_DIR')+'daily_analog_hk.ps'
get_timespan, time
ts = time_struct(time)
IF cadence EQ 1 THEN fileprefix = 'ST'+sat+'_PLA_hk_'+string(ts[0].year, format = '(I4.4)')+'_' ELSE $
  fileprefix = 'ST'+sat+'_PLA_hk_'+string(ts[0].year, format = '(I4.4)')+string(ts[0].month, format = '(I2.2)')+'_'
filesuffix = ['LVC', 'ESA_DFL_SCHAN', 'PAC_MCP_SSD', 'Temps']


COMMON tplot_com1
COMMON share1_mon
prefix_a = 'STA_Analog_HK_'
prefix_b = 'STB_Analog_HK_'

set_plot, 'PS'
popen, 'temp.ps'
pclose

IF sat EQ 'A' THEN prefix = prefix_a ELSE prefix = prefix_b

store_data, 'LVC_voltages', data = [prefix+'lvc_+12v', prefix+'lvc_-12v', $
					prefix+'lvc_+5v',prefix+'lvc_-5v', prefix+'lvc_+2.5v_a',prefix+'lvc_+2.5v_b']
options, 'LVC_voltages','title', 'LVC (black +12V/red -12V/purple +5V/orange -5V/green +2.5Va/cyan +2.5Vb)'
options, 'LVC_voltages','ytitle', sat+'!C!CLVC Voltages!C!C[V]'
ylim,    'LVC_voltages',-15,15,0
options, 'LVC_voltages','panel_size',2

store_data, 'LVC_1', data = ['empty',prefix+'lvc_+12v_imon']
options, 'LVC_1', 'ytitle', sat+'!C!CLVC +12v!C!C[mA]'
ylim,    'LVC_1',  0, 600, 0
options, 'LVC_1', 'yticks', 3
options, 'LVC_1', 'yminor', 3

store_data, 'LVC_2', data = ['empty',prefix+'lvc_-12v_imon']
options, 'LVC_2', 'ytitle', sat+'!C!CLVC -12v!C!C[mA]'
ylim,    'LVC_2',  0,600,0
options, 'LVC_2', 'yticks', 3
options, 'LVC_2', 'yminor', 3

store_data, 'LVC_3', data = ['empty',prefix+'lvc_+5v_imon']
options, 'LVC_3', 'ytitle', sat+'!C!CLVC +5v!C!C[mA]'
ylim,    'LVC_3',  0,600
options, 'LVC_3', 'yticks', 3
options, 'LVC_3', 'yminor', 3

store_data, 'LVC_4', data = ['empty', prefix+'lvc_-5v_imon']
options, 'LVC_4', 'ytitle',sat+'!C!CLVC -5v!C!C[mA]'
ylim,    'LVC_4',  0,600,0
options, 'LVC_4', 'yticks', 3
options, 'LVC_4', 'yminor', 3

store_data, 'LVC_5',data = ['empty',prefix+'lvc_+2.5v_a_imon']
options, 'LVC_5', 'ytitle',sat+'!C!CLVC +2.5_a!C!C[mA]'
ylim,    'LVC_5',  0,600,0
options, 'LVC_5', 'yticks', 3
options, 'LVC_5', 'yminor', 3

store_data, 'LVC_6',data= ['empty', prefix+'lvc_+2.5v_b_imon']
options, 'LVC_6', 'ytitle',sat+'!C!CLVC +2.5_b!C!C[mA]'
ylim,    'LVC_6',  0,600,0
options, 'LVC_6', 'yticks', 3
options, 'LVC_6', 'yminor', 3

store_data, 'ESA_voltages', data = [prefix+'esa_vm_pos',prefix+'esa_vm_neg']
options, 'ESA_voltages','title','ESA (black +, red -), DFL(black 1, green 2), and S Channel'
options, 'ESA_voltages','ytitle', sat+'!C!CESA Voltages!C!C[V]'
options, 'ESA_voltages','panel_size',2
ylim,    'ESA_voltages',-10000,10000,0

options, prefix+'esa_cm_dc', 'ytitle', sat+'!C!CESA CM DC!C!C[mA]!C!C'
ylim,    prefix+'esa_cm_dc', 0, 100, 0

store_data, 'DFL_vm', data = [prefix+'dfl_1_vm',prefix+'dfl_2_vm']
options, 'DFL_vm', 'ytitle',sat+'!C!CDFL Vm!C!C[V]!C'
ylim,    'DFL_vm',10,10000,1
options, 'DFL_vm','panel_size',2

store_data, 'DFL_tap', data=[prefix+'dfl_1_tap',prefix+'dfl_2_tap']
options,'DFL_tap','ytitle',sat+'!C!CDFL Tap!C!C[V]!C'
ylim,   'DFL_tap',10,10000,1
options,'DFL_tap','panel_size',2

store_data, 'DFL_cmdc', data = [prefix+'dfl_1_cm_dc', prefix+'dfl_2_cm_dc']
options,'DFL_cmdc','ytitle',sat+'!C!CDFL CM_DC!C!C[mA]!C!C!C'
ylim,   'DFL_cmdc',0,20,0
options,'DFL_cmdc','panel_size',2

options, prefix+'s_ch_vm', 'ytitle', sat+'!C!CS ch VM!C!C[V]!C!C'
ylim,    prefix+'s_ch_vm', -20, 20, 0

options, prefix+'s_ch_vm_tap', 'ytitle', sat+'!C!CS ch VM tap!C!C[V]!C!C'
ylim,    prefix+'s_ch_vm_tap', -20, 20, 0

options, prefix+'s_ch_cm_dc', 'ytitle', sat+'!C!CS ch CM DC!C!C[mA]!C!C!C'
ylim,    prefix+'s_ch_cm_dc', 0, 14, 0

store_data, 'TAC_temps', data = [prefix+'tac0_tsp',prefix+'tac2_tsp']
options, 'TAC_temps','ytitle',sat+'!C!CTAC!C!C[deg C]'
options, 'TAC_temps', 'title','Temperature Plots (Item_0: Black, Item_1: Red, Item_2: Green)'
ylim,    'TAC_temps',0, 30,0
options, 'TAC_temps','panel_size',2

store_data, 'TOF_hv_temps', data=[prefix+'tof_hv0_tsp',prefix+'tof_hv1_tsp']
options, 'TOF_hv_temps','ytitle',sat+'!C!CTOF HV!C!C[deg C]'
ylim,    'TOF_hv_temps',0, 30,0
options, 'TOF_hv_temps','panel_size',2

store_data, 'SC_temps', data=[prefix+'s_c_0_tsp',prefix,'s_c_1_tsp']
options, 'SC_temps','ytitle',sat+'!C!CSC!C!C[deg C]'
ylim,    'SC_temps',0, 30,0
options, 'SC_temps','panel_size',2

store_data, 'LVC_temps',data=[prefix+'lvc0_tsp', prefix+'lvc1_tsp']
options, 'LVC_temps', 'ytitle', sat+'!C!CLVC!C!C[deg C]'
ylim,    'LVC_temps',0, 30,0
options, 'LVC_temps', 'panel_size',2

store_data, 'SSD_temps', data = [prefix+'ssd_tc0', prefix+'ssd_tc1', prefix+'ssd_tc2']
options, 'SSD_temps', 'ytitle', sat+'!C!CSSD!C!C[deg C]'
ylim,    'SSD_temps', 0, 30, 0
options, 'SSD_temps', 'panel_size', 2

options, prefix+'pac_vm'          , 'title', 'PAC, MCP, and SSD'
options, prefix+'pac_vm'          , 'ytitle', sat+'!CPAC VM!C[V]'
options, prefix+'pac_cm_dc'       , 'ytitle', sat+'!C!CPAC!C!CCM DC!C!C[mA]!C'
options, prefix+'mcp_vm'          , 'ytitle', sat+'!C!CMCP!C!CVM!C!C[V]'
options, prefix+'mcp_cm_dc'       , 'ytitle', sat+'!C!CMCP!C!CCM DC!C!C[mA]!C'
options, prefix+'ssd_vm'          , 'ytitle', sat+'!C!CSSD!C!CVM!C!C[V]'
options, prefix+'ssd_hv_bias'     , 'ytitle', sat+'!C!CSSD!C!CHV BIAS!C!C[V]'
options, prefix+'ssd_v_pos_analog', 'ytitle', sat+'!C!CSSD!C!CPOS ANALOG!C!C[V]!C'
options, prefix+'ssd_v_neg_analog', 'ytitle', sat+'!C!CSSD!C!CNEG ANALOG!C!C[V]'
options, prefix+'ssd_v_pos_dig'   , 'ytitle', sat+'!C!CSSD!C!CPOS DIG!C!C[V]!C'
ylim, prefix+'pac_vm',         -20100, -19900, 0
ylim, prefix+'pac_cm_dc',           0,    150, 0
ylim, prefix+'mcp_vm',              0,   4000, 0
ylim, prefix+'mcp_cm_dc',           0,    150, 0
ylim, prefix+'ssd_vm',              0,    150, 0
ylim, prefix+'ssd_hv_bias',         0,    150, 0
ylim, prefix+'ssd_v_pos_analog',    0,     10, 0
ylim, prefix+'ssd_v_neg_analog',  -10,      0, 0
ylim, prefix+'ssd_v_pos_dig',       0,     10, 0
options, prefix+'pac_cm_dc',   'yticks', 3
options, prefix+'pac_cm_dc',   'yminor', 2
options, prefix+'mcp_cm_dc',   'yticks', 3
options, prefix+'mcp_cm_dc',   'yminor', 2
options, prefix+'ssd_vm',      'yticks', 3
options, prefix+'ssd_vm',      'yminor', 2
options, prefix+'ssd_hv_bias', 'yticks', 3
options, prefix+'ssd_hv_bias', 'yminor', 2


;options, prefix+'lvc_+12v_imon','color',0 ; black
;options, prefix+'lvc_-12v_imon','color',250 ; red
;options, prefix+'lvc_+5v_imon', 'color', 50 ; purple blue
;options, prefix+'lvc_-5v_imon', 'color', 200 ;orange
;options, prefix+'lvc_+2.5v_a_imon','color', 150 ; green
;options, prefix+'lvc_+2.5v_b_imon','color', 100 ; cyan blue

tplot_options, 'ymargin', [6, 6]
tplot_options, 'thick', 3.0
ThisDevice = !D.Name
SET_PLOT, 'PS'
FOR ii = 0, 3 DO BEGIN 
    filename = fileprefix+filesuffix[ii]
    filepath = getenv('OUT_DIR')+'/'+filename
    ps_file = filepath+'.ps'
    DEVICE, FILENAME = ps_file, XSIZE = 8.5, YSIZE = 11.0, /INCHES, $
            /COLOR, Bits_Per_Pixel = 8, PORTRAIT = 1, XOFFSET = 0.25, YOFFSET = 0
    
    LOADCT, 39, NCOLORS = 256

    CASE ii OF
        0:tplot, ['LVC_voltages', 'LVC_1', 'LVC_2', 'LVC_3', 'LVC_4', 'LVC_5', 'LVC_6']
        1:tplot, ['ESA_voltages', prefix+'esa_cm_dc', 'DFL_vm', 'DFL_tap', 'DFL_cmdc', $
                  prefix+'s_ch_vm', prefix+'s_ch_vm_tap', prefix+'s_ch_cm_dc']
        2:tplot, [prefix+'pac_vm', prefix+'pac_cm_dc', prefix+'mcp_vm', prefix+'mcp_cm_dc', $
                  prefix+'ssd_vm', prefix+'ssd_hv_bias', prefix+'ssd_v_pos_analog', $
                  prefix+'ssd_v_neg_analog', prefix+'ssd_v_pos_dig']
        3:tplot, ['TAC_temps', 'TOF_hv_temps', 'SC_temps', 'LVC_temps', 'SSD_temps']
    ENDCASE 
    DEVICE, /Close_File

                                ; Convert to png format
    command_string = 'convert -flatten -density 288 -geometry 25% -sharpen 3 ' + filepath + '.ps ' + filepath + '.png'
    spawn, command_string
    command_string = 'rm -f ' + filepath + '.ps'
    spawn, command_string
    IF cadence EQ 1 THEN command_string = 'scp '+filepath+'.png lorna@fiji:"/data1/Plots/HK_Yearly/' +filesuffix[ii]+'"' ELSE $
      command_string = 'scp '+filepath+'.png lorna@fiji:"/data1/Plots/HK_Monthly/'+filesuffix[ii]+'"' 
    spawn, command_string
    command_string = 'rm '+filepath+'.png'
    spawn, command_string
ENDFOR 
SET_PLOT, ThisDevice
loadct2, 41
END 
