;+ 
;PROCEDURE: pl_read_cdf_norm
;PURPOSE:
;  Read data from cdf files.
;
;PARAMETERS:   in:  sat        : 'A' or 'B'
;                   files      : Array of file paths to read from (strings)
;                   products   : Array of Products wanted (strings)
;                   which_epoch:  resolution
;		    E_step:  Array of desired energy steps (set to 0 if not applicable)
;		    crib_name:  String naming which type of product is being read (housekeeping, monitor rates, etc.)
;		    NO_ENG:  if set to 1, do not look for engineering mode data
;
;CREATED BY: L. Ellis (pl_read_cdf)
;
;LAST MODIFICATION: 05 August, 2008
;
;MODIFICATION HISTORY:
;    3 July, 2007: combined pl_read_cdf_mon, pl_read_cdf_mon_no_eng, pl_read_cdf_hk_1min,
;		   pl_read_cdf_dig_hk, pl_read_cdf_mon_full, and
;		   pl_read_cdf_sc_hk
;    18 July, 2007: changed 'first_index' to a long (LBE)
;                   changed loop in read_one_mon to long
;    30 Aug, 2007: Added check for data_index[0] ne -1 in read_product(LBE)
;    04 Sept, 2007: Changed check for data_index[0] eq -1 in read_product(LBE)
;    09-19-2007: LBE
;               Added cdf_close
;    19 Sept, 2007:  added removal of overflow value from normal monitor rates (KDCS)
;    24 Sept, 2007:  deleted removal of overflow value (KDCS)
;    18 Jan, 2008:  added 1 to maxrec info so that last record of day will be read (KDCS)
;    18 Jan, 2008:  modified index system to fix time stamp problem (KDCS)
;    14 Feb, 2008: Replaced case 1 in check_indices to deal with when 2 timestamps in a minute. (LBE)
;    29 Apr, 2008:  removed call for 1 minute time index in 5 minute monitor rates (KDCS)
;    04 Aug, 2008:  un-commented reading of 1 minute time stamps for normal monitor rates (KDCS)
;    05 Aug, 2008:  added data1_index and maxrec to read_data call in monitor rates
;    07 Aug, 2008:  changed 1441 to 1441.0 in multiplication to avoid converting long to integer (KDCS)
;    23 Sep, 2010: Changed loop to long (LBE);
;    04 Nov, 2014: Fix bug when no data (LBE)
;-

PRO read_product_norm, cdf_id, prod_name, data_var, data_index, epoch_maxrec

; prod_name: string with cdf variable name 
; data_var: the common variable in which to put the data
; data_index: the start index for records in the data_var
; epoch_maxrec: number of records we expect 

cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable

IF varinfo.maxrec+1 GE epoch_maxrec THEN maxrec = varinfo.maxrec ELSE maxrec = epoch_maxrec

IF maxrec GT 0 THEN BEGIN 
    cdf_varget, cdf_id, prod_name, temp_data, rec_count = maxrec+1, /zvariable
    num_dim = size(data_var, /n_dimensions)
    loop_num = n_elements(data_index)
    IF n_elements(data_index) EQ 1 THEN $
      IF data_index[0] EQ -1 THEN loop_num = 0

    CASE num_dim OF 
        1: BEGIN
            FOR kk = 0L, loop_num-1 DO BEGIN 
                data_var[data_index[kk]:(data_index[kk]+data_index[kk+2]-1)] = temp_data[data_index[kk+1]:(data_index[kk+1]+data_index[kk+2]-1)]
                kk = kk+2
            ENDFOR 
        END 
        2: BEGIN
            FOR kk = 0L, loop_num-1 DO BEGIN 
                data_var[*, data_index[kk]:(data_index[kk]+data_index[kk+2]-1)] = temp_data[*, data_index[kk+1]:(data_index[kk+1]+data_index[kk+2]-1)]
                kk = kk+2
            ENDFOR 
        END 
        3: BEGIN
            FOR kk = 0L, loop_num-1 DO BEGIN 
                data_var[*, *, data_index[kk]:(data_index[kk]+data_index[kk+2]-1)] = temp_data[*, *, data_index[kk+1]:(data_index[kk+1]+data_index[kk+2]-1)]
                kk = kk+2
            ENDFOR 
        END 
        ELSE: BEGIN 
            print, "Lorna: Add more dimensions"
            stop
        END
    ENDCASE 
ENDIF ELSE data_index = -1
END 

PRO remove_fill_norm, fill_val, data

; fill_val: fill_value to be replaced by NaN
; data: array of data values
indice = where(data EQ fill_val, count)
FOR ii = 0L, count-1 DO BEGIN
    data[indice[ii]] = !values.f_nan
ENDFOR 

END 


PRO init_data_norm, sat, num_records5, data_initialized 

COMMON com_norm

CASE sat OF
    'A': BEGIN 
	s_chan5_a = intarr(num_records5) ; channel of s-channel switch
	s_chan5_a[*] = -1
	error5_a	= intarr(num_records5) ; error flag
	error5_a[*]	= -1
	sf0_a_sci	= fltarr(32,8,num_records5) ; 12
	sf0_a_sci[*,*,*]	= !values.f_nan
	ra_trig_a_sci	= fltarr(32,8,num_records5) ; 15
	ra_trig_a_sci[*,*,*]	= !values.f_nan
	sfr0_a_sci	= fltarr(32,8,num_records5)
	sfr0_a_sci[*,*,*]	= !values.f_nan
	stp0_a_sci	= fltarr(32,8,num_records5)
	stp0_a_sci[*,*,*] 	= !values.f_nan	
	s_valid_a_sci 	= fltarr(32,8,num_records5)
	s_valid_a_sci[*,*,*]	= !values.f_nan
	ssd_sw_a_sci	= fltarr(32,8,num_records5)
	ssd_sw_a_sci[*,*,*] = !values.f_nan
    END 
    'B': BEGIN 

	s_chan5_b = intarr(num_records5)
	s_chan5_b[*] = -1
	error5_b	= intarr(num_records5) ; error flag
	error5_b[*]	= -1
	sf0_b_sci	= fltarr(32,8,num_records5) ; 12
	sf0_b_sci[*,*,*]	= !values.d_nan
	ra_trig_b_sci	= fltarr(32,8,num_records5) ; 15
	ra_trig_b_sci[*,*,*]	= !values.d_nan
	sfr0_b_sci	= fltarr(32,8,num_records5)
	sfr0_b_sci[*,*,*]	= !values.f_nan
	stp0_b_sci	= fltarr(32,8,num_records5)
	stp0_b_sci[*,*,*] 	= !values.f_nan	
	s_valid_b_sci 	= fltarr(32,8,num_records5)
	s_valid_b_sci[*,*,*]	= !values.f_nan
	ssd_sw_b_sci	= fltarr(32,8,num_records5)
	ssd_sw_b_sci[*,*,*] = !values.f_nan	
    END 
ENDCASE 

data_initialized = 1
END


PRO read_data_norm, cdf_id, sat, data_read, data5_index, epoch5maxrec

COMMON com_norm

CASE sat OF 
    'A': BEGIN
        read_product_norm, cdf_id, 'error5_mon', error5_a, data5_index, epoch5maxrec
	remove_fill_norm, -1, error5_a
	IF (TOTAL(error5_a, /NAN) GT 0) THEN print, 'ERROR5_MON FLAG SET'

	read_product_norm, cdf_id, 's_chan5_mon',s_chan5_a, data5_index, epoch5maxrec
	remove_fill_norm, -1, s_chan5_a
	
        read_product_norm, cdf_id, 'sf0_norm_science', sf0_a_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, sf0_a_sci

	read_product_norm, cdf_id,'ra_trig_norm_science', ra_trig_a_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, ra_trig_a_sci
	
	read_product_norm, cdf_id,'sfr0_norm_science',sfr0_a_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, sfr0_a_sci
		
	read_product_norm, cdf_id,'stp0_norm_science',stp0_a_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, stp0_a_sci

	read_product_norm, cdf_id,'s_valid_norm_science',s_valid_a_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, s_valid_a_sci

	read_product_norm, cdf_id,'ssd_sw_norm_science',ssd_sw_a_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, ssd_sw_a_sci
    END
    'B': BEGIN

	read_product_norm, cdf_id, 'error5_mon', error5_b, data5_index, epoch5maxrec
	remove_fill_norm, -1, error5_b
	IF (TOTAL(error5_b, /NAN) GT 0) THEN print, 'ERROR5_MON FLAG SET'
	
	read_product_norm, cdf_id, 's_chan5_mon',s_chan5_b, data5_index, epoch5maxrec
	remove_fill_norm, -1, s_chan5_b

        read_product_norm, cdf_id, 'sf0_norm_science', sf0_b_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, sf0_b_sci

	read_product_norm, cdf_id, 'ra_trig_norm_science', ra_trig_b_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, ra_trig_b_sci

	read_product_norm, cdf_id,'sfr0_norm_science',sfr0_b_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, sfr0_b_sci
		
	read_product_norm, cdf_id,'stp0_norm_science',stp0_b_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, stp0_b_sci

	read_product_norm, cdf_id,'s_valid_norm_science',s_valid_b_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, s_valid_b_sci

	read_product_norm, cdf_id,'ssd_sw_norm_science',ssd_sw_b_sci, data5_index, epoch5maxrec
	remove_fill_norm, -1, ssd_sw_b_sci
    END
ENDCASE
	
data_read = 1

END 

PRO check_indices_norm, index, epoch, resolution, file_num

; checks for missing records from the cdf epoch variable
; index: array of pairs [start_index,num_records] (could be [0,10,15,2] for times 0-9,15-16)
; epoch: array of time values read from cdf (and converted)
; resolution: 1,5, or 3 depending on epoch (may need to add variable)
; file_num: index of this file in the file array

first_index = 0L
first_index = long((file_num)*(1441.0/resolution)); changed from 1441 to 1441.0 (KDCS 8 August, 2008)

num_records = 0L
in_valid_area = 0
ii = 0L
index = [-1L]
in_synch = 1                    ; needed for when duplicate time-stamps -- only takes first
CASE resolution OF 
;    1: BEGIN 
;        FOR hour = 0, 23 DO BEGIN  
;            FOR min = 0, 59 DO BEGIN 
;                WHILE in_synch EQ 1 DO BEGIN 
;                    IF ii LT n_elements(epoch) THEN BEGIN 
;                        time = time_struct(epoch[ii])
;                        IF hour EQ time.hour AND min EQ time.min THEN BEGIN 
;                            IF in_valid_area EQ 0 THEN BEGIN
;                                start_index_time = LONG(first_index+(hour*60)+min)
;				IF start_index_time LT 0 THEN STOP
;                                start_index_cdf = ii
;                                num_records = 1
;                                in_valid_area = 1
;                            ENDIF ELSE BEGIN ; already in valid area
;                                num_records = num_records+1
;                            ENDELSE 
;                            ii = ii+1
;                            in_synch = 0
;                        ENDIF ELSE BEGIN
;                            IF ii GT 0 THEN BEGIN ; check for two valid timestamps in the minute
;                                last_time = time_struct(epoch[ii-1])
;                                IF last_time.hour EQ time.hour AND last_time.min EQ time.min AND last_time.sec NE time.sec THEN BEGIN 
;                                    num_records = num_records+1
;                                    ii = ii+1
;                                    in_synch = 0
;                                    min = min-1 ; do this minute again
;                                ENDIF ELSE BEGIN 
;                                    IF in_valid_area EQ 1 THEN BEGIN
;                                        in_valid_area = 0
;                                        IF index[0] EQ -1 THEN index = $
;                                          [long(start_index_time), long(start_index_cdf), long(num_records)] $
;                                        ELSE index = [index, long(start_index_time), long(start_index_cdf), long(num_records)]
;                                    ENDIF 
;                                    IF time.hour LT hour OR (hour EQ time.hour AND time.min LT min) THEN ii = ii+1 ELSE in_synch = 0
;                                ENDELSE 
;                            ENDIF ELSE IF time.hour LT hour OR (hour EQ time.hour AND time.min LT min) THEN ii = ii+1 ELSE in_synch = 0
;                        ENDELSE 
;                    ENDIF ELSE BEGIN 
;                        IF in_valid_area EQ 1 THEN BEGIN
;                            in_valid_area = 0
;                            IF index[0] EQ -1 THEN index = $
;                              [long(start_index_time), long(start_index_cdf), long(num_records)] $
;                            ELSE index = [index, long(start_index_time), long(start_index_cdf), long(num_records)]                
;                        ENDIF 
;                        in_synch = 0
;                    ENDELSE 
;                ENDWHILE 
;                in_synch = 1
;            ENDFOR 
;        ENDFOR 
;        IF in_valid_area EQ 1 THEN BEGIN
;            IF index[0] EQ -1 THEN index = $
;              [long(start_index_time), long(start_index_cdf), long(num_records)] $
;            ELSE index = [index, long(start_index_time), long(start_index_cdf), long(num_records)]                
;        ENDIF
;	;STOP
;    END
    5: BEGIN 
        FOR hour = 0, 23 DO BEGIN 
            FOR min = 0, 11 DO BEGIN 
                WHILE in_synch EQ 1 DO BEGIN 
                    IF ii LT n_elements(epoch) THEN BEGIN 
                        time = time_struct(epoch[ii])
                        IF (hour EQ time.hour AND time.min GE (min*5) AND time.min LT (min*5+5)) OR $
                          (time.hour EQ hour+1 AND time.min LE 4 AND min EQ 11) THEN BEGIN 
                            IF in_valid_area EQ 0 THEN BEGIN
                                start_index_time = first_index+(hour*12)+min
                                start_index_cdf = ii
                                num_records = 1
                                in_valid_area = 1
                            ENDIF ELSE BEGIN ; already in valid area
                                num_records = num_records+1
				; added next if statement so that a file with all records in synch will have a valid index (18 Jan, 2008)
					IF ii EQ n_elements(epoch)-1 THEN BEGIN
							IF index[0] EQ -1 THEN BEGIN
							index = [start_index_time, start_index_cdf, num_records]
							ENDIF ELSE BEGIN
							index = [index, start_index_time, start_index_cdf, num_records]
							ENDELSE
					ENDIF
                            ENDELSE 
                            ii = ii+1
                            in_synch = 0
                        ENDIF ELSE BEGIN
                            IF in_valid_area EQ 1 THEN BEGIN
                                in_valid_area = 0
                                IF index[0] EQ -1 THEN index = [start_index_time, start_index_cdf, num_records] $
                                ELSE index = [index, start_index_time, start_index_cdf, num_records]
                            ENDIF 
                            IF time.hour LT hour OR (hour EQ time.hour AND time.min LT min) THEN ii = ii+1 ELSE in_synch = 0
                        ENDELSE 
                    ENDIF ELSE BEGIN 
                        IF in_valid_area EQ 1 THEN BEGIN
                            in_valid_area = 0
                            IF index[0] EQ -1 THEN index = [start_index_time, start_index_cdf, num_records] $
                            ELSE index = [index, start_index_time, start_index_cdf, num_records]                
                        ENDIF 
                        in_synch = 0
                    ENDELSE 
                ENDWHILE
                in_synch = 1
            ENDFOR 
        ENDFOR 
    END
	
    ELSE: BEGIN
        print, "Lorna -- add variable resolution"
        stop
    END 
ENDCASE 
END 


PRO pl_read_cdf_norm, sat, files, products, which_epoch


COMMON share1_norm
COMMON com_norm
; check if there are any files to read
IF n_elements(products) GT 0 AND n_elements(files) EQ 0 THEN print, "No Data Files in this Time Range for Satellite ", sat


; initialize output variables (from common block)
;need_epoch1 = 0
need_epoch5 = 0

FOR ii = 0L, n_elements(which_epoch)-1 DO BEGIN 
    CASE which_epoch[ii] OF 
        1: BEGIN 
;            num_records1 = LONG(n_elements(files)*1441)
;            epoch1 = dblarr(num_records1)
;            epoch1(*) = !values.f_nan
;            need_epoch1 = 1
	    num_records5 = LONG(n_elements(files)*289)
            epoch5 = dblarr(num_records5)
            epoch5(*) = !values.f_nan
            need_epoch5 = 5
        END 
        ELSE: BEGIN
            print, "Invalid indication of which epoch is needed: ", which_epoch
            stop
        END
    ENDCASE 
ENDFOR 


data_initialized = 0
IF data_initialized EQ 0 THEN init_data_norm, sat, num_records5, data_initialized

    
; read the data

print, 'read data section started'

FOR ii = 0, n_elements(files)-1 DO BEGIN 
    IF strcmp(files[ii], '') NE 1 THEN BEGIN 
        cdf_id = cdf_open(files[ii])
                                ; get epochs
        FOR jj = 0L, n_elements(which_epoch)-1 DO BEGIN 
            
;            cdf_control, cdf_id, get_var_info = epoch1info, var = 'epoch1', /zvariable
;            IF epoch1info.maxrec GT 0 THEN BEGIN 
;                cdf_varget, cdf_id, 'epoch1', temp_epoch, rec_count = epoch1info.maxrec+1, /zvariable
;                converted_epoch = time_double(temp_epoch, /epoch)
;                check_indices_norm, data1_index, converted_epoch, which_epoch, ii
;               converted_index=0L
;
;			; below modified 17 January, 2008 to fix problem with repeated time stamps
;
;                        FOR kk = 0L, n_elements(data1_index)-2 DO BEGIN ; modified 17 January, 2008 
;			 converted_index = data1_index[kk+1]
;			 epoch1[data1_index[kk]:(data1_index[kk]+data1_index[kk+2]-1)] = $
;                              	converted_epoch[converted_index:(converted_index+data1_index[kk+2]-1)]
;                    kk = kk+2
;                ENDFOR 
;            ENDIF ELSE BEGIN
;		files[ii] = ''
;		data1_index = -1
;	    ENDELSE
;            remove_fill_norm, -1, epoch1
            cdf_control, cdf_id, get_var_info = epoch5info, var = 'epoch5_mon', /zvariable
            IF epoch5info.maxrec GT 0 THEN BEGIN 
                cdf_varget, cdf_id, 'epoch5_mon', temp_epoch, rec_count = epoch5info.maxrec+1, /zvariable
                converted_epoch5 = time_double(temp_epoch, /epoch)
                check_indices_norm, data5_index, converted_epoch5, 5, ii
                FOR kk = 0, n_elements(data5_index)-1 DO BEGIN 
                    epoch5[data5_index[kk]:(data5_index[kk]+data5_index[kk+2]-1)] = $
                      converted_epoch5[data5_index[kk+1]:(data5_index[kk+1]+data5_index[kk+2]-1)]
                    kk = kk+2
                ENDFOR 
            ENDIF ELSE files[ii] = ''
        ENDFOR 
        IF sat EQ 'A' THEN BEGIN 
        ;    IF need_epoch1 EQ 1 THEN epoch1_a = epoch1 
            IF need_epoch5 EQ 5 THEN epoch5_a = epoch5
        ENDIF ELSE BEGIN 
        ;    IF need_epoch1 EQ 1 THEN epoch1_b = epoch1 
            IF need_epoch5 EQ 5 THEN epoch5_b = epoch5 
        ENDELSE 
	
	data_read = 0
	IF data_read EQ 0 AND strcmp(files[ii], '') NE 1 THEN read_data_norm, cdf_id, sat, data_read, data5_index, epoch5info.maxrec+1 $
          ELSE data5_index = -1
	
   ENDIF
ENDFOR

IF sat EQ 'A' THEN BEGIN 
;    IF need_epoch1 EQ 1 THEN data1_index_a = data1_index 
    IF need_epoch5 EQ 5 THEN data5_index_a = data5_index
ENDIF ELSE BEGIN
;    IF need_epoch1 EQ 1 THEN data1_index_b = data1_index
    IF need_epoch5 EQ 5 THEN data5_index_b = data5_index
ENDELSE 

final_count_5 = num_records5
END 
