;+
;PROCEDURE: pl_read_cdf_high_res
;PURPOSE:
;  Read data from cdf files, and calculate proton bulk parameters.
;
;PARAMETERS:   in:  sat        : 'A' or 'B'
;                   files      : Array of file paths to read from (strings)
;                   which_epoch: 0(for variable), 1, or 5 minute resolution
;				
;
;CREATED BY: K. Simunac (based on L. Ellis' pl_read_cdf)
;
;LAST MODIFICATION: 05/08/2008
;
;MODIFICATION HISTORY:
;    09/18/2006: Created (pl_read_cdf)
;
;	December 2006 K.Simunac modifies for monitor rates
;	4 Jan, 2007:  modified to check for error flags
;	7 Jan, 2007:  modified to output counts per second (if desired)
;	8 Jan, 2007:  modified to calculate select ratios
;	12 Jan, 2007:  modified variable and program names to avoid confusion
;		read_product -> read_product_mon
;		remove_fill -> remove_fill_mon
;		init_mom -> init_mon
;		mom_initialized -> mon_initialized
;		mom_read -> mon_read
;		check_indices -> check_indices_mon
;	24 Jan, 2007:  IMPORTANT FIX to sum_defl... index system
;	29 Jan, 2007:  modified to plot counts versus time versus ESA step
;	Feb 2007: added routines to calculate bulk parameters -- see line 325
;	29 Mar, 2007: Set file_name to '' if no records & added check
;                     if maxrec = 0 (LBE)
;	6 April, 2007: Added time index to "raw counts" output file to coordinate
;			with s channel switch info (looked like a mismatch, but 
;			in fact o.k.)
;	9 April, 2007:  Modified check_indices_mon_science to look for repeated 
;			time steps
;	04/10/2007: LBE changed name of check_indices, and fixed it,
;                changed index variable to triplets from pairs
;	02/15/2008:  LBE fixed problem in time index system
;	03/11/2008:  KDCS added routine to check for extra records
;	05/08/2008:  KDCS modifies routine for allocating extra records to existing
;			data arrays
;-

PRO read_product_high_res, cdf_id, prod_name, data_var, data_index, epoch_maxrec
compile_opt strictarrsubs

; prod_name: string with cdf variable name 
; data_var: the common variable in which to put the data
; data_index: the start index for records in the data_var
; epoch_maxrec: number of records we expect 

cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable

IF varinfo.maxrec+1 GE epoch_maxrec THEN maxrec = varinfo.maxrec ELSE maxrec = epoch_maxrec

;stop

IF maxrec GT 0 THEN BEGIN 
	cdf_varget, cdf_id, prod_name, temp_data, rec_count = maxrec+1, /zvariable
	num_dim = size(data_var, /n_dimensions)

	CASE num_dim OF 
    	1: BEGIN
        	FOR kk = 0L,n_elements(data_index)-2 DO BEGIN ; changed to -2 17 October, 2007
	 		data_var[data_index[kk]:(data_index[kk]+data_index[kk+2]-1)] = temp_data[data_index[kk+1]:(data_index[kk+1]+data_index[kk+2]-1)]
                	kk = kk+2
        	ENDFOR 
    	END 
    	2: BEGIN
        	FOR kk = 0L,n_elements(data_index)-2 DO BEGIN 
			data_var[*, data_index[kk]:(data_index[kk]+data_index[kk+2]-1)] = temp_data[*, data_index[kk+1]:(data_index[kk+1]+data_index[kk+2]-1)]
                	kk = kk+2
        	ENDFOR 
    	END 
    	3: BEGIN
      		FOR kk = 0L, n_elements(data_index)-2 DO BEGIN 
			data_var[*, *, data_index[kk]:(data_index[kk]+data_index[kk+2]-1)] = temp_data[*, *, data_index[kk+1]:(data_index[kk+1]+data_index[kk+2]-1)]
                	kk = kk+2
        	ENDFOR 
    	END 
    	ELSE: BEGIN 
        	print, "Lorna: Add more dimensions"
        	stop
    	END
	ENDCASE 
ENDIF ELSE BEGIN
	data_index = -1
ENDELSE
END 

PRO remove_fill_high_res, fill_val, data
compile_opt strictarrsubs

; fill_val: fill_value to be replaced by NaN
; data: array of data values
indice = where(data EQ fill_val, count)
FOR ii = 0L, count-1 DO BEGIN
    data[indice[ii]] = !values.f_nan ; changed to float from double 17 January, 2008
ENDFOR 

END 


PRO init_mon_high_res, sat, num_records1, mon_science_initialized
compile_opt strictarrsubs

; initialize all the monitor rate variables (in com_high_res)

COMMON com_high_res

CASE sat OF
    'A': BEGIN 
	s_chan1_a	= intarr(num_records1) ; channel of s-channel switch
	s_chan1_a[*]	= -1 
	error1_a	= intarr(num_records1) ; error flag
	error1_a[*]	= -1	
	sf0_a_full	= fltarr(128,32,num_records1) 
	sf0_a_full[*,*,*]	= !values.f_nan
	ra_trig_a_full	= fltarr(128,32,num_records1) ; 15
	ra_trig_a_full[*,*,*]	= !values.f_nan
	data_matrix_A = fltarr(128,  FIX(num_records1/10))
	data_matrix_A[*,*] = !values.f_nan
		
    END 
    'B': BEGIN 
	s_chan1_b	= intarr(num_records1)
	s_chan1_b[*]	= -1
	error1_b	= intarr(num_records1) ; error flag
	error1_b[*]	= -1	
	sf0_b_full	= fltarr(128,32,num_records1) ; 12
	sf0_b_full[*,*,*]	= !values.f_nan	
	ra_trig_b_full	= fltarr(128,32,num_records1) ; 15
	ra_trig_b_full[*,*,*]	= !values.f_nan
	data_matrix_B = fltarr(128,  FIX(num_records1/10))
	data_matrix_B[*,*] = !values.f_nan
	END
ENDCASE 
mon_science_initialized = 1

END 

PRO read_mon_high_res, cdf_id, sat, mon_science_read, data1_index, epoch1maxrec;, num_records1
compile_opt strictarrsubs

COMMON com_high_res
CASE sat OF 
    'A': BEGIN
	
	read_product_high_res, cdf_id, 'error1', error1_a, data1_index, epoch1maxrec
	remove_fill_high_res, -1, error1_a
	IF (TOTAL(error1_a, /NAN) GT 0) THEN print, 'ERROR1 FLAG SET'

	read_product_high_res, cdf_id, 's_chan1', s_chan1_a, data1_index, epoch1maxrec
	remove_fill_high_res, -1, s_chan1_a

	read_product_high_res, cdf_id, 'sf0_full', sf0_a_full, data1_index, epoch1maxrec
	remove_fill_high_res, -1, sf0_a_full
	read_product_high_res, cdf_id, 'ra_trig_full', ra_trig_a_full, data1_index, epoch1maxrec
	remove_fill_high_res, -1, ra_trig_a_full


    END
    'B': BEGIN

	read_product_high_res, cdf_id, 'error1', error1_b, data1_index, epoch1maxrec
	remove_fill_high_res, -1, error1_b
	IF (TOTAL(error1_b, /NAN) GT 0) THEN print, 'ERROR1 FLAG SET'

	read_product_high_res, cdf_id, 's_chan1', s_chan1_b, data1_index, epoch1maxrec
	remove_fill_high_res, -1, s_chan1_b

	read_product_high_res, cdf_id, 'sf0_full', sf0_b_full, data1_index, epoch1maxrec
	remove_fill_high_res, -1, sf0_b_full
	read_product_high_res, cdf_id, 'ra_trig_full', ra_trig_b_full, data1_index, epoch1maxrec
	remove_fill_high_res, -1, ra_trig_b_full
	
	END

    ENDCASE
    mon_science_read = 1
END 

PRO check_indices_high_res, index, epoch, resolution, file_num
compile_opt strictarrsubs

; checks for missing records from the cdf epoch variable
; index: array of pairs [start_index,num_records] (could be [0,10,15,2] for times 0-9,15-16)
; epoch: array of time values read from cdf (and converted)
; resolution: 1 for 1 minute
; file_num: index of this file in the file array


first_index=0L
first_index = LONG(file_num*(1441/resolution)) ; changed from 1440 to 1441 (24 March, 2008)

num_records = 0L
in_valid_area = 0
ii = 0L
index = [-1L]
in_synch = 1 ; needed for when duplicate time-stamps -- only takes first

CASE resolution OF 
    1: BEGIN 
        FOR hour = 0, 23 DO BEGIN  
            FOR min = 0, 59 DO BEGIN 
                WHILE in_synch EQ 1 DO BEGIN 
                    IF ii LT n_elements(epoch) THEN BEGIN 
                        time = time_struct(epoch[ii])
                        IF hour EQ time.hour AND min EQ time.min THEN BEGIN 
                            IF in_valid_area EQ 0 THEN BEGIN
                                start_index_time = first_index+(hour*60)+min
                                start_index_cdf = ii
                                num_records = 1
                                in_valid_area = 1
                            ENDIF ELSE BEGIN ; already in valid area
                                num_records = num_records+1
                            ENDELSE 
                            ii = ii+1
                            in_synch = 0
                        ENDIF ELSE BEGIN
                            IF ii GT 0 THEN BEGIN ; check for two valid timestamps in the minute
                                last_time = time_struct(epoch[ii-1])
                                IF last_time.hour EQ time.hour AND last_time.min EQ time.min AND last_time.sec NE time.sec THEN BEGIN 
                                    num_records = num_records+1
                                    ii = ii+1
                                    in_synch = 0
                                    min = min-1 ; do this minute again
                                ENDIF ELSE BEGIN 
                                    IF in_valid_area EQ 1 THEN BEGIN
                                        in_valid_area = 0
                                        IF index[0] EQ -1 THEN index = $
                                          [long(start_index_time), long(start_index_cdf), long(num_records)] $
                                        ELSE index = [index, long(start_index_time), long(start_index_cdf), long(num_records)]
                                    ENDIF 
                                    IF time.hour LT hour OR (hour EQ time.hour AND time.min LT min) THEN ii = ii+1 ELSE in_synch = 0
                                ENDELSE 
                            ENDIF ELSE IF time.hour LT hour OR (hour EQ time.hour AND time.min LT min) THEN ii = ii+1 ELSE in_synch = 0
                        ENDELSE 
                    ENDIF ELSE BEGIN 
                        IF in_valid_area EQ 1 THEN BEGIN
                            in_valid_area = 0
                            IF index[0] EQ -1 THEN index = $
                              [long(start_index_time), long(start_index_cdf), long(num_records)] $
                            ELSE index = [index, long(start_index_time), long(start_index_cdf), long(num_records)]                
                        ENDIF 
                        in_synch = 0
                    ENDELSE 
                ENDWHILE 
                in_synch = 1
            ENDFOR 
        ENDFOR 
        IF in_valid_area EQ 1 THEN BEGIN
            IF index[0] EQ -1 THEN index = $
              [long(start_index_time), long(start_index_cdf), long(num_records)] $
            ELSE index = [index, long(start_index_time), long(start_index_cdf), long(num_records)]                
        ENDIF 
    END
    ELSE: BEGIN
        print, "Lorna -- add variable resolution"
        stop
    END 
ENDCASE 
;stop
END 


PRO pl_read_cdf_high_res, sat, files, which_epoch, time
compile_opt strictarrsubs

COMMON share1_high_res
COMMON com_high_res
; check if there are any files to read
IF n_elements(products) GT 0 AND n_elements(files) EQ 0 THEN print, "No Data Files in this Time Range for Satellite ", sat

; initialize output variables (from common block)
need_epoch1 = 0

FOR ii = 0L, n_elements(which_epoch)-1 DO BEGIN 
    CASE which_epoch[ii] OF 
        1: BEGIN 
            num_records1 = LONG(n_elements(files)*1441)
            epoch1 = dblarr(num_records1)
            epoch1(*) = !values.d_nan
            need_epoch1 = 1
        END 
        ELSE: BEGIN
            print, "Invalid indication of which epoch is needed: ", which_epoch
            stop
        END
    ENDCASE 
ENDFOR 

mon_science_initialized = 0
IF mon_science_initialized EQ 0 THEN init_mon_high_res, sat, num_records1, mon_science_initialized
    
; read data

file_records = LONARR(n_elements(files))
file_records(*) = 0L
sum_so_far = LONARR(n_elements(files))
sum_so_far(*) = 0L

FOR ii = 0L, n_elements(files)-1 DO BEGIN 
    IF strcmp(files[ii], '') NE 1 THEN BEGIN 
        cdf_id = cdf_open(files[ii])
                                ; get epochs
        FOR jj = 0L, n_elements(which_epoch)-1 DO BEGIN 
            CASE which_epoch[jj] OF 
                1: BEGIN 
                    cdf_control, cdf_id, get_var_info = epoch1info, var = 'epoch1', /zvariable
                    IF epoch1info.maxrec GE 0 THEN BEGIN 
                        cdf_varget, cdf_id, 'epoch1', temp_epoch, rec_count = epoch1info.maxrec+1, /zvariable
		
			;changed rec_count to +1 so that last record of day will be included 15 August, 2007
			
                        converted_epoch = time_double(temp_epoch, /epoch)
                        check_indices_high_res, data1_index, converted_epoch, which_epoch, ii

			IF n_elements(converted_epoch) GT 1441 THEN BEGIN
				epoch1 = [epoch1,dblarr(n_elements(converted_epoch)-1441)]
				p = 0L
				p=LONG(n_elements(converted_epoch)-1441)
				new_num_records1 = num_records1 + p


				PRINT, 'Re-initializing arrays to accomodate more elements.'
			
				CASE sat OF
   					'A': BEGIN 
					s_chan1_a	= [s_chan1_a, intarr(p)] ; channel of s-channel switch
					error1_a	= [error1_a,intarr(p)] ; error flag
					new_sf0_a_full = fltarr(128,32,(num_records1+p))
					new_sf0_a_full(*,*,*) = !values.f_nan	
					new_sf0_a_full(*,*,0:(num_records1-1)) = sf0_a_full
					sf0_a_full = new_sf0_a_full
					new_ra_trig_a_full = fltarr(128,32,(num_records1+p))
					new_ra_trig_a_full(*,*,*) = !values.f_nan 
					new_ra_trig_a_full(*,*,0:(num_records1 - 1)) = ra_trig_a_full
					ra_trig_a_full = new_ra_trig_a_full
					data_matrix_A = fltarr(128,  FIX((num_records1+p)/10.0))		
    					END 

    					'B': BEGIN
					s_chan1_b	= [s_chan1_b, intarr(p)] ; channel of s-channel switch
					error1_b	= [error1_b,intarr(p)] ; error flag
					new_sf0_b_full = fltarr(128,32,(num_records1+p))
					new_sf0_b_full(*,*,*) = !values.f_nan	
					new_sf0_b_full(*,*,0:(num_records1-1)) = sf0_b_full
					sf0_b_full = new_sf0_b_full
					new_ra_trig_b_full = fltarr(128,32,(num_records1+p))
					new_ra_trig_b_full(*,*,*) = !values.f_nan 
					new_ra_trig_b_full(*,*,0:(num_records1 - 1)) = ra_trig_b_full
					ra_trig_b_full = new_ra_trig_b_full
					data_matrix_B = fltarr(128,  FIX((num_records1+p)/10.0)) 
					END

				ENDCASE 

    				num_records1 = new_num_records1
			ENDIF

			
                     	converted_index=0L

			; below modified 17 January, 2008 to fix problem with repeated time stamps

                        FOR kk = 0L, n_elements(data1_index)-2 DO BEGIN ; modified 17 January, 2008 
			 converted_index = data1_index[kk+1]
			 epoch1[data1_index[kk]:(data1_index[kk]+data1_index[kk+2]-1)] = $
                              	converted_epoch[converted_index:(converted_index+data1_index[kk+2]-1)]
				;stop
				
                            kk = kk+2
                        ENDFOR
			;stop
		   ENDIF ELSE files[ii] = ''
		remove_fill_high_res, -1E31, epoch1
                  END 
                ELSE: BEGIN
                    print, "Invalid indication of which epoch is needed: ", which_epoch
                    stop
                END
            ENDCASE 
        ENDFOR 
        IF sat EQ 'A' THEN BEGIN 
            IF need_epoch1 EQ 1 THEN epoch1_a = epoch1 
        ENDIF ELSE BEGIN 
            IF need_epoch1 EQ 1 THEN epoch1_b = epoch1 
        ENDELSE 

        ; get other data
        mon_science_read = 0
	IF mon_science_read EQ 0 THEN read_mon_high_res, cdf_id, sat, mon_science_read, data1_index, epoch1info.maxrec+1;, num_records1
	;changed to maxrec + 1 so that last record of day will be read 15 August, 2007
    ENDIF 
ENDFOR 


IF sat EQ 'A' THEN BEGIN 
    IF need_epoch1 EQ 1 THEN data1_index_a = data1_index 
ENDIF ELSE BEGIN
    IF need_epoch1 EQ 1 THEN data1_index_b = data1_index
ENDELSE 

final_count = num_records1


END
