;+
;PROCEDURE: pl_plot_l2_1dmax
;PURPOSE:
;  It is a crib sheet for plotting stereo-plastic 1DMax moments using
;  the TPLOT package
;
;INPUT
;PARAMETERS:   sat_a_mom: Array of moments wanted for sat A
;              sat_b_mom: Array of moments wanted for sat B
;
;CREATED BY: L. Ellis
;
;MODIFICATION HISTORY:
;    10/31/2008: LBE: Created
;    03/09/2009: LBE: added order flag (1=only prelim, 2=valid first, 3=prelim first) -- default is valid only
;-
PRO pl_plot_l2_1dmax, sat, $
  order = order, $
  INST_COORD = INST_COORD, $
  SC_COORD = SC_COORD, BROWSE = BROWSE, HELP = HELP
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose

get_err_no = 0 & get_err_msg = ''

IF KEYWORD_SET(HELP) THEN BEGIN
    PRINT, '- sat_moment: "A_D"'
    PRINT, '- help = help: show procedure inputs'
    RETURN
ENDIF

satchk = WHERE(sat NE 'A' AND sat NE 'B', csatchk)
IF csatchk GT 0 THEN BEGIN
    err_msg, 'Input string error: SC description string'
ENDIF

; Loop over all sat/product combinations
FOR ii = 0, N_ELEMENTS(sat)-1 DO BEGIN
    
    get_err_no = 0 & get_err_msg = '' ; reset error indicator
    
    get_pla_l2_1dmax, sat(ii), browse = browse, order = order
    
    IF get_err_no NE 0 THEN BEGIN
        err_msg, 'No data for satellite: ' + sat(ii)
    ENDIF
    
ENDFOR


END
