;+
;PROCEDURE: pl_make_stack_plot_from_crib
;
;
;CREATED BY: L. Ellis (pl_plot_obmom_from_crib)
; 	Modified by K. Simunac to call procedures for processing
;	full resolution rate data
;
;	Most recent modification:  29 March, 2007
;       04/22/2008: LBE: Added an hour on each end of time because need extra 30 minutes on each end for fitting.
;                        Added num_days argument.
;       04/28/2008: LBE: Added tplot_dir.
;-


PRO pl_make_stack_plot_from_crib, sat, bkgd, time, num_days, table_location, output_dir, tplot_dir, INST_COORD=INST_COORD
compile_opt strictarrsubs

  COMMON get_error, get_err_no, get_err_msg, default_verbose

get_timespan, ts
check_time=time_struct(ts[0])

IF sat EQ 'A' THEN BEGIN
	
	IF check_time.year EQ 2007 AND check_time.doy LT 45 THEN BEGIN
		sat_a_rate = ['sf0']
	ENDIF ELSE BEGIN
		sat_a_rate=['ra_trig']
	ENDELSE

	
	; Figure out which files we need to read from
	 seek_files, 'A', 'science', files_a
	 dummy = where(strcmp(files_a, '') NE 1, num_a_valid_files)
	 IF num_a_valid_files EQ 0 AND n_elements(sat_a_rate) GT 0 THEN print, "No files found for spacecraft A"
  
	; Read data, make calculations and plots

	IF num_a_valid_files GT 0 AND n_elements(sat_a_rate) GT 0 THEN BEGIN
		pl_read_cdf_high_res,'A',files_a, 1, time
	ENDIF

  	IF num_a_valid_files GT 0 AND n_elements(sat_a_rate) GT 0 THEN BEGIN
		stack_plot, 'A', 2, files_a, time, num_days, table_location, output_dir
 	 ENDIF


ENDIF ELSE BEGIN

	IF check_time.year EQ 2007 AND check_time.doy LT 60 THEN BEGIN
		sat_b_rate = ['sf0']
	ENDIF ELSE BEGIN
		sat_b_rate=['ra_trig']
	ENDELSE


	; Figure out which files we need to read from
	 seek_files, 'B', 'science', files_b
  	 dummy = where(strcmp(files_b, '') NE 1, num_b_valid_files)
  	 IF num_b_valid_files EQ 0 AND n_elements(sat_b_rate) GT 0 THEN print, "No files found for spacecraft B"
 

	 ; Read data, make calculations and plots
  	IF num_b_valid_files GT 0 AND n_elements(sat_b_rate) GT 0 THEN BEGIN
		pl_read_cdf_high_res,'B',files_b, 1, time
	ENDIF


  	IF num_b_valid_files GT 0 AND n_elements(sat_b_rate) GT 0 THEN BEGIN
		stack_plot, 'B', 2, files_b, time, num_days, table_location, output_dir
  	ENDIF

ENDELSE

close, /all

PRINT, 'Program Complete'
END
