;+
;PROCEDURE: make_tplot_struct_dig_hk
;PURPOSE: Create tplot structures from data
;
;PARAMETERS:   sat : 'A' or 'B'
;              prod_dig_hk: array of product names
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 01/12/2007
;
;MODIFICATION HISTORY:
;    09/21/2006 Created
;	November 2006 K. Simunac modifies for housekeeping data
;	12 Jan, 2007 variable names modified to avoid confusion
;-
PRO make_tplot_struct_dig_hk, sat, prod_dig_hk
compile_opt strictarrsubs
COMMON tplot_com1
dig_hk_finished = 0
FOR ii = 0, n_elements(prod_dig_hk)-1 DO BEGIN 
    SWITCH prod_dig_hk[ii] OF 

	   'dpu_sw_version':                  ; 0 
           'cmd_rcvd_cnt':                    ; 1
           'cmd_exec_cnt':                    ; 2
           'cmd_total_err_cnt':               ; 3
           'cmd_parity_err_cnt':              ; 4
           'cmd_frame_err_cnt':               ; 5
           'cmd_illegal_err_cnt':             ; 6
           'ic_status_reg':                   ; 7
           'ic_ctl_reg':                      ; 8
           'lbc_reset_ctl':                   ; 9
           'lbc_mode_ctl':                    ; 10
           'lbc_logic_ctl_a':                 ; 11
           'lbc_logic_ctl_b':                 ; 12
           'lbc_tac_pwr_ctl':                 ; 13
           'lbc_reg_seq':                     ; 14
           'lbc_event_ctl':                   ; 15
           'lbc_rlim_ch':                     ; 16
           'lbc_rlim_hi':                     ; 17
           'lbc_rlim_lo':                     ; 18
           'lbe_pos_ctrl':                    ; 19
           'lbe_pos_disable0':                ; 20
           'lbe_pos_disable2':                ; 21
           'lbe_tac0_ctrl':                   ; 22
           'lbe_tac0_dac':                    ; 23
           'lbe_tac2_ctrl':                   ; 24
           'lbe_tac2_dac':                    ; 25
           'lbe_tac0_under_hi':               ; 26
           'lbe_tac0_under_lo':               ; 27
           'lbe_tac0_over_hi':                ; 28
           'lbe_tac0_over_lo':                ; 29
           'lbe_tac2_under_hi':               ; 30
           'lbe_tac2_under_lo':               ; 31
           'lbe_tac2_over_hi':                ; 32
           'lbe_tac2_over_lo':                ; 33
           'lbe_ssd_ctrl':                    ; 34
           'lbe_ssd_cmd_h':                   ; 35
           'lbe_ssd_cmd_l':                   ; 36
           'lbe_ssd_dis':                     ; 37
           'lbe_ssd_under_hi':                ; 38
           'lbe_ssd_under_lo':                ; 39
           'lbe_ssd_over_hi':                 ; 40
           'lbe_ssd_over_lo':                 ; 41
           'lbe_sel_ctrl':                    ; 42
           'lbe_trig_mode':                   ; 43
           'lbe_esa_step':                    ; 44
           'lbe_defl_step':                   ; 45
           'lbe_ssd_offset0':                 ; 46
           'lbe_ssd_offset1':                 ; 47
           'lbe_ssd_offset2':                 ; 48
           'lbe_ssd_offset3':                 ; 49
           'lbe_ssd_offset4':                 ; 50
           'lbe_ssd_offset5':                 ; 51
           'lbe_ssd_offset6':                 ; 52
           'lbe_ssd_offset7':                 ; 53
           'lbe_stim_enable':                 ; 54
           'lbe_stim_freq_hi':                ; 55
           'lbe_stim_freq_lo':                ; 56
           'lbe_sel0_window':                 ; 57
           'lbe_sel2_window':                 ; 58
           'lbe_ssd_offset8':                 ; 59
           'lbe_ssd_offset9':                 ; 60
           'lbe_ssd_offset10':                ; 61
           'lbe_ssd_offset11':                ; 62
           'lbe_ssd_offset12':                ; 63
           'lbe_ssd_offset13':                ; 64
           'lbe_ssd_offset14':                ; 65
           'lbe_ssd_offset15':                ; 66
           'lbe_pos_ra':                      ; 67
           'dacm_pac_mcp_ssd_ctl_mcp_limit':  ; 68
           'dacm_pac_limit':                  ; 69
           'dacm_esa_ctl':                    ; 70
           'dacm_s_ch_ctl':                   ; 71
           'dacm_dfl_1_ctl':                  ; 72
           'dacm_dfl_2_ctl':                  ; 73
           'dacm_control':                    ; 74
           'dacm_status':                     ; 75
           'dacm_adc_lu_ctr':                 ; 76
           'dacm_dfl_1_offset':               ; 77
           'dacm_dfl_2_offset':               ; 78
           'dacm_pac_coarse':                 ; 79
           'dacm_pac_fine':                   ; 80
           'dacm_pac_cm_fs_coarse':           ; 81
           'dacm_pac_cm_fs_fine':             ; 82
           'dacm_mcp_coarse':                 ; 83
           'dacm_mcp_fine':                   ; 84
           'dacm_mcp_cm_fs_coarse':           ; 85
           'dacm_mcp_cm_fs_fine':             ; 86
           'dacm_ssd_coarse':                 ; 87
           'dacm_ssd_fine':                   ; 88
           'dacm_esa_coarse':                 ; 89
           'dacm_esa_fine':                   ; 90
           'dacm_s_ch_coarse':                ; 91
           'dacm_s_ch_fine':                  ; 92
           'dacm_s_ch_tap_coarse':            ; 93
           'dacm_s_ch_tap_fine':              ; 94
           'dacm_dfl_1_coarse':               ; 95
           'dacm_dfl_1_fine':                 ; 96
           'dacm_dfl_1_dfine':                ; 97
           'dacm_dfl_2_coarse':               ; 98
           'dacm_dfl_2_fine':                 ; 99
           'dacm_dfl_2_dfine':                ; 100
           'dacr_pac_mcp_ssd_ctl_mcp_limit':  ; 101
           'dacr_pac_limit':                  ; 102
           'dacr_esa_ctl':                    ; 103
           'dacr_s_ch_ctl':                   ; 104
           'dacr_dfl_1_ctl':                  ; 105
           'dacr_dfl_2_ctl':                  ; 106
           'dacr_control':                    ; 107
           'dacr_status':                     ; 108
           'dacr_adc_lu_ctr':                 ; 109
           'dacr_dfl_1_offset':               ; 110
           'dacr_dfl_2_offset':               ; 111
           'dacr_c_pac_coarse':               ; 112
           'dacr_c_pac_fine':                 ; 113
           'dacr_c_pac_cm_fs_coarse':         ; 114
           'dacr_c_pac_cm_fs_fine':           ; 115
           'dacr_c_mcp_coarse':               ; 116
           'dacr_c_mcp_fine':                 ; 117
           'dacr_c_mcp_cm_fs_coarse':         ; 118
           'dacr_c_mcp_cm_fs_fine':           ; 119
           'dacr_c_ssd_coarse':               ; 120
           'dacr_c_ssd_fine':                 ; 121
           'dacr_c_esa_coarse':               ; 122
           'dacr_c_esa_fine':                 ; 123
           'dacr_c_s_ch_coarse':              ; 124
           'dacr_c_s_ch_fine':                ; 125
           'dacr_c_s_ch_tap_coarse':          ; 126
           'dacr_c_s_ch_tap_fine':            ; 127
           'dacr_dfl_1_coarse':               ; 128
           'dacr_dfl_1_fine':                 ; 129
           'dacr_dfl_1_dfine':                ; 130
           'dacr_dfl_2_coarse':               ; 131
           'dacr_dfl_2_fine':                 ; 132
           'dacr_dfl_2_dfine':                ; 133
           'sw_status1':                      ; 134
           'sw_hv_ramp_status':               ; 135
           'sw_hv_enable_status':             ; 136
           'sw_hv_limit_status':              ; 137
           'sw_eepromchksum':                 ; 138
           'hkp_sampletime':                  ; 139
           'pac_discharge_status':            ; 140
           'pac_discharge_cnt':               ; 141
           'pac_discharge_conseccntr':        ; 142
           'pac_discharge_safe_att':          ; 143
           'analog_limit_status':             ; 144
           'analog_lim_pt1_status':           ; 145
           'analog_lim_pt1_id':               ; 146
           'analog_lim_pt1_red':              ; 147
           'analog_lim_pt2_status':           ; 148
           'analog_lim_pt2_id':               ; 149
           'analog_lim_pt2_red':              ; 150
           'analog_lim_pt3_status':           ; 151
           'analog_lim_pt3_id':               ; 152
           'analog_lim_pt3_red':              ; 153
           'analog_lim_pt4_status':           ; 154
           'analog_lim_pt4_id':               ; 155
           'analog_lim_pt4_red':              ; 156
           'analog_lim_pt5_status':           ; 157
           'analog_lim_pt5_id':               ; 158
           'analog_lim_pt5_red':              ; 159
           'analog_lim_pt6_status':           ; 160
           'analog_lim_pt6_id':               ; 161
           'analog_lim_pt6_red':              ; 162
           'analog_lim_pt7_status':           ; 163
           'analog_lim_pt7_id':               ; 164
           'analog_lim_pt7_red':              ; 165
           'analog_lim_pt8_status':           ; 166
           'analog_lim_pt8_id':               ; 167
           'analog_lim_pt8_red':              ; 168
           'analog_lim_pt9_status':           ; 169
           'analog_lim_pt9_id':               ; 170
           'analog_lim_pt9_red':              ; 171
           'analog_lim_pt10_status':          ; 172
           'analog_lim_pt10_id':              ; 173
           'analog_lim_pt10_red':             ; 174
           'analog_lim_pt11_status':          ; 175
           'analog_lim_pt11_id':              ; 176
           'analog_lim_pt11_red':             ; 177
           'analog_lim_pt12_status':          ; 178
           'analog_lim_pt12_id':              ; 179
           'analog_lim_pt12_red':             ; 180
           'analog_lim_pt13_status':          ; 181
           'analog_lim_pt13_id':              ; 182
           'analog_lim_pt13_red':             ; 183
           'analog_lim_pt14_status':          ; 184
           'analog_lim_pt14_id':              ; 185
           'analog_lim_pt14_red':             ; 186
           'analog_lim_pt15_status':          ; 187
           'analog_lim_pt15_id':              ; 188
           'analog_lim_pt15_red':             ; 189
           'opmode':                          ; 190
           'sw_mode':                         ; 191
           'proton_mode':                     ; 192
           'active_supplyid':                 ; 193
           'supply_coarse_rb':                ; 194
           'supply_fine_rb':                  ; 195
           'swmaint_supplystat':              ; 196
           'swmaint_pac_coarse':              ; 197
           'swmaint_pac_fine': BEGIN              ; 198 
            IF dig_hk_finished EQ 0 THEN BEGIN 
                make_dig_hk_struct, sat, prod_dig_hk
                dig_hk_finished = 1
            ENDIF 
            BREAK 
        END 
    ENDSWITCH 
ENDFOR 
END 
