;+
;PROCEDURE: make_mon_struct_no_eng
;PURPOSE: Create tplot structures from data
;
;PARAMETERS:   sat : 'A' or 'B'
;
;CREATED BY: L. Ellis (make_moment_struct)
;
;LAST MODIFICATION: 07/06/2007
;
;MODIFICATION HISTORY:
;    10/14/2006 Created
;
;   December 2006 modified by K. Simunac for monitor rates
;	4 Jan, 2007:  modified to store error flags
;	12 Jan, 2007:  modified variable and program names to avoid confusion
;	24 Jan, 20007:  IMPORTANT FIX TO low/high indices
;	03/07/2007:	Some of the code is compacted using the 'EXECUTE' command
;	5 July, 2007:	corrected Hz conversion factor
;	6 July, 2007:  added separate "execute" commands for products that are ratios of rates
;-


PRO make_mon_struct_no_eng, HZ, sat, prod_mon, E_step
compile_opt strictarrsubs
COMMON share1_mon
COMMON com_mon

; CONVERSION TO COUNTS PER SECOND IF HZ = 1
IF (HZ EQ 0) THEN BEGIN
	factor5 = 1L
	;factor1 = 1L
ENDIF ELSE BEGIN
	;0.0128 seconds/defl step * 32 defl steps = 0.4096 seconds per ESA step
	; 4 ESA steps * 0.4096 seconds * 5 sweeps = 8.192 seconds
	factor5 = 8.192
	;factor1 = 1.6384
ENDELSE

low5=0L
high5=0L
;low1=0L
;high1=0L


FOR z=0,N_ELEMENTS(E_step)-1 DO BEGIN
low5 = (num_rows5)*E_step(z)
high5 = (num_rows5)*E_step(z)+num_rows5-1
;low1 = (num_rows1)*E_step(z)
;high1 = (num_rows1)*E_step(z)+num_rows1-1

;stop
prefix = ' '
IF (sat EQ 'A') THEN prefix = 'A_Monitor_Rate_'
IF (sat EQ 'B') THEN prefix = 'B_Monitor_Rate_'

 IF sat EQ 'A' THEN BEGIN 
        
	;epoch1 = epoch1_a
        epoch5 = epoch5_a
        error5_mon = error5_mon_a
	;error1 = error1_a

        FOR y = 0, n_elements(prod_mon)-1 DO BEGIN

	IF prod_mon(y) NE 'stop0' AND prod_mon(y) NE 'start0' AND $
		prod_mon(y) NE 'stop2' AND prod_mon(y) NE 'start2' AND $
		prod_mon(y) NE 'sf0ra_trig' AND prod_mon(y) NE 'pos1' AND $
		prod_mon(y) NE 'pos2' AND prod_mon(y) NE 'pos3' THEN BEGIN

            IF E_step(z) EQ 32 THEN BEGIN
                iex = EXECUTE(prod_mon(y) + '_sci = REFORM(TOTAL(sum_defl_' + prod_mon(y) + '_a_sci, 2,  /NaN))/factor5')
            ENDIF ELSE BEGIN
                iex = EXECUTE(prod_mon(y) + '_sci = (sum_defl_' + prod_mon(y) + '_a_sci(low5:high5))/factor5')
            ENDELSE

	ENDIF ELSE BEGIN
	
	    IF E_step(z) EQ 32 THEN BEGIN
                iex = EXECUTE(prod_mon(y) + '_sci = REFORM(TOTAL(sum_defl_' + prod_mon(y) + '_a_sci, 2,  /NaN))/32')
            ENDIF ELSE BEGIN
                iex = EXECUTE(prod_mon(y) + '_sci = (sum_defl_' + prod_mon(y) + '_a_sci(low5:high5))')
            ENDELSE

	ENDELSE	


;            CASE prod_mon(y) OF
;                's_valid':  BEGIN
;                    s_valid_sci = (sum_defl_s_valid_a_sci(low5:high5))/factor5 ;0
;		    ;s_valid_eng = (sum_defl_s_valid_a_eng(low1:high1))/factor1 ;0
;                END
;                's_e_not_req':  BEGIN
;                    s_e_not_req_sci = (sum_defl_s_e_not_req_a_sci(low5:high5))/factor5 ;1
;		    ;s_e_not_req_eng = (sum_defl_s_e_not_req_a_eng(low1:high1))/factor1 ;1
;                END
;                's_e_req':  BEGIN
;                    s_e_req_sci = (sum_defl_s_e_req_a_sci(low5:high5))/factor5 ;2
;		    ;s_e_req_eng = (sum_defl_s_e_req_a_eng(low1:high1))/factor1 ;2
;                END
;                's_no_pos':  BEGIN
;                    s_no_pos_sci = (sum_defl_s_no_pos_a_sci(low5:high5))/factor5 ;3
;		    ;s_no_pos_eng = (sum_defl_s_no_pos_a_eng(low1:high1))/factor1 ;3
;                END
;                's_mult_pos':  BEGIN
;                    s_mult_pos_sci = (sum_defl_s_mult_pos_a_sci(low5:high5))/factor5 ;4
;		    ;s_mult_pos_eng = (sum_defl_s_mult_pos_a_eng(low1:high1))/factor1 ;4
;                END
;                's_no_e':  BEGIN
;                    s_no_e_sci = (sum_defl_s_no_e_a_sci(low5:high5))/factor5 ;5
;		    ;s_no_e_eng = (sum_defl_s_no_e_a_eng(low1:high1))/factor1 ;5
;                END
;                's_mult_e':  BEGIN
;                    s_mult_e_sci = (sum_defl_s_mult_e_a_sci(low5:high5))/factor5 ;6
;		    ;s_mult_e_eng = (sum_defl_s_mult_e_a_eng(low1:high1))/factor1 ;6
;                END
;                'ra_sat_a':  BEGIN
;                    ra_sat_a_sci = (sum_defl_ra_sat_a_a_sci(low5:high5))/factor5 ;7
;		    ;ra_sat_a_eng = (sum_defl_ra_sat_a_a_eng(low1:high1))/factor1 ;7
;                END
;                'ra_sat_b':  BEGIN
;                    ra_sat_b_sci = (sum_defl_ra_sat_b_a_sci(low5:high5))/factor5 ;8
;		    ;ra_sat_b_eng = (sum_defl_ra_sat_b_a_eng(low1:high1))/factor1 ;8
;                END
;                'ra_sat_both':  BEGIN
;                    ra_sat_both_sci = (sum_defl_ra_sat_both_a_sci(low5:high5))/factor5 ;9
;		    ;ra_sat_both_eng = (sum_defl_ra_sat_both_a_eng(low1:high1))/factor1 ;9
;                END
;                'ssd_sw':  BEGIN
;                    ssd_sw_sci = (sum_defl_ssd_sw_a_sci(low5:high5))/factor5 ;10
;		    ;ssd_sw_eng = (sum_defl_ssd_sw_a_eng(low1:high1))/factor1 ;10
;                END
;                'ssd_st':  BEGIN
;                    ssd_st_sci = (sum_defl_ssd_st_a_sci(low5:high5))/factor5 ;11
;		    ;ssd_st_eng = (sum_defl_ssd_st_a_eng(low1:high1))/factor1 ;11
;                END
;                'sf0':  BEGIN
;                    sf0_sci = (sum_defl_sf0_a_sci(low5:high5))/factor5 ;12
;		    ;sf0_eng = (sum_defl_sf0_a_eng(low1:high1))/factor1 ;12
;                END
;                'sfr0':  BEGIN
;                    sfr0_sci = (sum_defl_sfr0_a_sci(low5:high5))/factor5 ;13
;		    ;sfr0_eng = (sum_defl_sfr0_a_eng(low1:high1))/factor1 ;13
;                END
;                'stp0':  BEGIN
;                    stp0_sci = (sum_defl_stp0_a_sci(low5:high5))/factor5 ;14
;		    ;stp0_eng = (sum_defl_stp0_a_eng(low1:high1))/factor1 ;14
;                END
;                'ra_trig':  BEGIN
;                    ra_trig_sci = (sum_defl_ra_trig_a_sci(low5:high5))/factor5 ;15
;		    ;ra_trig_eng = (sum_defl_ra_trig_a_eng(low1:high1))/factor1 ;15
;                END
;                'pos1_0':  BEGIN
;                    pos1_0_sci = (sum_defl_pos1_0_a_sci(low5:high5))/factor5 ;16
;		    ;pos1_0_eng = (sum_defl_pos1_0_a_eng(low1:high1))/factor1 ;16
;                END
;                'pos1_1':  BEGIN
;                    pos1_1_sci = (sum_defl_pos1_1_a_sci(low5:high5))/factor5 ;17
;		    ;pos1_1_eng = (sum_defl_pos1_1_a_eng(low1:high1))/factor1 ;17
;                END
;                'w_no_pos':  BEGIN
;                    w_no_pos_sci = (sum_defl_w_no_pos_a_sci(low5:high5))/factor5 ;18
;		    ;w_no_pos_eng = (sum_defl_w_no_pos_a_eng(low1:high1))/factor1 ;18
;                END
;                'w_mult_pos':  BEGIN
;                    w_mult_pos_sci = (sum_defl_w_mult_pos_a_sci(low5:high5))/factor5 ;19
;		    ;w_mult_pos_eng = (sum_defl_w_mult_pos_a_eng(low1:high1))/factor1 ;19
;                END
;                'w_valid':  BEGIN
;                    w_valid_sci = (sum_defl_w_valid_a_sci(low5:high5))/factor5 ;20
;		    ;w_valid_eng = (sum_defl_w_valid_a_eng(low1:high1))/factor1 ;20
;                END
;                'sf2':  BEGIN
;                    sf2_sci = (sum_defl_sf2_a_sci(low5:high5))/factor5 ;21
;		    ;sf2_eng = (sum_defl_sf2_a_eng(low1:high1))/factor1 ;21
;                END
;                'sfr2':  BEGIN
;                    sfr2_sci = (sum_defl_sfr2_a_sci(low5:high5))/factor5 ;22
;		    ;sfr2_eng = (sum_defl_sfr2_a_eng(low1:high1))/factor1 ;22
;                END
;                'stp2':  BEGIN
;                    stp2_sci = (sum_defl_stp2_a_sci(low5:high5))/factor5 ;23
;		    ;stp2_eng = (sum_defl_stp2_a_eng(low1:high1))/factor1 ;23
;                END
;                'pos2_0':  BEGIN
;                    pos2_0_sci = (sum_defl_pos2_0_a_sci(low5:high5))/factor5 ;24
;		    ;pos2_0_eng = (sum_defl_pos2_0_a_eng(low1:high1))/factor1 ;24
;                END
;                'pos2_1':  BEGIN
;                    pos2_1_sci = (sum_defl_pos2_1_a_sci(low5:high5))/factor5 ;25
;		    ;pos2_1_eng = (sum_defl_pos2_1_a_eng(low1:high1))/factor1 ;25
;                END
;                'pos2_2':  BEGIN
;                    pos2_2_sci = (sum_defl_pos2_2_a_sci(low5:high5))/factor5 ;26
;		    ;pos2_2_eng = (sum_defl_pos2_2_a_eng(low1:high1) )/factor1;26
;                END
;                'pos2_3':  BEGIN
;                    pos2_3_sci = (sum_defl_pos2_3_a_sci(low5:high5))/factor5 ;27
;		    ;pos2_3_eng = (sum_defl_pos2_3_a_eng(low1:high1))/factor1 ;27
;                END
;                'pos3_0':  BEGIN
;                    pos3_0_sci = (sum_defl_pos3_0_a_sci(low5:high5))/factor5 ;28
;		    ;pos3_0_eng = (sum_defl_pos3_0_a_eng(low1:high1))/factor1 ;28
;                END
;                'pos3_1':  BEGIN
;                    pos3_1_sci = (sum_defl_pos3_1_a_sci(low5:high5))/factor5 ;29
;		    ;pos3_1_eng = (sum_defl_pos3_1_a_eng(low1:high1))/factor1 ;29
;                END
;                'pos3_2':  BEGIN
;                    pos3_2_sci = (sum_defl_pos3_2_a_sci(low5:high5))/factor5 ;30
;		    ;pos3_2_eng = (sum_defl_pos3_2_a_eng(low1:high1))/factor1 ;30
;                END
;                'pos3_3':  BEGIN
;                    pos3_3_sci = (sum_defl_pos3_3_a_sci(low5:high5))/factor5 ;31
;		    ;pos3_3_eng = (sum_defl_pos3_3_a_eng(low1:high1))/factor1 ;31	
;                END
;                'stop0':  BEGIN
;                    stop0_sci = (sum_defl_stop0_a_sci(low5:high5))
;		    ;stop0_eng = (sum_defl_stop0_a_eng(low1:high1))	
;                END
;                'start0':  BEGIN
;                    start0_sci = (sum_defl_start0_a_sci(low5:high5))
;		    ;start0_eng = (sum_defl_start0_a_eng(low1:high1))	
;                END
;                'stop2':  BEGIN
;                    stop2_sci = (sum_defl_stop2_a_sci(low5:high5))
;		    ;stop2_eng = (sum_defl_stop2_a_eng(low1:high1))	
;                END
;                'start2':  BEGIN
;                    start2_sci = (sum_defl_start2_a_sci(low5:high5))
;		    ;start2_eng = (sum_defl_start2_a_eng(low1:high1))	
;                END
;		'pos1':  BEGIN
;			pos1_sci = (sum_defl_pos1_a_sci(low5:high5))
;			;pos1_eng = (sum_defl_pos1_a_eng(low1:high1))
;		END
;		'pos2':  BEGIN
;			pos2_sci = (sum_defl_pos2_a_sci(low5:high5))
;			;pos2_eng = (sum_defl_pos2_a_eng(low1:high1))
;		END
;		'pos3':  BEGIN
;			pos3_sci = (sum_defl_pos3_a_sci(low5:high5))
;			;pos3_eng = (sum_defl_pos3_a_eng(low1:high1))
;		END 
;            ENDCASE
        ENDFOR

ENDIF ELSE BEGIN 
	;epoch1 = epoch1_b
	epoch5 = epoch5_b
	error5_mon = error5_mon_b
	;error1 = error1_b 

	FOR y=0, n_elements(prod_mon)-1 DO BEGIN

	IF prod_mon(y) NE 'stop0' AND prod_mon(y) NE 'start0' AND $
		prod_mon(y) NE 'stop2' AND prod_mon(y) NE 'start2' AND $
		prod_mon(y) NE 'sf0ra_trig' AND prod_mon(y) NE 'pos1' AND $
		prod_mon(y) NE 'pos2' AND prod_mon(y) NE 'pos3' THEN BEGIN

            IF E_step(z) EQ 32 THEN BEGIN
                iex = EXECUTE(prod_mon(y) + '_sci = REFORM(TOTAL(sum_defl_' + prod_mon(y) + '_b_sci, 2,  /NaN))/factor5')
            ENDIF ELSE BEGIN
                iex = EXECUTE(prod_mon(y) + '_sci = (sum_defl_' + prod_mon(y) + '_b_sci(low5:high5))/factor5')
            ENDELSE

	ENDIF ELSE BEGIN

	    IF E_step(z) EQ 32 THEN BEGIN
                iex = EXECUTE(prod_mon(y) + '_sci = REFORM(TOTAL(sum_defl_' + prod_mon(y) + '_b_sci, 2,  /NaN))/32')
            ENDIF ELSE BEGIN
                iex = EXECUTE(prod_mon(y) + '_sci = (sum_defl_' + prod_mon(y) + '_b_sci(low5:high5))')
            ENDELSE
	
	ENDELSE

;	CASE prod_mon(y) OF
;	's_valid':  BEGIN
;		s_valid_sci = (sum_defl_s_valid_b_sci(low5:high5))/factor5 ;0
;		;s_valid_eng = (sum_defl_s_valid_b_eng(low1:high1))/factor1 ;0
;		END
;	's_e_not_req':  BEGIN
;		s_e_not_req_sci = (sum_defl_s_e_not_req_b_sci(low5:high5))/factor5 ;1
;		;s_e_not_req_eng = (sum_defl_s_e_not_req_b_eng(low1:high1))/factor1 ;1
;		END
;	's_e_req':  BEGIN
;		s_e_req_sci = (sum_defl_s_e_req_b_sci(low5:high5))/factor5 ;2
;		;s_e_req_eng = (sum_defl_s_e_req_b_eng(low1:high1))/factor1 ;2
;		END
;	's_no_pos':  BEGIN
;		s_no_pos_sci = (sum_defl_s_no_pos_b_sci(low5:high5))/factor5 ;3
;		;s_no_pos_eng = (sum_defl_s_no_pos_b_eng(low1:high1))/factor1 ;3
;		END
;	's_mult_pos':  BEGIN
;		s_mult_pos_sci = (sum_defl_s_mult_pos_b_sci(low5:high5))/factor5 ;4
;		;s_mult_pos_eng = (sum_defl_s_mult_pos_b_eng(low1:high1))/factor1 ;4
;		END
;	's_no_e':  BEGIN
;		s_no_e_sci = (sum_defl_s_no_e_b_sci(low5:high5))/factor5 ;5
;		;s_no_e_eng = (sum_defl_s_no_e_b_eng(low1:high1))/factor1 ;5
;		END
;	's_mult_e':  BEGIN
;		s_mult_e_sci = (sum_defl_s_mult_e_b_sci(low5:high5))/factor5 ;6
;		;s_mult_e_eng = (sum_defl_s_mult_e_b_eng(low1:high1))/factor1 ;6
;		END
;	'ra_sat_a':  BEGIN
;		ra_sat_a_sci = (sum_defl_ra_sat_a_b_sci(low5:high5))/factor5 ;7
;		;ra_sat_a_eng = (sum_defl_ra_sat_a_b_eng(low1:high1))/factor1 ;7
;		END
;	'ra_sat_b':  BEGIN
;		ra_sat_b_sci = (sum_defl_ra_sat_b_b_sci(low5:high5))/factor5 ;8
;		;ra_sat_b_eng = (sum_defl_ra_sat_b_b_eng(low1:high1))/factor1 ;8
;		END
;	'ra_sat_both':  BEGIN
;		ra_sat_both_sci = (sum_defl_ra_sat_both_b_sci(low5:high5))/factor5 ;9
;		;ra_sat_both_eng = (sum_defl_ra_sat_both_b_eng(low1:high1))/factor1 ;9
;		END
;	'ssd_sw':  BEGIN
;		ssd_sw_sci = (sum_defl_ssd_sw_b_sci(low5:high5))/factor5 ;10
;		;ssd_sw_eng = (sum_defl_ssd_sw_b_eng(low1:high1))/factor1 ;10
;		END
;	'ssd_st':  BEGIN
;		ssd_st_sci = (sum_defl_ssd_st_b_sci(low5:high5))/factor5 ;11
;		;ssd_st_eng = (sum_defl_ssd_st_b_eng(low1:high1))/factor1 ;11
;		END
;	'sf0':  BEGIN
;		sf0_sci = (sum_defl_sf0_b_sci(low5:high5))/factor5 ;12
;		;sf0_eng = (sum_defl_sf0_b_eng(low1:high1))/factor1 ;12
;		END
;	'sfr0':  BEGIN
;		sfr0_sci = (sum_defl_sfr0_b_sci(low5:high5))/factor5 ;13
;		;sfr0_eng = (sum_defl_sfr0_b_eng(low1:high1))/factor1 ;13
;		END
;	'stp0':  BEGIN
;		stp0_sci = (sum_defl_stp0_b_sci(low5:high5))/factor5 ;14
;		;stp0_eng = (sum_defl_stp0_b_eng(low1:high1))/factor1 ;14
;		END
;	'ra_trig':  BEGIN
;		ra_trig_sci = (sum_defl_ra_trig_b_sci(low5:high5))/factor5 ;15
;		;ra_trig_eng = (sum_defl_ra_trig_b_eng(low1:high1))/factor1 ;15
;		END
;	'pos1_0':  BEGIN
;		pos1_0_sci = (sum_defl_pos1_0_b_sci(low5:high5))/factor5 ;16
;		;pos1_0_eng = (sum_defl_pos1_0_b_eng(low1:high1))/factor1 ;16
;		END
;	'pos1_1':  BEGIN
;		pos1_1_sci = (sum_defl_pos1_1_b_sci(low5:high5))/factor5 ;17
;		;pos1_1_eng = (sum_defl_pos1_1_b_eng(low1:high1))/factor1 ;17
;		END
;	'w_no_pos':  BEGIN
;		w_no_pos_sci = (sum_defl_w_no_pos_b_sci(low5:high5))/factor5 ;18
;		;w_no_pos_eng = (sum_defl_w_no_pos_b_eng(low1:high1))/factor1 ;18
;		END
;	'w_mult_pos':  BEGIN
;		w_mult_pos_sci = (sum_defl_w_mult_pos_b_sci(low5:high5))/factor5 ;19
;		;w_mult_pos_eng = (sum_defl_w_mult_pos_b_eng(low1:high1))/factor1 ;19
;		END
;	'w_valid':  BEGIN
;		w_valid_sci = (sum_defl_w_valid_b_sci(low5:high5))/factor5 ;20
;		;w_valid_eng = (sum_defl_w_valid_b_eng(low1:high1))/factor1 ;20
;		END
;	'sf2':  BEGIN
;		sf2_sci = (sum_defl_sf2_b_sci(low5:high5))/factor5 ;21
;		;sf2_eng = (sum_defl_sf2_b_eng(low1:high1))/factor1 ;21
;		END
;	'sfr2':  BEGIN
;		sfr2_sci = (sum_defl_sfr2_b_sci(low5:high5))/factor5 ;22
;		;sfr2_eng = (sum_defl_sfr2_b_eng(low1:high1))/factor1 ;22
;		END
;	'stp2':  BEGIN
;		stp2_sci = (sum_defl_stp2_b_sci(low5:high5))/factor5 ;23
;		;stp2_eng = (sum_defl_stp2_b_eng(low1:high1))/factor1 ;23
;		END
;	'pos2_0':  BEGIN
;		pos2_0_sci = (sum_defl_pos2_0_b_sci(low5:high5))/factor5 ;24
;		;pos2_0_eng = (sum_defl_pos2_0_b_eng(low1:high1))/factor1 ;24
;		END
;	'pos2_1':  BEGIN
;		pos2_1_sci = (sum_defl_pos2_1_b_sci(low5:high5))/factor5 ;25
;		;pos2_1_eng = (sum_defl_pos2_1_b_eng(low1:high1))/factor1 ;25
;		END
;	'pos2_2':  BEGIN
;		pos2_2_sci = (sum_defl_pos2_2_b_sci(low5:high5))/factor5 ;26
;		;pos2_2_eng = (sum_defl_pos2_2_b_eng(low1:high1) )/factor1;26
;		END
;	'pos2_3':  BEGIN
;		pos2_3_sci = (sum_defl_pos2_3_b_sci(low5:high5))/factor5 ;27
;		;pos2_3_eng = (sum_defl_pos2_3_b_eng(low1:high1))/factor1 ;27
;		END
;	'pos3_0':  BEGIN
;		pos3_0_sci = (sum_defl_pos3_0_b_sci(low5:high5))/factor5 ;28
;		;pos3_0_eng = (sum_defl_pos3_0_b_eng(low1:high1))/factor1 ;28
;		END
;	'pos3_1':  BEGIN
;		pos3_1_sci = (sum_defl_pos3_1_b_sci(low5:high5))/factor5 ;29
;		;pos3_1_eng = (sum_defl_pos3_1_b_eng(low1:high1))/factor1 ;29
;		END
;	'pos3_2':  BEGIN
;		pos3_2_sci = (sum_defl_pos3_2_b_sci(low5:high5))/factor5 ;30
;		;pos3_2_eng = (sum_defl_pos3_2_b_eng(low1:high1))/factor1 ;30
;		END
;	'pos3_3':  BEGIN
;		pos3_3_sci = (sum_defl_pos3_3_b_sci(low5:high5))/factor5 ;31
;		;pos3_3_eng = (sum_defl_pos3_3_b_eng(low1:high1))/factor1 ;31	
;		END
;	'stop0':  BEGIN
;		stop0_sci = (sum_defl_stop0_b_sci(low5:high5)) 
;		;stop0_eng = (sum_defl_stop0_b_eng(low1:high1))	
;		END
;	'start0':  BEGIN
;		start0_sci = (sum_defl_start0_b_sci(low5:high5)) 
;		;start0_eng = (sum_defl_start0_b_eng(low1:high1))	
;		END
;	'stop2':  BEGIN
;		stop2_sci = (sum_defl_stop2_b_sci(low5:high5)) 
;		;stop2_eng = (sum_defl_stop2_b_eng(low1:high1))	
;		END
;	'start2':  BEGIN
;		start2_sci = (sum_defl_start2_b_sci(low5:high5)) 
;		;start2_eng = (sum_defl_start2_b_eng(low1:high1))	
;		END
;	'pos1':  BEGIN
;		pos1_sci = (sum_defl_pos1_b_sci(low5:high5))
;		;pos1_eng = (sum_defl_pos1_b_eng(low1:high1))
;		END
;	'pos2':  BEGIN
;		pos2_sci = (sum_defl_pos2_b_sci(low5:high5))
;		;pos2_eng = (sum_defl_pos2_b_eng(low1:high1))
;		END
;	'pos3':  BEGIN
;		pos3_sci = (sum_defl_pos3_b_sci(low5:high5))
;		;pos3_eng = (sum_defl_pos3_b_eng(low1:high1))
;		END
;
;	ENDCASE
	ENDFOR
ENDELSE 

p=' '
	CASE E_step(z) OF
		0: p = '_0'
		1: p = '_1'
		2: p = '_2'
		3: p = '_3'
		4: p = '_4'
		5: p = '_5'
		6: p = '_6'
		7: p = '_7'
		8: p = '_8'
		9: p = '_9'
		10: p = '_10'
		11: p = '_11'
		12: p = '_12'
		13: p = '_13'
		14: p = '_14'
		15: p = '_15'
		16: p = '_16'
		17: p = '_17'
		18: p = '_18'
		19: p = '_19'
		20: p = '_20'
		21: p = '_21'
		22: p = '_22'
		23: p = '_23'
		24: p = '_24'
		25: p = '_25'
		26: p = '_26'
		27: p = '_27'
		28: p = '_28'
		29: p = '_29'
		30: p = '_30'
		31: p = '_31'
		32: p = '_32'
	ENDCASE
labels = ' '


	FOR i=0, n_elements(prod_mon)-1 DO BEGIN
	CASE prod_mon(i) OF
		's_valid':	BEGIN
				store_data, prefix+'s_valid_sci'+p, data = {x:epoch5, y:s_valid_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;0
				;store_data, prefix+'s_valid_eng'+p, data = {x:epoch1, y:s_valid_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;0
				END
		's_e_not_req':	BEGIN
				store_data, prefix+'s_e_not_req_sci'+p, data = {x:epoch5, y:s_e_not_req_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;1
				;store_data, prefix+'s_e_not_req_eng'+p, data = {x:epoch1, y:s_e_not_req_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;1
				END
		's_e_req':	BEGIN
				store_data, prefix+'s_e_req_sci'+p, data = {x:epoch5, y:s_e_req_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;2
				;store_data, prefix+'s_e_req_eng'+p, data = {x:epoch1, y:s_e_req_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;2
				END
		's_no_pos':	BEGIN
				store_data, prefix+'s_no_pos_sci'+p, data = {x:epoch5, y:s_no_pos_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;3
				;store_data, prefix+'s_no_pos_eng'+p, data = {x:epoch1, y:s_no_pos_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;3
				END
		's_mult_pos':	BEGIN
				store_data, prefix+'s_mult_pos_sci'+p, data = {x:epoch5, y:s_mult_pos_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;4
				;store_data, prefix+'s_mult_pos_eng'+p, data = {x:epoch1, y:s_mult_pos_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;4
				END
		's_no_e':	BEGIN
				store_data, prefix+'s_no_e_sci'+p, data = {x:epoch5, y:s_no_e_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;5
				;store_data, prefix+'s_no_e_eng'+p, data = {x:epoch1, y:s_no_e_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;5
				END
		's_mult_e':	BEGIN
				store_data, prefix+'s_mult_e_sci'+p, data = {x:epoch5, y:s_mult_e_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;6
				;store_data, prefix+'s_mult_e_eng'+p, data = {x:epoch1, y:s_mult_e_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;6
				END
		'ra_sat_a':	BEGIN
				store_data, prefix+'ra_sat_a_sci'+p, data = {x:epoch5, y:ra_sat_a_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;7
				;store_data, prefix+'ra_sat_a_eng'+p, data = {x:epoch1, y:ra_sat_a_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;7
				END
		'ra_sat_b':	BEGIN
				store_data, prefix+'ra_sat_b_sci'+p, data = {x:epoch5, y:ra_sat_b_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;8
				;store_data, prefix+'ra_sat_b_eng'+p, data = {x:epoch1, y:ra_sat_b_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;8
				END
		'ra_sat_both':	BEGIN
				store_data, prefix+'ra_sat_both_sci'+p, data = {x:epoch5, y:ra_sat_both_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;9
				;store_data, prefix+'ra_sat_both_eng'+p, data = {x:epoch1, y:ra_sat_both_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;9
				END
		'ssd_sw':	BEGIN
				store_data, prefix+'ssd_sw_sci'+p, data = {x:epoch5, y:ssd_sw_sci}, dlim = {ylog:1, labels:labels, panel_size:2.} ;10
				;store_data, prefix+'ssd_sw_eng'+p, data = {x:epoch1, y:ssd_sw_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;10
				END
		'ssd_st':	BEGIN
				store_data, prefix+'ssd_st_sci'+p, data = {x:epoch5, y:ssd_st_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;11
				;store_data, prefix+'ssd_st_eng'+p, data = {x:epoch1, y:ssd_st_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;11
				END
		'sf0':		BEGIN
				store_data, prefix+'sf0_sci'+p, data = {x:epoch5, y:sf0_sci}, dlim = {ylog:1, labels:labels, panel_size:2.} ;12
				;store_data, prefix+'sf0_eng'+p, data = {x:epoch1, y:sf0_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;12
				END
		'sfr0':		BEGIN
				store_data, prefix+'sfr0_sci'+p, data = {x:epoch5, y:sfr0_sci}, dlim = {ylog:1, labels:labels, panel_size:2.} ;13
				;store_data, prefix+'sfr0_eng'+p, data = {x:epoch1, y:sfr0_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;13
				END
		'stp0':		BEGIN
				store_data, prefix+'stp0_sci'+p, data = {x:epoch5, y:stp0_sci}, dlim = {ylog:1, labels:labels, panel_size:2.} ;14
				;store_data, prefix+'stp0_eng'+p, data = {x:epoch1, y:stp0_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;14
				END
		'ra_trig':	BEGIN
				store_data, prefix+'ra_trig_sci'+p, data = {x:epoch5, y:ra_trig_sci}, dlim = {ylog:1, labels:labels, panel_size:2.} ;15
				;store_data, prefix+'ra_trig_eng'+p, data = {x:epoch1, y:ra_trig_eng}, dlim = {ylog:1, labels:labels, panel_size:2.} ;15
				END
		'pos1_0':	BEGIN
				store_data, prefix+'pos1_0_sci'+p, data = {x:epoch5, y:pos1_0_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;16
				;store_data, prefix+'pos1_0_eng'+p, data = {x:epoch1, y:pos1_0_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;16
				END
		'pos1_1':	BEGIN
				store_data, prefix+'pos1_1_sci'+p, data = {x:epoch5, y:pos1_1_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;17
				;store_data, prefix+'pos1_1_eng'+p, data = {x:epoch1, y:pos1_1_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;17
				END
		'w_no_pos':	BEGIN
				store_data, prefix+'w_no_pos_sci'+p, data = {x:epoch5, y:w_no_pos_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;18
				;store_data, prefix+'w_no_pos_eng'+p, data = {x:epoch1, y:w_no_pos_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;18
				END
		'w_mult_pos':	BEGIN
				store_data, prefix+'w_mult_pos_sci'+p, data = {x:epoch5, y:w_mult_pos_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;19
				;store_data, prefix+'w_mult_pos_eng'+p, data = {x:epoch1, y:w_mult_pos_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;19
				END
		'w_valid':	BEGIN
				store_data, prefix+'w_valid_sci'+p, data = {x:epoch5, y:w_valid_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;20
				;store_data, prefix+'w_valid_eng'+p, data = {x:epoch1, y:w_valid_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;20
				END
		'sf2':		BEGIN
				store_data, prefix+'sf2_sci'+p, data = {x:epoch5, y:sf2_sci}, dlim = {ylog:1, labels:labels, panel_size:2.} ;21
				;store_data, prefix+'sf2_eng'+p, data = {x:epoch1, y:sf2_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;21
				END		
		'sfr2':		BEGIN
				store_data, prefix+'sfr2_sci'+p, data = {x:epoch5, y:sfr2_sci}, dlim = {ylog:1, labels:labels, panel_size:2.} ;22
				;store_data, prefix+'sfr2_eng'+p, data = {x:epoch1, y:sfr2_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;22
				END
		'stp2':		BEGIN
				store_data, prefix+'stp2_sci'+p, data = {x:epoch5, y:stp2_sci}, dlim = {ylog:1, labels:labels, panel_size:2.} ;23
				;store_data, prefix+'stp2_eng'+p, data = {x:epoch1, y:stp2_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;23
				END
		'pos2_0':	BEGIN
				store_data, prefix+'pos2_0_sci'+p, data = {x:epoch5, y:pos2_0_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;24
				;store_data, prefix+'pos2_0_eng'+p, data = {x:epoch1, y:pos2_0_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;24
				END
		'pos2_1':	BEGIN
				store_data, prefix+'pos2_1_sci'+p, data = {x:epoch5, y:pos2_1_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;25
				;store_data, prefix+'pos2_1_eng'+p, data = {x:epoch1, y:pos2_1_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;25
				END
		'pos2_2':	BEGIN
				store_data, prefix+'pos2_2_sci'+p, data = {x:epoch5, y:pos2_2_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;26
				;store_data, prefix+'pos2_2_eng'+p, data = {x:epoch1, y:pos2_2_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;26
				END
		'pos2_3':	BEGIN
				store_data, prefix+'pos2_3_sci'+p, data = {x:epoch5, y:pos2_3_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;27
				;store_data, prefix+'pos2_3_eng'+p, data = {x:epoch1, y:pos2_3_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;27
				END
		'pos3_0':	BEGIN
				store_data, prefix+'pos3_0_sci'+p, data = {x:epoch5, y:pos3_0_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;28
				;store_data, prefix+'pos3_0_eng'+p, data = {x:epoch1, y:pos3_0_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;28
				END
		'pos3_1':	BEGIN
				store_data, prefix+'pos3_1_sci'+p, data = {x:epoch5, y:pos3_1_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;29
				;store_data, prefix+'pos3_1_eng'+p, data = {x:epoch1, y:pos3_1_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;29
				END
		'pos3_2':	BEGIN
				store_data, prefix+'pos3_2_sci'+p, data = {x:epoch5, y:pos3_2_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;30
				;store_data, prefix+'pos3_2_eng'+p, data = {x:epoch1, y:pos3_2_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;30
				END
		'pos3_3':	BEGIN
				store_data, prefix+'pos3_3_sci'+p, data = {x:epoch5, y:pos3_3_sci}, dlim = {ylog:0, labels:labels, panel_size:2.} ;31
				;store_data, prefix+'pos3_3_eng'+p, data = {x:epoch1, y:pos3_3_eng}, dlim = {ylog:0, labels:labels, panel_size:2.} ;31
				END
		'pos1':		BEGIN
				store_data, prefix+'pos1_sci'+p, data = {x:epoch5, y:pos1_sci},dlim={ylog:1, labels:labels, panel_size:2.}
				END
		'pos2':		BEGIN
				store_data, prefix+'pos2_sci'+p, data = {x:epoch5, y:pos2_sci},dlim={ylog:1, labels:labels, panel_size:2.}
				END
		'pos3':		BEGIN
				store_data, prefix+'pos3_sci'+p, data = {x:epoch5, y:pos3_sci},dlim={ylog:1, labels:labels, panel_size:2.}
				END
		'stop0':	BEGIN
				store_data, prefix+'stop0_sci'+p, data = {x:epoch5, y:stop0_sci}, dlim = {ylog:0, labels:labels, panel_size:2.}
				;store_data, prefix+'stop0_eng'+p, data = {x:epoch1, y:stop0_eng}, dlim = {ylog:0, labels:labels, panel_size:2.}
				END
		'start0':	BEGIN
				store_data, prefix+'start0_sci'+p, data = {x:epoch5, y:start0_sci}, dlim = {ylog:0, labels:labels, panel_size:2.}
				;store_data, prefix+'start0_eng'+p, data = {x:epoch1, y:start0_eng}, dlim = {ylog:0, labels:labels, panel_size:2.}
				END
		'stop2':	BEGIN
				store_data, prefix+'stop2_sci'+p, data = {x:epoch5, y:stop2_sci}, dlim = {ylog:0, labels:labels, panel_size:2.}
				;store_data, prefix+'stop2_eng'+p, data = {x:epoch1, y:stop2_eng}, dlim = {ylog:0, labels:labels, panel_size:2.}
				END
		'start2':	BEGIN
				store_data, prefix+'start2_sci'+p, data = {x:epoch5, y:start2_sci}, dlim = {ylog:0, labels:labels, panel_size:2.}
				;store_data, prefix+'start2_eng'+p, data = {x:epoch1, y:start2_eng}, dlim = {ylog:0, labels:labels, panel_size:2.}
				END
		'sf0ra_trig':	BEGIN
				store_data, prefix+'sf0ra_trig_sci'+p, data = {x:epoch5, y:sf0ra_trig_sci}, dlim = {ylog:0, labels:labels, panel_size:2.}
				END
				
	ENDCASE
	ENDFOR

ENDFOR

store_data, prefix+'error5_mon', data = {x:epoch5, y:error5_mon}, dlim = {ylog:0, labels:labels, panel_size:2.}
;store_data, prefix+'error1', data = {x:epoch1, y:error1}, dlim = {ylog:0, labels:labels, panel_size:2.} ;0

END 
