;+
;PROCEDURE: make_mon_struct_full
;PURPOSE: Create tplot structures from data
;
;PARAMETERS:   sat : 'A' or 'B'
;
;CREATED BY: L. Ellis (make_moment_struct)
;
;LAST MODIFICATION: 07/05/2007
;
;MODIFICATION HISTORY:
;    10/14/2006 Created
;
;   December 2006 modified by K. Simunac for monitor rates
;	4 Jan, 2007:  modified to store error flags
;	12 Jan, 2007:  modified variable and program names to avoid confusion
;	24 Jan, 20007:  IMPORTANT FIX TO low/high indices
;	3 July, 2007	calls com_mon and share1_mon variables
;	5 July, 2007	corrected Hz conversion factor
;	31 July, 2008	modified Hz conversion factor
;				- previously conversion to Hz gave average counts per second during accumulation cycle
;				- new conversion gives counts/sec as though detector had larger solid angle and could
;				  observe all out-of-ecliptic angles simultaneously
;-


PRO make_mon_struct_full, HZ, sat, prod_mon_full, E_step
compile_opt strictarrsubs
COMMON share1_mon
COMMON com_mon

; CONVERSION TO COUNTS PER SECOND IF HZ = 1
IF (HZ EQ 0) THEN BEGIN
	factor1 = 1L
ENDIF ELSE BEGIN
	; 0.0128 seconds per defl step * 32 steps = 0.4096 seconds at each ESA step -- old conversion factor
	factor1 = 0.0128 ; modified 31 July, 2008 (KDCS) 
ENDELSE

low1=0L
high1=0L


FOR z=0,N_ELEMENTS(E_step)-1 DO BEGIN
low1 = (num_rows1_full)*E_step(z)
high1 = (num_rows1_full)*E_step(z)+num_rows1_full-1

;stop
prefix = ' '
IF (sat EQ 'A') THEN prefix = 'A_Monitor_Rate_Full_'
IF (sat EQ 'B') THEN prefix = 'B_Monitor_Rate_Full_'

IF sat EQ 'A' THEN BEGIN 

	epoch1 = epoch1_full_a
	error1 = error1_full_a

	FOR y=0, n_elements(prod_mon_full)-1 DO BEGIN
	CASE prod_mon_full(y) OF
	's_valid':  s_valid_full = (sum_defl_s_valid_a_full(low1:high1))/factor1 ;0
	's_e_not_req': s_e_not_req_full = (sum_defl_s_e_not_req_a_full(low1:high1))/factor1 ;1
	's_e_req': s_e_req_full = (sum_defl_s_e_req_a_full(low1:high1))/factor1 ;2
	's_no_pos': s_no_pos_full = (sum_defl_s_no_pos_a_full(low1:high1))/factor1 ;3
	's_mult_pos': s_mult_pos_full = (sum_defl_s_mult_pos_a_full(low1:high1))/factor1 ;4
	's_no_e': s_no_e_full = (sum_defl_s_no_e_a_full(low1:high1))/factor1 ;5
	's_mult_e': s_mult_e_full = (sum_defl_s_mult_e_a_full(low1:high1))/factor1 ;6
	'ra_sat_a': ra_sat_a_full = (sum_defl_ra_sat_a_a_full(low1:high1))/factor1 ;7
	'ra_sat_b': ra_sat_b_full = (sum_defl_ra_sat_b_a_full(low1:high1))/factor1 ;8
	'ra_sat_both': ra_sat_both_full = (sum_defl_ra_sat_both_a_full(low1:high1))/factor1 ;9
	'ssd_sw': ssd_sw_full = (sum_defl_ssd_sw_a_full(low1:high1))/factor1 ;10
	'ssd_st': ssd_st_full = (sum_defl_ssd_st_a_full(low1:high1))/factor1 ;11
	'sf0':  sf0_full = (sum_defl_sf0_a_full(low1:high1))/factor1 ;12
	'sfr0':  sfr0_full = (sum_defl_sfr0_a_full(low1:high1))/factor1 ;13
	'stp0': stp0_full = (sum_defl_stp0_a_full(low1:high1))/factor1 ;14
	'ra_trig': ra_trig_full = (sum_defl_ra_trig_a_full(low1:high1))/factor1 ;15
	'pos1_0':  pos1_0_full = (sum_defl_pos1_0_a_full(low1:high1))/factor1 ;16
	'pos1_1': pos1_1_full = (sum_defl_pos1_1_a_full(low1:high1))/factor1 ;17
	'w_no_pos': w_no_pos_full = (sum_defl_w_no_pos_a_full(low1:high1))/factor1 ;18
	'w_mult_pos': w_mult_pos_full = (sum_defl_w_mult_pos_a_full(low1:high1))/factor1 ;19
	'w_valid': w_valid_full = (sum_defl_w_valid_a_full(low1:high1))/factor1 ;20
	'sf2': sf2_full = (sum_defl_sf2_a_full(low1:high1))/factor1 ;21
	'sfr2':  sfr2_full = (sum_defl_sfr2_a_full(low1:high1))/factor1 ;22
	'stp2':  stp2_full = (sum_defl_stp2_a_full(low1:high1))/factor1 ;23
	'pos2_0': pos2_0_full = (sum_defl_pos2_0_a_full(low1:high1))/factor1 ;24
	'pos2_1': pos2_1_full = (sum_defl_pos2_1_a_full(low1:high1))/factor1 ;25
	'pos2_2': pos2_2_full = (sum_defl_pos2_2_a_full(low1:high1) )/factor1;26
	'pos2_3': pos2_3_full = (sum_defl_pos2_3_a_full(low1:high1))/factor1 ;27
	'pos2':   pos2_full = (sum_defl_pos2_a_full(low1:high1))/factor1
	'pos3_0': pos3_0_full = (sum_defl_pos3_0_a_full(low1:high1))/factor1 ;28
	'pos3_1': pos3_1_full = (sum_defl_pos3_1_a_full(low1:high1))/factor1 ;29
	'pos3_2': pos3_2_full = (sum_defl_pos3_2_a_full(low1:high1))/factor1 ;30
	'pos3_3': pos3_3_full = (sum_defl_pos3_3_a_full(low1:high1))/factor1 ;31	
	'pos3':   pos3_full = (sum_defl_pos3_a_full(low1:high1))/factor1
	'stop0':  stop0_full = (sum_defl_stop0_a_full(low1:high1))	
	'start0': start0_full = (sum_defl_start0_a_full(low1:high1))	
	'stop2':  stop2_full = (sum_defl_stop2_a_full(low1:high1))
	'start2': start2_full = (sum_defl_start2_a_full(low1:high1))	
	ENDCASE
	ENDFOR

ENDIF ELSE BEGIN 

	epoch1 = epoch1_full_b
	error1 = error1_full_b

	FOR y=0, n_elements(prod_mon_full)-1 DO BEGIN
	CASE prod_mon_full(y) OF
	's_valid':  s_valid_full = (sum_defl_s_valid_b_full(low1:high1))/factor1 ;0
	's_e_not_req': s_e_not_req_full = (sum_defl_s_e_not_req_b_full(low1:high1))/factor1 ;1
	's_e_req': s_e_req_full = (sum_defl_s_e_req_b_full(low1:high1))/factor1 ;2
	's_no_pos': s_no_pos_full = (sum_defl_s_no_pos_b_full(low1:high1))/factor1 ;3
	's_mult_pos': s_mult_pos_full = (sum_defl_s_mult_pos_b_full(low1:high1))/factor1 ;4
	's_no_e': s_no_e_full = (sum_defl_s_no_e_b_full(low1:high1))/factor1 ;5
	's_mult_e': s_mult_e_full = (sum_defl_s_mult_e_b_full(low1:high1))/factor1 ;6
	'ra_sat_a': ra_sat_a_full = (sum_defl_ra_sat_a_b_full(low1:high1))/factor1 ;7
	'ra_sat_b': ra_sat_b_full = (sum_defl_ra_sat_b_b_full(low1:high1))/factor1 ;8
	'ra_sat_both': ra_sat_both_full = (sum_defl_ra_sat_both_b_full(low1:high1))/factor1 ;9
	'ssd_sw': ssd_sw_full = (sum_defl_ssd_sw_b_full(low1:high1))/factor1 ;10
	'ssd_st': ssd_st_full = (sum_defl_ssd_st_b_full(low1:high1))/factor1 ;11
	'sf0':  sf0_full = (sum_defl_sf0_b_full(low1:high1))/factor1 ;12
	'sfr0':  sfr0_full = (sum_defl_sfr0_b_full(low1:high1))/factor1 ;13
	'stp0': stp0_full = (sum_defl_stp0_b_full(low1:high1))/factor1 ;14
	'ra_trig': ra_trig_full = (sum_defl_ra_trig_b_full(low1:high1))/factor1 ;15
	'pos1_0': pos1_0_full = (sum_defl_pos1_0_b_full(low1:high1))/factor1 ;16
	'pos1_1': pos1_1_full = (sum_defl_pos1_1_b_full(low1:high1))/factor1 ;17
	'w_no_pos': w_no_pos_full = (sum_defl_w_no_pos_b_full(low1:high1))/factor1 ;18
	'w_mult_pos': w_mult_pos_full = (sum_defl_w_mult_pos_b_full(low1:high1))/factor1 ;19
	'w_valid': w_valid_full = (sum_defl_w_valid_b_full(low1:high1))/factor1 ;20
	'sf2': sf2_full = (sum_defl_sf2_b_full(low1:high1))/factor1 ;21
	'sfr2':  sfr2_full = (sum_defl_sfr2_b_full(low1:high1))/factor1 ;22
	'stp2':  stp2_full = (sum_defl_stp2_b_full(low1:high1))/factor1 ;23
	'pos2_0': pos2_0_full = (sum_defl_pos2_0_b_full(low1:high1))/factor1 ;24
	'pos2_1': pos2_1_full = (sum_defl_pos2_1_b_full(low1:high1))/factor1 ;25
	'pos2_2': pos2_2_full = (sum_defl_pos2_2_b_full(low1:high1) )/factor1;26
	'pos2_3': pos2_3_full = (sum_defl_pos2_3_b_full(low1:high1))/factor1 ;27
	'pos2':   pos2_full = (sum_defl_pos2_b_full(low1:high1))/factor1
	'pos3_0': pos3_0_full = (sum_defl_pos3_0_b_full(low1:high1))/factor1 ;28
	'pos3_1': pos3_1_full = (sum_defl_pos3_1_b_full(low1:high1))/factor1 ;29
	'pos3_2': pos3_2_full = (sum_defl_pos3_2_b_full(low1:high1))/factor1 ;30
	'pos3_3': pos3_3_full = (sum_defl_pos3_3_b_full(low1:high1))/factor1 ;31	
	'pos3':   pos3_full = (sum_defl_pos3_b_full(low1:high1))/factor1
	'stop0':  stop0_full = (sum_defl_stop0_b_full(low1:high1))	
	'start0': start0_full = (sum_defl_start0_b_full(low1:high1))	
	'stop2':  stop2_full = (sum_defl_stop2_b_full(low1:high1))
	'start2': start2_full = (sum_defl_start2_b_full(low1:high1))	
	ENDCASE
	ENDFOR

ENDELSE 

p=' '
	CASE E_step(z) OF
		0: p = '_0'
		1: p = '_1'
		2: p = '_2'
		3: p = '_3'
		4: p = '_4'
		5: p = '_5'
		6: p = '_6'
		7: p = '_7'
		8: p = '_8'
		9: p = '_9'
		10: p = '_10'
		11: p = '_11'
		12: p = '_12'
		13: p = '_13'
		14: p = '_14'
		15: p = '_15'
		16: p = '_16'
		17: p = '_17'
		18: p = '_18'
		19: p = '_19'
		20: p = '_20'
		21: p = '_21'
		22: p = '_22'
		23: p = '_23'
		24: p = '_24'
		25: p = '_25'
		26: p = '_26'
		27: p = '_27'
		28: p = '_28'
		29: p = '_29'
		30: p = '_30'
		31: p = '_31'
		40: p = '_40'
		41: p = '_41'
		42: p = '_42'
		43: p = '_43'
		44: p = '_44'
		45: p = '_45'
		46: p = '_46'
		47: p = '_47'
		48: p = '_48'
		49: p = '_49'
		50: p = '_50'
		51: p = '_51'
		52: p = '_52'
		53: p = '_53'
		54: p = '_54'
		55: p = '_55'
		56: p = '_56'
		57: p = '_57'
		58: p = '_58'
		59: p = '_59'
		60: p = '_60'
		61: p = '_61'
		62: p = '_62'
		63: p = '_63'
		64: p = '_64'
		65: p = '_65'
		66: p = '_66'
		67: p = '_67'
		68: p = '_68'
		69: p = '_69'
		70: p = '_70'
		71: p = '_71'
		72: p = '_72'
		73: p = '_73'
		74: p = '_74'
		75: p = '_75'
		76: p = '_76'
		77: p = '_77'
		78: p = '_78'
		79: p = '_79'
		80: p = '_80'
		81: p = '_81'
		82: p = '_82'
		83: p = '_83'
		84: p = '_84'
		85: p = '_85'
		86: p = '_86'
		87: p = '_87'
		88: p = '_88'
		89: p = '_89'
		90: p = '_90'
		91: p = '_91'
		92: p = '_92'
		93: p = '_93'
		94: p = '_94'
		95: p = '_95'
		96: p = '_96'
		97: p = '_97'
		98: p = '_98'
		99: p = '_99'
		100: p = '_100'
		101: p = '_101'
		102: p = '_102'
		103: p = '_103'
		104: p = '_104'
		105: p = '_105'
		106: p = '_106'
		107: p = '_107'
		108: p = '_108'
		109: p = '_109'
		110: p = '_110'
		111: p = '_111'
		112: p = '_112'
		113: p = '_113'
		114: p = '_114'
		115: p = '_115'
		116: p = '_116'
		117: p = '_117'
		118: p = '_118'
		119: p = '_119'
		120: p = '_120'
		121: p = '_121'
		122: p = '_122'
		123: p = '_123'
		124: p = '_124'
		125: p = '_125'
		126: p = '_126'
		127: p = '_127'
		
	ENDCASE
labels = ' '


	FOR i=0, n_elements(prod_mon_full)-1 DO BEGIN
	CASE prod_mon_full(i) OF
		's_valid':	store_data, prefix+'s_valid_full'+p, data = {x:epoch1, y:s_valid_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;0
		's_e_not_req':	store_data, prefix+'s_e_not_req_full'+p, data = {x:epoch1, y:s_e_not_req_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;1				
		's_e_req':	store_data, prefix+'s_e_req_full'+p, data = {x:epoch1, y:s_e_req_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;2
		's_no_pos':	store_data, prefix+'s_no_pos_full'+p, data = {x:epoch1, y:s_no_pos_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;3
		's_mult_pos':	store_data, prefix+'s_mult_pos_full'+p, data = {x:epoch1, y:s_mult_pos_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;4
		's_no_e':	store_data, prefix+'s_no_e_full'+p, data = {x:epoch1, y:s_no_e_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;5
		's_mult_e':	store_data, prefix+'s_mult_e_full'+p, data = {x:epoch1, y:s_mult_e_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;6
		'ra_sat_a':	store_data, prefix+'ra_sat_a_full'+p, data = {x:epoch1, y:ra_sat_a_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;7
		'ra_sat_b':	store_data, prefix+'ra_sat_b_full'+p, data = {x:epoch1, y:ra_sat_b_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;8
		'ra_sat_both':	store_data, prefix+'ra_sat_both_full'+p, data = {x:epoch1, y:ra_sat_both_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;9
		'ssd_sw':	store_data, prefix+'ssd_sw_full'+p, data = {x:epoch1, y:ssd_sw_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;10
		'ssd_st':	store_data, prefix+'ssd_st_full'+p, data = {x:epoch1, y:ssd_st_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;11
		'sf0':		store_data, prefix+'sf0_full'+p, data = {x:epoch1, y:sf0_full}, dlim = {ylog:1, labels:labels, panel_size:2.} ;12
		'sfr0':		store_data, prefix+'sfr0_full'+p, data = {x:epoch1, y:sfr0_full}, dlim = {ylog:1, labels:labels, panel_size:2.} ;13
		'stp0':		store_data, prefix+'stp0_full'+p, data = {x:epoch1, y:stp0_full}, dlim = {ylog:1, labels:labels, panel_size:2.} ;14
		'ra_trig':	store_data, prefix+'ra_trig_full'+p, data = {x:epoch1, y:ra_trig_full}, dlim = {ylog:1, labels:labels, panel_size:2.} ;15
		'pos1_0':	store_data, prefix+'pos1_0_full'+p, data = {x:epoch1, y:pos1_0_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;16
		'pos1_1':	store_data, prefix+'pos1_1_full'+p, data = {x:epoch1, y:pos1_1_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;17
		'w_no_pos':	store_data, prefix+'w_no_pos_full'+p, data = {x:epoch1, y:w_no_pos_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;18
		'w_mult_pos':	store_data, prefix+'w_mult_pos_full'+p, data = {x:epoch1, y:w_mult_pos_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;19
		'w_valid':	store_data, prefix+'w_valid_full'+p, data = {x:epoch1, y:w_valid_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;20
		'sf2':		store_data, prefix+'sf2_full'+p, data = {x:epoch1, y:sf2_full}, dlim = {ylog:1, labels:labels, panel_size:2.} ;21
		'sfr2':		store_data, prefix+'sfr2_full'+p, data = {x:epoch1, y:sfr2_full}, dlim = {ylog:1, labels:labels, panel_size:2.} ;22
		'stp2':		store_data, prefix+'stp2_full'+p, data = {x:epoch1, y:stp2_full}, dlim = {ylog:1, labels:labels, panel_size:2.} ;23
		'pos2_0':	store_data, prefix+'pos2_0_full'+p, data = {x:epoch1, y:pos2_0_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;24
		'pos2_1':	store_data, prefix+'pos2_1_full'+p, data = {x:epoch1, y:pos2_1_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;25
		'pos2_2':	store_data, prefix+'pos2_2_full'+p, data = {x:epoch1, y:pos2_2_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;26
		'pos2_3':	store_data, prefix+'pos2_3_full'+p, data = {x:epoch1, y:pos2_3_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;27
		'pos3_0':	store_data, prefix+'pos3_0_full'+p, data = {x:epoch1, y:pos3_0_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;28
		'pos3_1':	store_data, prefix+'pos3_1_full'+p, data = {x:epoch1, y:pos3_1_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;29
		'pos3_2':	store_data, prefix+'pos3_2_full'+p, data = {x:epoch1, y:pos3_2_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;30
		'pos3_3':	store_data, prefix+'pos3_3_full'+p, data = {x:epoch1, y:pos3_3_full}, dlim = {ylog:0, labels:labels, panel_size:2.} ;31
		'pos2':		store_data, prefix+'pos2_full'+p, data = {x:epoch1, y:pos2_full},dlim={ylog:1, labels:labels, panel_size:2.}
		'pos3':		store_data, prefix+'pos3_full'+p, data = {x:epoch1, y:pos3_full},dlim={ylog:1, labels:labels, panel_size:2.}
		'stop0':	store_data, prefix+'stop0_full'+p, data = {x:epoch1, y:stop0_full}, dlim = {ylog:0, labels:labels, panel_size:2.}
		'start0':	store_data, prefix+'start0_full'+p, data = {x:epoch1, y:start0_full}, dlim = {ylog:0, labels:labels, panel_size:2.}
		'stop2':	store_data, prefix+'stop2_full'+p, data = {x:epoch1, y:stop2_full}, dlim = {ylog:0, labels:labels, panel_size:2.}
		'start2':	store_data, prefix+'start2_full'+p, data = {x:epoch1, y:start2_full}, dlim = {ylog:0, labels:labels, panel_size:2.}

	ENDCASE
	ENDFOR

ENDFOR

store_data, prefix+'error1', data = {x:epoch1, y:error1}, dlim = {ylog:0, labels:labels, panel_size:2.} ;0
END 
