;+
;PROCEDURE: make_dig_hk_struct
;PURPOSE: Create tplot structures from data
;
;PARAMETERS:   sat : 'A' or 'B'
;
;CREATED BY: L. Ellis (make_moment_struct)
;
;LAST MODIFICATION: 07/03/2007
;
;MODIFICATION HISTORY:
;    10/14/2006 Created
;
;   November 2006 modified by K. Simunac for housekeeping data
;	12 Jan, 2007	modified variable names to avoid confusion
;	3 July, 2007	calls com_mon and share1_mon variables

PRO make_dig_hk_struct, sat, prod_dig_hk
compile_opt strictarrsubs
prefix = ' '

IF (sat EQ 'A') THEN prefix = 'A_DIG_HK_'
IF (sat EQ 'B') THEN prefix = 'B_DIG_HK_'

COMMON share1_mon
COMMON com_mon
IF sat EQ 'A' THEN BEGIN 
	epoch1 = epoch1_dig_hk_a ; used to be epoch1_a

	FOR i=0, n_elements(prod_dig_hk)-1 DO BEGIN
	CASE prod_dig_hk(i) OF

	'dpu_sw_version':  dpu_sw_version = dpu_sw_version_a             ; 0 
        'cmd_rcvd_cnt':  cmd_rcvd_cnt = cmd_rcvd_cnt_a                 ; 1
        'cmd_exec_cnt':  cmd_exec_cnt = cmd_exec_cnt_a                 ; 2
        'cmd_total_err_cnt':  cmd_total_err_cnt = cmd_total_err_cnt_a       ; 3
        'cmd_parity_err_cnt':  cmd_parity_err_cnt = cmd_parity_err_cnt_a     ; 4
        'cmd_frame_err_cnt':  cmd_frame_err_cnt = cmd_frame_err_cnt_a       ; 5
        'cmd_illegal_err_cnt':  cmd_illegal_err_cnt = cmd_illegal_err_cnt_a   ; 6
        'ic_status_reg':  ic_status_reg = ic_status_reg_a               ; 7
        'ic_ctl_reg':  ic_ctl_reg = ic_ctl_reg_a                     ; 8
        'lbc_reset_ctl':  lbc_reset_ctl = lbc_reset_ctl_a               ; 9
        'lbc_mode_ctl':  lbc_mode_ctl = lbc_mode_ctl_a                 ; 10
        'lbc_logic_ctl_a':  lbc_logic_ctl_a = lbc_logic_ctl_a_a           ; 11
        'lbc_logic_ctl_b':  lbc_logic_ctl_b = lbc_logic_ctl_b_a           ; 12
        'lbc_tac_pwr_ctl':  lbc_tac_pwr_ctl = lbc_tac_pwr_ctl_a           ; 13
        'lbc_reg_seq':  lbc_reg_seq = lbc_reg_seq_a                   ; 14
        'lbc_event_ctl':  lbc_event_ctl = lbc_event_ctl_a               ; 15
        'lbc_rlim_ch':  lbc_rlim_ch = lbc_rlim_ch_a                   ; 16
        'lbc_rlim_hi':  lbc_rlim_hi = lbc_rlim_hi_a                   ; 17
        'lbc_rlim_lo':  lbc_rlim_lo = lbc_rlim_lo_a                   ; 18
        'lbe_pos_ctrl':  lbe_pos_ctrl = lbe_pos_ctrl_a                 ; 19
        'lbe_pos_disable0':  lbe_pos_disable0 = lbe_pos_disable0_a         ; 20
        'lbe_pos_disable2':  lbe_pos_disable2 = lbe_pos_disable2_a         ; 21
        'lbe_tac0_ctrl':  lbe_tac0_ctrl = lbe_tac0_ctrl_a               ; 22
        'lbe_tac0_dac':  lbe_tac0_dac = lbe_tac0_dac_a                 ; 23
        'lbe_tac2_ctrl':  lbe_tac2_ctrl = lbe_tac2_ctrl_a               ; 24
        'lbe_tac2_dac':  lbe_tac2_dac = lbe_tac2_dac_a                 ; 25
        'lbe_tac0_under_hi':  lbe_tac0_under_hi = lbe_tac0_under_hi_a       ; 26
        'lbe_tac0_under_lo':  lbe_tac0_under_lo = lbe_tac0_under_lo_a       ; 27
        'lbe_tac0_over_hi':  lbe_tac0_over_hi = lbe_tac0_over_hi_a         ; 28
        'lbe_tac0_over_lo':  lbe_tac0_over_lo = lbe_tac0_over_lo_a         ; 29
        'lbe_tac2_under_hi':  lbe_tac2_under_hi = lbe_tac2_under_hi_a       ; 30
        'lbe_tac2_under_lo':  lbe_tac2_under_lo = lbe_tac2_under_lo_a       ; 31
        'lbe_tac2_over_hi':  lbe_tac2_over_hi = lbe_tac2_over_hi_a         ; 32
        'lbe_tac2_over_lo':  lbe_tac2_over_lo = lbe_tac2_over_lo_a         ; 33
        'lbe_ssd_ctrl':  lbe_ssd_ctrl = lbe_ssd_ctrl_a                 ; 34
        'lbe_ssd_cmd_h':  lbe_ssd_cmd_h = lbe_ssd_cmd_h_a               ; 35
        'lbe_ssd_cmd_l':  lbe_ssd_cmd_l = lbe_ssd_cmd_l_a               ; 36
        'lbe_ssd_dis':  lbe_ssd_dis = lbe_ssd_dis_a                   ; 37
        'lbe_ssd_under_hi':  lbe_ssd_under_hi = lbe_ssd_under_hi_a         ; 38
        'lbe_ssd_under_lo':  lbe_ssd_under_lo = lbe_ssd_under_lo_a         ; 39
        'lbe_ssd_over_hi':  lbe_ssd_over_hi = lbe_ssd_over_hi_a           ; 40
        'lbe_ssd_over_lo':  lbe_ssd_over_lo = lbe_ssd_over_lo_a           ; 41
        'lbe_sel_ctrl':  lbe_sel_ctrl = lbe_sel_ctrl_a                 ; 42
        'lbe_trig_mode':  lbe_trig_mode = lbe_trig_mode_a               ; 43
        'lbe_esa_step':  lbe_esa_step = lbe_esa_step_a                 ; 44
        'lbe_defl_step':  lbe_defl_step = lbe_defl_step_a               ; 45
        'lbe_ssd_offset0':  lbe_ssd_offset0 = lbe_ssd_offset0_a           ; 46
        'lbe_ssd_offset1':  lbe_ssd_offset1 = lbe_ssd_offset1_a           ; 47
        'lbe_ssd_offset2':  lbe_ssd_offset2 = lbe_ssd_offset2_a           ; 48
        'lbe_ssd_offset3':  lbe_ssd_offset3 = lbe_ssd_offset3_a           ; 49
        'lbe_ssd_offset4':  lbe_ssd_offset4 = lbe_ssd_offset4_a           ; 50
        'lbe_ssd_offset5':  lbe_ssd_offset5 = lbe_ssd_offset5_a           ; 51
        'lbe_ssd_offset6':  lbe_ssd_offset6 = lbe_ssd_offset6_a           ; 52
        'lbe_ssd_offset7':  lbe_ssd_offset7 = lbe_ssd_offset7_a           ; 53
        'lbe_stim_enable':  lbe_stim_enable = lbe_stim_enable_a           ; 54
        'lbe_stim_freq_hi':  lbe_stim_freq_hi = lbe_stim_freq_hi_a         ; 55
        'lbe_stim_freq_lo':  lbe_stim_freq_lo = lbe_stim_freq_lo_a         ; 56
        'lbe_sel0_window':  lbe_sel0_window = lbe_sel0_window_a           ; 57
        'lbe_sel2_window':  lbe_sel2_window = lbe_sel2_window_a           ; 58
        'lbe_ssd_offset8':  lbe_ssd_offset8 = lbe_ssd_offset8_a           ; 59
        'lbe_ssd_offset9':  lbe_ssd_offset9 = lbe_ssd_offset9_a           ; 60
        'lbe_ssd_offset10':  lbe_ssd_offset10 = lbe_ssd_offset10_a         ; 61
        'lbe_ssd_offset11':  lbe_ssd_offset11 = lbe_ssd_offset11_a         ; 62
        'lbe_ssd_offset12':  lbe_ssd_offset12 = lbe_ssd_offset12_a         ; 63
        'lbe_ssd_offset13':  lbe_ssd_offset13 = lbe_ssd_offset13_a         ; 64
        'lbe_ssd_offset14':  lbe_ssd_offset14 = lbe_ssd_offset14_a         ; 65
        'lbe_ssd_offset15':  lbe_ssd_offset15 = lbe_ssd_offset15_a         ; 66
        'lbe_pos_ra':  lbe_pos_ra = lbe_pos_ra_a                     ; 67
        'dacm_pac_mcp_ssd_ctl_mcp_limit':  dacm_pac_mcp_ssd_ctl_mcp_limit = dacm_pac_mcp_ssd_ctl_mcp_limit_a  ; 68
        'dacm_pac_limit':  dacm_pac_limit = dacm_pac_limit_a             ; 69
        'dacm_esa_ctl':  dacm_esa_ctl = dacm_esa_ctl_a                 ; 70
        'dacm_s_ch_ctl':  dacm_s_ch_ctl = dacm_s_ch_ctl_a               ; 71
        'dacm_dfl_1_ctl':  dacm_dfl_1_ctl = dacm_dfl_1_ctl_a             ; 72
        'dacm_dfl_2_ctl':  dacm_dfl_2_ctl = dacm_dfl_2_ctl_a             ; 73
        'dacm_control':  dacm_control = dacm_control_a                ; 74
        'dacm_status':  dacm_status = dacm_status_a                   ; 75
        'dacm_adc_lu_ctr':  dacm_adc_lu_ctr = dacm_adc_lu_ctr_a           ; 76
        'dacm_dfl_1_offset':  dacm_dfl_1_offset = dacm_dfl_1_offset_a       ; 77
        'dacm_dfl_2_offset':  dacm_dfl_2_offset = dacm_dfl_2_offset_a       ; 78
        'dacm_pac_coarse':  dacm_pac_coarse = dacm_pac_coarse_a           ; 79
        'dacm_pac_fine':  dacm_pac_fine = dacm_pac_fine_a               ; 80
        'dacm_pac_cm_fs_coarse':  dacm_pac_cm_fs_coarse = dacm_pac_cm_fs_coarse_a           ; 81
        'dacm_pac_cm_fs_fine':  dacm_pac_cm_fs_fine = dacm_pac_cm_fs_fine_a   ; 82
        'dacm_mcp_coarse':  dacm_mcp_coarse = dacm_mcp_coarse_a           ; 83
        'dacm_mcp_fine':  dacm_mcp_fine = dacm_mcp_fine_a               ; 84
        'dacm_mcp_cm_fs_coarse':  dacm_mcp_cm_fs_coarse = dacm_mcp_cm_fs_coarse_a           ; 85
        'dacm_mcp_cm_fs_fine':  dacm_mcp_cm_fs_fine = dacm_mcp_cm_fs_fine_a   ; 86
        'dacm_ssd_coarse':  dacm_ssd_coarse = dacm_ssd_coarse_a           ; 87
        'dacm_ssd_fine':  dacm_ssd_fine = dacm_ssd_fine_a               ; 88
        'dacm_esa_coarse':  dacm_esa_coarse = dacm_esa_coarse_a           ; 89
        'dacm_esa_fine':  dacm_esa_fine = dacm_esa_fine_a               ; 90
        'dacm_s_ch_coarse':  dacm_s_ch_coarse = dacm_s_ch_coarse_a         ; 91
        'dacm_s_ch_fine':  dacm_s_ch_fine = dacm_s_ch_fine_a             ; 92
        'dacm_s_ch_tap_coarse':  dacm_s_ch_tap_coarse = dacm_s_ch_tap_coarse_a ; 93
        'dacm_s_ch_tap_fine':  dacm_s_ch_tap_fine = dacm_s_ch_tap_fine_a     ; 94
        'dacm_dfl_1_coarse':  dacm_dfl_1_coarse = dacm_dfl_1_coarse_a       ; 95
        'dacm_dfl_1_fine':  dacm_dfl_1_fine = dacm_dfl_1_fine_a           ; 96
        'dacm_dfl_1_dfine':  dacm_dfl_1_dfine = dacm_dfl_1_dfine_a         ; 97
        'dacm_dfl_2_coarse':  dacm_dfl_2_coarse = dacm_dfl_2_coarse_a       ; 98
        'dacm_dfl_2_fine':  dacm_dfl_2_fine = dacm_dfl_2_fine_a           ; 99
        'dacm_dfl_2_dfine':  dacm_dfl_2_dfine = dacm_dfl_2_dfine_a         ; 100
        'dacr_pac_mcp_ssd_ctl_mcp_limit':  dacr_pac_mcp_ssd_ctl_mcp_limit = dacr_pac_mcp_ssd_ctl_mcp_limit_a  ; 101
        'dacr_pac_limit':  dacr_pac_limit = dacr_pac_limit_a             ; 102
        'dacr_esa_ctl':  dacr_esa_ctl = dacr_esa_ctl_a                 ; 103
        'dacr_s_ch_ctl':  dacr_s_ch_ctl = dacr_s_ch_ctl_a               ; 104
        'dacr_dfl_1_ctl':  dacr_dfl_1_ctl = dacr_dfl_1_ctl_a             ; 105
        'dacr_dfl_2_ctl':  dacr_dfl_2_ctl = dacr_dfl_2_ctl_a             ; 106
        'dacr_control':  dacr_control = dacr_control_a                 ; 107
        'dacr_status':  dacr_status = dacr_status_a                   ; 108
        'dacr_adc_lu_ctr':  dacr_adc_lu_ctr = dacr_adc_lu_ctr_a           ; 109
        'dacr_dfl_1_offset':  dacr_dfl_1_offset = dacr_dfl_1_offset_a       ; 110
        'dacr_dfl_2_offset':  dacr_dfl_2_offset = dacr_dfl_2_offset_a       ; 111
        'dacr_c_pac_coarse':  dacr_c_pac_coarse = dacr_c_pac_coarse_a       ; 112
        'dacr_c_pac_fine':  dacr_c_pac_fine = dacr_c_pac_fine_a           ; 113
        'dacr_c_pac_cm_fs_coarse':  dacr_c_pac_cm_fs_coarse = dacr_c_pac_cm_fs_coarse_a         ; 114
        'dacr_c_pac_cm_fs_fine':  dacr_c_pac_cm_fs_fine = dacr_c_pac_cm_fs_fine_a		  ; 115
        'dacr_c_mcp_coarse':  dacr_c_mcp_coarse = dacr_c_mcp_coarse_a       ; 116
        'dacr_c_mcp_fine':  dacr_c_mcp_fine = dacr_c_mcp_fine_a           ; 117
        'dacr_c_mcp_cm_fs_coarse':  dacr_c_mcp_cm_fs_coarse = dacr_c_mcp_cm_fs_coarse_a         ; 118
        'dacr_c_mcp_cm_fs_fine':  dacr_c_mcp_cm_fs_fine = dacr_c_mcp_cm_fs_fine_a           ; 119
        'dacr_c_ssd_coarse':  dacr_c_ssd_coarse = dacr_c_ssd_coarse_a       ; 120
        'dacr_c_ssd_fine':  dacr_c_ssd_fine = dacr_c_ssd_fine_a           ; 121
        'dacr_c_esa_coarse':  dacr_c_esa_coarse = dacr_c_esa_coarse_a       ; 122
        'dacr_c_esa_fine':  dacr_c_esa_fine = dacr_c_esa_fine_a           ; 123
        'dacr_c_s_ch_coarse':  dacr_c_s_ch_coarse = dacr_c_s_ch_coarse_a     ; 124
        'dacr_c_s_ch_fine':  dacr_c_s_ch_fine = dacr_c_s_ch_fine_a         ; 125
        'dacr_c_s_ch_tap_coarse':  dacr_c_s_ch_tap_coarse = dacr_c_s_ch_tap_coarse_a          ; 126
        'dacr_c_s_ch_tap_fine':  dacr_c_s_ch_tap_fine = dacr_c_s_ch_tap_fine_a ; 127
        'dacr_dfl_1_coarse':  dacr_dfl_1_coarse = dacr_dfl_1_coarse_a       ; 128
        'dacr_dfl_1_fine':  dacr_dfl_1_fine = dacr_dfl_1_fine_a           ; 129
        'dacr_dfl_1_dfine':  dacr_dfl_1_dfine = dacr_dfl_1_dfine_a         ; 130
        'dacr_dfl_2_coarse':  dacr_dfl_2_coarse = dacr_dfl_2_coarse_a       ; 131
        'dacr_dfl_2_fine':  dacr_dfl_2_fine = dacr_dfl_2_fine_a           ; 132
        'dacr_dfl_2_dfine':  dacr_dfl_2_dfine = dacr_dfl_2_dfine_a         ; 133
        'sw_status1':  sw_status1 = sw_status1_a                     ; 134
        'sw_hv_ramp_status':  sw_hv_ramp_status = sw_hv_ramp_status_a       ; 135
        'sw_hv_enable_status':  sw_hv_enable_status = sw_hv_enable_status_a   ; 136
        'sw_hv_limit_status':  sw_hv_limit_status = sw_hv_limit_status_a     ; 137
        'sw_eepromchksum':  sw_eepromchksum = sw_eepromchksum_a           ; 138
        'hkp_sampletime':  hkp_sampletime = hkp_sampletime_a             ; 139
        'pac_discharge_status':  pac_discharge_status = pac_discharge_status_a ; 140
        'pac_discharge_cnt':  pac_discharge_cnt = pac_discharge_cnt_a       ; 141
        'pac_discharge_conseccntr':  pac_discharge_conseccntr = pac_discharge_conseccntr_a        ; 142
        'pac_discharge_safe_att':  pac_discharge_safe_att = pac_discharge_safe_att_a          ; 143
        'analog_limit_status':  analog_limit_status = analog_limit_status_a   ; 144
        'analog_lim_pt1_status':  analog_lim_pt1_status = analog_lim_pt1_status_a		  ; 145
        'analog_lim_pt1_id':  analog_lim_pt1_id = analog_lim_pt1_id_a       ; 146
        'analog_lim_pt1_red':  analog_lim_pt1_red = analog_lim_pt1_red_a     ; 147
        'analog_lim_pt2_status':  analog_lim_pt2_status = analog_lim_pt2_status_a           ; 148
        'analog_lim_pt2_id':  analog_lim_pt2_id = analog_lim_pt2_id_a       ; 149
        'analog_lim_pt2_red':  analog_lim_pt2_red = analog_lim_pt2_red_a     ; 150
        'analog_lim_pt3_status':  analog_lim_pt3_status = analog_lim_pt3_status_a           ; 151
        'analog_lim_pt3_id':  analog_lim_pt3_id = analog_lim_pt3_id_a       ; 152
        'analog_lim_pt3_red':  analog_lim_pt3_red = analog_lim_pt3_red_a     ; 153
        'analog_lim_pt4_status':  analog_lim_pt4_status = analog_lim_pt4_status_a           ; 154
        'analog_lim_pt4_id':  analog_lim_pt4_id = analog_lim_pt4_id_a       ; 155
        'analog_lim_pt4_red':  analog_lim_pt4_red = analog_lim_pt4_red_a     ; 156
        'analog_lim_pt5_status':  analog_lim_pt5_status = analog_lim_pt5_status_a           ; 157
        'analog_lim_pt5_id':  analog_lim_pt5_id = analog_lim_pt5_id_a       ; 158
        'analog_lim_pt5_red':  analog_lim_pt5_red = analog_lim_pt5_red_a     ; 159
        'analog_lim_pt6_status':  analog_lim_pt6_status = analog_lim_pt6_status_a           ; 160
        'analog_lim_pt6_id':  analog_lim_pt6_id = analog_lim_pt6_id_a       ; 161
        'analog_lim_pt6_red':  analog_lim_pt6_red = analog_lim_pt6_red_a     ; 162
        'analog_lim_pt7_status':  analog_lim_pt7_status = analog_lim_pt7_status_a           ; 163
        'analog_lim_pt7_id':  analog_lim_pt7_id = analog_lim_pt7_id_a       ; 164
        'analog_lim_pt7_red':  analog_lim_pt7_red = analog_lim_pt7_red_a     ; 165
        'analog_lim_pt8_status':  analog_lim_pt8_status = analog_lim_pt8_status_a           ; 166
        'analog_lim_pt8_id':  analog_lim_pt8_id = analog_lim_pt8_id_a       ; 167
        'analog_lim_pt8_red':  analog_lim_pt8_red = analog_lim_pt8_red_a     ; 168
        'analog_lim_pt9_status':  analog_lim_pt9_status = analog_lim_pt9_status_a           ; 169
        'analog_lim_pt9_id':  analog_lim_pt9_id = analog_lim_pt9_id_a       ; 170
        'analog_lim_pt9_red':  analog_lim_pt9_red = analog_lim_pt9_red_a     ; 171
        'analog_lim_pt10_status':  analog_lim_pt10_status = analog_lim_pt10_status_a          ; 172
        'analog_lim_pt10_id':  analog_lim_pt10_id = analog_lim_pt10_id_a     ; 173
        'analog_lim_pt10_red':  analog_lim_pt10_red = analog_lim_pt10_red_a   ; 174
        'analog_lim_pt11_status':  analog_lim_pt11_status = analog_lim_pt11_status_a          ; 175
        'analog_lim_pt11_id':  analog_lim_pt11_id = analog_lim_pt11_id_a     ; 176
        'analog_lim_pt11_red':  analog_lim_pt11_red = analog_lim_pt11_red_a   ; 177
        'analog_lim_pt12_status':  analog_lim_pt12_status = analog_lim_pt12_status_a          ; 178
        'analog_lim_pt12_id':  analog_lim_pt12_id = analog_lim_pt12_id_a     ; 179
        'analog_lim_pt12_red':  analog_lim_pt12_red = analog_lim_pt12_red_a   ; 180
        'analog_lim_pt13_status':  analog_lim_pt13_status = analog_lim_pt13_status_a          ; 181
        'analog_lim_pt13_id':  analog_lim_pt13_id = analog_lim_pt13_id_a     ; 182
        'analog_lim_pt13_red':  analog_lim_pt13_red = analog_lim_pt13_red_a   ; 183
        'analog_lim_pt14_status':  analog_lim_pt14_status = analog_lim_pt14_status_a          ; 184
        'analog_lim_pt14_id':  analog_lim_pt14_id = analog_lim_pt14_id_a     ; 185
        'analog_lim_pt14_red':  analog_lim_pt14_red = analog_lim_pt14_red_a   ; 186
        'analog_lim_pt15_status':  analog_lim_pt15_status = analog_lim_pt15_status_a          ; 187
        'analog_lim_pt15_id':  analog_lim_pt15_id = analog_lim_pt15_id_a     ; 188
        'analog_lim_pt15_red':  analog_lim_pt15_red = analog_lim_pt15_red_a   ; 189
        'opmode':  opmode = opmode_a                             ; 190
        'sw_mode':  sw_mode = sw_mode_a                           ; 191
        'proton_mode':  proton_mode = proton_mode_a                   ; 192
        'active_supplyid':  active_supplyid = active_supplyid_a           ; 193
        'supply_coarse_rb':  supply_coarse_rb = supply_coarse_rb_a         ; 194
        'supply_fine_rb':  supply_fine_rb = supply_fine_rb_a             ; 195
        'swmaint_supplystat':  swmaint_supplystat = swmaint_supplystat_a     ; 196
        'swmaint_pac_coarse':  swmaint_pac_coarse = swmaint_pac_coarse_a     ; 197
        'swmaint_pac_fine':  swmaint_pac_fine = swmaint_pac_fine_a         ; 198
   
	ENDCASE
	ENDFOR

ENDIF ELSE BEGIN 
	epoch1 = epoch1_dig_hk_b ; used to be epoch1_b

	FOR i=0, n_elements(prod_dig_hk)-1 DO BEGIN
	CASE prod_dig_hk(i) OF

	'dpu_sw_version':  dpu_sw_version = dpu_sw_version_b             ; 0 
        'cmd_rcvd_cnt':  cmd_rcvd_cnt = cmd_rcvd_cnt_b                 ; 1
        'cmd_exec_cnt':  cmd_exec_cnt = cmd_exec_cnt_b                 ; 2
        'cmd_total_err_cnt':  cmd_total_err_cnt = cmd_total_err_cnt_b       ; 3
        'cmd_parity_err_cnt':  cmd_parity_err_cnt = cmd_parity_err_cnt_b     ; 4
        'cmd_frame_err_cnt':  cmd_frame_err_cnt = cmd_frame_err_cnt_b       ; 5
        'cmd_illegal_err_cnt':  cmd_illegal_err_cnt = cmd_illegal_err_cnt_b   ; 6
        'ic_status_reg':  ic_status_reg = ic_status_reg_b               ; 7
        'ic_ctl_reg':  ic_ctl_reg = ic_ctl_reg_b                     ; 8
        'lbc_reset_ctl':  lbc_reset_ctl = lbc_reset_ctl_b               ; 9
        'lbc_mode_ctl':  lbc_mode_ctl = lbc_mode_ctl_b                 ; 10
        'lbc_logic_ctl_a':  lbc_logic_ctl_a = lbc_logic_ctl_a_b           ; 11
        'lbc_logic_ctl_b':  lbc_logic_ctl_b = lbc_logic_ctl_b_b           ; 12
        'lbc_tac_pwr_ctl':  lbc_tac_pwr_ctl = lbc_tac_pwr_ctl_b           ; 13
        'lbc_reg_seq':  lbc_reg_seq = lbc_reg_seq_b                   ; 14
        'lbc_event_ctl':  lbc_event_ctl = lbc_event_ctl_b               ; 15
        'lbc_rlim_ch':  lbc_rlim_ch = lbc_rlim_ch_b                   ; 16
        'lbc_rlim_hi':  lbc_rlim_hi = lbc_rlim_hi_b                   ; 17
        'lbc_rlim_lo':  lbc_rlim_lo = lbc_rlim_lo_b                   ; 18
        'lbe_pos_ctrl':  lbe_pos_ctrl = lbe_pos_ctrl_b                 ; 19
        'lbe_pos_disable0':  lbe_pos_disable0 = lbe_pos_disable0_b         ; 20
        'lbe_pos_disable2':  lbe_pos_disable2 = lbe_pos_disable2_b         ; 21
        'lbe_tac0_ctrl':  lbe_tac0_ctrl = lbe_tac0_ctrl_b               ; 22
        'lbe_tac0_dac':  lbe_tac0_dac = lbe_tac0_dac_b                 ; 23
        'lbe_tac2_ctrl':  lbe_tac2_ctrl = lbe_tac2_ctrl_b               ; 24
        'lbe_tac2_dac':  lbe_tac2_dac = lbe_tac2_dac_b                 ; 25
        'lbe_tac0_under_hi':  lbe_tac0_under_hi = lbe_tac0_under_hi_b       ; 26
        'lbe_tac0_under_lo':  lbe_tac0_under_lo = lbe_tac0_under_lo_b       ; 27
        'lbe_tac0_over_hi':  lbe_tac0_over_hi = lbe_tac0_over_hi_b         ; 28
        'lbe_tac0_over_lo':  lbe_tac0_over_lo = lbe_tac0_over_lo_b         ; 29
        'lbe_tac2_under_hi':  lbe_tac2_under_hi = lbe_tac2_under_hi_b       ; 30
        'lbe_tac2_under_lo':  lbe_tac2_under_lo = lbe_tac2_under_lo_b       ; 31
        'lbe_tac2_over_hi':  lbe_tac2_over_hi = lbe_tac2_over_hi_b         ; 32
        'lbe_tac2_over_lo':  lbe_tac2_over_lo = lbe_tac2_over_lo_b         ; 33
        'lbe_ssd_ctrl':  lbe_ssd_ctrl = lbe_ssd_ctrl_b                 ; 34
        'lbe_ssd_cmd_h':  lbe_ssd_cmd_h = lbe_ssd_cmd_h_b               ; 35
        'lbe_ssd_cmd_l':  lbe_ssd_cmd_l = lbe_ssd_cmd_l_b               ; 36
        'lbe_ssd_dis':  lbe_ssd_dis = lbe_ssd_dis_b                   ; 37
        'lbe_ssd_under_hi':  lbe_ssd_under_hi = lbe_ssd_under_hi_b         ; 38
        'lbe_ssd_under_lo':  lbe_ssd_under_lo = lbe_ssd_under_lo_b         ; 39
        'lbe_ssd_over_hi':  lbe_ssd_over_hi = lbe_ssd_over_hi_b           ; 40
        'lbe_ssd_over_lo':  lbe_ssd_over_lo = lbe_ssd_over_lo_b           ; 41
        'lbe_sel_ctrl':  lbe_sel_ctrl = lbe_sel_ctrl_b                 ; 42
        'lbe_trig_mode':  lbe_trig_mode = lbe_trig_mode_b               ; 43
        'lbe_esa_step':  lbe_esa_step = lbe_esa_step_b                 ; 44
        'lbe_defl_step':  lbe_defl_step = lbe_defl_step_b               ; 45
        'lbe_ssd_offset0':  lbe_ssd_offset0 = lbe_ssd_offset0_b           ; 46
        'lbe_ssd_offset1':  lbe_ssd_offset1 = lbe_ssd_offset1_b           ; 47
        'lbe_ssd_offset2':  lbe_ssd_offset2 = lbe_ssd_offset2_b           ; 48
        'lbe_ssd_offset3':  lbe_ssd_offset3 = lbe_ssd_offset3_b           ; 49
        'lbe_ssd_offset4':  lbe_ssd_offset4 = lbe_ssd_offset4_b           ; 50
        'lbe_ssd_offset5':  lbe_ssd_offset5 = lbe_ssd_offset5_b           ; 51
        'lbe_ssd_offset6':  lbe_ssd_offset6 = lbe_ssd_offset6_b           ; 52
        'lbe_ssd_offset7':  lbe_ssd_offset7 = lbe_ssd_offset7_b           ; 53
        'lbe_stim_enable':  lbe_stim_enable = lbe_stim_enable_b           ; 54
        'lbe_stim_freq_hi':  lbe_stim_freq_hi = lbe_stim_freq_hi_b         ; 55
        'lbe_stim_freq_lo':  lbe_stim_freq_lo = lbe_stim_freq_lo_b         ; 56
        'lbe_sel0_window':  lbe_sel0_window = lbe_sel0_window_b           ; 57
        'lbe_sel2_window':  lbe_sel2_window = lbe_sel2_window_b           ; 58
        'lbe_ssd_offset8':  lbe_ssd_offset8 = lbe_ssd_offset8_b           ; 59
        'lbe_ssd_offset9':  lbe_ssd_offset9 = lbe_ssd_offset9_b           ; 60
        'lbe_ssd_offset10':  lbe_ssd_offset10 = lbe_ssd_offset10_b         ; 61
        'lbe_ssd_offset11':  lbe_ssd_offset11 = lbe_ssd_offset11_b         ; 62
        'lbe_ssd_offset12':  lbe_ssd_offset12 = lbe_ssd_offset12_b         ; 63
        'lbe_ssd_offset13':  lbe_ssd_offset13 = lbe_ssd_offset13_b         ; 64
        'lbe_ssd_offset14':  lbe_ssd_offset14 = lbe_ssd_offset14_b         ; 65
        'lbe_ssd_offset15':  lbe_ssd_offset15 = lbe_ssd_offset15_b         ; 66
        'lbe_pos_ra':  lbe_pos_ra = lbe_pos_ra_b                     ; 67
        'dacm_pac_mcp_ssd_ctl_mcp_limit':  dacm_pac_mcp_ssd_ctl_mcp_limit = dacm_pac_mcp_ssd_ctl_mcp_limit_b  ; 68
        'dacm_pac_limit':  dacm_pac_limit = dacm_pac_limit_b             ; 69
        'dacm_esa_ctl':  dacm_esa_ctl = dacm_esa_ctl_b                 ; 70
        'dacm_s_ch_ctl':  dacm_s_ch_ctl = dacm_s_ch_ctl_b               ; 71
        'dacm_dfl_1_ctl':  dacm_dfl_1_ctl = dacm_dfl_1_ctl_b             ; 72
        'dacm_dfl_2_ctl':  dacm_dfl_2_ctl = dacm_dfl_2_ctl_b             ; 73
        'dacm_control':  dacm_control = dacm_control_b                ; 74
        'dacm_status':  dacm_status = dacm_status_b                   ; 75
        'dacm_adc_lu_ctr':  dacm_adc_lu_ctr = dacm_adc_lu_ctr_b           ; 76
        'dacm_dfl_1_offset':  dacm_dfl_1_offset = dacm_dfl_1_offset_b       ; 77
        'dacm_dfl_2_offset':  dacm_dfl_2_offset = dacm_dfl_2_offset_b       ; 78
        'dacm_pac_coarse':  dacm_pac_coarse = dacm_pac_coarse_b           ; 79
        'dacm_pac_fine':  dacm_pac_fine = dacm_pac_fine_b               ; 80
        'dacm_pac_cm_fs_coarse':  dacm_pac_cm_fs_coarse = dacm_pac_cm_fs_coarse_b           ; 81
        'dacm_pac_cm_fs_fine':  dacm_pac_cm_fs_fine = dacm_pac_cm_fs_fine_b   ; 82
        'dacm_mcp_coarse':  dacm_mcp_coarse = dacm_mcp_coarse_b           ; 83
        'dacm_mcp_fine':  dacm_mcp_fine = dacm_mcp_fine_b               ; 84
        'dacm_mcp_cm_fs_coarse':  dacm_mcp_cm_fs_coarse = dacm_mcp_cm_fs_coarse_b           ; 85
        'dacm_mcp_cm_fs_fine':  dacm_mcp_cm_fs_fine = dacm_mcp_cm_fs_fine_b   ; 86
        'dacm_ssd_coarse':  dacm_ssd_coarse = dacm_ssd_coarse_b           ; 87
        'dacm_ssd_fine':  dacm_ssd_fine = dacm_ssd_fine_b               ; 88
        'dacm_esa_coarse':  dacm_esa_coarse = dacm_esa_coarse_b           ; 89
        'dacm_esa_fine':  dacm_esa_fine = dacm_esa_fine_b               ; 90
        'dacm_s_ch_coarse':  dacm_s_ch_coarse = dacm_s_ch_coarse_b         ; 91
        'dacm_s_ch_fine':  dacm_s_ch_fine = dacm_s_ch_fine_b             ; 92
        'dacm_s_ch_tap_coarse':  dacm_s_ch_tap_coarse = dacm_s_ch_tap_coarse_b ; 93
        'dacm_s_ch_tap_fine':  dacm_s_ch_tap_fine = dacm_s_ch_tap_fine_b     ; 94
        'dacm_dfl_1_coarse':  dacm_dfl_1_coarse = dacm_dfl_1_coarse_b       ; 95
        'dacm_dfl_1_fine':  dacm_dfl_1_fine = dacm_dfl_1_fine_b           ; 96
        'dacm_dfl_1_dfine':  dacm_dfl_1_dfine = dacm_dfl_1_dfine_b         ; 97
        'dacm_dfl_2_coarse':  dacm_dfl_2_coarse = dacm_dfl_2_coarse_b       ; 98
        'dacm_dfl_2_fine':  dacm_dfl_2_fine = dacm_dfl_2_fine_b           ; 99
        'dacm_dfl_2_dfine':  dacm_dfl_2_dfine = dacm_dfl_2_dfine_b         ; 100
        'dacr_pac_mcp_ssd_ctl_mcp_limit':  dacr_pac_mcp_ssd_ctl_mcp_limit = dacr_pac_mcp_ssd_ctl_mcp_limit_b  ; 101
        'dacr_pac_limit':  dacr_pac_limit = dacr_pac_limit_b             ; 102
        'dacr_esa_ctl':  dacr_esa_ctl = dacr_esa_ctl_b                 ; 103
        'dacr_s_ch_ctl':  dacr_s_ch_ctl = dacr_s_ch_ctl_b               ; 104
        'dacr_dfl_1_ctl':  dacr_dfl_1_ctl = dacr_dfl_1_ctl_b             ; 105
        'dacr_dfl_2_ctl':  dacr_dfl_2_ctl = dacr_dfl_2_ctl_b             ; 106
        'dacr_control':  dacr_control = dacr_control_b                 ; 107
        'dacr_status':  dacr_status = dacr_status_b                   ; 108
        'dacr_adc_lu_ctr':  dacr_adc_lu_ctr = dacr_adc_lu_ctr_b           ; 109
        'dacr_dfl_1_offset':  dacr_dfl_1_offset = dacr_dfl_1_offset_b       ; 110
        'dacr_dfl_2_offset':  dacr_dfl_2_offset = dacr_dfl_2_offset_b       ; 111
        'dacr_c_pac_coarse':  dacr_c_pac_coarse = dacr_c_pac_coarse_b       ; 112
        'dacr_c_pac_fine':  dacr_c_pac_fine = dacr_c_pac_fine_b           ; 113
        'dacr_c_pac_cm_fs_coarse':  dacr_c_pac_cm_fs_coarse = dacr_c_pac_cm_fs_coarse_b         ; 114
        'dacr_c_pac_cm_fs_fine':  dacr_c_pac_cm_fs_fine = dacr_c_pac_cm_fs_fine_b		  ; 115
        'dacr_c_mcp_coarse':  dacr_c_mcp_coarse = dacr_c_mcp_coarse_b       ; 116
        'dacr_c_mcp_fine':  dacr_c_mcp_fine = dacr_c_mcp_fine_b           ; 117
        'dacr_c_mcp_cm_fs_coarse':  dacr_c_mcp_cm_fs_coarse = dacr_c_mcp_cm_fs_coarse_b         ; 118
        'dacr_c_mcp_cm_fs_fine':  dacr_c_mcp_cm_fs_fine = dacr_c_mcp_cm_fs_fine_b           ; 119
        'dacr_c_ssd_coarse':  dacr_c_ssd_coarse = dacr_c_ssd_coarse_b       ; 120
        'dacr_c_ssd_fine':  dacr_c_ssd_fine = dacr_c_ssd_fine_b           ; 121
        'dacr_c_esa_coarse':  dacr_c_esa_coarse = dacr_c_esa_coarse_b       ; 122
        'dacr_c_esa_fine':  dacr_c_esa_fine = dacr_c_esa_fine_b           ; 123
        'dacr_c_s_ch_coarse':  dacr_c_s_ch_coarse = dacr_c_s_ch_coarse_b     ; 124
        'dacr_c_s_ch_fine':  dacr_c_s_ch_fine = dacr_c_s_ch_fine_b         ; 125
        'dacr_c_s_ch_tap_coarse':  dacr_c_s_ch_tap_coarse = dacr_c_s_ch_tap_coarse_b          ; 126
        'dacr_c_s_ch_tap_fine':  dacr_c_s_ch_tap_fine = dacr_c_s_ch_tap_fine_b ; 127
        'dacr_dfl_1_coarse':  dacr_dfl_1_coarse = dacr_dfl_1_coarse_b       ; 128
        'dacr_dfl_1_fine':  dacr_dfl_1_fine = dacr_dfl_1_fine_b           ; 129
        'dacr_dfl_1_dfine':  dacr_dfl_1_dfine = dacr_dfl_1_dfine_b         ; 130
        'dacr_dfl_2_coarse':  dacr_dfl_2_coarse = dacr_dfl_2_coarse_b       ; 131
        'dacr_dfl_2_fine':  dacr_dfl_2_fine = dacr_dfl_2_fine_b           ; 132
        'dacr_dfl_2_dfine':  dacr_dfl_2_dfine = dacr_dfl_2_dfine_b         ; 133
        'sw_status1':  sw_status1 = sw_status1_b                     ; 134
        'sw_hv_ramp_status':  sw_hv_ramp_status = sw_hv_ramp_status_b       ; 135
        'sw_hv_enable_status':  sw_hv_enable_status = sw_hv_enable_status_b   ; 136
        'sw_hv_limit_status':  sw_hv_limit_status = sw_hv_limit_status_b     ; 137
        'sw_eepromchksum':  sw_eepromchksum = sw_eepromchksum_b           ; 138
        'hkp_sampletime':  hkp_sampletime = hkp_sampletime_b             ; 139
        'pac_discharge_status':  pac_discharge_status = pac_discharge_status_b ; 140
        'pac_discharge_cnt':  pac_discharge_cnt = pac_discharge_cnt_b       ; 141
        'pac_discharge_conseccntr':  pac_discharge_conseccntr = pac_discharge_conseccntr_b        ; 142
        'pac_discharge_safe_att':  pac_discharge_safe_att = pac_discharge_safe_att_b          ; 143
        'analog_limit_status':  analog_limit_status = analog_limit_status_b   ; 144
        'analog_lim_pt1_status':  analog_lim_pt1_status = analog_lim_pt1_status_b		  ; 145
        'analog_lim_pt1_id':  analog_lim_pt1_id = analog_lim_pt1_id_b       ; 146
        'analog_lim_pt1_red':  analog_lim_pt1_red = analog_lim_pt1_red_b     ; 147
        'analog_lim_pt2_status':  analog_lim_pt2_status = analog_lim_pt2_status_b           ; 148
        'analog_lim_pt2_id':  analog_lim_pt2_id = analog_lim_pt2_id_b       ; 149
        'analog_lim_pt2_red':  analog_lim_pt2_red = analog_lim_pt2_red_b     ; 150
        'analog_lim_pt3_status':  analog_lim_pt3_status = analog_lim_pt3_status_b           ; 151
        'analog_lim_pt3_id':  analog_lim_pt3_id = analog_lim_pt3_id_b       ; 152
        'analog_lim_pt3_red':  analog_lim_pt3_red = analog_lim_pt3_red_b     ; 153
        'analog_lim_pt4_status':  analog_lim_pt4_status = analog_lim_pt4_status_b           ; 154
        'analog_lim_pt4_id':  analog_lim_pt4_id = analog_lim_pt4_id_b       ; 155
        'analog_lim_pt4_red':  analog_lim_pt4_red = analog_lim_pt4_red_b     ; 156
        'analog_lim_pt5_status':  analog_lim_pt5_status = analog_lim_pt5_status_b           ; 157
        'analog_lim_pt5_id':  analog_lim_pt5_id = analog_lim_pt5_id_b       ; 158
        'analog_lim_pt5_red':  analog_lim_pt5_red = analog_lim_pt5_red_b     ; 159
        'analog_lim_pt6_status':  analog_lim_pt6_status = analog_lim_pt6_status_b           ; 160
        'analog_lim_pt6_id':  analog_lim_pt6_id = analog_lim_pt6_id_b       ; 161
        'analog_lim_pt6_red':  analog_lim_pt6_red = analog_lim_pt6_red_b     ; 162
        'analog_lim_pt7_status':  analog_lim_pt7_status = analog_lim_pt7_status_b           ; 163
        'analog_lim_pt7_id':  analog_lim_pt7_id = analog_lim_pt7_id_b       ; 164
        'analog_lim_pt7_red':  analog_lim_pt7_red = analog_lim_pt7_red_b     ; 165
        'analog_lim_pt8_status':  analog_lim_pt8_status = analog_lim_pt8_status_b           ; 166
        'analog_lim_pt8_id':  analog_lim_pt8_id = analog_lim_pt8_id_b       ; 167
        'analog_lim_pt8_red':  analog_lim_pt8_red = analog_lim_pt8_red_b     ; 168
        'analog_lim_pt9_status':  analog_lim_pt9_status = analog_lim_pt9_status_b           ; 169
        'analog_lim_pt9_id':  analog_lim_pt9_id = analog_lim_pt9_id_b       ; 170
        'analog_lim_pt9_red':  analog_lim_pt9_red = analog_lim_pt9_red_b     ; 171
        'analog_lim_pt10_status':  analog_lim_pt10_status = analog_lim_pt10_status_b          ; 172
        'analog_lim_pt10_id':  analog_lim_pt10_id = analog_lim_pt10_id_b     ; 173
        'analog_lim_pt10_red':  analog_lim_pt10_red = analog_lim_pt10_red_b   ; 174
        'analog_lim_pt11_status':  analog_lim_pt11_status = analog_lim_pt11_status_b          ; 175
        'analog_lim_pt11_id':  analog_lim_pt11_id = analog_lim_pt11_id_b     ; 176
        'analog_lim_pt11_red':  analog_lim_pt11_red = analog_lim_pt11_red_b   ; 177
        'analog_lim_pt12_status':  analog_lim_pt12_status = analog_lim_pt12_status_b          ; 178
        'analog_lim_pt12_id':  analog_lim_pt12_id = analog_lim_pt12_id_b     ; 179
        'analog_lim_pt12_red':  analog_lim_pt12_red = analog_lim_pt12_red_b   ; 180
        'analog_lim_pt13_status':  analog_lim_pt13_status = analog_lim_pt13_status_b          ; 181
        'analog_lim_pt13_id':  analog_lim_pt13_id = analog_lim_pt13_id_b     ; 182
        'analog_lim_pt13_red':  analog_lim_pt13_red = analog_lim_pt13_red_b   ; 183
        'analog_lim_pt14_status':  analog_lim_pt14_status = analog_lim_pt14_status_b          ; 184
        'analog_lim_pt14_id':  analog_lim_pt14_id = analog_lim_pt14_id_b     ; 185
        'analog_lim_pt14_red':  analog_lim_pt14_red = analog_lim_pt14_red_b   ; 186
        'analog_lim_pt15_status':  analog_lim_pt15_status = analog_lim_pt15_status_b          ; 187
        'analog_lim_pt15_id':  analog_lim_pt15_id = analog_lim_pt15_id_b     ; 188
        'analog_lim_pt15_red':  analog_lim_pt15_red = analog_lim_pt15_red_b   ; 189
        'opmode':  opmode = opmode_b                             ; 190
        'sw_mode':  sw_mode = sw_mode_b                           ; 191
        'proton_mode':  proton_mode = proton_mode_b                   ; 192
        'active_supplyid':  active_supplyid = active_supplyid_b           ; 193
        'supply_coarse_rb':  supply_coarse_rb = supply_coarse_rb_b         ; 194
        'supply_fine_rb':  supply_fine_rb = supply_fine_rb_b             ; 195
        'swmaint_supplystat':  swmaint_supplystat = swmaint_supplystat_b     ; 196
        'swmaint_pac_coarse':  swmaint_pac_coarse = swmaint_pac_coarse_b     ; 197
        'swmaint_pac_fine':  swmaint_pac_fine = swmaint_pac_fine_b         ; 198
     
	ENDCASE
	ENDFOR
ENDELSE 

labels = ' '

FOR ii=0, n_elements(prod_dig_hk)-1 DO BEGIN
	CASE prod_dig_hk(ii) OF
		
	   'dpu_sw_version':  store_data, prefix+'dpu_sw_version', data = {x:epoch1, y:dpu_sw_version}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 0 
           'cmd_rcvd_cnt':  store_data, prefix+'cmd_rcvd_cnt', data = {x:epoch1, y:cmd_rcvd_cnt}, dlim = {ylog:0, labels:labels, panel_size:2.}  ; 1
           'cmd_exec_cnt':  store_data, prefix+'cmd_exec_cnt', data = {x:epoch1, y:cmd_exec_cnt}, dlim = {ylog:0, labels:labels, panel_size:2.}   ; 2
           'cmd_total_err_cnt':  store_data, prefix+'cmd_total_err_cnt', data = {x:epoch1, y:cmd_total_err_cnt}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 3
           'cmd_parity_err_cnt':  store_data, prefix+'cmd_parity_err_cnt', data = {x:epoch1, y:cmd_parity_err_cnt}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 4
           'cmd_frame_err_cnt':  store_data, prefix+'cmd_frame_err_cnt', data = {x:epoch1, y:cmd_frame_err_cnt}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 5
           'cmd_illegal_err_cnt':  store_data, prefix+'cmd_illegal_err_cnt', data = {x:epoch1, y:cmd_illegal_err_cnt}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 6
           'ic_status_reg':  store_data, prefix+'ic_status_reg', data = {x:epoch1, y:ic_status_reg}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 7
           'ic_ctl_reg':  store_data, prefix+'ic_ctl_reg', data = {x:epoch1, y:ic_ctl_reg}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 8
           'lbc_reset_ctl':  store_data, prefix+'lbc_reset_ctl', data = {x:epoch1, y:lbc_reset_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 9
           'lbc_mode_ctl':  store_data, prefix+'lbc_mode_ctl', data = {x:epoch1, y:lbc_mode_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 10         
	   'lbc_logic_ctl_a':  store_data, prefix+'lbc_logic_ctl_a', data = {x:epoch1, y:lbc_logic_ctl_a}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 11
           'lbc_logic_ctl_b':  store_data, prefix+'lbc_logic_ctl_b', data = {x:epoch1, y:lbc_logic_ctl_b}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 12
           'lbc_tac_pwr_ctl':  store_data, prefix+'lbc_tac_pwr_ctl', data = {x:epoch1, y:lbc_tac_pwr_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 13
           'lbc_reg_seq':  store_data, prefix+'lbc_reg_seq', data = {x:epoch1, y:lbc_reg_seq}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 14
           'lbc_event_ctl':    store_data, prefix+'lbc_event_ctl', data = {x:epoch1, y:lbc_event_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 15
           'lbc_rlim_ch':  store_data, prefix+'lbc_rlim_ch', data = {x:epoch1, y:lbc_rlim_ch}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 16
           'lbc_rlim_hi':  store_data, prefix+'lbc_rlim_hi', data = {x:epoch1, y:lbc_rlim_hi}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 17
           'lbc_rlim_lo':  store_data, prefix+'lbc_rlim_lo', data = {x:epoch1, y:lbc_rlim_lo}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 18
           'lbe_pos_ctrl':  store_data, prefix+'lbe_pos_ctrl', data = {x:epoch1, y:lbe_pos_ctrl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 19
           'lbe_pos_disable0':  store_data, prefix+'lbe_pos_disable0', data = {x:epoch1, y:lbe_pos_disable0}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 20
           'lbe_pos_disable2':  store_data, prefix+'lbe_pos_disable2', data = {x:epoch1, y:lbe_pos_disable2}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 21
           'lbe_tac0_ctrl':  store_data, prefix+'lbe_tac0_ctrl', data = {x:epoch1, y:lbe_tac0_ctrl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 22
           'lbe_tac0_dac':  store_data, prefix+'lbe_tac0_dac', data = {x:epoch1, y:lbe_tac0_dac}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 23
           'lbe_tac2_ctrl':  store_data, prefix+'lbe_tac2_ctrl', data = {x:epoch1, y:lbe_tac2_ctrl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 24
           'lbe_tac2_dac':  store_data, prefix+'lbe_tac2_dac', data = {x:epoch1, y:lbe_tac2_dac}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 25
           'lbe_tac0_under_hi':  store_data, prefix+'lbe_tac0_under_hi', data = {x:epoch1, y:lbe_tac0_under_hi}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 26
           'lbe_tac0_under_lo':  store_data, prefix+'lbe_tac0_under_lo', data = {x:epoch1, y:lbe_tac0_under_lo}, dlim = {ylog:0, labels:labels, panel_size:2.}  ; 27
           'lbe_tac0_over_hi':  store_data, prefix+'lbe_tac0_over_hi', data = {x:epoch1, y:lbe_tac0_over_hi}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 28
           'lbe_tac0_over_lo':  store_data, prefix+'lbe_tac0_over_lo', data = {x:epoch1, y:lbe_tac0_over_lo}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 29
           'lbe_tac2_under_hi':  store_data, prefix+'lbe_tac2_under_hi', data = {x:epoch1, y:lbe_tac2_under_hi}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 30
           'lbe_tac2_under_lo':  store_data, prefix+'lbe_tac2_under_lo', data = {x:epoch1, y:lbe_tac2_under_lo}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 31
           'lbe_tac2_over_hi':  store_data, prefix+'lbe_tac2_over_hi', data = {x:epoch1, y:lbe_tac2_over_hi}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 32
           'lbe_tac2_over_lo':  store_data, prefix+'lbe_tac2_over_lo', data = {x:epoch1, y:lbe_tac2_over_lo}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 33
           'lbe_ssd_ctrl':  store_data, prefix+'lbe_ssd_ctrl', data = {x:epoch1, y:lbe_ssd_ctrl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 34
           'lbe_ssd_cmd_h':  store_data, prefix+'lbe_ssd_cmd_h', data = {x:epoch1, y:lbe_ssd_cmd_h}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 35
           'lbe_ssd_cmd_l':  store_data, prefix+'lbe_ssd_cmd_l', data = {x:epoch1, y:lbe_ssd_cmd_l}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 36
           'lbe_ssd_dis':  store_data, prefix+'lbe_ssd_dis', data = {x:epoch1, y:lbe_ssd_dis}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 37
           'lbe_ssd_under_hi':  store_data, prefix+'lbe_ssd_under_hi', data = {x:epoch1, y:lbe_ssd_under_hi}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 38
           'lbe_ssd_under_lo':  store_data, prefix+'lbe_ssd_under_lo', data = {x:epoch1, y:lbe_ssd_under_lo}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 39
           'lbe_ssd_over_hi':  store_data, prefix+'lbe_ssd_over_hi', data = {x:epoch1, y:lbe_ssd_over_hi}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 40
           'lbe_ssd_over_lo':  store_data, prefix+'lbe_ssd_over_lo', data = {x:epoch1, y:lbe_ssd_over_lo}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 41
           'lbe_sel_ctrl':  store_data, prefix+'lbe_sel_ctrl', data = {x:epoch1, y:lbe_sel_ctrl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 42
           'lbe_trig_mode':  store_data, prefix+'lbe_trig_mode', data = {x:epoch1, y:lbe_trig_mode}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 43
           'lbe_esa_step':  store_data, prefix+'lbe_esa_step', data = {x:epoch1, y:lbe_esa_step}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 44
           'lbe_defl_step':  store_data, prefix+'lbe_defl_step', data = {x:epoch1, y:lbe_defl_step}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 45
           'lbe_ssd_offset0':  store_data, prefix+'lbe_ssd_offset0', data = {x:epoch1, y:lbe_ssd_offset0}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 46
           'lbe_ssd_offset1':  store_data, prefix+'lbe_ssd_offset1', data = {x:epoch1, y:lbe_ssd_offset1}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 47
           'lbe_ssd_offset2':  store_data, prefix+'lbe_ssd_offset2', data = {x:epoch1, y:lbe_ssd_offset2}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 48
           'lbe_ssd_offset3':  store_data, prefix+'lbe_ssd_offset3', data = {x:epoch1, y:lbe_ssd_offset3}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 49
           'lbe_ssd_offset4':  store_data, prefix+'lbe_ssd_offset4', data = {x:epoch1, y:lbe_ssd_offset4}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 50
           'lbe_ssd_offset5':  store_data, prefix+'lbe_ssd_offset5', data = {x:epoch1, y:lbe_ssd_offset5}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 51
           'lbe_ssd_offset6':  store_data, prefix+'lbe_ssd_offset6', data = {x:epoch1, y:lbe_ssd_offset6}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 52
           'lbe_ssd_offset7':  store_data, prefix+'lbe_ssd_offset7', data = {x:epoch1, y:lbe_ssd_offset7}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 53
           'lbe_stim_enable':  store_data, prefix+'lbe_stim_enable', data = {x:epoch1, y:lbe_stim_enable}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 54
           'lbe_stim_freq_hi':  store_data, prefix+'lbe_stim_freq_hi', data = {x:epoch1, y:lbe_stim_freq_hi}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 55
           'lbe_stim_freq_lo':  store_data, prefix+'lbe_stim_freq_lo', data = {x:epoch1, y:lbe_stim_freq_lo}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 56
           'lbe_sel0_window':  store_data, prefix+'lbe_sel0_window', data = {x:epoch1, y:lbe_sel0_window}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 57
           'lbe_sel2_window':  store_data, prefix+'lbe_sel2_window', data = {x:epoch1, y:lbe_sel2_window}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 58
           'lbe_ssd_offset8':  store_data, prefix+'lbe_ssd_offset8', data = {x:epoch1, y:lbe_ssd_offset8}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 59
           'lbe_ssd_offset9':  store_data, prefix+'lbe_ssd_offset9', data = {x:epoch1, y:lbe_ssd_offset9}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 60
           'lbe_ssd_offset10':  store_data, prefix+'lbe_ssd_offset10', data = {x:epoch1, y:lbe_ssd_offset10}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 61
           'lbe_ssd_offset11':  store_data, prefix+'lbe_ssd_offset11', data = {x:epoch1, y:lbe_ssd_offset11}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 62
           'lbe_ssd_offset12':  store_data, prefix+'lbe_ssd_offset12', data = {x:epoch1, y:lbe_ssd_offset12}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 63
           'lbe_ssd_offset13':  store_data, prefix+'lbe_ssd_offset13', data = {x:epoch1, y:lbe_ssd_offset13}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 64
           'lbe_ssd_offset14':  store_data, prefix+'lbe_ssd_offset14', data = {x:epoch1, y:lbe_ssd_offset14}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 65
           'lbe_ssd_offset15':  store_data, prefix+'lbe_ssd_offset15', data = {x:epoch1, y:lbe_ssd_offset15}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 66
           'lbe_pos_ra':  store_data, prefix+'lbe_pos_ra', data = {x:epoch1, y:lbe_pos_ra}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 67
           'dacm_pac_mcp_ssd_ctl_mcp_limit':  store_data, prefix+'dacm_pac_mcp_ssd_ctl_mcp_limit', data = {x:epoch1, y:dacm_pac_mcp_ssd_ctl_mcp_limit}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 68
           'dacm_pac_limit':  store_data, prefix+'dacm_pac_limit', data = {x:epoch1, y:dacm_pac_limit}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 69
           'dacm_esa_ctl':  store_data, prefix+'dacm_esa_ctl', data = {x:epoch1, y:dacm_esa_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 70
           'dacm_s_ch_ctl':  store_data, prefix+'dacm_s_ch_ctl', data = {x:epoch1, y:dacm_s_ch_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 71
           'dacm_dfl_1_ctl':  store_data, prefix+'dacm_dfl_1_ctl', data = {x:epoch1, y:dacm_dfl_1_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 72
           'dacm_dfl_2_ctl':  store_data, prefix+'dacm_dfl_2_ctl', data = {x:epoch1, y:dacm_dfl_2_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 73
           'dacm_control':  store_data, prefix+'dacm_control', data = {x:epoch1, y:dacm_control}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 74
           'dacm_status':  store_data, prefix+'dacm_status', data = {x:epoch1, y:dacm_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 75
           'dacm_adc_lu_ctr':  store_data, prefix+'dacm_adc_lu_ctr', data = {x:epoch1, y:dacm_adc_lu_ctr}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 76
           'dacm_dfl_1_offset':  store_data, prefix+'dacm_dfl_1_offset', data = {x:epoch1, y:dacm_dfl_1_offset}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 77
           'dacm_dfl_2_offset':  store_data, prefix+'dacm_dfl_2_offset', data = {x:epoch1, y:dacm_dfl_2_offset}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 78
           'dacm_pac_coarse':  store_data, prefix+'dacm_pac_coarse', data = {x:epoch1, y:dacm_pac_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 79
           'dacm_pac_fine':  store_data, prefix+'dacm_pac_fine', data = {x:epoch1, y:dacm_pac_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 80
           'dacm_pac_cm_fs_coarse':  store_data, prefix+'dacm_pac_cm_fs_coarse', data = {x:epoch1, y:dacm_pac_cm_fs_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 81
           'dacm_pac_cm_fs_fine':  store_data, prefix+'dacm_pac_cm_fs_fine', data = {x:epoch1, y:dacm_pac_cm_fs_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 82
           'dacm_mcp_coarse':  store_data, prefix+'dacm_mcp_coarse', data = {x:epoch1, y:dacm_mcp_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 83
           'dacm_mcp_fine':  store_data, prefix+'dacm_mcp_fine', data = {x:epoch1, y:dacm_mcp_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 84
           'dacm_mcp_cm_fs_coarse':  store_data, prefix+'dacm_mcp_cm_fs_coarse', data = {x:epoch1, y:dacm_mcp_cm_fs_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 85
           'dacm_mcp_cm_fs_fine':  store_data, prefix+'dacm_mcp_cm_fs_fine', data = {x:epoch1, y:dacm_mcp_cm_fs_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 86
           'dacm_ssd_coarse':  store_data, prefix+'dacm_ssd_coarse', data = {x:epoch1, y:dacm_ssd_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 87
           'dacm_ssd_fine':  store_data, prefix+'dacm_ssd_fine', data = {x:epoch1, y:dacm_ssd_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 88
           'dacm_esa_coarse':  store_data, prefix+'dacm_esa_coarse', data = {x:epoch1, y:dacm_esa_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 89
           'dacm_esa_fine':  store_data, prefix+'dacm_esa_fine', data = {x:epoch1, y:dacm_esa_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 90
           'dacm_s_ch_coarse':  store_data, prefix+'dacm_s_ch_coarse', data = {x:epoch1, y:dacm_s_ch_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 91
           'dacm_s_ch_fine':  store_data, prefix+'dacm_s_ch_fine', data = {x:epoch1, y:dacm_s_ch_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 92
           'dacm_s_ch_tap_coarse':  store_data, prefix+'dacm_s_ch_tap_coarse', data = {x:epoch1, y:dacm_s_ch_tap_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 93
           'dacm_s_ch_tap_fine':  store_data, prefix+'dacm_s_ch_tap_fine', data = {x:epoch1, y:dacm_s_ch_tap_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 94
           'dacm_dfl_1_coarse':  store_data, prefix+'dacm_dfl_1_coarse', data = {x:epoch1, y:dacm_dfl_1_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 95
           'dacm_dfl_1_fine':  store_data, prefix+'dacm_dfl_1_fine', data = {x:epoch1, y:dacm_dfl_1_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 96
           'dacm_dfl_1_dfine':  store_data, prefix+'dacm_dfl_1_dfine', data = {x:epoch1, y:dacm_dfl_1_dfine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 97
           'dacm_dfl_2_coarse':  store_data, prefix+'dacm_dfl_2_coarse', data = {x:epoch1, y:dacm_dfl_2_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 98
           'dacm_dfl_2_fine':  store_data, prefix+'dacm_dfl_2_fine', data = {x:epoch1, y:dacm_dfl_2_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 99
           'dacm_dfl_2_dfine':  store_data, prefix+'dacm_dfl_2_dfine', data = {x:epoch1, y:dacm_dfl_2_dfine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 100
           'dacr_pac_mcp_ssd_ctl_mcp_limit':  store_data, prefix+'dacr_pac_mcp_ssd_ctl_mcp_limit', data = {x:epoch1, y:dacr_pac_mcp_ssd_ctl_mcp_limit}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 101
           'dacr_pac_limit':  store_data, prefix+'dacr_pac_limit', data = {x:epoch1, y:dacr_pac_limit}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 102
           'dacr_esa_ctl':  store_data, prefix+'dacr_esa_ctl', data = {x:epoch1, y:dacr_esa_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 103
           'dacr_s_ch_ctl':  store_data, prefix+'dacr_s_ch_ctl', data = {x:epoch1, y:dacr_s_ch_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 104
           'dacr_dfl_1_ctl':  store_data, prefix+'dacr_dfl_1_ctl', data = {x:epoch1, y:dacr_dfl_1_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 105
           'dacr_dfl_2_ctl':  store_data, prefix+'dacr_dfl_2_ctl', data = {x:epoch1, y:dacr_dfl_2_ctl}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 106
           'dacr_control':  store_data, prefix+'dacr_control', data = {x:epoch1, y:dacr_control}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 107
           'dacr_status':  store_data, prefix+'dacr_status', data = {x:epoch1, y:dacr_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 108
           'dacr_adc_lu_ctr': store_data, prefix+'dacr_adc_lu_ctr', data = {x:epoch1, y:dacr_adc_lu_ctr}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 109
           'dacr_dfl_1_offset':  store_data, prefix+'dacr_dfl_1_offset', data = {x:epoch1, y:dacr_dfl_1_offset}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 110
           'dacr_dfl_2_offset':  store_data, prefix+'dacr_dfl_2_offset', data = {x:epoch1, y:dacr_dfl_2_offset}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 111
           'dacr_c_pac_coarse':  store_data, prefix+'dacr_c_pac_coarse', data = {x:epoch1, y:dacr_c_pac_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 112
           'dacr_c_pac_fine':  store_data, prefix+'dacr_c_pac_fine', data = {x:epoch1, y:dacr_c_pac_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 113
           'dacr_c_pac_cm_fs_coarse':  store_data, prefix+'dacr_c_pac_cm_fs_coarse', data = {x:epoch1, y:dacr_c_pac_cm_fs_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 114
           'dacr_c_pac_cm_fs_fine':  store_data, prefix+'dacr_c_pac_cm_fs_fine', data = {x:epoch1, y:dacr_c_pac_cm_fs_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 115
           'dacr_c_mcp_coarse':   store_data, prefix+'dacr_c_mcp_coarse', data = {x:epoch1, y:dacr_c_mcp_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 116
           'dacr_c_mcp_fine':  store_data, prefix+'dacr_c_mcp_fine', data = {x:epoch1, y:dacr_c_mcp_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 117
           'dacr_c_mcp_cm_fs_coarse':  store_data, prefix+'dacr_c_mcp_cm_fs_coarse', data = {x:epoch1, y:dacr_c_mcp_cm_fs_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 118
           'dacr_c_mcp_cm_fs_fine':  store_data, prefix+'dacr_c_mcp_cm_fs_fine', data = {x:epoch1, y:dacr_c_mcp_cm_fs_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 119
           'dacr_c_ssd_coarse':  store_data, prefix+'dacr_c_ssd_coarse', data = {x:epoch1, y:dacr_c_ssd_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 120
           'dacr_c_ssd_fine':  store_data, prefix+'dacr_c_ssd_fine', data = {x:epoch1, y:dacr_c_ssd_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 121
           'dacr_c_esa_coarse':  store_data, prefix+'dacr_c_esa_coarse', data = {x:epoch1, y:dacr_c_esa_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 122
           'dacr_c_esa_fine':  store_data, prefix+'dacr_c_esa_fine', data = {x:epoch1, y:dacr_c_esa_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 123
           'dacr_c_s_ch_coarse':  store_data, prefix+'dacr_c_s_ch_coarse', data = {x:epoch1, y:dacr_c_s_ch_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 124
           'dacr_c_s_ch_fine':  store_data, prefix+'dacr_c_s_ch_fine', data = {x:epoch1, y:dacr_c_s_ch_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 125
           'dacr_c_s_ch_tap_coarse':  store_data, prefix+'dacr_c_s_ch_tap_coarse', data = {x:epoch1, y:dacr_c_s_ch_tap_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 126
           'dacr_c_s_ch_tap_fine':  store_data, prefix+'dacr_c_s_ch_tap_fine', data = {x:epoch1, y:dacr_c_s_ch_tap_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 127
           'dacr_dfl_1_coarse':  store_data, prefix+'dacr_dfl_1_coarse', data = {x:epoch1, y:dacr_dfl_1_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 128
           'dacr_dfl_1_fine':  store_data, prefix+'dacr_dfl_1_fine', data = {x:epoch1, y:dacr_dfl_1_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 129
           'dacr_dfl_1_dfine':  store_data, prefix+'dacr_dfl_1_dfine', data = {x:epoch1, y:dacr_dfl_1_dfine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 130
           'dacr_dfl_2_coarse':  store_data, prefix+'dacr_dfl_2_coarse', data = {x:epoch1, y:dacr_dfl_2_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 131
           'dacr_dfl_2_fine':  store_data, prefix+'dacr_dfl_2_fine', data = {x:epoch1, y:dacr_dfl_2_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 132
           'dacr_dfl_2_dfine':  store_data, prefix+'dacr_dfl_2_dfine', data = {x:epoch1, y:dacr_dfl_2_dfine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 133
           'sw_status1':  store_data, prefix+'sw_status1', data = {x:epoch1, y:sw_status1}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 134
           'sw_hv_ramp_status':  store_data, prefix+'sw_hv_ramp_status', data = {x:epoch1, y:sw_hv_ramp_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 135
           'sw_hv_enable_status':  store_data, prefix+'sw_hv_enable_status', data = {x:epoch1, y:sw_hv_enable_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 136
           'sw_hv_limit_status':  store_data, prefix+'sw_hv_limit_status', data = {x:epoch1, y:sw_hv_limit_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 137
           'sw_eepromchksum':  store_data, prefix+'sw_eepromchksum', data = {x:epoch1, y:sw_eepromchksum}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 138
           'hkp_sampletime':  store_data, prefix+'hkp_sampletime', data = {x:epoch1, y:hkp_sampletime}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 139
           'pac_discharge_status':  store_data, prefix+'pac_discharge_status', data = {x:epoch1, y:pac_discharge_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 140
           'pac_discharge_cnt':  store_data, prefix+'pac_discharge_cnt', data = {x:epoch1, y:pac_discharge_cnt}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 141
           'pac_discharge_conseccntr':  store_data, prefix+'pac_discharge_conseccntr', data = {x:epoch1, y:pac_discharge_conseccntr}, dlim = {ylog:0, labels:labels, panel_size:2.}      ; 142
           'pac_discharge_safe_att':  store_data, prefix+'pac_discharge_safe_att', data = {x:epoch1, y:pac_discharge_safe_att}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 143
           'analog_limit_status':  store_data, prefix+'analog_limit_status', data = {x:epoch1, y:analog_limit_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 144
           'analog_lim_pt1_status':  store_data, prefix+'analog_lim_pt1_status', data = {x:epoch1, y:analog_lim_pt1_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 145
           'analog_lim_pt1_id':  store_data, prefix+'analog_lim_pt1_id', data = {x:epoch1, y:analog_lim_pt1_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 146
           'analog_lim_pt1_red':  store_data, prefix+'analog_lim_pt1_red', data = {x:epoch1, y:analog_lim_pt1_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 147
           'analog_lim_pt2_status':  store_data, prefix+'analog_lim_pt2_status', data = {x:epoch1, y:analog_lim_pt2_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 148
           'analog_lim_pt2_id':  store_data, prefix+'analog_lim_pt2_id', data = {x:epoch1, y:analog_lim_pt2_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 149
           'analog_lim_pt2_red':  store_data, prefix+'analog_lim_pt2_red', data = {x:epoch1, y:analog_lim_pt2_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 150
           'analog_lim_pt3_status':  store_data, prefix+'analog_lim_pt3_status', data = {x:epoch1, y:analog_lim_pt3_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 151
           'analog_lim_pt3_id':  store_data, prefix+'analog_lim_pt3_id', data = {x:epoch1, y:analog_lim_pt3_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 152
           'analog_lim_pt3_red':  store_data, prefix+'analog_lim_pt3_red', data = {x:epoch1, y:analog_lim_pt3_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 153
           'analog_lim_pt4_status':  store_data, prefix+'analog_lim_pt4_status', data = {x:epoch1, y:analog_lim_pt4_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 154
           'analog_lim_pt4_id':  store_data, prefix+'analog_lim_pt4_id', data = {x:epoch1, y:analog_lim_pt4_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 155
           'analog_lim_pt4_red':  store_data, prefix+'analog_lim_pt4_red', data = {x:epoch1, y:analog_lim_pt4_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 156
           'analog_lim_pt5_status':  store_data, prefix+'analog_lim_pt5_status', data = {x:epoch1, y:analog_lim_pt5_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 157
           'analog_lim_pt5_id':  store_data, prefix+'analog_lim_pt5_id', data = {x:epoch1, y:analog_lim_pt5_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 158
           'analog_lim_pt5_red':  store_data, prefix+'analog_lim_pt5_red', data = {x:epoch1, y:analog_lim_pt5_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 159
           'analog_lim_pt6_status':  store_data, prefix+'analog_lim_pt6_status', data = {x:epoch1, y:analog_lim_pt6_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 160
           'analog_lim_pt6_id':  store_data, prefix+'analog_lim_pt6_id', data = {x:epoch1, y:analog_lim_pt6_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 161
           'analog_lim_pt6_red':  store_data, prefix+'analog_lim_pt6_red', data = {x:epoch1, y:analog_lim_pt6_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 162
           'analog_lim_pt7_status':  store_data, prefix+'analog_lim_pt7_status', data = {x:epoch1, y:analog_lim_pt7_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 163
           'analog_lim_pt7_id':  store_data, prefix+'analog_lim_pt7_id', data = {x:epoch1, y:analog_lim_pt7_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 164
           'analog_lim_pt7_red':  store_data, prefix+'analog_lim_pt7_red', data = {x:epoch1, y:analog_lim_pt7_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 165
           'analog_lim_pt8_status':  store_data, prefix+'analog_lim_pt8_status', data = {x:epoch1, y:analog_lim_pt8_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 166
           'analog_lim_pt8_id':  store_data, prefix+'analog_lim_pt8_id', data = {x:epoch1, y:analog_lim_pt8_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 167
           'analog_lim_pt8_red':  store_data, prefix+'analog_lim_pt8_red', data = {x:epoch1, y:analog_lim_pt8_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 168
           'analog_lim_pt9_status':  store_data, prefix+'analog_lim_pt9_status', data = {x:epoch1, y:analog_lim_pt9_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 169
           'analog_lim_pt9_id':  store_data, prefix+'analog_lim_pt9_id', data = {x:epoch1, y:analog_lim_pt9_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 170
           'analog_lim_pt9_red':  store_data, prefix+'analog_lim_pt9_red', data = {x:epoch1, y:analog_lim_pt9_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 171
           'analog_lim_pt10_status':  store_data, prefix+'analog_lim_pt10_status', data = {x:epoch1, y:analog_lim_pt10_status}, dlim = {ylog:0, labels:labels, panel_size:2.}      ; 172
           'analog_lim_pt10_id':  store_data, prefix+'analog_lim_pt10_id', data = {x:epoch1, y:analog_lim_pt10_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 173
           'analog_lim_pt10_red':  store_data, prefix+'analog_lim_pt10_red', data = {x:epoch1, y:analog_lim_pt10_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 174
           'analog_lim_pt11_status':  store_data, prefix+'analog_lim_pt11_status', data = {x:epoch1, y:analog_lim_pt11_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 175
           'analog_lim_pt11_id':  store_data, prefix+'analog_lim_pt11_id', data = {x:epoch1, y:analog_lim_pt11_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 176
           'analog_lim_pt11_red':  store_data, prefix+'analog_lim_pt11_red', data = {x:epoch1, y:analog_lim_pt11_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 177
           'analog_lim_pt12_status':  store_data, prefix+'analog_lim_pt12_status', data = {x:epoch1, y:analog_lim_pt12_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 178
           'analog_lim_pt12_id':  store_data, prefix+'analog_lim_pt12_id', data = {x:epoch1, y:analog_lim_pt12_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 179
           'analog_lim_pt12_red':  store_data, prefix+'analog_lim_pt12_red', data = {x:epoch1, y:analog_lim_pt12_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 180
           'analog_lim_pt13_status':  store_data, prefix+'analog_lim_pt13_status', data = {x:epoch1, y:analog_lim_pt13_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 181
           'analog_lim_pt13_id':  store_data, prefix+'analog_lim_pt13_id', data = {x:epoch1, y:analog_lim_pt13_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 182
           'analog_lim_pt13_red':  store_data, prefix+'analog_lim_pt13_red', data = {x:epoch1, y:analog_lim_pt13_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 183
           'analog_lim_pt14_status':  store_data, prefix+'analog_lim_pt14_status', data = {x:epoch1, y:analog_lim_pt14_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 184
           'analog_lim_pt14_id':  store_data, prefix+'analog_lim_pt14_id', data = {x:epoch1, y:analog_lim_pt14_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 185
           'analog_lim_pt14_red':  store_data, prefix+'analog_lim_pt14_red', data = {x:epoch1, y:analog_lim_pt14_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 186
           'analog_lim_pt15_status':  store_data, prefix+'analog_lim_pt15_status', data = {x:epoch1, y:analog_lim_pt15_status}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 187
           'analog_lim_pt15_id':  store_data, prefix+'analog_lim_pt15_id', data = {x:epoch1, y:analog_lim_pt15_id}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 188
           'analog_lim_pt15_red':  store_data, prefix+'analog_lim_pt15_red', data = {x:epoch1, y:analog_lim_pt15_red}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 189
           'opmode':  store_data, prefix+'opmode', data = {x:epoch1, y:opmode}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 190
           'sw_mode':  store_data, prefix+'sw_mode', data = {x:epoch1, y:sw_mode}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 191
           'proton_mode':  store_data, prefix+'proton_mode', data = {x:epoch1, y:proton_mode}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 192
           'active_supplyid':  store_data, prefix+'active_supplyid', data = {x:epoch1, y:active_supplyid}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 193
           'supply_coarse_rb':  store_data, prefix+'supply_coarse_rb', data = {x:epoch1, y:supply_coarse_rb}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 194
           'supply_fine_rb':  store_data, prefix+'supply_fine_rb', data = {x:epoch1, y:supply_fine_rb}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 195
           'swmaint_supplystat':  store_data, prefix+'swmaint_supplystat', data = {x:epoch1, y:swmaint_supplystat}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 196
           'swmaint_pac_coarse':  store_data, prefix+'swmaint_pac_coarse', data = {x:epoch1, y:swmaint_pac_coarse}, dlim = {ylog:0, labels:labels, panel_size:2.}  ; 197
           'swmaint_pac_fine':  store_data, prefix+'swmaint_pac_fine', data = {x:epoch1, y:swmaint_pac_fine}, dlim = {ylog:0, labels:labels, panel_size:2.} ; 198
	ENDCASE
ENDFOR


END 
