;+
; PROCEDURE: get_pla_theta_angles, sat, theta_step
;
; PURPOSE: Get STEREO/PLASTIC deflection angles
;
; INPUT:  sat: S/C id - 'A' or 'B'
;         prod: the product string
;
; OUTPUT: theta_step: deflection angle vlaues
;
; CREATED BY: C. Mouikis
;
; LAST MODIFICATION:  
;
; MODIFICATION HISTORY:
;
;-

PRO get_pla_theta_angles, sat, prod, theta_step
compile_opt strictarrsubs

theta_step = 0. 

IF prod EQ 'h_alpha' OR prod EQ 'h+peak' OR $
  prod EQ 'he++peak' OR prod EQ 'he++tcr' OR $
  prod EQ 'sw_z>2_h' OR prod EQ 'sw_z>2_l' THEN BEGIN
    
    
    theta_step = INDGEN(32)*1.33-21.28

ENDIF

IF prod EQ 'sw_z>2_h' THEN BEGIN

    theta_step =  INDGEN(8)*(4*1.33)-21.88

ENDIF

IF prod EQ 'sw_z>2_l' THEN BEGIN

    theta_step =  INDGEN(1)*(32*1.33)-21.88

ENDIF

IF prod EQ 'wap_ssd_tcr' OR  prod EQ 'wap_ssd_dcr' OR  prod EQ 'wap_no_ssd_dcr' THEN BEGIN

    theta_step =  INDGEN(1)*(32*1.33)-21.88

ENDIF

IF prod EQ 'sw_priority' THEN BEGIN

    theta_step =  INDGEN(16)*(2*1.33)-21.28 + 1.33

ENDIF
  

  
  
END
