; Lorna Ellis
; 05/01/2014
; get_pla_sc_hk

; Reads hk data from sc cdfs and makes tplot variables.

PRO get_pla_sc_hk, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'sc', filesfound
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            pl_ebox_tmp_name             = 'pl_ebox_tmp'
            pl_tof_tmp_name              = 'pl_tof_tmp'
            pl_pwr_cur_name              = 'pl_pwr_cur'
            pl_pwr_vt_name               = 'pl_pwr_vt'
            pl_surv_pwr_cur_name         = 'pl_surv_pwr_cur'
            pl_surv_pwr_vt_name          = 'pl_surv_pwr_vt'
            pl_inst_msg_pwr_dwn_req_name = 'pl_inst_msg_pwr_dwn_req'
            pl_pwr_tt_name               = 'pl_pwr_tt'
            pl_surv_pwr_tt_name          = 'pl_surv_pwr_tt'
            cdf_varget, cdf_id, pl_ebox_tmp_name,             cdf_pl_ebox_tmp,             rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, pl_tof_tmp_name,              cdf_pl_tof_tmp,              rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, pl_pwr_cur_name,              cdf_pl_pwr_cur,              rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, pl_pwr_vt_name,               cdf_pl_pwr_vt,               rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, pl_surv_pwr_cur_name,         cdf_pl_surv_pwr_cur,         rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, pl_surv_pwr_vt_name,          cdf_pl_surv_pwr_vt,          rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, pl_inst_msg_pwr_dwn_req_name, cdf_pl_inst_msg_pwr_dwn_req, rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, pl_pwr_tt_name,               cdf_pl_pwr_tt,               rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, pl_surv_pwr_tt_name,          cdf_pl_surv_pwr_tt,          rec_count = epochinfo.maxrec+1, /zvariable
            IF ifwd EQ 0 THEN BEGIN
                converted_epoch         = REFORM(time_double(epoch, /epoch))
                pl_ebox_tmp             = float(reform(cdf_pl_ebox_tmp    ))
                pl_tof_tmp              = float(reform(cdf_pl_tof_tmp     ))
                pl_pwr_cur              = float(reform(cdf_pl_pwr_cur     ))
                pl_pwr_vt               = float(reform(cdf_pl_pwr_vt      )) 
                pl_surv_pwr_cur         = float(reform(cdf_pl_surv_pwr_cur))
                pl_surv_pwr_vt          = float(reform(cdf_pl_surv_pwr_vt ))
                pl_inst_msg_pwr_dwn_req = strcompress(string(cdf_pl_inst_msg_pwr_dwn_req), /remove_all)
                pl_pwr_tt               = strcompress(string(cdf_pl_pwr_tt              ), /remove_all)
                pl_surv_pwr_tt          = strcompress(string(cdf_pl_surv_pwr_tt         ), /remove_all)
            ENDIF ELSE BEGIN
                converted_epoch         = [converted_epoch,         float(reform(time_double(epoch, /epoch)))]
                pl_ebox_tmp             = [pl_ebox_tmp,             float(reform(cdf_pl_ebox_tmp           ))]
                pl_tof_tmp              = [pl_tof_tmp,              float(reform(cdf_pl_tof_tmp            ))]
                pl_pwr_cur              = [pl_pwr_cur,              float(reform(cdf_pl_pwr_cur            ))]
                pl_pwr_vt               = [pl_pwr_vt,               float(reform(cdf_pl_pwr_vt             ))]
                pl_surv_pwr_cur         = [pl_surv_pwr_cur,         float(reform(cdf_pl_surv_pwr_cur       ))]
                pl_surv_pwr_vt          = [pl_surv_pwr_vt,          float(reform(cdf_pl_surv_pwr_vt        ))]
                pl_inst_msg_pwr_dwn_req = [pl_inst_msg_pwr_dwn_req, strcompress(string(cdf_pl_inst_msg_pwr_dwn_req), /remove_all)]
                pl_pwr_tt               = [pl_pwr_tt,               strcompress(string(cdf_pl_pwr_tt              ), /remove_all)]
                pl_surv_pwr_tt          = [pl_surv_pwr_tt,          strcompress(string(cdf_pl_surv_pwr_tt         ), /remove_all)]
            ENDELSE
            ifwd =  ifwd + 1            
        ENDIF
        cdf_close, cdf_id
    ENDIF
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

; outside timerange
get_timespan, tt
bad_i = where(converted_epoch LT tt[0] OR converted_epoch GT tt[1], bad_count, complement = good_i, ncomplement = good_count)
IF good_count EQ 0 THEN BEGIN 
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF ELSE IF bad_count GT 0 THEN BEGIN
    converted_epoch         = converted_epoch        [good_i]
    pl_ebox_tmp             = pl_ebox_tmp            [good_i]
    pl_tof_tmp              = pl_tof_tmp             [good_i]
    pl_pwr_cur              = pl_pwr_cur             [good_i]
    pl_pwr_vt               = pl_pwr_vt              [good_i]
    pl_surv_pwr_cur         = pl_surv_pwr_cur        [good_i]
    pl_surv_pwr_vt          = pl_surv_pwr_vt         [good_i]
    pl_inst_msg_pwr_dwn_req = pl_inst_msg_pwr_dwn_req[good_i]
    pl_pwr_tt               = pl_pwr_tt              [good_i]
    pl_surv_pwr_tt          = pl_surv_pwr_tt         [good_i]
ENDIF 

; check for fill
bad_ebox_tmp_i     = where(pl_ebox_tmp     EQ -1, bad_ebox_tmp_c    )
bad_tof_tmp_i      = where(pl_tof_tmp      EQ -1, bad_tof_tmp_c     )
bad_pwr_cur_i      = where(pl_pwr_cur      EQ -1, bad_pwr_cur_c     )
bad_pwr_vt_i       = where(pl_pwr_vt       EQ -1, bad_pwr_vt_c      )
bad_surv_pwr_cur_i = where(pl_surv_pwr_cur EQ -1, bad_surv_pwr_cur_c)
bad_surv_pwr_vt_i  = where(pl_surv_pwr_vt  EQ -1, bad_surv_pwr_vt_c )
IF bad_ebox_tmp_c     GT 0 THEN pl_ebox_tmp    [bad_ebox_tmp_i    ] = !values.f_nan
IF bad_tof_tmp_c      GT 0 THEN pl_tof_tmp     [bad_tof_tmp_i     ] = !values.f_nan
IF bad_pwr_cur_c      GT 0 THEN pl_pwr_cur     [bad_pwr_cur_i     ] = !values.f_nan
IF bad_pwr_vt_c       GT 0 THEN pl_pwr_vt      [bad_pwr_vt_i      ] = !values.f_nan
IF bad_surv_pwr_cur_c GT 0 THEN pl_surv_pwr_cur[bad_surv_pwr_cur_i] = !values.f_nan
IF bad_surv_pwr_vt_c  GT 0 THEN pl_surv_pwr_vt [bad_surv_pwr_vt_i ] = !values.f_nan

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_sc_'

store_data, varstr+'pl_ebox_tmp', $
            data = {x:converted_epoch, y:pl_ebox_tmp                 }, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpl_ebox_tmp!C!Cdec C'       }
store_data, varstr+'pl_tof_tmp', $
            data = {x:converted_epoch, y:pl_tof_tmp                  }, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpl_tof_tmp!C!Cdec C'        }
store_data, varstr+'pl_pwr_cur', $
            data = {x:converted_epoch, y:pl_pwr_cur                  }, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpl_pwr_cur!C!CAmps'         }
store_data, varstr+'pl_pwr_vt', $
            data = {x:converted_epoch, y:pl_pwr_vt                   }, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpl_pwr_vt!C!CVolts'         }
store_data, varstr+'pl_surv_pwr_cur', $
            data = {x:converted_epoch, y:pl_surv_pwr_cur             }, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpl_surv_pwr_cur!C!CAmps'    }
store_data, varstr+'pl_surv_pwr_vt', $
            data = {x:converted_epoch, y:pl_surv_pwr_vt              }, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpl_surv_pwr_vt!C!CVolts'    }
store_data, varstr+'pl_inst_msg_pwr_dwn_req', $
            data = {x:converted_epoch, y:pl_inst_msg_pwr_dwn_req     }, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpl_inst_msg_pwr_dwn_req'    }
store_data, varstr+'pl_pwr_tt', $
            data = {x:converted_epoch, y:pl_pwr_tt                   }, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpl_pwr_tt'                  }
store_data, varstr+'pl_surv_pwr_tt', $
            data = {x:converted_epoch, y:pl_surv_pwr_tt              }, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'ST'+sat+'!C!Cpl_surv_pwr_tt'             }
END
