;+
; PROCEDURE: get_pla_pha
;
; PURPOSE: To create the data structure of the 'pha' product
;
; INPUT: sat: S/C id - 'A' or 'B'
;
; OUTPUT: the data structure is returned
;
; CREATED BY: L. Ellis -- based on Chris's get_pla_h1_alpha
;
; LAST MODIFICATION:
;
; MODIFICATION HISTORY:
;   07-14-2009: LBE: Created
;   11-03-2209: LBE: Removed stop if no data found.
;
;-

PRO get_pla_pha, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

prod        = 'pha'

seek_files, sat, 'science', filesfound ; find files that correspond to time interval
iff = WHERE(filesfound NE '',  ciff)
IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'epoch1'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'pha'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
            cdf_varget, cdf_id, prod_name, cdf_data, rec_count = epochinfo.maxrec+1, /zvariable

            prod_name = 'error1'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_error1, rec_count = epochinfo.maxrec+1, /zvariable

            IF ifwd EQ 0 THEN BEGIN
                converted_epoch = REFORM(time_double(epoch, /epoch))
                data            = TRANSPOSE(cdf_data)
                error1          = REFORM(cdf_error1)
            ENDIF ELSE BEGIN
                converted_epoch = [converted_epoch, REFORM(time_double(epoch, /epoch))]
                data            = [data,            TRANSPOSE(cdf_data)]
                error1          = [error1,          REFORM(cdf_error1)]
            ENDELSE
            ifwd =  ifwd + 1
        ENDIF
        
        cdf_close, cdf_id

    ENDIF
    
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    print, 'No data found for time interval'
ENDIF ELSE BEGIN 

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------

    icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                     converted_epoch GT (time_double('2050-01-01')), cicepoch)
    IF cicepoch GT 0 THEN STOP

    data =  FLOAT(data)
    icdata = WHERE(data EQ -1, cicdata)
    IF cicdata GT 0 THEN BEGIN
        data(icdata) =  !VALUES.F_NAN
    ENDIF

; remove times with error set
    ierr =  WHERE(error1 NE 0,  cierr)
    IF cierr GT 0 THEN BEGIN 
        data[ierr, *, *] = !values.f_nan
    ENDIF 

; reverse defl on odd esa
    a = data
    FOR jj = 0, 767 DO BEGIN 
        temp_data = reform(data[*, 0, jj])
        reverse_i = where(temp_data MOD 2 EQ 1, count)
        IF count GT 0 THEN data[reverse_i, 1, jj] = 31 - data[reverse_i, 1, jj]
    ENDFOR 
    
    prod_name = sat+'_'+prod
    store_data, prod_name, data = {x: converted_epoch, y: data}
ENDELSE 
END
