; 03/24/2016 LBE -- created

PRO get_pla_l3_heplus_psd, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'l3_heplus_psd', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_bulk_speed'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vel, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_thermal_speed'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vth, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'proton_number_density'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_den, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'he_plus_phase_space_density'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_psd, rec_count = epochinfo.maxrec+1, /zvariable
            
            prod_name = 'he_plus_counts'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_cts, rec_count = epochinfo.maxrec+1, /zvariable
            IF ifwd EQ 0 THEN BEGIN
                converted_epoch = REFORM(time_double(epoch, /epoch))
                vel             = REFORM(cdf_vel)
                vth             = REFORM(cdf_vth)
                den             = REFORM(cdf_den)
                psd             = TRANSPOSE(cdf_psd)
                cts             = TRANSPOSE(cdf_cts)
            ENDIF ELSE BEGIN
                converted_epoch = [converted_epoch, REFORM(time_double(epoch, /epoch))]
                vel             = [vel,             REFORM(            cdf_vel       )]
                vth             = [vth,             REFORM(            cdf_vth       )]
                den             = [den,             REFORM(            cdf_den       )]
                psd             = [psd,             TRANSPOSE(         cdf_psd       )]
                cts             = [cts,             TRANSPOSE(         cdf_cts       )]
            ENDELSE
            ifwd =  ifwd + 1
        ENDIF
        cdf_close, cdf_id
    ENDIF
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

get_timespan, ts
wanted_i = where(converted_epoch GE ts[0] AND converted_epoch LE ts[1], wanted_count)
IF wanted_count GT 0 THEN BEGIN
    converted_epoch = converted_epoch[wanted_i]
    vel       = vel      [wanted_i]
    vth       = vth      [wanted_i]
    den       = den      [wanted_i]
    psd       = psd      [wanted_i, *]
    cts       = cts      [wanted_i, *]
ENDIF ELSE BEGIN 
    print, 'no data in timespan'
    return
ENDELSE 

bad_vel_i       = where(vel       LT -1e+30, bad_vel_c)
bad_vth_i       = where(vth       LT -1e+30, bad_vth_c)
bad_den_i       = where(den       LT -1e+30, bad_den_c)
bad_psd_i       = where(psd       LT -1e+30, bad_psd_c)
bad_cts_i       = where(cts       LT -1e+30, bad_cts_c)
IF bad_vel_c       GT 0 THEN vel      [bad_vel_i] = !values.f_nan
IF bad_vth_c       GT 0 THEN vth      [bad_vth_i] = !values.f_nan
IF bad_den_c       GT 0 THEN den      [bad_den_i] = !values.f_nan
IF bad_psd_c       GT 0 THEN psd      [bad_psd_i] = !values.f_nan
IF bad_cts_c       GT 0 THEN cts      [bad_cts_i] = !values.f_nan

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_l2_alphas_'

store_data, varstr+'proton_bulk_speed', $
            data = {x:converted_epoch, y:vel}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'V (km s!U-1!N)!C!CHERTN'}
store_data, varstr+'proton_thermal_speed', $
            data = {x:converted_epoch, y:vth}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Thermal Speed (km/s)'}
store_data, varstr+'proton_density', $
            data = {x:converted_epoch, y:den}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'n (cm!U-3!N)'}
FOR ii = 0, 50 DO BEGIN 
    store_data, varstr+'he_plus_psd_'+string(ii, format = '(I2.2)'), $
            data = {x:converted_epoch, y:reform(psd[*, ii])}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'HePlus_PSD_'+string(ii, format = '(I2.2)')+'!C!C(s!U3!N/km!U6!N)'}
    store_data, varstr+'he_plus_counts' +string(ii, format = '(I2.2)'), $
            data = {x:converted_epoch, y:reform(cts[*, ii])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'HePlus_Counts_'+string(ii, format = '(I2.2)')}
ENDFOR 

END
