; 01/10/2008 LBE -- added error and error_poor_stats
; 01/28/2008 LBE -- added velocity_sdev
; 02/06/2008 LBE -- changed from l2mom to l2obmom
; 03/25/2009 LBE -- Updated for new CDFs. (V02)
; 07/15/2010 LBE -- Removed mom argument
; 11/04/2010 LBE -- added order flag (1=only prelim, 2=valid first, 3=prelim first) -- default is valid only

PRO get_pla_l2obmom, sat, order = order
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

IF keyword_set(order) EQ 0 THEN order = 0
IF order EQ 0 THEN BEGIN 
    seek_files, sat, 'l2_obmom_valid', filesfound, browse = browse
    iff = WHERE(filesfound NE '',  ciff)
    valid_count  = ciff
    prelim_count = 0
ENDIF ELSE IF order EQ 1 THEN BEGIN 
    seek_files, sat, 'l2_obmom_prelim', filesfound, browse = browse
    iff = WHERE(filesfound NE '',  ciff)
    valid_count  = 0
    prelim_count = ciff
ENDIF ELSE IF order EQ 2 OR order EQ 3 THEN BEGIN 
    seek_files, sat, 'l2_obmom_valid', filesfound_valid, browse = browse
    valid_i = WHERE(filesfound_valid NE '',  valid_count)
    seek_files, sat, 'l2_obmom_prelim', filesfound_prelim, browse = browse
    prelim_i = WHERE(filesfound_prelim NE '',  prelim_count)
    IF valid_count GT 0 AND prelim_count GT 0 THEN BEGIN
        IF array_equal(valid_i, prelim_i) EQ 1 THEN BEGIN ; same 
            IF order EQ 2 THEN BEGIN 
                filesfound = filesfound_valid
                ciff = valid_count
            ENDIF ELSE BEGIN 
                filesfound = filesfound_prelim
                ciff = prelim_count
            ENDELSE 
        ENDIF ELSE BEGIN
            iv = 0L             ; index into valid
            ip = 0L             ; index into prelim
            in = 0L             ; index into new
            filesfound = strarr(n_elements(filesfound_valid)) ; could be either valid or prelim
            WHILE iv LT valid_count AND ip LT prelim_count DO BEGIN
                year_v      = fix(strmid(filesfound_valid [iv], strlen(filesfound_valid [iv])-16, 4))
                year_p      = fix(strmid(filesfound_prelim[ip], strlen(filesfound_prelim[ip])-16, 4))
                monthdate_v = fix(strmid(filesfound_valid [iv], strlen(filesfound_valid [iv])-12, 4))
                monthdate_p = fix(strmid(filesfound_prelim[ip], strlen(filesfound_prelim[ip])-12, 4))
                IF year_p LT year_v OR (year_p EQ year_v AND monthdate_p LT monthdate_v) THEN BEGIN ; prelim earlier
                    filesfound[in] = filesfound_prelim[ip]
                    in = in + 1
                    ip = ip + 1
                ENDIF ELSE IF year_p GT year_v OR (year_p EQ year_v AND monthdate_p GT monthdate_v) THEN BEGIN ; valid earlier
                    filesfound[in] = filesfound_valid[iv]
                    in = in + 1
                    iv = iv + 1
                ENDIF ELSE BEGIN ; same date
                    IF order EQ 2 THEN filesfound[in] = filesfound_valid[iv] $
                    ELSE filesfound[in] = filesfound_prelim[ip] 
                    in = in + 1
                    iv = iv + 1
                    ip = ip + 1
                ENDELSE 
            ENDWHILE 
            WHILE iv LT valid_count DO BEGIN ; fill in valid count
                filesfound[in] = filesfound_valid[iv] 
                in = in + 1
                iv = iv + 1
            ENDWHILE 
            WHILE ip LT prelim_count DO BEGIN ; fill in prelim count
                filesfound[in] = filesfound_prelim[ip] 
                in = in + 1
                ip = ip + 1
            ENDWHILE 
            ciff = in
        ENDELSE 
    ENDIF ELSE IF valid_count GT 0 THEN BEGIN 
        filesfound = filesfound_valid
        ciff = valid_count
    ENDIF ELSE IF prelim_count GT 0 THEN BEGIN
        filesfound = filesfound_prelim
        ciff = prelim_count
    ENDIF ELSE BEGIN ; no data
        filesfound = filesfound_valid
        ciff = 0
    ENDELSE 
ENDIF ELSE BEGIN
    print, 'invalid order'
    stop
ENDELSE 

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 

FOR jj = 0, n_elements(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        IF   strmid(filesfound[jj], strlen(filesfound[jj])-25, 8) EQ 'in_valid' THEN is_valid = 1 ELSE $
          IF strmid(filesfound[jj], strlen(filesfound[jj])-25, 8) EQ 'nonvalid' THEN is_valid = 0 ELSE stop

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'epoch'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable

            IF is_valid EQ 0 THEN BEGIN 
                prod_name = 'error'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_error,               rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'look_up_vel'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_look_up_vel,         rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'svalid_ratrig'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_svalid_ratrig,       rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'ra_eff'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_ra_eff,              rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'pri0_ratio'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_pri0_ratio,          rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_density'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
                cdf_varget, cdf_id, prod_name, cdf_density,             rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_bulk_speed_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_bulk_speed,          rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_Vx_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_vx_inst,             rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_Vy_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_vy_inst,             rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_Vz_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_vz_inst,             rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_temperature_xx_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_temperature,         rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_temperature_xy_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_temperature_xy_inst, rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_temperature_xz_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_temperature_xz_inst, rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_temperature_yy_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_temperature_yy_inst, rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_temperature_yz_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_temperature_yz_inst, rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_temperature_zz_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_temperature_zz_inst, rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_pressure_xx_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_pressure_xx_inst,    rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_pressure_xy_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_pressure_xy_inst,    rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_pressure_xz_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_pressure_xz_inst,    rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_pressure_yy_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_pressure_yy_inst,    rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_pressure_yz_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_pressure_yz_inst,    rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_pressure_zz_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_pressure_zz_inst,    rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_energy_flux_x_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_energy_flux_x_inst,  rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_energy_flux_y_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_energy_flux_y_inst,  rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_energy_flux_z_inst'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_energy_flux_z_inst,  rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_bulk_speed_spcrft'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_bulk_speed_spcrft,   rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_Vx_spcrft'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_vx_spcrft,           rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_Vy_spcrft'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_vy_spcrft,           rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_Vz_spcrft'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_vz_spcrft,           rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_n_s_flow_angle_spcrft'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_ns_spcrft,           rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_e_w_flow_angle_spcrft'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_ew_spcrft,           rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_bulk_speed_HERTN'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_bulk_speed_hertn,    rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_bulk_speed_RTN'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_bulk_speed_rtn,      rec_count = epochinfo.maxrec+1, /zvariable
            ENDIF 


            IF is_valid EQ 1 THEN BEGIN
                prod_name = 'proton_number_density'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable
                cdf_varget,  cdf_id, prod_name, cdf_density,    rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_bulk_speed'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget,  cdf_id, prod_name, cdf_bulk_speed, rec_count = epochinfo.maxrec+1, /zvariable
                prod_name = 'proton_temperature'
                cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
                cdf_varget, cdf_id, prod_name, cdf_temperature, rec_count = epochinfo.maxrec+1, /zvariable
            ENDIF 

            prod_name = 'error_poor_stats'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_error_poor_stats, rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'velocity_sdev'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_velocity_sdev,    rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_n_s_flow_angle_inst'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_ns_inst,          rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_e_w_flow_angle_inst'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_ew_inst,          rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_Vr_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vr_hertn,         rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_Vt_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vt_hertn,         rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_Vn_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vn_hertn,         rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_n_s_flow_angle_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_ns_hertn,         rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_e_w_flow_angle_HERTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_ew_hertn,         rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_Vr_RTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vr_rtn,           rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_Vt_RTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vt_rtn,           rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_Vn_RTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_vn_rtn,           rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_n_s_flow_angle_RTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_ns_rtn,           rec_count = epochinfo.maxrec+1, /zvariable
            prod_name = 'proton_e_w_flow_angle_RTN'
            cdf_control, cdf_id, get_var_info = varinfo, var = prod_name, /zvariable  
            cdf_varget, cdf_id, prod_name, cdf_ew_rtn,           rec_count = epochinfo.maxrec+1, /zvariable
            
            
            IF ifwd EQ 0 THEN BEGIN
                converted_epoch     = REFORM(time_double(epoch, /epoch))
                IF is_valid EQ 0 THEN BEGIN 
                    error               = REFORM(cdf_error)
                    look_up_vel         = REFORM(cdf_look_up_vel)
                    svalid_ratrig       = REFORM(cdf_svalid_ratrig)
                    ra_eff              = REFORM(cdf_ra_eff)
                    pri0_ratio          = REFORM(cdf_pri0_ratio)
                    vx_inst             = REFORM(cdf_vx_inst)
                    vy_inst             = REFORM(cdf_vy_inst)
                    vz_inst             = REFORM(cdf_vz_inst)
                    temperature_xy_inst = REFORM(cdf_temperature_xy_inst)
                    temperature_xz_inst = REFORM(cdf_temperature_xz_inst)
                    temperature_yy_inst = REFORM(cdf_temperature_yy_inst)
                    temperature_yz_inst = REFORM(cdf_temperature_yz_inst)
                    temperature_zz_inst = REFORM(cdf_temperature_zz_inst)
                    pressure_xx_inst    = REFORM(cdf_pressure_xx_inst)
                    pressure_xy_inst    = REFORM(cdf_pressure_xy_inst)
                    pressure_xz_inst    = REFORM(cdf_pressure_xz_inst)
                    pressure_yy_inst    = REFORM(cdf_pressure_yy_inst)
                    pressure_yz_inst    = REFORM(cdf_pressure_yz_inst)
                    pressure_zz_inst    = REFORM(cdf_pressure_zz_inst)
                    energy_flux_x_inst  = REFORM(cdf_energy_flux_x_inst)
                    energy_flux_y_inst  = REFORM(cdf_energy_flux_y_inst)
                    energy_flux_z_inst  = REFORM(cdf_energy_flux_z_inst)
                    bulk_speed_spcrft   = REFORM(cdf_bulk_speed_spcrft)
                    vx_spcrft           = REFORM(cdf_vx_spcrft)
                    vy_spcrft           = REFORM(cdf_vy_spcrft)
                    vz_spcrft           = REFORM(cdf_vz_spcrft)
                    ns_spcrft           = REFORM(cdf_ns_spcrft)
                    ew_spcrft           = REFORM(cdf_ew_spcrft)
                    bulk_speed_hertn    = REFORM(cdf_bulk_speed_hertn)
                    bulk_speed_rtn      = REFORM(cdf_bulk_speed_rtn)
                ENDIF ELSE BEGIN 
                    fill    = fltarr(n_elements(epoch))
                    fill[*] = !values.f_nan
                    error               = fill
                    look_up_vel         = fill
                    svalid_ratrig       = fill
                    ra_eff              = fill
                    pri0_ratio          = fill
                    vx_inst             = fill
                    vy_inst             = fill
                    vz_inst             = fill
                    temperature_xy_inst = fill
                    temperature_xz_inst = fill
                    temperature_yy_inst = fill
                    temperature_yz_inst = fill
                    temperature_zz_inst = fill
                    pressure_xx_inst    = fill
                    pressure_xy_inst    = fill
                    pressure_xz_inst    = fill
                    pressure_yy_inst    = fill
                    pressure_yz_inst    = fill
                    pressure_zz_inst    = fill
                    energy_flux_x_inst  = fill
                    energy_flux_y_inst  = fill
                    energy_flux_z_inst  = fill
                    bulk_speed_spcrft   = fill
                    vx_spcrft           = fill
                    vy_spcrft           = fill
                    vz_spcrft           = fill
                    ns_spcrft           = fill
                    ew_spcrft           = fill
                    bulk_speed_hertn    = fill
                    bulk_speed_rtn      = fill
                ENDELSE 
                velocity_sdev       = REFORM(cdf_velocity_sdev)
                error_poor_stats    = REFORM(cdf_error_poor_stats)
                density             = REFORM(cdf_density)
                bulk_speed          = REFORM(cdf_bulk_speed)
                temperature         = REFORM(cdf_temperature)
                ns_inst             = REFORM(cdf_ns_inst)
                ew_inst             = REFORM(cdf_ew_inst)
                vr_hertn            = REFORM(cdf_vr_hertn)
                vt_hertn            = REFORM(cdf_vt_hertn)
                vn_hertn            = REFORM(cdf_vn_hertn)
                ns_hertn            = REFORM(cdf_ns_hertn)
                ew_hertn            = REFORM(cdf_ew_hertn)
                vr_rtn              = REFORM(cdf_vr_rtn)
                vt_rtn              = REFORM(cdf_vt_rtn)
                vn_rtn              = REFORM(cdf_vn_rtn)
                ns_rtn              = REFORM(cdf_ns_rtn)
                ew_rtn              = REFORM(cdf_ew_rtn)
            ENDIF ELSE BEGIN
                converted_epoch     = [converted_epoch,     REFORM(time_double(epoch, /epoch))]
                IF is_valid EQ 0 THEN BEGIN 
                    error               = [error,               REFORM(cdf_error)]
                    look_up_vel         = [look_up_vel,         REFORM(cdf_look_up_vel)]
                    svalid_ratrig       = [svalid_ratrig,       REFORM(cdf_svalid_ratrig)]
                    ra_eff              = [ra_eff,              REFORM(cdf_ra_eff)]
                    pri0_ratio          = [pri0_ratio,          REFORM(cdf_pri0_ratio)]
                    vx_inst             = [vx_inst,             REFORM(cdf_vx_inst)]
                    vy_inst             = [vy_inst,             REFORM(cdf_vy_inst)]
                    vz_inst             = [vz_inst,             REFORM(cdf_vz_inst)]
                    temperature_xy_inst = [temperature_xy_inst, REFORM(cdf_temperature_xy_inst)]
                    temperature_xz_inst = [temperature_xz_inst, REFORM(cdf_temperature_xz_inst)]
                    temperature_yy_inst = [temperature_yy_inst, REFORM(cdf_temperature_yy_inst)]
                    temperature_yz_inst = [temperature_yz_inst, REFORM(cdf_temperature_yz_inst)]
                    temperature_zz_inst = [temperature_zz_inst, REFORM(cdf_temperature_zz_inst)]
                    pressure_xx_inst    = [pressure_xx_inst,    REFORM(cdf_pressure_xx_inst)]
                    pressure_xy_inst    = [pressure_xy_inst,    REFORM(cdf_pressure_xy_inst)]
                    pressure_xz_inst    = [pressure_xz_inst,    REFORM(cdf_pressure_xz_inst)]
                    pressure_yy_inst    = [pressure_yy_inst,    REFORM(cdf_pressure_yy_inst)]
                    pressure_yz_inst    = [pressure_yz_inst,    REFORM(cdf_pressure_yz_inst)]
                    pressure_zz_inst    = [pressure_zz_inst,    REFORM(cdf_pressure_zz_inst)]
                    energy_flux_x_inst  = [energy_flux_x_inst,  REFORM(cdf_energy_flux_x_inst)]
                    energy_flux_y_inst  = [energy_flux_y_inst,  REFORM(cdf_energy_flux_y_inst)]
                    energy_flux_z_inst  = [energy_flux_z_inst,  REFORM(cdf_energy_flux_z_inst)]
                    bulk_speed_spcrft   = [bulk_speed_spcrft,   REFORM(cdf_bulk_speed_spcrft)]
                    vx_spcrft           = [vx_spcrft,           REFORM(cdf_vx_spcrft)]
                    vy_spcrft           = [vy_spcrft,           REFORM(cdf_vy_spcrft)]
                    vz_spcrft           = [vz_spcrft,           REFORM(cdf_vz_spcrft)]
                    ns_spcrft           = [ns_spcrft,           REFORM(cdf_ns_spcrft)]
                    ew_spcrft           = [ew_spcrft,           REFORM(cdf_ew_spcrft)]
                    bulk_speed_hertn    = [bulk_speed_hertn,    REFORM(cdf_bulk_speed_hertn)]
                    bulk_speed_rtn      = [bulk_speed_rtn,      REFORM(cdf_bulk_speed_rtn)]
                ENDIF ELSE BEGIN 
                    fill    = fltarr(n_elements(epoch))
                    fill[*] = !values.f_nan
                    error               = [error,               fill]
                    look_up_vel         = [look_up_vel,         fill]
                    svalid_ratrig       = [svalid_ratrig,       fill]
                    ra_eff              = [ra_eff,              fill]
                    pri0_ratio          = [pri0_ratio,          fill]
                    vx_inst             = [vx_inst,             fill]
                    vy_inst             = [vy_inst,             fill]
                    vz_inst             = [vz_inst,             fill]
                    temperature_xy_inst = [temperature_xy_inst, fill]
                    temperature_xz_inst = [temperature_xz_inst, fill]
                    temperature_yy_inst = [temperature_yy_inst, fill]
                    temperature_yz_inst = [temperature_yz_inst, fill]
                    temperature_zz_inst = [temperature_zz_inst, fill]
                    pressure_xx_inst    = [pressure_xx_inst,    fill]
                    pressure_xy_inst    = [pressure_xy_inst,    fill]
                    pressure_xz_inst    = [pressure_xz_inst,    fill]
                    pressure_yy_inst    = [pressure_yy_inst,    fill]
                    pressure_yz_inst    = [pressure_yz_inst,    fill]
                    pressure_zz_inst    = [pressure_zz_inst,    fill]
                    energy_flux_x_inst  = [energy_flux_x_inst,  fill]
                    energy_flux_y_inst  = [energy_flux_y_inst,  fill]
                    energy_flux_z_inst  = [energy_flux_z_inst,  fill]
                    bulk_speed_spcrft   = [bulk_speed_spcrft,   fill]
                    vx_spcrft           = [vx_spcrft,           fill]
                    vy_spcrft           = [vy_spcrft,           fill]
                    vz_spcrft           = [vz_spcrft,           fill]
                    ns_spcrft           = [ns_spcrft,           fill]
                    ew_spcrft           = [ew_spcrft,           fill]
                    bulk_speed_hertn    = [bulk_speed_hertn,    fill]
                    bulk_speed_rtn      = [bulk_speed_rtn,      fill]
                ENDELSE 
                velocity_sdev       = [velocity_sdev,    REFORM(cdf_velocity_sdev)]
                error_poor_stats    = [error_poor_stats, REFORM(cdf_error_poor_stats)]
                density             = [density,          REFORM(cdf_density)]
                bulk_speed          = [bulk_speed,       REFORM(cdf_bulk_speed)]
                temperature         = [temperature,      REFORM(cdf_temperature)]
                ns_inst             = [ns_inst,          REFORM(cdf_ns_inst)]
                ew_inst             = [ew_inst,          REFORM(cdf_ew_inst)]
                vr_hertn            = [vr_hertn,         REFORM(cdf_vr_hertn)]
                vt_hertn            = [vt_hertn,         REFORM(cdf_vt_hertn)]
                vn_hertn            = [vn_hertn,         REFORM(cdf_vn_hertn)]
                ns_hertn            = [ns_hertn,         REFORM(cdf_ns_hertn)]
                ew_hertn            = [ew_hertn,         REFORM(cdf_ew_hertn)]
                vr_rtn              = [vr_rtn,           REFORM(cdf_vr_rtn)]
                vt_rtn              = [vt_rtn,           REFORM(cdf_vt_rtn)]
                vn_rtn              = [vn_rtn,           REFORM(cdf_vn_rtn)]
                ns_rtn              = [ns_rtn,           REFORM(cdf_ns_rtn)]
                ew_rtn              = [ew_rtn,           REFORM(cdf_ew_rtn)]
            ENDELSE
            ifwd =  ifwd + 1
        ENDIF
        cdf_close, cdf_id
    ENDIF
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

bad_density_i             = where(density             LT -1e+30, bad_density_c)
bad_look_up_vel_i         = where(look_up_vel         LT -1e+30, bad_look_up_vel_c)
bad_svalid_ratrig_i       = where(svalid_ratrig       LT -1e+30, bad_svalid_ratrig_c)
bad_ra_eff_i              = where(ra_eff              LT -1e+30, bad_ra_eff_c)
bad_pri0_ratio_i          = where(pri0_ratio          LT -1e+30, bad_pri0_ratio_c)
bad_velocity_sdev_i       = where(velocity_sdev       LT -1e+30, bad_velocity_sdev_c)
bad_bulk_speed_i          = where(bulk_speed          LT -1e+30, bad_bulk_speed_c)
bad_vx_inst_i             = where(vx_inst             LT -1e+30, bad_vx_inst_c)
bad_vy_inst_i             = where(vy_inst             LT -1e+30, bad_vy_inst_c)
bad_vz_inst_i             = where(vz_inst             LT -1e+30, bad_vz_inst_c)
bad_ns_inst_i             = where(ns_inst             LT -1e+30, bad_ns_inst_c)
bad_ew_inst_i             = where(ew_inst             LT -1e+30, bad_ew_inst_c)
bad_temperature_i         = where(temperature         LT -1e+30, bad_temperature_c)
bad_temperature_xy_inst_i = where(temperature_xy_inst LT -1e+30, bad_temperature_xy_inst_c)
bad_temperature_xz_inst_i = where(temperature_xz_inst LT -1e+30, bad_temperature_xz_inst_c)
bad_temperature_yy_inst_i = where(temperature_yy_inst LT -1e+30, bad_temperature_yy_inst_c)
bad_temperature_yz_inst_i = where(temperature_yz_inst LT -1e+30, bad_temperature_yz_inst_c)
bad_temperature_zz_inst_i = where(temperature_zz_inst LT -1e+30, bad_temperature_zz_inst_c)
bad_pressure_xx_inst_i    = where(pressure_xx_inst    LT -1e+30, bad_pressure_xx_inst_c)
bad_pressure_xy_inst_i    = where(pressure_xy_inst    LT -1e+30, bad_pressure_xy_inst_c)
bad_pressure_xz_inst_i    = where(pressure_xz_inst    LT -1e+30, bad_pressure_xz_inst_c)
bad_pressure_yy_inst_i    = where(pressure_yy_inst    LT -1e+30, bad_pressure_yy_inst_c)
bad_pressure_yz_inst_i    = where(pressure_yz_inst    LT -1e+30, bad_pressure_yz_inst_c)
bad_pressure_zz_inst_i    = where(pressure_zz_inst    LT -1e+30, bad_pressure_zz_inst_c)
bad_energy_flux_x_inst_i  = where(energy_flux_x_inst  LT -1e+30, bad_energy_flux_x_inst_c)
bad_energy_flux_y_inst_i  = where(energy_flux_y_inst  LT -1e+30, bad_energy_flux_y_inst_c)
bad_energy_flux_z_inst_i  = where(energy_flux_z_inst  LT -1e+30, bad_energy_flux_z_inst_c)
bad_bulk_speed_spcrft_i   = where(bulk_speed_spcrft   LT -1e+30, bad_bulk_speed_spcrft_c)
bad_vx_spcrft_i           = where(vx_spcrft           LT -1e+30, bad_vx_spcrft_c)
bad_vy_spcrft_i           = where(vy_spcrft           LT -1e+30, bad_vy_spcrft_c)
bad_vz_spcrft_i           = where(vz_spcrft           LT -1e+30, bad_vz_spcrft_c)
bad_ns_spcrft_i           = where(ns_spcrft           LT -1e+30, bad_ns_spcrft_c)
bad_ew_spcrft_i           = where(ew_spcrft           LT -1e+30, bad_ew_spcrft_c)
bad_bulk_speed_hertn_i    = where(bulk_speed_hertn    LT -1e+30, bad_bulk_speed_hertn_c)
bad_vr_hertn_i            = where(vr_hertn            LT -1e+30, bad_vr_hertn_c)
bad_vt_hertn_i            = where(vt_hertn            LT -1e+30, bad_vt_hertn_c)
bad_vn_hertn_i            = where(vn_hertn            LT -1e+30, bad_vn_hertn_c)
bad_ns_hertn_i            = where(ns_hertn            LT -1e+30, bad_ns_hertn_c)
bad_ew_hertn_i            = where(ew_hertn            LT -1e+30, bad_ew_hertn_c)
bad_bulk_speed_rtn_i      = where(bulk_speed_rtn      LT -1e+30, bad_bulk_speed_rtn_c)
bad_vr_rtn_i              = where(vr_rtn              LT -1e+30, bad_vr_rtn_c)
bad_vt_rtn_i              = where(vt_rtn              LT -1e+30, bad_vt_rtn_c)
bad_vn_rtn_i              = where(vn_rtn              LT -1e+30, bad_vn_rtn_c)
bad_ns_rtn_i              = where(ns_rtn              LT -1e+30, bad_ns_rtn_c)
bad_ew_rtn_i              = where(ew_rtn              LT -1e+30, bad_ew_rtn_c)
IF bad_look_up_vel_c         GT 0 THEN look_up_vel        [bad_look_up_vel_i]         = !values.f_nan
IF bad_svalid_ratrig_c       GT 0 THEN svalid_ratrig      [bad_svalid_ratrig_i]       = !values.f_nan
IF bad_ra_eff_c              GT 0 THEN ra_eff             [bad_ra_eff_i]              = !values.f_nan
IF bad_pri0_ratio_c          GT 0 THEN pri0_ratio         [bad_pri0_ratio_i]          = !values.f_nan
IF bad_velocity_sdev_c       GT 0 THEN velocity_sdev      [bad_velocity_sdev_i]       = !values.f_nan
IF bad_density_c             GT 0 THEN density            [bad_density_i]             = !values.f_nan
IF bad_bulk_speed_c          GT 0 THEN bulk_speed         [bad_bulk_speed_i]          = !values.f_nan
IF bad_vx_inst_c             GT 0 THEN vx_inst            [bad_vx_inst_i]             = !values.f_nan
IF bad_vy_inst_c             GT 0 THEN vy_inst            [bad_vy_inst_i]             = !values.f_nan
IF bad_vz_inst_c             GT 0 THEN vz_inst            [bad_vz_inst_i]             = !values.f_nan
IF bad_ns_inst_c             GT 0 THEN ns_inst            [bad_ns_inst_i]             = !values.f_nan
IF bad_ew_inst_c             GT 0 THEN ew_inst            [bad_ew_inst_i]             = !values.f_nan
IF bad_temperature_c         GT 0 THEN temperature        [bad_temperature_i]         = !values.f_nan
IF bad_temperature_xy_inst_c GT 0 THEN temperature_xy_inst[bad_temperature_xy_inst_i] = !values.f_nan
IF bad_temperature_xz_inst_c GT 0 THEN temperature_xz_inst[bad_temperature_xz_inst_i] = !values.f_nan
IF bad_temperature_yy_inst_c GT 0 THEN temperature_yy_inst[bad_temperature_yy_inst_i] = !values.f_nan
IF bad_temperature_yz_inst_c GT 0 THEN temperature_yz_inst[bad_temperature_yz_inst_i] = !values.f_nan
IF bad_temperature_zz_inst_c GT 0 THEN temperature_zz_inst[bad_temperature_zz_inst_i] = !values.f_nan
IF bad_pressure_xx_inst_c    GT 0 THEN pressure_xx_inst   [bad_pressure_xx_inst_i]    = !values.f_nan
IF bad_pressure_xy_inst_c    GT 0 THEN pressure_xy_inst   [bad_pressure_xy_inst_i]    = !values.f_nan
IF bad_pressure_xz_inst_c    GT 0 THEN pressure_xz_inst   [bad_pressure_xz_inst_i]    = !values.f_nan
IF bad_pressure_yy_inst_c    GT 0 THEN pressure_yy_inst   [bad_pressure_yy_inst_i]    = !values.f_nan
IF bad_pressure_yz_inst_c    GT 0 THEN pressure_yz_inst   [bad_pressure_yz_inst_i]    = !values.f_nan
IF bad_pressure_zz_inst_c    GT 0 THEN pressure_zz_inst   [bad_pressure_zz_inst_i]    = !values.f_nan
IF bad_energy_flux_x_inst_c  GT 0 THEN energy_flux_x_inst [bad_energy_flux_x_inst_i]  = !values.f_nan
IF bad_energy_flux_y_inst_c  GT 0 THEN energy_flux_y_inst [bad_energy_flux_y_inst_i]  = !values.f_nan
IF bad_energy_flux_z_inst_c  GT 0 THEN energy_flux_z_inst [bad_energy_flux_z_inst_i]  = !values.f_nan
IF bad_bulk_speed_spcrft_c   GT 0 THEN bulk_speed_spcrft  [bad_bulk_speed_spcrft_i]   = !values.f_nan
IF bad_vx_spcrft_c           GT 0 THEN vx_spcrft          [bad_vx_spcrft_i]           = !values.f_nan
IF bad_vy_spcrft_c           GT 0 THEN vy_spcrft          [bad_vy_spcrft_i]           = !values.f_nan
IF bad_vz_spcrft_c           GT 0 THEN vz_spcrft          [bad_vz_spcrft_i]           = !values.f_nan
IF bad_ns_spcrft_c           GT 0 THEN ns_spcrft          [bad_ns_spcrft_i]           = !values.f_nan
IF bad_ew_spcrft_c           GT 0 THEN ew_spcrft          [bad_ew_spcrft_i]           = !values.f_nan
IF bad_bulk_speed_hertn_c    GT 0 THEN bulk_speed_hertn   [bad_bulk_speed_hertn_i]    = !values.f_nan
IF bad_vr_hertn_c            GT 0 THEN vr_hertn           [bad_vr_hertn_i]            = !values.f_nan
IF bad_vt_hertn_c            GT 0 THEN vt_hertn           [bad_vt_hertn_i]            = !values.f_nan
IF bad_vn_hertn_c            GT 0 THEN vn_hertn           [bad_vn_hertn_i]            = !values.f_nan
IF bad_ns_hertn_c            GT 0 THEN ns_hertn           [bad_ns_hertn_i]            = !values.f_nan
IF bad_ew_hertn_c            GT 0 THEN ew_hertn           [bad_ew_hertn_i]            = !values.f_nan
IF bad_bulk_speed_rtn_c      GT 0 THEN bulk_speed_rtn     [bad_bulk_speed_rtn_i]      = !values.f_nan
IF bad_vr_rtn_c              GT 0 THEN vr_rtn             [bad_vr_rtn_i]              = !values.f_nan
IF bad_vt_rtn_c              GT 0 THEN vt_rtn             [bad_vt_rtn_i]              = !values.f_nan
IF bad_vn_rtn_c              GT 0 THEN vn_rtn             [bad_vn_rtn_i]              = !values.f_nan
IF bad_ns_rtn_c              GT 0 THEN ns_rtn             [bad_ns_rtn_i]              = !values.f_nan
IF bad_ew_rtn_c              GT 0 THEN ew_rtn             [bad_ew_rtn_i]              = !values.f_nan

; Add empty spots in arrays so don't get lines across plots
epoch_st = time_string(converted_epoch)
num_gap = 0
FOR ii = 0L, n_elements(converted_epoch)-2 DO BEGIN
    IF converted_epoch[ii+1] GT converted_epoch[ii]+120 THEN BEGIN ; allow 2 minutes break
        IF num_gap EQ 0 THEN gap_i = [ii] ELSE gap_i = [gap_i, ii]
        num_gap = num_gap + 1
    ENDIF
ENDFOR 
IF num_gap GT 0 THEN BEGIN
    temp_converted_epoch     = dblarr(n_elements(converted_epoch)+num_gap)
    temp_velocity_sdev       = dblarr(n_elements(converted_epoch)+num_gap)
    temp_error_poor_stats    = dblarr(n_elements(converted_epoch)+num_gap)
    temp_density             = dblarr(n_elements(converted_epoch)+num_gap)
    temp_bulk_speed          = dblarr(n_elements(converted_epoch)+num_gap)
    temp_temperature         = dblarr(n_elements(converted_epoch)+num_gap)
    temp_ns_inst             = dblarr(n_elements(converted_epoch)+num_gap)
    temp_ew_inst             = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vr_hertn            = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vt_hertn            = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vn_hertn            = dblarr(n_elements(converted_epoch)+num_gap)
    temp_ns_hertn            = dblarr(n_elements(converted_epoch)+num_gap)
    temp_ew_hertn            = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vr_rtn              = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vt_rtn              = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vn_rtn              = dblarr(n_elements(converted_epoch)+num_gap)
    temp_ns_rtn              = dblarr(n_elements(converted_epoch)+num_gap)
    temp_ew_rtn              = dblarr(n_elements(converted_epoch)+num_gap)
    temp_error               = dblarr(n_elements(converted_epoch)+num_gap)
    temp_look_up_vel         = dblarr(n_elements(converted_epoch)+num_gap)
    temp_svalid_ratrig       = dblarr(n_elements(converted_epoch)+num_gap)
    temp_ra_eff              = dblarr(n_elements(converted_epoch)+num_gap)
    temp_pri0_ratio          = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vx_inst             = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vy_inst             = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vz_inst             = dblarr(n_elements(converted_epoch)+num_gap)
    temp_temperature_xy_inst = dblarr(n_elements(converted_epoch)+num_gap)
    temp_temperature_xz_inst = dblarr(n_elements(converted_epoch)+num_gap)
    temp_temperature_yy_inst = dblarr(n_elements(converted_epoch)+num_gap)
    temp_temperature_yz_inst = dblarr(n_elements(converted_epoch)+num_gap)
    temp_temperature_zz_inst = dblarr(n_elements(converted_epoch)+num_gap)
    temp_pressure_xx_inst    = dblarr(n_elements(converted_epoch)+num_gap)
    temp_pressure_xy_inst    = dblarr(n_elements(converted_epoch)+num_gap)
    temp_pressure_xz_inst    = dblarr(n_elements(converted_epoch)+num_gap)
    temp_pressure_yy_inst    = dblarr(n_elements(converted_epoch)+num_gap)
    temp_pressure_yz_inst    = dblarr(n_elements(converted_epoch)+num_gap)
    temp_pressure_zz_inst    = dblarr(n_elements(converted_epoch)+num_gap)
    temp_energy_flux_x_inst  = dblarr(n_elements(converted_epoch)+num_gap)
    temp_energy_flux_y_inst  = dblarr(n_elements(converted_epoch)+num_gap)
    temp_energy_flux_z_inst  = dblarr(n_elements(converted_epoch)+num_gap)
    temp_bulk_speed_spcrft   = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vx_spcrft           = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vy_spcrft           = dblarr(n_elements(converted_epoch)+num_gap)
    temp_vz_spcrft           = dblarr(n_elements(converted_epoch)+num_gap)
    temp_ns_spcrft           = dblarr(n_elements(converted_epoch)+num_gap)
    temp_ew_spcrft           = dblarr(n_elements(converted_epoch)+num_gap)
    temp_bulk_speed_hertn    = dblarr(n_elements(converted_epoch)+num_gap)
    temp_bulk_speed_rtn      = dblarr(n_elements(converted_epoch)+num_gap)
    new_i = 0
    FOR ii = -1, num_gap-1 DO BEGIN 
        CASE ii OF
            -1: BEGIN 
                start_i  = 0         
                stop_i   = gap_i[0] 
                num_good = gap_i[0] + 1
            END
            (num_gap - 1): BEGIN
                start_i  = gap_i[ii]+1
                stop_i   = n_elements(converted_epoch) - 1                
                num_good = n_elements(converted_epoch) - 1 - gap_i[ii] 
            END
            ELSE: BEGIN
                start_i  = gap_i[ii] + 1
                stop_i   = gap_i[ii+1]
                num_good = gap_i[ii+1] - gap_i[ii] 
            END
        ENDCASE 
        temp_converted_epoch    [new_i:(new_i+num_good-1)] = converted_epoch    [start_i:stop_i]
        temp_velocity_sdev      [new_i:(new_i+num_good-1)] = velocity_sdev      [start_i:stop_i]
        temp_error_poor_stats   [new_i:(new_i+num_good-1)] = error_poor_stats   [start_i:stop_i]
        temp_density            [new_i:(new_i+num_good-1)] = density            [start_i:stop_i]
        temp_bulk_speed         [new_i:(new_i+num_good-1)] = bulk_speed         [start_i:stop_i]
        temp_temperature        [new_i:(new_i+num_good-1)] = temperature        [start_i:stop_i]
        temp_ns_inst            [new_i:(new_i+num_good-1)] = ns_inst            [start_i:stop_i]
        temp_ew_inst            [new_i:(new_i+num_good-1)] = ew_inst            [start_i:stop_i]
        temp_vr_hertn           [new_i:(new_i+num_good-1)] = vr_hertn           [start_i:stop_i]
        temp_vt_hertn           [new_i:(new_i+num_good-1)] = vt_hertn           [start_i:stop_i]
        temp_vn_hertn           [new_i:(new_i+num_good-1)] = vn_hertn           [start_i:stop_i]
        temp_ns_hertn           [new_i:(new_i+num_good-1)] = ns_hertn           [start_i:stop_i]
        temp_ew_hertn           [new_i:(new_i+num_good-1)] = ew_hertn           [start_i:stop_i]
        temp_vr_rtn             [new_i:(new_i+num_good-1)] = vr_rtn             [start_i:stop_i]
        temp_vt_rtn             [new_i:(new_i+num_good-1)] = vt_rtn             [start_i:stop_i]
        temp_vn_rtn             [new_i:(new_i+num_good-1)] = vn_rtn             [start_i:stop_i]
        temp_ns_rtn             [new_i:(new_i+num_good-1)] = ns_rtn             [start_i:stop_i]
        temp_ew_rtn             [new_i:(new_i+num_good-1)] = ew_rtn             [start_i:stop_i]
        temp_error              [new_i:(new_i+num_good-1)] = error              [start_i:stop_i]
        temp_look_up_vel        [new_i:(new_i+num_good-1)] = look_up_vel        [start_i:stop_i]
        temp_svalid_ratrig      [new_i:(new_i+num_good-1)] = svalid_ratrig      [start_i:stop_i]
        temp_ra_eff             [new_i:(new_i+num_good-1)] = ra_eff             [start_i:stop_i]
        temp_pri0_ratio         [new_i:(new_i+num_good-1)] = pri0_ratio         [start_i:stop_i]
        temp_vx_inst            [new_i:(new_i+num_good-1)] = vx_inst            [start_i:stop_i]
        temp_vy_inst            [new_i:(new_i+num_good-1)] = vy_inst            [start_i:stop_i]
        temp_vz_inst            [new_i:(new_i+num_good-1)] = vz_inst            [start_i:stop_i]
        temp_temperature_xy_inst[new_i:(new_i+num_good-1)] = temperature_xy_inst[start_i:stop_i]
        temp_temperature_xz_inst[new_i:(new_i+num_good-1)] = temperature_xz_inst[start_i:stop_i]
        temp_temperature_yy_inst[new_i:(new_i+num_good-1)] = temperature_yy_inst[start_i:stop_i]
        temp_temperature_yz_inst[new_i:(new_i+num_good-1)] = temperature_yz_inst[start_i:stop_i]
        temp_temperature_zz_inst[new_i:(new_i+num_good-1)] = temperature_zz_inst[start_i:stop_i]
        temp_pressure_xx_inst   [new_i:(new_i+num_good-1)] = pressure_xx_inst   [start_i:stop_i]
        temp_pressure_xy_inst   [new_i:(new_i+num_good-1)] = pressure_xy_inst   [start_i:stop_i]
        temp_pressure_xz_inst   [new_i:(new_i+num_good-1)] = pressure_xz_inst   [start_i:stop_i]
        temp_pressure_yy_inst   [new_i:(new_i+num_good-1)] = pressure_yy_inst   [start_i:stop_i]
        temp_pressure_yz_inst   [new_i:(new_i+num_good-1)] = pressure_yz_inst   [start_i:stop_i]
        temp_pressure_zz_inst   [new_i:(new_i+num_good-1)] = pressure_zz_inst   [start_i:stop_i]
        temp_energy_flux_x_inst [new_i:(new_i+num_good-1)] = energy_flux_x_inst [start_i:stop_i]
        temp_energy_flux_y_inst [new_i:(new_i+num_good-1)] = energy_flux_y_inst [start_i:stop_i]
        temp_energy_flux_z_inst [new_i:(new_i+num_good-1)] = energy_flux_z_inst [start_i:stop_i]
        temp_bulk_speed_spcrft  [new_i:(new_i+num_good-1)] = bulk_speed_spcrft  [start_i:stop_i]
        temp_vx_spcrft          [new_i:(new_i+num_good-1)] = vx_spcrft          [start_i:stop_i]
        temp_vy_spcrft          [new_i:(new_i+num_good-1)] = vy_spcrft          [start_i:stop_i]
        temp_vz_spcrft          [new_i:(new_i+num_good-1)] = vz_spcrft          [start_i:stop_i]
        temp_ns_spcrft          [new_i:(new_i+num_good-1)] = ns_spcrft          [start_i:stop_i]
        temp_ew_spcrft          [new_i:(new_i+num_good-1)] = ew_spcrft          [start_i:stop_i]
        temp_bulk_speed_hertn   [new_i:(new_i+num_good-1)] = bulk_speed_hertn   [start_i:stop_i]
        temp_bulk_speed_rtn     [new_i:(new_i+num_good-1)] = bulk_speed_rtn     [start_i:stop_i]
        new_i = new_i + num_good
        IF ii LT num_gap-1 THEN BEGIN  
            temp_converted_epoch    [new_i] = temp_converted_epoch[new_i-1]+60 ; add minute
            temp_velocity_sdev      [new_i] = !values.f_nan
            temp_error_poor_stats   [new_i] = !values.f_nan
            temp_density            [new_i] = !values.f_nan
            temp_bulk_speed         [new_i] = !values.f_nan
            temp_temperature        [new_i] = !values.f_nan
            temp_ns_inst            [new_i] = !values.f_nan
            temp_ew_inst            [new_i] = !values.f_nan
            temp_vr_hertn           [new_i] = !values.f_nan
            temp_vt_hertn           [new_i] = !values.f_nan
            temp_vn_hertn           [new_i] = !values.f_nan
            temp_ns_hertn           [new_i] = !values.f_nan
            temp_ew_hertn           [new_i] = !values.f_nan
            temp_vr_rtn             [new_i] = !values.f_nan
            temp_vt_rtn             [new_i] = !values.f_nan
            temp_vn_rtn             [new_i] = !values.f_nan
            temp_ns_rtn             [new_i] = !values.f_nan
            temp_ew_rtn             [new_i] = !values.f_nan
            temp_error              [new_i] = !values.f_nan
            temp_look_up_vel        [new_i] = !values.f_nan
            temp_svalid_ratrig      [new_i] = !values.f_nan
            temp_ra_eff             [new_i] = !values.f_nan
            temp_pri0_ratio         [new_i] = !values.f_nan
            temp_vx_inst            [new_i] = !values.f_nan
            temp_vy_inst            [new_i] = !values.f_nan
            temp_vz_inst            [new_i] = !values.f_nan
            temp_temperature_xy_inst[new_i] = !values.f_nan
            temp_temperature_xz_inst[new_i] = !values.f_nan
            temp_temperature_yy_inst[new_i] = !values.f_nan
            temp_temperature_yz_inst[new_i] = !values.f_nan
            temp_temperature_zz_inst[new_i] = !values.f_nan
            temp_pressure_xx_inst   [new_i] = !values.f_nan
            temp_pressure_xy_inst   [new_i] = !values.f_nan
            temp_pressure_xz_inst   [new_i] = !values.f_nan
            temp_pressure_yy_inst   [new_i] = !values.f_nan
            temp_pressure_yz_inst   [new_i] = !values.f_nan
            temp_pressure_zz_inst   [new_i] = !values.f_nan
            temp_energy_flux_x_inst [new_i] = !values.f_nan
            temp_energy_flux_y_inst [new_i] = !values.f_nan
            temp_energy_flux_z_inst [new_i] = !values.f_nan
            temp_bulk_speed_spcrft  [new_i] = !values.f_nan
            temp_vx_spcrft          [new_i] = !values.f_nan
            temp_vy_spcrft          [new_i] = !values.f_nan
            temp_vz_spcrft          [new_i] = !values.f_nan
            temp_ns_spcrft          [new_i] = !values.f_nan
            temp_ew_spcrft          [new_i] = !values.f_nan
            temp_bulk_speed_hertn   [new_i] = !values.f_nan
            temp_bulk_speed_rtn     [new_i] = !values.f_nan
            new_i = new_i + 1
        ENDIF 
    ENDFOR
    converted_epoch     = temp_converted_epoch            
    velocity_sdev       = temp_velocity_sdev                      
    error_poor_stats    = temp_error_poor_stats                      
    density             = temp_density                      
    bulk_speed          = temp_bulk_speed                      
    temperature         = temp_temperature                      
    ns_inst             = temp_ns_inst                      
    ew_inst             = temp_ew_inst                      
    vr_hertn            = temp_vr_hertn                      
    vt_hertn            = temp_vt_hertn                      
    vn_hertn            = temp_vn_hertn                      
    ns_hertn            = temp_ns_hertn                      
    ew_hertn            = temp_ew_hertn                      
    vr_rtn              = temp_vr_rtn                      
    vt_rtn              = temp_vt_rtn                      
    vn_rtn              = temp_vn_rtn                      
    ns_rtn              = temp_ns_rtn                      
    ew_rtn              = temp_ew_rtn                      
    error               = temp_error                      
    look_up_vel         = temp_look_up_vel                    
    svalid_ratrig       = temp_svalid_ratrig        
    ra_eff              = temp_ra_eff                   
    pri0_ratio          = temp_pri0_ratio                
    vx_inst             = temp_vx_inst             
    vy_inst             = temp_vy_inst          
    vz_inst             = temp_vz_inst         
    temperature_xy_inst = temp_temperature_xy_inst       
    temperature_xz_inst = temp_temperature_xz_inst
    temperature_yy_inst = temp_temperature_yy_inst
    temperature_yz_inst = temp_temperature_yz_inst
    temperature_zz_inst = temp_temperature_zz_inst
    pressure_xx_inst    = temp_pressure_xx_inst            
    pressure_xy_inst    = temp_pressure_xy_inst            
    pressure_xz_inst    = temp_pressure_xz_inst            
    pressure_yy_inst    = temp_pressure_yy_inst  
    pressure_yz_inst    = temp_pressure_yz_inst  
    pressure_zz_inst    = temp_pressure_zz_inst              
    energy_flux_x_inst  = temp_energy_flux_x_inst              
    energy_flux_y_inst  = temp_energy_flux_y_inst              
    energy_flux_z_inst  = temp_energy_flux_z_inst              
    bulk_speed_spcrft   = temp_bulk_speed_spcrft              
    vx_spcrft           = temp_vx_spcrft              
    vy_spcrft           = temp_vy_spcrft              
    vz_spcrft           = temp_vz_spcrft              
    ns_spcrft           = temp_ns_spcrft              
    ew_spcrft           = temp_ew_spcrft              
    bulk_speed_hertn    = temp_bulk_speed_hertn              
    bulk_speed_rtn      = temp_bulk_speed_rtn              
ENDIF 

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_l2_obmom_'

store_data, varstr+'velocity_sdev', $
            data = {x:converted_epoch, y:velocity_sdev}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'velocity_sdev'}
store_data, varstr+'error_poor_stats', $
            data = {x:converted_epoch, y:error_poor_stats}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'error: poor stats'}
store_data, varstr+'density', $
            data = {x:converted_epoch, y:density}, $
            dlim = {panel_size:1, ylog:1, $
                    ytitle:'n (cm!U-3!N)'}
store_data, varstr+'bulk_speed', $
            data = {x:converted_epoch, y:bulk_speed}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'Speed (km s!U-1!N)'}
store_data, varstr+'ns_inst', $
            data = {x:converted_epoch, y:ns_inst}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'N/S Inst. (deg.)'}
store_data, varstr+'ew_inst', $
            data = {x:converted_epoch, y:ew_inst}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'E/W Inst. (deg.)'}
store_data, varstr+'temperature', $
                data = {x:converted_epoch, y:temperature}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'T!N Inst. (keV)'}
store_data, varstr+'vr_hertn', $
            data = {x:converted_epoch, y:vr_hertn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'V!LR!N HERTN (km s!U-1!N)'}
store_data, varstr+'vt_hertn', $
            data = {x:converted_epoch, y:vt_hertn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'V!LT!N HERTN (km s!U-1!N)'}
store_data, varstr+'vn_hertn', $
            data = {x:converted_epoch, y:vn_hertn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'V!LN!N HERTN (km s!U-1!N)'}
store_data, varstr+'ns_hertn', $
            data = {x:converted_epoch, y:ns_hertn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'N/S HERTN (deg.)'}
store_data, varstr+'ew_hertn', $
            data = {x:converted_epoch, y:ew_hertn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'E/W HERTN (deg.)'}
store_data, varstr+'vr_rtn', $
            data = {x:converted_epoch, y:vr_rtn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'V!LR!N RTN (km s!U-1!N)'}
store_data, varstr+'vt_rtn', $
            data = {x:converted_epoch, y:vt_rtn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'V!LT!N RTN (km s!U-1!N)'}
store_data, varstr+'vn_rtn', $
            data = {x:converted_epoch, y:vn_rtn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'V!LN!N RTN (km s!U-1!N)'}
store_data, varstr+'ns_rtn', $
            data = {x:converted_epoch, y:ns_rtn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'N/S RTN (deg.)'}
store_data, varstr+'ew_rtn', $
            data = {x:converted_epoch, y:ew_rtn}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'E/W RTN (deg.)'}
IF order NE 0 THEN BEGIN 
    store_data, varstr+'error', $
                data = {x:converted_epoch, y:error}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'error flag'}
    store_data, varstr+'look_up_vel', $
                data = {x:converted_epoch, y:look_up_vel}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'look_up_vel'}
    store_data, varstr+'svalid_ratrig', $
                data = {x:converted_epoch, y:svalid_ratrig}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'svalid_ratrig ratio'}
    store_data, varstr+'ra_eff', $
                data = {x:converted_epoch, y:ra_eff}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'ra_eff'}
    store_data, varstr+'pri0_ratio', $
                data = {x:converted_epoch, y:pri0_ratio}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'pri0_ratio'}
    store_data, varstr+'vx_inst', $
                data = {x:converted_epoch, y:vx_inst}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'V!LX!N Inst. (km s!U-1!N)'}
    store_data, varstr+'vy_inst', $
                data = {x:converted_epoch, y:vy_inst}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'V!LY!N Inst. (km s!U-1!N)'}
    store_data, varstr+'vz_inst', $
                data = {x:converted_epoch, y:vz_inst}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'V!LZ!N Inst. (km s!U-1!N)'}
    store_data, varstr+'temperature_xy_inst', $
                data = {x:converted_epoch, y:temperature_xy_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'T!LXY!N Inst. (keV)'}
    store_data, varstr+'temperature_xz_inst', $
                data = {x:converted_epoch, y:temperature_xz_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'T!LXZ!N Inst. (keV)'}
    store_data, varstr+'temperature_yy_inst', $
                data = {x:converted_epoch, y:temperature_yy_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'T!LYY!N Inst. (keV)'}
    store_data, varstr+'temperature_yz_inst', $
                data = {x:converted_epoch, y:temperature_yz_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'T!LYZ!N Inst. (keV)'}
    store_data, varstr+'temperature_zz_inst', $
                data = {x:converted_epoch, y:temperature_zz_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'T!LZZ!N Inst. (keV)'}
    store_data, varstr+'pressure_xx_inst', $
                data = {x:converted_epoch, y:pressure_xx_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'P!LXX!N Inst. (nP)'}
    store_data, varstr+'pressure_xy_inst', $
                data = {x:converted_epoch, y:pressure_xy_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'P!LXY!N Inst. (nP)'}
    store_data, varstr+'pressure_xz_inst', $
                data = {x:converted_epoch, y:pressure_xz_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'P!LXZ!N Inst. (nP)'}
    store_data, varstr+'pressure_yy_inst', $
                data = {x:converted_epoch, y:pressure_yy_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'P!LYY!N Inst. (nP)'}
    store_data, varstr+'pressure_yz_inst', $
                data = {x:converted_epoch, y:pressure_yz_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'P!LYZ!N Inst. (nP)'}
    store_data, varstr+'pressure_zz_inst', $
                data = {x:converted_epoch, y:pressure_zz_inst}, $
                dlim = {panel_size:1, ylog:1, $
                        ytitle:'P!LZZ!N Inst. (nP)'}
    store_data, varstr+'energy_flux_x_inst', $
                data = {x:converted_epoch, y:energy_flux_x_inst}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'V!LX!N Inst. (km s!U-1!N)'}
    store_data, varstr+'energy_flux_y_inst', $
                data = {x:converted_epoch, y:energy_flux_y_inst}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'V!LY!N Inst. (km s!U-1!N)'}
    store_data, varstr+'energy_flux_z_inst', $
                data = {x:converted_epoch, y:energy_flux_z_inst}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'V!LZ!N Inst. (km s!U-1!N)'}
    store_data, varstr+'bulk_speed_spcrft', $
                data = {x:converted_epoch, y:bulk_speed_spcrft}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'Speed Spcrft. (km s!U-1!N)'}
    store_data, varstr+'vx_spcrft', $
                data = {x:converted_epoch, y:vx_spcrft}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'V!LX!N Spcrft. (km s!U-1!N)'}
    store_data, varstr+'vy_spcrft', $
                data = {x:converted_epoch, y:vy_spcrft}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'V!LY!N Spcrft. (km s!U-1!N)'}
    store_data, varstr+'vz_spcrft', $
                data = {x:converted_epoch, y:vz_spcrft}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'V!LZ!N Spcrft. (km s!U-1!N)'}
    store_data, varstr+'ns_spcrft', $
                data = {x:converted_epoch, y:ns_spcrft}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'N/S Spcrft. (deg.)'}
    store_data, varstr+'ew_spcrft', $
                data = {x:converted_epoch, y:ew_spcrft}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'E/W Spcrft. (deg.)'}
    store_data, varstr+'bulk_speed_hertn', $
                data = {x:converted_epoch, y:bulk_speed_hertn}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'Speed HERTN (km s!U-1!N)'}
    store_data, varstr+'bulk_speed_rtn', $
                data = {x:converted_epoch, y:bulk_speed_rtn}, $
                dlim = {panel_size:1, ylog:0, $
                        ytitle:'Speed RTN (km s!U-1!N)'}
ENDIF 
    

END
