;+
; FUNCTION: get_pla_data
;
; PURPOSE:to call the relevant product reading function
;
; INPPUT: sat  -  S/C id - 'A' or 'B'
;         prod - 
;
; KEYWORDS: full_chan : 2=main,1=schan, default=both - use to specify which channel to include 
;           from_full : set if want spectrogram created from full distribution --
;                       necessary if have included running average
;           weights   : Array of floats for running average
;                       Should add to 1. Should have odd # of elements. (ex: [.25, .5, .25])
;           no_defl   : Sum over defl before running ave.
;           accum_min     : Run accumulation rather than average -- running accum,  remove zeros
;           key_eff   : Use position bin efficiencies before finding average.
;           roll_eff  : Use roll efficiencies for each position bin.
;           accum_time: [num_min_accum, start_time]
;
; LAST MODIFICATION:
;
; MODIFICATION LIST:
;   05-20-2010: LBE: Added full_chan keyword (for specifying which channel to include)
;                    Added weights keyword (for when using running average)
;   05-24-2010: LBE: Added no_defl keyword.
;   06-08-2010: LBE: Added accum_min keyword.
;   12-16-2011: LBE: Added key_eff keyword.
;   03-16-2012: LBE: Added roll_eff.
;   05-23-2012: LBE: Added keywords to he++peak and he++tcr.
;   05-29-2012: LBE: Added accum_time.
;   09-27-2012: LBE: Added set_to_beg keyword.
;   01-23-2013: LBE: Add erase gaps keywords (to make spears in plots disappear).
;   11-28-2016: LBE: Added from_full keyword to h1_alpha

FUNCTION get_pla_data, sat, prod, class, full_chan = full_chan, weights = weights, from_full = from_full, no_defl = no_defl, accum_min = accum_min, key_eff = key_eff, roll_eff = roll_eff, accum_time = accum_time, set_to_beg = set_to_beg, erase_gaps = erase_gaps
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose

CASE prod OF
    'h_alpha':             RETURN, get_pla_h1_alpha(sat, set_to_beg = set_to_beg, from_full = from_full)
    'h+peak':              RETURN, get_pla_h1_peak(sat, full_chan = full_chan, weights = weights, $
                                                   from_full = from_full, no_defl = no_defl, accum_min = accum_min, $
                                                   key_eff = key_eff, roll_eff = roll_eff, set_to_beg = set_to_beg)
    'he++peak':            RETURN, get_pla_he2_peak(sat, from_full = from_full, weights = weights, $
                                                   full_chan = full_chan, no_defl = no_defl, accum_min = accum_min, $
                                                   set_to_beg = set_to_beg)
    'he++tcr':             RETURN, get_pla_he2_tcr(sat, from_full = from_full, weights = weights, $
                                                   full_chan = full_chan, no_defl = no_defl, accum_min = accum_min, $
                                                   set_to_beg = set_to_beg)
    'sw_z>2_h':            RETURN, get_pla_sw_z2_h(sat, class, set_to_beg = set_to_beg, erase_gaps = erase_gaps)
    'sw_z>2_l':            RETURN, get_pla_sw_z2_l(sat, class, full_chan = full_chan, roll_eff = roll_eff, $
                                                   set_to_beg = set_to_beg, erase_gaps = erase_gaps)
    'wap_ssd_tcr':         RETURN, get_pla_wap_ssd_tcr(sat, class, set_to_beg = set_to_beg, erase_gaps = erase_gaps)
    'wap_ssd_dcr':         RETURN, get_pla_wap_ssd_dcr(sat, class, set_to_beg = set_to_beg, erase_gaps = erase_gaps)
    'wap_no_ssd_dcr':      RETURN, get_pla_wap_no_ssd_dcr(sat, class, set_to_beg = set_to_beg, erase_gaps = erase_gaps)
    'sw_priority':         RETURN, get_pla_sw_priority(sat, class, set_to_beg = set_to_beg, erase_gaps = erase_gaps)   
    'wap_priority_ssd':    RETURN, get_pla_wap_priority_ssd(sat, class, set_to_beg = set_to_beg, erase_gaps = erase_gaps)
    'wap_priority_no_ssd': RETURN, get_pla_wap_priority_no_ssd(sat, class, set_to_beg = set_to_beg, erase_gaps = erase_gaps)
    'class':               RETURN, get_class(sat, set_to_beg = set_to_beg)
    ELSE: BEGIN
        err_msg, 'No product found matching: ' + prod
        get_err_no =  1
    END
ENDCASE
stop
RETURN, 0

END
