; 09/24/2010 LBE Created

PRO get_pla_beacon_heavies, sat
compile_opt strictarrsubs

COMMON get_error, get_err_no, get_err_msg, default_verbose
get_err_no = 0 & get_err_msg = ''

seek_files, sat, 'beacon', filesfound, browse = browse
iff = WHERE(filesfound NE '',  ciff)

IF ciff EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No files found'
    RETURN
ENDIF

;------------------------------------------------------------------
; Read CDF files for the specific product related parameters
;------------------------------------------------------------------
ifwd = 0 
FOR jj = 0, N_ELEMENTS(filesfound)-1 DO BEGIN

    IF filesfound(jj) NE '' THEN BEGIN

        cdf_id = cdf_open(filesfound(jj))

        prod_name = 'Epoch1'
        cdf_control, cdf_id, get_var_info = epochinfo, var = prod_name, /zvariable

        IF epochinfo.maxrec GE 0 THEN BEGIN
            
            cdf_varget, cdf_id, prod_name, epoch, rec_count = epochinfo.maxrec+1, /zvariable
            
            check_name       = 'Checksum'
            error_name       = 'Error_Flag'
            schan_name       = 'SChannel_switch'
            swz_start_name   = 'SW_Z>2_startESA' ; [2]
            swz_name         = 'SW_Z>2' ; [10,2]
            wap_ssd_dcr_name = 'WAP_SSD_DCR' ; [5,3]
            wap_ssd_tcr_name = 'WAP_SSD_TCR' ; [5,3]
            num_cycles_name  = 'Num_Cycles_Heavies' ; [5,3]

            cdf_varget, cdf_id, check_name,       cdf_check,       rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, error_name,       cdf_error,       rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, schan_name,       cdf_schan,       rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, swz_start_name,   cdf_swz_start,   rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, swz_name,         cdf_swz,         rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, wap_ssd_dcr_name, cdf_wap_ssd_dcr, rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, wap_ssd_tcr_name, cdf_wap_ssd_tcr, rec_count = epochinfo.maxrec+1, /zvariable
            cdf_varget, cdf_id, num_cycles_name,  cdf_num_cycles,  rec_count = epochinfo.maxrec+1, /zvariable

            IF ifwd EQ 0 THEN BEGIN
                converted_epoch = REFORM(time_double(epoch, /epoch))
                check           = float(reform(cdf_check))
                error           = float(reform(cdf_error))
                schan           = float(reform(cdf_schan))
                swz_start       = float(transpose(cdf_swz_start))
                swz             = float(transpose(cdf_swz))
                wap_ssd_dcr     = float(transpose(cdf_wap_ssd_dcr))
                wap_ssd_tcr     = float(transpose(cdf_wap_ssd_tcr))
                num_cycles      = float(transpose(cdf_num_cycles))
            ENDIF ELSE BEGIN
                converted_epoch = [converted_epoch, float(reform(time_double(epoch, /epoch)))]
                check           = [check,           float(reform(cdf_check))]
                error           = [error,           float(reform(cdf_error))]
                schan           = [schan,           float(reform(cdf_schan))]
                swz_start       = [swz_start,       float(float(transpose(cdf_swz_start)))]
                swz             = [swz,             float(float(transpose(cdf_swz)))]
                wap_ssd_dcr     = [wap_ssd_dcr,     float(float(transpose(cdf_wap_ssd_dcr)))]
                wap_ssd_tcr     = [wap_ssd_tcr,     float(float(transpose(cdf_wap_ssd_tcr)))]
                num_cycles      = [num_cycles,      float(float(transpose(cdf_num_cycles)))]
            ENDELSE
            ifwd =  ifwd + 1
        ENDIF
        cdf_close, cdf_id
    ENDIF
ENDFOR

IF ifwd EQ 0 THEN BEGIN
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF

;------------------------------------------------------------------
; Check individual arrays for value range validity
;------------------------------------------------------------------
icepoch =  WHERE(converted_epoch LT (time_double('1958-01-01')) OR $
                 converted_epoch GT (time_double('2050-01-01')), cicepoch)
IF cicepoch GT 0 THEN STOP

; outside timerange
get_timespan, tt
bad_i = where(converted_epoch LT tt[0] OR converted_epoch GT tt[1], bad_count, complement = good_i, ncomplement = good_count)
IF good_count EQ 0 THEN BEGIN 
    get_err_no =  1
    get_err_msg =  'No data found for time interval'
    RETURN
ENDIF ELSE IF bad_count GT 0 THEN BEGIN
    converted_epoch = converted_epoch[good_i]
    check           = check          [good_i]
    error           = error          [good_i]
    schan           = schan          [good_i]
    swz_start       = swz_start      [good_i, *] 
    swz             = swz            [good_i, *, *]
    wap_ssd_dcr     = wap_ssd_dcr    [good_i, *, *]
    wap_ssd_tcr     = wap_ssd_tcr    [good_i, *, *]
    num_cycles      = num_cycles     [good_i, *, *]
ENDIF 

; check for fill values
bad_check       = where((check      LT 0) OR (check     EQ 255), check_count)
bad_error       = where((error      LT 0) OR (error     EQ 255), error_count)
bad_schan       = where((schan      LT 0) OR (schan     EQ 255), schan_count)
bad_swz_start   = where((swz_start  LT 0) OR (swz_start EQ 255), swz_start_count)
bad_swz         = where(swz         LT 0, swz_count)
bad_wap_ssd_dcr = where(wap_ssd_dcr LT 0, wap_ssd_dcr_count)
bad_wap_ssd_tcr = where(wap_ssd_tcr LT 0, wap_ssd_tcr_count)
bad_num_cycles  = where(num_cycles  LT 0, num_cycles_count)
IF check_count       GT 0 THEN check      [bad_check      ] = !values.f_nan
IF error_count       GT 0 THEN error      [bad_error      ] = !values.f_nan
IF schan_count       GT 0 THEN schan      [bad_schan      ] = !values.f_nan
IF swz_start_count   GT 0 THEN swz_start  [bad_swz_start  ] = !values.f_nan
IF swz_count         GT 0 THEN swz        [bad_swz        ] = !values.f_nan
IF wap_ssd_dcr_count GT 0 THEN wap_ssd_dcr[bad_wap_ssd_dcr] = !values.f_nan
IF wap_ssd_tcr_count GT 0 THEN wap_ssd_tcr[bad_wap_ssd_tcr] = !values.f_nan
IF num_cycles_count  GT 0 THEN num_cycles [bad_num_cycles] = !values.f_nan

; check for bad data
bad_i = where(check GT 0 OR error GT 0, bad_count)
IF bad_count GT 0 THEN BEGIN 
    swz        [bad_i, *, *] = !values.f_nan
    wap_ssd_dcr[bad_i, *, *] = !values.f_nan
    wap_ssd_tcr[bad_i, *, *] = !values.f_nan
ENDIF 
FOR ii = 0, 9 DO BEGIN ; 10 classes
    swz_flag = reform(swz[*, 1, ii])
    bad_i = where(swz_flag GT 0, bad_count)
    IF bad_count GT 0 THEN swz[bad_i, 0, ii] = !values.f_nan
ENDFOR 

;------------------------------------------------------------------
; Save in tplot variables
;------------------------------------------------------------------
varstr = sat + '_beacon_'

store_data, varstr+'checksum_flag', $
            data = {x:converted_epoch, y:check}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'checksum flag'}
store_data, varstr+'error', $
            data = {x:converted_epoch, y:error}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'error flag'}
store_data, varstr+'schan_esa', $
            data = {x:converted_epoch, y:schan}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'schan esa'}
store_data, varstr+'swz_start_esa', $
            data = {x:converted_epoch, y:swz_start}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_start_esa'}
store_data, varstr+'swz_start_esa_c00_c04', $
            data = {x:converted_epoch, y:reform(swz_start[*, 0])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_start_esa_c00_c04'}
store_data, varstr+'swz_start_esa_c05_c09', $
            data = {x:converted_epoch, y:reform(swz_start[*, 1])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_start_esa_c05_c09'}
store_data, varstr+'swz', $
            data = {x:converted_epoch, y:swz}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz'}
store_data, varstr+'swz_c00', $
            data = {x:converted_epoch, y:reform(swz[*, 0, 0])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_c00'}
store_data, varstr+'swz_c01', $
            data = {x:converted_epoch, y:reform(swz[*, 0, 1])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_c01'}
store_data, varstr+'swz_c02', $
            data = {x:converted_epoch, y:reform(swz[*, 0, 2])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_c02'}
store_data, varstr+'swz_c03', $
            data = {x:converted_epoch, y:reform(swz[*, 0, 3])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_c03'}
store_data, varstr+'swz_c04', $
            data = {x:converted_epoch, y:reform(swz[*, 0, 4])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_c04'}
store_data, varstr+'swz_c05', $
            data = {x:converted_epoch, y:reform(swz[*, 0, 5])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_c05'}
store_data, varstr+'swz_c06', $
            data = {x:converted_epoch, y:reform(swz[*, 0, 6])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_c06'}
store_data, varstr+'swz_c07', $
            data = {x:converted_epoch, y:reform(swz[*, 0, 7])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_c07'}
store_data, varstr+'swz_c08', $
            data = {x:converted_epoch, y:reform(swz[*, 0, 8])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_c08'}
store_data, varstr+'swz_c09', $
            data = {x:converted_epoch, y:reform(swz[*, 0, 9])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'swz_c09'}
store_data, varstr+'wap_ssd_dcr', $
            data = {x:converted_epoch, y:wap_ssd_dcr}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c00_e000_e040', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 0, 0])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c00_e041_e080', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 1, 0])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c00_e081_e127', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 2, 0])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c01_e000_e040', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 0, 1])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c01_e041_e080', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 1, 1])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c01_e081_e127', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 2, 1])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c02_e000_e040', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 0, 2])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c02_e041_e080', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 1, 2])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c02_e081_e127', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 2, 2])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c03_e000_e040', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 0, 3])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c03_e041_e080', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 1, 3])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c03_e081_e127', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 2, 3])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c04_e000_e040', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 0, 4])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c04_e041_e080', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 1, 4])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_dcr_c04_e081_e127', $
            data = {x:converted_epoch, y:reform(wap_ssd_dcr[*, 2, 4])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_dcr'}
store_data, varstr+'wap_ssd_tcr', $
            data = {x:converted_epoch, y:wap_ssd_tcr}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c00_e000_e040', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 0, 0])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c00_e041_e080', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 1, 0])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c00_e081_e127', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 2, 0])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c01_e000_e040', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 0, 1])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c01_e041_e080', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 1, 1])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c01_e081_e127', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 2, 1])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c02_e000_e040', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 0, 2])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c02_e041_e080', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 1, 2])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c02_e081_e127', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 2, 2])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c03_e000_e040', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 0, 3])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c03_e041_e080', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 1, 3])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c03_e081_e127', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 2, 3])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c04_e000_e040', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 0, 4])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c04_e041_e080', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 1, 4])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'wap_ssd_tcr_c04_e081_e127', $
            data = {x:converted_epoch, y:reform(wap_ssd_tcr[*, 2, 4])}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'wap_ssd_tcr'}
store_data, varstr+'num_cycles', $
            data = {x:converted_epoch, y:num_cycles}, $
            dlim = {panel_size:1, ylog:0, $
                    ytitle:'num_cycles'}

END
