;+
;PROCEDURE: find_cal_indices
;PURPOSE: figure out which data points use which calibration file
;
;PARAMETERS:   
; in : epoch -- array of epoch times, may include NaN
; in : data  -- array of data, indices of Nan should match those for
;               epoch
; in : cal_start  -- for each element, start time of that
;                       calibration file
; in : cal_stop   -- for each element, stop time of that
;                       calibration file
; out: data_indices   -- indices into a data array for valid data
;                      (record index)
; out: cal_file_index -- for each valid data point, gives index of cal
;                       file to use
;
;CREATED BY: L. Ellis
;
;LAST MODIFICATION: 10/14/2006
;
;MODIFICATION HISTORY:
;    10/14/2006 Created
;	November 2006 -- K. Simunac modified cal_file_index to "long' 
;    04/18/2008 LBE: Added check that num_data_indices GT 0
;    06/11/2014 LBE: Check epoch for NaN instead of data
;-
PRO find_cal_indices, epoch, data, cal_start, cal_stop, data_indices, cal_file_index
compile_opt strictarrsubs

num_cal_files = n_elements(cal_start)
;data_indices = where(finite(data), num_data_indices) ; gives index for record
data_indices = where(finite(epoch), num_data_indices) ; gives index for record
IF num_data_indices GT 0 THEN BEGIN 
    cal_file_index = lonarr(num_data_indices) ; for each data point, give index of cal file (changed to long array by K. Simunac)
    cal_file = 0L
    record = 0L
    IF epoch[data_indices[record]] LT cal_start[cal_file] AND cal_start[cal_file] NE -1 THEN BEGIN
        print, "epoch doesn't fit in calibration times"
        stop
    ENDIF ELSE cal_file_index[record] = cal_file
    record = record + 1
    WHILE record LT num_data_indices AND cal_file LT num_cal_files DO BEGIN 
        IF cal_stop[cal_file] EQ -1 OR epoch[data_indices[record]] LT cal_stop[cal_file] THEN BEGIN 
            cal_file_index[record] = cal_file
            record = record + 1
        ENDIF ELSE cal_file = cal_file + 1
    ENDWHILE
    IF record NE num_data_indices OR cal_file NE num_cal_files-1 THEN BEGIN
        print, "Error in looping"
        stop
    ENDIF  
ENDIF 
moments_started = 1

END

