; Lorna Ellis
; 04/17/2013
; check_proton_outliers_a.pro

; This is a procedure to check outliers for STA (just to make files
; smaller).

; input : epoch1   : dblarr of epoch times
; output: bad_i    : index of bad times
;         bad_count: number of bad times

PRO check_proton_outliers_a_v10, small_epoch1, bad_i, bad_count
compile_opt strictarrsubs

IF finite(small_epoch1[0] EQ 0) THEN BEGIN 
    good_i = where(finite(small_epoch1) EQ 1, good_count)
    IF good_count EQ 0 THEN stop ; problem! No good values. Shouldn't get here.
    temp_epoch = time_string(small_epoch1[good_i[0]])
ENDIF ELSE temp_epoch = time_string(small_epoch1[0])

epoch_st = time_string(small_epoch1)

IF temp_epoch LT '2008-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2007-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-02-14/16:10:37') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-18/20:44:36') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-21/16:51:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-24/07:32:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-24/09:41:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-26/06:32:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-26/09:20:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-26/09:31:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-26/09:44:35') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-02-26/10:21:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-26/10:22:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-26/10:41:35') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-02-26/11:30:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-26/14:39:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-26/18:55:35') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-02-26/18:59:35') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-02-26/19:02:35') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-02-27/20:05:35'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-03-11/21:56:33') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-03-11/21:59:33') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-03-13/20:55:32') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-03-20/01:39:31'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-04-02/12:04:28') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-04-06/08:13:27') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-04-11/14:53:26') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-04-12/04:25:26') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-04-13/07:15:26') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-04-13/07:16:26') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-04-13/07:40:26') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-04-29/11:13:25'), $ ; KDCS 05/07/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-05-07/18:36:23') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-05-07/18:57:23') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-05-07/19:19:23') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-05-07/19:23:23') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-05-07/19:28:23') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-05-07/19:38:23') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-05-07/19:42:23') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-05-07/19:43:23') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-05-08/20:22:23') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-05-16/01:58:22') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-05-17/12:15:22') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-05-19/00:28:21') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-05-22/05:26:21') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-05-22/09:45:21') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-05-25/07:20:21'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-06-01/04:57:21') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-02/13:37:20') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-08/21:34:20') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-14/03:47:18') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-14/03:57:18') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-06-14/10:57:18') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-19/10:40:18') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-22/18:48:17') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-30/10:47:55') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-30/15:38:55') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-30/15:45:55') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-30/15:49:55') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-30/16:05:55') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-30/16:09:55') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-06-30/17:18:55'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-07-01/05:59:55') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-07-11/13:35:54') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-11/13:47:54') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-11/14:35:54') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-11/14:36:54') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-11/14:38:54') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-11/16:04:54') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-11/23:32:54') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-12/01:41:54') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-12/04:09:54') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-14/22:39:54') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-27/08:14:52') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-30/10:25:51') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-07-31/05:28:51'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-08-07/07:28:50') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-08-21/03:49:49') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-08-21/03:52:49') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-08-21/04:08:49'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-09-15/06:46:45') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-09-15/14:53:45') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-09-15/18:04:45'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-10-01/15:57:43') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-10-11/17:44:41') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-10-11/17:48:41') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-10-12/20:36:41') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-10-12/20:39:41') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-10-12/20:40:41') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-10-14/12:12:41') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-10-19/01:11:40') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-10-19/01:39:40') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-10-20/07:10:40') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-10-20/15:24:40'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2007-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2007-11-01/19:36:37') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-11-02/15:05:37') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-11-02/15:06:37') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-11-02/19:00:37') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-11-03/01:21:37') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-11-14/11:02:36') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-11-14/11:18:36') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-11-17/10:38:36') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-11-21/04:44:36') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-11-21/06:54:36') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-11-26/13:33:35'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2007-12-08/09:10:32') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-12-12/18:51:31') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-12-18/04:48:30') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-12-18/23:52:30') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-12-18/23:55:30') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-12-19/00:07:30') OR $ ; KDCS 05/07/2013
                      (epoch_st EQ '2007-12-19/00:45:30') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-12-29/14:35:29') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-12-30/17:00:29') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2007-12-31/17:44:29'), $ ; KDCS 04/17/2013
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2009-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2008-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-01-09/02:31:27') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-01-09/15:03:27') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-01-10/23:41:27') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-01-11/03:36:27') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-01-16/06:35:26') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-01-16/20:11:26') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-01-17/13:33:25') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-01-20/03:40:25') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-01-30/00:15:23'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-02-04/14:32:23') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-02-04/15:07:23') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-02-04/15:08:23') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-02-06/10:53:23') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-02-06/12:18:23') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-02-12/02:03:23') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-02-12/03:52:23') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-02-13/01:05:22'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-03-01/07:06:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-01/07:27:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-02/05:55:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-02/05:56:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-02/15:39:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-02/17:39:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-02/22:51:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-03/00:33:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-03/02:24:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-03/07:15:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-03/07:32:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-03/11:07:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-03/14:04:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-04/01:27:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-04/02:16:19') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-04/16:21:18') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-05/08:10:18') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-06/01:22:18') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-08/01:27:18') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-09/16:22:17') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-09/23:11:17') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-12/07:33:17') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-26/08:28:16') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-29/08:23:16') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-03-29/12:19:16'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-04-02/05:37:15') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-04-02/16:55:15') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-04-07/06:05:15') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-04-08/03:13:15') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-04-08/11:47:14') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-04-08/19:33:14') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-04-10/08:27:14') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-04-10/11:08:14') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-04-13/07:06:14') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-04-24/21:33:11') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-04-26/01:18:11'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-05-03/13:37:10') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-05-04/07:02:10') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-05-06/11:06:09') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2008-05-08/23:55:09') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-05-09/13:03:09') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-05-13/19:14:09') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-05-16/23:17:09'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-06-01/09:28:06') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-01/09:58:06') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-01/10:27:06') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-01/10:50:06') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-01/14:25:06') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-02/02:55:06') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-03/08:18:05') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-03/08:19:05') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-03/23:31:05') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-06/01:17:05') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-06/01:18:05') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-06/01:29:05') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-09/20:53:04') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-12/07:12:04') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-13/19:56:04') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-16/18:53:03') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-16/20:02:03') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-17/10:30:03') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-24/02:12:03') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2008-06-24/02:13:03') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2008-06-24/11:16:03') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-06-30/16:34:02'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-07-01/05:16:02') OR $ ; KDCS 05/17/2013
                      (epoch_st EQ '2008-07-02/19:15:02') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-07-03/02:59:02') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-07-03/22:45:02') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-07-03/23:17:02') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-07-04/02:10:02') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-07-05/05:34:02') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-07-09/04:42:01') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-07-14/21:33:00') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-07-24/09:44:58'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-08-04/02:18:57') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-08-04/02:22:57') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-08-14/14:30:56') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-08-15/19:52:56') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2008-08-19/02:11:55') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2008-08-21/02:32:55') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-08-21/08:45:55') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2008-08-21/09:09:55') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2008-08-21/09:11:55') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-08-31/10:36:53'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-09-05/00:49:52') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-09-06/11:51:52') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-09-06/20:38:52') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-09-08/15:25:51') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-09-09/18:12:51') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-09-16/20:53:51') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-09-17/01:49:51') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-09-20/06:35:51'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-10-05/07:17:49') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-12/14:32:47') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-12/14:36:47') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-12/14:41:47') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-13/08:39:47') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-13/09:26:47') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-16/01:29:46') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-19/04:32:46') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-22/20:44:45') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-23/13:21:45') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-27/06:03:45') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-27/06:04:45') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-28/07:28:45') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-10-29/23:32:45'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2008-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2008-11-01/00:49:44') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-11-02/01:13:44') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2008-11-02/07:11:44') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-11-09/14:07:44') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-11-09/14:19:44') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-11-09/14:30:44') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-11-09/20:23:44') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-11-19/16:10:42') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-11-21/10:05:42') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-11-29/04:59:40') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-11-29/11:35:40'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2008-12-04/16:47:39') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-12-07/21:56:38') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-12-09/19:09:38') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-12-12/16:12:38') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-12-12/16:13:38') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-12-27/04:20:37') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-12-27/04:26:37') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-12-28/11:23:37') OR $ ; KDCS 04/18/2013
                      (epoch_st EQ '2008-12-28/15:31:37'), $ ; KDCS 04/18/2013
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2010-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2009-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-01-02/12:41:35') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-01-05/12:21:34') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-01-06/19:51:34') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2009-01-06/19:52:34') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2009-01-12/17:32:33') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2009-01-12/17:33:33') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2009-01-25/05:30:30') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-01-26/02:41:30'), $ ; KDCS 05/17/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-02-04/12:11:30') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-04/12:13:30') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-14/22:45:29') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-16/15:34:29') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-16/18:00:29') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-17/19:11:28') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-17/19:12:28') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-18/00:55:28') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-23/04:37:27') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-23/09:06:27') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-24/09:06:27') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-24/09:07:27') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-24/09:08:27') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-24/09:09:27') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-24/09:17:27') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-24/09:22:27') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-02-24/09:23:27'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-03-03/11:41:26') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-04/03:33:26') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-10/13:03:24') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-10/13:04:24') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-15/12:14:24') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-15/20:44:24') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-16/02:24:24') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-19/10:09:23') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-19/10:12:23') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-19/10:13:23') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-19/10:14:23') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-26/22:00:23') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-31/03:00:23') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-31/15:43:23') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-03-31/15:44:23'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-04-01/04:10:23') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-04/13:30:22') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-05/19:36:22') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-06/11:54:22') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-08/05:28:22') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-08/23:40:22') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-09/08:45:22') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-20/00:47:20') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-20/13:08:19') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-20/13:09:19') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-21/01:31:19') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-25/05:50:19') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-04-28/18:42:18'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-05-01/04:05:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-05-03/16:33:17') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-05-09/18:50:17') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-05-10/00:59:17') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-05-10/07:25:17') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-05-10/20:06:17') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-05-14/12:01:17') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-05-25/05:00:16') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-05-31/08:58:15') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-05-31/16:54:15'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-06-01/09:19:14') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2009-06-05/16:48:14') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-06-10/17:30:13') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-06-12/04:37:12') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-06-20/13:23:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-06-21/06:11:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-06-24/18:52:11'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-07-01/19:33:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-07-18/02:18:08') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-07-31/07:05:06'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-08-01/12:29:05') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-08-02/22:50:05') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-08-07/20:09:29') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-08-07/20:57:29') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-08-07/21:05:29') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-08-22/13:10:27') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-08-22/19:23:27') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-08-24/03:42:27'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-09-09/01:39:25') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-09-09/01:40:25') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-09-09/01:41:25') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-09-09/01:42:25') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-09-19/00:18:24') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-09-27/05:04:22'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-10-06/20:01:21') OR $ ; KDCS 05/08/2013
                      (epoch_st EQ '2009-10-15/23:22:20') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-10-15/23:24:20') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-10-16/06:53:20') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-10-16/07:01:20') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-10-16/07:40:20'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2009-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2009-11-01/16:45:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-01/17:22:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-01/17:23:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-01/17:30:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-01/17:37:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-01/17:38:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-01/17:39:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-01/19:06:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-01/19:27:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-03/08:55:18') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-26/01:45:14') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-26/01:49:14') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-26/01:52:14') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-26/03:30:14') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-26/03:36:14') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-27/06:35:14') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-29/18:53:14') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-11-30/00:18:14'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2009-12-03/15:14:14') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-11/14:01:13') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-20/22:04:12') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-20/22:11:12') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-22/17:52:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-22/17:57:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-22/18:54:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-22/22:01:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-24/10:28:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-25/08:17:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-25/08:22:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-25/08:46:11') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-27/15:31:10') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-27/19:11:10') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-27/22:48:10') OR $ ; KDCS 04/19/2013
                      (epoch_st EQ '2009-12-29/10:19:10'), $ ; KDCS 04/19/2013
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2011-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2010-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-01-03/18:58:09') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-04/08:48:09') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-01-04/08:53:09') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-01-07/18:52:08') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-17/01:46:08') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-17/01:49:08') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-01-17/18:02:07') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-19/15:41:07') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-19/23:55:07') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-23/20:33:07') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-25/01:22:07') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-25/01:23:07') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-25/06:53:07') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-25/10:08:07') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-25/11:11:07') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-01-25/12:50:07'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-02-12/21:28:04') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-13/14:40:04') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-13/15:35:04') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-13/16:27:04') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-14/03:51:04') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-14/10:34:04') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-14/11:25:04') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-14/11:52:04') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-14/13:55:04') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-14/14:36:04') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-19/21:03:03') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-20/19:45:03') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-22/00:44:03') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-22/05:25:03') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-02-22/05:28:03') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-02-22/05:37:03') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-22/05:40:03') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-22/16:38:03') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-23/16:35:02') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-02-25/15:05:02'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-03-02/16:52:02') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-02/22:47:02') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-08/11:09:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-12/01:01:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-12/01:02:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-12/04:38:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-12/05:14:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-12/06:01:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-12/07:24:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-12/07:25:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-12/07:39:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-12/07:59:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-17/04:41:01') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-22/22:15:00') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-22/22:27:00') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-22/23:59:00') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-23/06:27:00') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-23/06:38:00') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-23/06:44:00') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-30/17:28:59') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-30/20:51:59') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-30/22:38:59') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-03-30/23:31:59') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-31/10:38:59') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-03-31/12:05:59'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-04-01/02:48:59') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-04-01/15:43:59') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-04-04/10:17:58') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-04-05/12:50:58') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-04-05/15:55:58') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-04-11/07:30:57') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-04-18/18:16:56') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-04-19/07:35:56'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-05-02/07:53:56') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-05-02/08:03:56') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-05-02/11:41:56') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-05-04/20:53:55') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-05-08/01:34:55') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-05-12/12:51:54') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-05-12/16:21:54') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-05-19/16:20:53') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-05-19/18:00:53'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-06-04/15:49:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/16:01:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/16:20:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/16:23:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/16:24:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/16:43:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/16:49:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/16:51:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/16:53:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/18:33:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/19:53:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-04/20:28:51') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-06-04/21:24:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-05/06:26:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-05/06:40:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-05/06:50:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-05/21:23:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-15/04:23:51') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-06-15/23:30:51'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-07-01/11:15:48') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-07-01/11:55:48') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-07-01/12:42:48') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-07-05/12:01:48') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-07-06/00:09:48') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-07-07/02:52:48'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-08-11/21:33:44') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-08-17/18:28:43') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-08-20/18:01:42') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-08-20/18:16:42'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-09-11/07:34:41') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-09-11/07:48:41') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-11/07:51:41') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-09-11/07:52:41') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-09-11/07:53:41') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-09-11/08:21:41') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-11/08:28:41') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-11/10:20:41') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-11/16:43:41') OR $ ; KDCS 05/20/2013
                      (epoch_st EQ '2010-09-11/18:14:41') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-11/19:43:41') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-09-11/19:44:41') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-09-11/20:14:41') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-11/20:15:41') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-11/20:16:41') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-15/22:21:40') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-16/10:38:40') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-17/03:44:40') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-18/11:04:40') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-18/17:39:40') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-24/18:46:39') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-09-25/11:41:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/11:45:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/12:48:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/13:17:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/14:18:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/15:34:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/15:58:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/16:23:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/16:28:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/16:29:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/17:08:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/17:35:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/18:54:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/19:14:39') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-09-25/19:21:39'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-10-29/23:20:36') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-10-29/23:21:36') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-10-29/23:36:36') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-10-29/23:38:36') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-10-31/03:14:35') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-10-31/04:10:35') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-10-31/04:52:35') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-10-31/07:40:35') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-10-31/08:15:35') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-10-31/09:51:35'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2010-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2010-11-07/17:03:34') OR $ ; KDCS 05/14/2013
                      (epoch_st EQ '2010-11-14/17:06:33') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-14/17:22:33') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-14/23:58:33') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-16/02:14:33') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-16/07:25:33') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-16/10:48:33') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-16/19:05:33') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-16/19:23:33') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-16/19:24:33') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/15:14:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/16:39:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/16:42:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/16:59:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/17:06:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/17:07:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/17:11:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/18:54:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/19:03:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/19:53:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/19:59:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/20:00:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/20:01:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-21/21:33:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-22/02:26:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-22/02:28:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-22/02:35:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-22/03:14:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-22/03:15:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-26/15:48:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-26/15:51:32') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-11-26/16:58:32'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2010-12-13/13:28:31') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-12-15/16:05:31') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-12-17/19:21:31') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-12-23/00:15:30') OR $ ; KDCS 05/01/2013
                      (epoch_st EQ '2010-12-23/02:24:30'), $ ; KDCS 05/01/2013
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2012-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2011-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-01-01/22:06:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-05/00:00:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-05/00:07:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-05/02:30:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-05/02:43:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-05/03:48:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-09/16:53:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-10/07:31:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/22:28:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/22:29:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/22:31:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/22:46:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/22:56:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/22:59:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/23:09:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/23:10:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/23:13:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/23:19:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/23:24:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/23:35:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-12/23:42:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-13/00:04:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-13/00:12:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-13/14:08:28') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-17/10:23:27') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-01-17/13:12:27'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-02-02/01:39:27') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-02-02/01:48:27') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-02-07/18:07:26') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-02-07/20:00:26') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-02-07/20:01:26') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-02-07/21:54:26') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-02-09/02:50:26') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-02-09/09:38:26') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-02-10/20:45:26') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-02-20/09:07:24') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-02-26/10:34:24') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-02-27/08:18:24'), $ ; KDCS 05/16/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-03-04/09:11:24') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-04/14:05:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-09/08:08:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-14/20:25:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-14/23:25:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-14/23:38:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/01:28:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/02:31:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/02:47:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/02:56:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/03:03:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/04:15:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/04:17:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/04:29:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/04:44:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/04:47:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/09:08:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/13:18:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-15/14:11:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-22/19:57:23') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-03-22/20:20:23') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-03-22/20:37:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-22/21:53:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-22/21:54:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-22/23:19:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-22/23:23:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-22/23:25:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-22/23:35:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-23/00:15:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-23/06:54:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-23/06:55:23') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-30/21:11:22') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-30/22:04:22') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-03-30/23:22:22'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-04-06/00:42:21') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-08/10:00:21') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-08/10:02:21') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-11/16:00:20') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-04-11/19:36:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-12/03:18:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-12/03:20:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-12/04:15:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-12/04:16:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-12/06:24:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-12/06:27:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-12/07:26:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-12/19:32:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-26/05:40:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-26/20:33:20') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-04-27/06:00:20'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-05-01/05:43:19') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-01/05:51:19') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-01/06:19:19') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-01/06:29:19') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-05/07:49:19') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-07/06:52:19') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-07/06:56:19') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-07/07:03:19') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-07/07:06:19') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-07/07:08:19') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-07/07:10:19') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-07/07:14:19') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-07/07:19:19') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-07/07:28:19') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-07/07:34:19') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-07/07:49:19') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-07/11:09:19') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-11/10:35:18') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-13/14:12:18') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-21/17:36:17') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-21/17:37:17') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-23/00:55:17') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-23/01:05:17') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-05-24/07:22:17') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-05-28/02:54:16'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-06-01/09:32:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-01/14:31:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-04/01:18:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-04/09:36:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-04/10:44:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-04/17:57:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-04/18:04:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-04/18:08:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/13:30:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/13:49:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/13:51:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/14:03:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/14:21:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/14:38:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/14:49:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/14:57:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/15:20:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/15:22:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/15:24:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/15:35:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/15:36:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/15:38:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/15:42:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/15:50:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/15:54:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:03:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:11:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:14:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:18:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:19:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:20:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:22:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:31:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:38:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:43:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:45:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/16:56:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/18:36:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-05/22:08:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/00:07:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/01:38:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/01:40:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/01:52:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:24:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:27:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:30:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:34:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:40:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:42:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:43:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:46:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:47:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:50:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:51:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/02:55:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/03:05:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/03:20:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/03:24:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/03:25:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/03:27:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/06:55:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/08:03:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/08:08:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/08:43:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/08:46:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/08:50:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/08:55:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:02:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:03:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:04:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:05:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:10:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:12:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:14:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:19:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:20:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:22:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:28:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:29:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:31:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:32:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:33:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:34:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:35:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:39:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:42:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:47:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/09:56:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/10:00:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/10:06:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/11:10:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/11:16:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/11:17:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/11:52:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/11:55:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/11:56:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:06:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:07:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:10:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:12:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:28:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:30:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:31:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:33:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:36:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:37:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:39:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:41:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:42:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:44:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:45:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:46:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:50:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:51:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:55:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:56:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/12:58:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:02:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:03:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:06:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:09:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:10:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:11:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:14:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:17:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:18:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:19:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:21:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:23:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:26:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:28:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:31:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:32:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:33:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:34:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:37:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:41:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:42:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:44:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:46:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:47:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:50:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:51:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:53:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/13:59:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:00:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:03:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:04:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:06:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:07:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:09:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:12:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:17:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:18:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:26:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:28:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:29:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:30:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:35:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:36:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:38:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:40:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:42:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:43:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:47:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/14:52:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:08:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:11:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:14:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:15:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:17:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:18:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:19:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:24:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:26:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:28:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:29:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:32:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:35:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:36:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:37:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:44:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:46:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:51:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:55:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:56:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/15:59:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:01:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:03:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:09:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:10:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:16:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:18:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:20:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:21:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:24:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:26:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:27:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:29:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:31:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:32:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:33:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:35:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:37:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:38:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:39:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:40:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:43:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:44:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:46:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:47:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:49:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:50:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:51:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:56:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/16:59:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:01:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:02:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:05:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:08:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:09:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:10:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:11:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:13:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:14:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:15:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:16:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:19:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:20:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:28:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:32:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:34:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:38:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:39:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:41:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:45:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:46:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:48:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:49:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:50:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:53:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:54:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:55:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:56:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/17:58:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:03:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:08:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:16:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:17:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:18:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:19:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:21:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:22:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:24:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:25:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:26:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:31:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:32:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:34:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:35:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:37:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:51:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:53:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/18:59:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:06:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:08:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:09:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:13:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:14:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:16:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:17:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:18:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:21:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:23:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:27:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:35:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:36:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:41:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:42:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:44:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:46:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:52:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:54:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:55:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/19:58:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:02:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:06:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:10:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:11:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:21:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:25:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:26:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:29:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:30:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:33:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:43:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:46:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:47:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:50:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/20:56:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:02:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:03:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:06:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:11:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:13:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:14:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:15:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:20:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:21:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:22:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:32:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:34:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:42:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:44:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:45:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:50:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/21:51:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:08:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:13:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:18:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:22:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:25:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:27:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:30:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:32:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:38:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:41:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:45:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:46:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:48:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:49:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/22:51:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:00:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:01:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:03:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:05:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:06:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:07:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:08:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:26:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:30:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:37:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:45:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:51:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:53:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-06/23:57:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-07/00:01:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-08/16:20:16') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-06-17/13:42:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-28/16:42:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-29/01:40:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-06-29/13:10:16'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-07-09/12:18:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/13:17:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/13:18:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/14:06:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/14:26:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/14:31:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/14:50:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/14:56:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/15:01:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/15:13:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/15:15:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/15:19:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/15:21:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/15:37:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/16:27:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/16:33:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/16:56:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/18:01:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/18:11:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/18:59:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/19:02:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/19:10:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/19:11:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/19:17:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/19:19:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/19:43:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/19:45:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/19:46:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/19:49:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/19:57:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:04:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:06:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:14:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:18:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:22:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:28:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:30:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:38:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:39:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:54:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:57:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/20:58:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-09/21:01:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-10/05:53:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-16/10:48:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-16/14:19:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-16/16:22:15') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-07-24/18:38:14') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-26/16:41:14') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-07-26/16:49:14') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-26/16:52:14') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-07-26/16:55:14') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-26/17:10:14') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-07-26/17:15:14') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-07-26/23:49:14'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-08-01/08:04:13') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-08-01/14:45:13') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-08-02/05:22:13') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-08-03/07:16:13') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-08-07/15:56:13') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-08-22/13:34:11') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-08-29/16:53:11') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-08-30/06:47:11'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-09-01/00:18:11') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-08/17:13:10') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-08/17:26:10') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-09/17:03:10') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-09/19:29:10') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-10/17:37:10') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-10/17:38:10') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-11/14:45:10') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-14/15:48:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/19:27:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/19:34:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/19:35:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/19:43:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/19:44:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/19:58:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/20:03:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/20:05:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/20:08:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/20:14:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/20:15:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/20:34:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/20:38:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/20:52:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-17/21:00:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-20/17:59:17') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-20/22:29:17') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-22/20:58:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-24/09:11:16') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-09-24/09:35:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-24/09:36:16') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-09-24/09:41:16') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-09-24/09:47:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-24/09:56:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-25/13:42:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-09-28/04:06:16'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-10-01/08:59:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-10-01/18:22:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-10-03/11:11:16') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-10-07/22:01:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-10-08/03:46:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-10-08/07:07:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-10-08/14:46:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-10-11/03:51:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-10-19/14:00:15') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-10-30/10:44:13'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2011-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2011-11-06/07:23:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-06/07:36:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-06/07:58:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-13/21:18:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/09:57:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/10:58:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/11:18:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/11:26:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/11:59:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/13:11:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/13:19:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/14:12:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/14:25:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/15:19:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/16:26:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/17:21:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/18:16:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/18:57:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/19:05:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-20/19:33:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-22/02:12:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-22/03:05:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-22/03:30:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-22/05:14:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-22/05:17:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-23/06:03:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-23/06:17:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-23/06:48:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-23/06:49:12') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-30/19:41:11') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-11-30/19:42:11'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2011-12-01/14:05:11') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-01/14:52:11') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-15/03:40:09') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-12-20/00:14:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-20/04:03:09') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2011-12-20/08:45:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-20/17:26:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-20/21:51:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/11:12:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/11:13:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/11:18:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/11:23:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/11:37:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/11:56:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/12:00:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/12:04:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/12:23:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/12:25:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/12:41:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/13:18:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/13:43:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/13:53:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/14:32:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/14:44:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/14:45:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/14:50:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/14:53:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/15:25:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/16:28:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/17:01:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/17:23:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/17:26:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/17:52:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/17:53:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/17:57:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/18:14:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/18:35:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/18:41:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/19:00:09') OR $ ; KDCS 05/03/2013
                      (epoch_st EQ '2011-12-28/20:25:09'), $ ; KDCS 05/03/2013
                      bad_count)
    ENDELSE 
ENDIF ELSE IF temp_epoch LT '2013-01-01/00:00:00' THEN BEGIN 
    IF temp_epoch LT '2012-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-01-05/04:44:08') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2012-01-05/05:02:08') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2012-01-10/11:25:08') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-01-17/02:15:07') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-01-26/07:22:06') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-01-29/16:45:06') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-01-29/19:15:06') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-01-29/21:28:06') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-01-29/21:39:06') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-01-29/21:49:06'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-02-02/09:30:06') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-04/23:21:06') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2012-02-11/05:39:06') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-16/02:06:06') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-20/05:59:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-20/07:00:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-20/07:18:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-20/07:41:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-20/08:07:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-20/08:11:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-20/09:00:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-20/09:03:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/09:25:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/10:33:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/13:10:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/13:24:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/13:30:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/13:38:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/13:41:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/13:45:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/13:50:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/14:29:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/14:34:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/14:47:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/14:59:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/15:04:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/15:12:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/15:17:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/15:22:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/15:23:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/17:00:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-21/17:30:05') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-02-27/00:40:05'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-04-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-03-10/01:54:04') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-03-10/02:47:04') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-03-10/05:04:04') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-03-16/08:07:04') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-03-19/02:40:04') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-03-20/01:55:04') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-03-20/02:21:04') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-03-20/02:22:04') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-03-20/04:03:04') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-03-21/13:25:04'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-05-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-04-10/10:04:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-10/16:56:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-17/16:54:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-20/03:26:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-23/03:27:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-26/22:25:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/04:33:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/04:53:02') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2012-04-30/05:10:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/05:27:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/05:28:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/05:29:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/05:30:02') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2012-04-30/05:31:02') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2012-04-30/05:37:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/05:39:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/05:45:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/05:48:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/05:49:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/05:54:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/05:55:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/06:00:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/06:07:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/06:10:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/07:26:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/07:32:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/07:37:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/08:06:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/08:22:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/09:30:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/09:53:02') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-04-30/10:09:02'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-06-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-05-11/18:29:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-14/16:22:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-16/08:01:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/08:34:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/08:36:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/08:46:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/08:48:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/08:57:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:00:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:01:01') OR $ ; KDCS 05/22/2013
                      (epoch_st EQ '2012-05-28/09:04:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:07:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:10:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:12:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:13:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:15:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:16:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:17:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:18:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:19:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:20:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:21:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:22:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:24:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:26:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:28:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:29:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:30:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:31:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:33:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:34:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:36:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:37:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:39:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:40:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:41:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:42:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:43:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:46:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:47:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:48:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:49:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:50:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:51:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:52:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:53:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/09:58:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:00:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:01:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:02:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:04:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:06:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:13:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:17:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:18:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:19:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:20:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:22:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:23:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:24:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:26:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:29:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:55:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:57:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:58:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/10:59:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:00:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:01:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:02:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:03:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:04:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:06:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:08:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:09:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:10:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:11:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:12:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:13:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:14:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:15:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:16:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:18:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:19:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:22:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:23:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:25:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:27:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:28:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:33:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:35:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:36:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:37:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:38:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:39:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:41:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:42:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:43:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:44:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:45:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:46:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:47:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:48:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:49:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:50:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:51:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:52:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:53:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:54:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:56:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:57:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:58:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/11:59:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:00:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:01:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:05:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:06:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:08:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:10:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:12:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:13:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:15:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:17:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:26:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:29:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:30:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:31:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:32:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:33:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-05-28/12:49:01'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-07-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-06-02/00:51:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-12/19:54:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-14/01:05:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-14/01:24:01') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-14/01:41:01') OR $ ; KDCS 05/24/2013
                      (epoch_st EQ '2012-06-21/12:26:00') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-21/13:48:00') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-21/14:07:00') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-21/14:19:00') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-21/15:03:00') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-21/15:13:00') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-21/17:15:00') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-21/20:08:00') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-06-28/17:06:00'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-08-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-07-03/07:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-06/01:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-06/10:21:58') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2012-07-07/18:30:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-09/21:25:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-15/23:07:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-15/23:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-16/16:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-16/17:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-20/16:51:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/09:49:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/10:04:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/10:21:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/10:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/10:30:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/10:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/10:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/10:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/10:51:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/11:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/12:06:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/12:20:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/12:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/12:39:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/12:57:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/12:58:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/13:00:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/13:07:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/13:09:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/13:22:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/13:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/13:35:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/14:31:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/14:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/15:11:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/15:13:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/15:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/15:35:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/15:36:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/15:40:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/15:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/15:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/16:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/16:08:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/16:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/16:25:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/16:52:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/16:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/16:58:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:09:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:11:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:13:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:25:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:36:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:52:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:53:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/17:56:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:00:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:02:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:06:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:09:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:14:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:15:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:17:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:25:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:30:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:36:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:44:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:50:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:51:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:57:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:58:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/18:59:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:06:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:07:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:08:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:11:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:13:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:14:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:15:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:16:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:21:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:31:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:36:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:46:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:48:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:49:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:56:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/19:58:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:00:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:07:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:12:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:14:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:26:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:36:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:39:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:43:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:52:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/20:57:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:00:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:06:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:07:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:08:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:09:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:10:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:11:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:12:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:25:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:29:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:40:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:52:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:56:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:58:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/21:59:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:10:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:12:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:15:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:21:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:26:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:29:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:41:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:44:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:53:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/22:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:04:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:09:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:12:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:13:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:14:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:18:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:22:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:30:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:31:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:40:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:41:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:44:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:46:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:48:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:49:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-23/23:56:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:01:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:08:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:11:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:14:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:17:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:18:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:21:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:22:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:35:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:43:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:46:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:49:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:50:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:56:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/00:59:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:02:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:04:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:06:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:09:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:13:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:15:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:16:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:22:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:35:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:36:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:41:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:43:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:46:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:52:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:53:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:58:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/01:59:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:01:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:06:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:10:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:13:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:18:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:21:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:29:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:30:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:40:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:50:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:56:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/02:58:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:00:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:01:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:07:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:16:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:17:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:22:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:35:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:36:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:40:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:41:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/03:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:01:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:02:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:08:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:11:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:12:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:14:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:17:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:21:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:31:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:39:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:49:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:50:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:51:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:53:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/04:59:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:00:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:01:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:07:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:11:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:13:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:17:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:20:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:21:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:26:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:29:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:30:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:43:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:51:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:52:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/05:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:01:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:02:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:06:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:09:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:12:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:13:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:15:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:17:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:18:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:20:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:26:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:29:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:40:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:50:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:51:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/06:58:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:15:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:17:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:18:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:20:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:26:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:29:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:30:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:39:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:40:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:41:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:44:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:49:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:50:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:56:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/07:57:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:01:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:02:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:04:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:08:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:14:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:15:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:17:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:18:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:26:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:29:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:31:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:39:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:40:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:41:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:44:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:46:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:53:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/08:58:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:00:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:01:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:04:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:07:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:12:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:15:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:30:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:35:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:43:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:44:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:50:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:53:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/09:56:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:08:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:18:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:21:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:26:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:31:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:35:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:41:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:44:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:51:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/10:57:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:00:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:06:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:11:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:20:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:22:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:25:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:30:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:31:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:39:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:42:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:46:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:50:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:51:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:53:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/11:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:00:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:04:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:16:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:17:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:21:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:25:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:27:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:39:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:40:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:43:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:50:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:52:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/12:57:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:02:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:08:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:09:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:11:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:13:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:14:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:16:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:20:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:21:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:22:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:24:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:39:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:40:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:44:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:48:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:49:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:50:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:51:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:56:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/13:59:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:00:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:04:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:05:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:08:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:13:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:15:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:16:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:19:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:28:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:29:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:31:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:36:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:37:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:39:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:46:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:47:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:48:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:51:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:54:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:55:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/14:58:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:02:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:03:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:06:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:07:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:08:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:11:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:14:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:23:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:25:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:26:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:29:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:30:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:32:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:33:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:34:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:36:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:38:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:39:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:41:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:45:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:48:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:52:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/15:56:58') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:05:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:08:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:12:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:14:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:15:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:19:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:28:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:33:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:35:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:42:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:43:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:44:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:45:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:46:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:47:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:50:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:51:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:54:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/16:56:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:01:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:03:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:05:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:08:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:10:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:11:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:12:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:13:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:14:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:17:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:24:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:26:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:27:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:28:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:32:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:34:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:35:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:38:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:39:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:40:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:42:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:44:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:45:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:48:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:51:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:52:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:56:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:57:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/17:58:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:05:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:07:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:12:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:18:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:21:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:25:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:30:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:31:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:32:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:37:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:38:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:39:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:40:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:44:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:57:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/18:58:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:00:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:03:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:05:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:06:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:07:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:09:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:12:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:17:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:27:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:30:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:34:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:36:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:41:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:43:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:44:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:50:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:51:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:52:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:53:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:57:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/19:59:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:02:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:03:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:04:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:06:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:09:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:11:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:12:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:16:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:18:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:19:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:21:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:25:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:28:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:29:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:30:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:31:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:32:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:38:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:44:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:48:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:49:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/20:53:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:02:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:03:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:04:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:05:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:07:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:17:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:20:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:22:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:24:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:30:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:38:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:40:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:42:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:43:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:44:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:49:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:50:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:58:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/21:59:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:00:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:04:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:08:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:12:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:13:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:16:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:20:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:27:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:29:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:35:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:39:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:40:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:41:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:42:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:43:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:45:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/22:53:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:01:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:02:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:05:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:10:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:16:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:17:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:19:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:20:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:25:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:28:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:34:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:35:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:37:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:38:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:41:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-24/23:43:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/00:29:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/00:33:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/01:38:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/01:58:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/01:59:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:01:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:02:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:03:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:30:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:39:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:42:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:44:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:47:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:49:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:53:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:54:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:55:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:56:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/02:57:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/03:02:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/03:05:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/03:13:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/03:16:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/03:19:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/03:20:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/03:21:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/03:23:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/03:24:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/05:19:57') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2012-07-25/05:20:57') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2012-07-25/05:26:57') OR $ ; KDCS 05/16/2013
                      (epoch_st EQ '2012-07-25/06:46:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/06:47:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/07:39:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/07:43:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/07:50:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/07:52:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/07:54:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/07:57:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:00:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:04:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:06:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:11:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:12:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:16:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:18:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:20:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:23:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:26:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:33:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:34:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:36:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:38:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:43:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:44:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:45:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:46:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:50:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:51:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/08:54:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:01:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:04:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:09:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:10:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:13:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:16:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:17:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:22:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:23:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:27:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:29:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:31:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:33:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:34:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:37:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:40:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:49:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/09:59:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:00:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:03:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:08:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:14:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:15:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:23:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:25:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:26:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:27:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:31:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:32:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:39:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:42:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:53:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:55:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:57:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/10:58:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/11:01:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/11:25:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/11:26:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/11:27:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/11:30:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/11:43:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/11:45:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/11:57:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:00:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:01:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:02:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:03:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:05:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:06:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:11:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:13:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:14:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:15:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:17:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:22:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:29:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:30:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:34:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:36:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/12:37:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:08:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:13:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:22:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:32:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:36:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:37:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:39:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:41:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:42:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:46:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:47:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:48:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:53:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:57:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/13:59:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/14:00:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/14:08:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/14:12:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/14:13:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/14:19:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/14:24:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/14:31:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/14:42:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/14:50:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/15:03:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/15:14:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/15:24:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/15:53:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/15:59:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/16:05:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/16:11:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/16:18:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/16:25:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/16:28:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/16:30:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/16:31:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/16:39:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/16:56:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/17:13:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/17:48:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/18:03:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/18:27:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/18:55:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:00:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:05:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:13:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:31:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:35:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:36:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:38:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:39:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:40:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:42:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:44:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:48:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:50:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:53:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/19:56:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:01:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:10:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:18:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:20:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:22:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:26:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:45:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:47:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:48:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:52:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/20:57:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/21:08:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/21:31:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/21:45:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/21:50:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/21:51:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/21:52:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/21:58:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/22:01:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/22:06:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/22:08:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/22:09:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/22:10:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/22:26:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/22:40:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-25/23:18:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-26/00:02:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-26/00:03:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-26/00:19:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-26/00:30:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-26/00:36:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-26/01:00:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-26/01:34:57') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-07-27/23:31:57'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-09-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-08-03/21:30:56') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-08-15/07:56:55') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-08-20/11:34:54') OR $ ; KDCS 05/24/2013
                      (epoch_st EQ '2012-08-20/11:51:54') OR $ ; KDCS 05/24/2013
                      (epoch_st EQ '2012-08-22/12:22:54') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-08-22/12:23:54') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-08-22/20:56:54') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-08-22/21:10:54') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-08-22/21:16:54') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-08-22/22:15:54') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-08-22/23:47:54') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-08-23/03:20:54') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-08-28/06:25:54'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-10-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-09-03/04:37:53') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-09-05/13:53:53') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-09-05/14:27:53') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-09-09/20:54:52') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-09-09/21:00:52') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-09-12/16:50:52') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-09-22/02:35:51') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-09-22/06:26:51') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-09-23/01:00:51') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-09-30/19:20:50'), $ ; KDCS 05/24/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-11-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-10-13/10:11:49') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-10-13/18:21:49') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-10-14/00:06:49') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-10-14/00:09:49') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-10-19/05:32:48') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-10-19/05:50:48') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-10-19/05:58:48') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-10-19/06:46:48') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-10-19/09:15:48') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-10-19/22:01:48'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2012-12-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2012-11-03/11:38:47') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-11-03/23:27:47') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-11-05/01:18:47') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-11-06/15:42:47') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-11-17/10:47:46') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-11-20/06:27:45') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-11-23/07:21:45') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-11-25/06:49:45') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-11-26/09:15:44'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDIF ELSE BEGIN 
        bad_i = where((epoch_st EQ '2012-12-01/05:30:44') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-01/05:31:44') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-01/07:26:44') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-10/12:01:43') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-12/05:54:43') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-12/05:55:43') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-12/05:56:43') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-25/04:49:42') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-25/04:54:42') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-25/04:56:42') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-25/04:57:42') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-25/05:09:42') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-28/18:07:41') OR $ ; KDCS 05/06/2013
                      (epoch_st EQ '2012-12-28/20:11:41'), $ ; KDCS 05/06/2013
                      bad_count)
    ENDELSE 
ENDIF ELSE BEGIN                ; 2013
    IF temp_epoch LT '2013-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-01-06/15:19:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:29:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/15:30:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/15:36:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:39:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/15:45:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:47:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:54:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:56:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:59:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/16:24:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/16:35:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:02:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/17:04:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:06:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:08:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:09:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:19:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:24:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/18:20:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/18:22:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/18:29:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/22:23:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-16/22:50:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-27/16:44:39'), $ ; KDCS 03/13/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-02-12/02:42:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-12/06:08:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-12/14:36:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/13:54:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/14:50:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:03:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:18:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:33:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:41:37') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2013-02-19/15:45:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:53:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:56:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/16:02:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/16:20:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/16:22:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-20/12:34:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-21/06:42:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-21/06:47:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-21/06:50:37'), $ ; KDCS 04/16/2013
                      bad_count)
    ENDIF 
ENDELSE 
END 
