; Lorna Ellis
; 04/22/2013
; check_ns_outliers_a_v10.pro

; This is a procedure to check outliers for STA (just to make files
; smaller).

; input : epoch1   : dblarr of epoch times
; output: bad_i    : index of bad times
;         bad_count: number of bad times

PRO check_ns_outliers_a_v10, small_epoch1, bad_i, bad_count
compile_opt strictarrsubs

IF finite(small_epoch1[0] EQ 0) THEN BEGIN 
    good_i = where(finite(small_epoch1) EQ 1, good_count)
    IF good_count EQ 0 THEN stop ; problem! No good values. Shouldn't get here.
    temp_epoch = time_string(small_epoch1[good_i[0]])
ENDIF ELSE temp_epoch = time_string(small_epoch1[0])

epoch_st = time_string(small_epoch1)

IF temp_epoch LT '2008-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2007-05-31/19:23:21') OR $ ; KDCS 05/07/2013
                  (epoch_st EQ '2007-07-19/19:14:53') OR $ ; KDCS 04/17/2013
                  (epoch_st EQ '2007-08-24/10:02:49') OR $ ; KDCS 04/17/2013
                  (epoch_st EQ '2007-12-09/22:43:32'), $ ; KDCS 04/17/2013
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2009-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2008-02-25/13:08:20') OR $ ; KDCS 04/18/2013
                  (epoch_st EQ '2008-05-17/08:48:09') OR $ ; KDCS 04/18/2013
                  (epoch_st EQ '2008-07-07/07:36:01') OR $ ; KDCS 04/18/2013
                  (epoch_st EQ '2008-07-07/07:37:01') OR $ ; KDCS 04/18/2013
                  (epoch_st EQ '2008-09-30/11:57:50') OR $ ; KDCS 04/18/2013
                  (epoch_st EQ '2008-11-23/12:02:41') OR $ ; KDCS 04/18/2013
                  (epoch_st EQ '2008-11-24/00:56:41') OR $ ; KDCS 04/18/2013
                  (epoch_st EQ '2008-11-28/06:47:40'), $ ; KDCS 04/18/2013
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2010-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2009-02-13/03:16:29') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-03-09/14:39:25') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-04-03/16:34:22') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-04-11/02:56:21') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-05-08/09:09:17') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-06-05/22:28:14') OR $ ; KDCS 05/08/2013
                  (epoch_st EQ '2009-06-12/19:37:12') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-06-14/09:32:12') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-06-14/10:24:12') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-06-14/21:59:12') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-06-19/14:17:11') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-07-12/15:38:09') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-08-08/01:28:29') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-08-11/10:47:28') OR $ ; KDCS 05/08/2013
                  (epoch_st EQ '2009-08-14/17:55:28') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-08-18/12:27:27') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-09-01/15:35:26') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-09-12/14:55:25') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-10-28/17:58:19') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-11-09/04:56:17') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-11-09/13:40:17') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-11-09/22:38:17') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-11-13/14:40:16') OR $ ; KDCS 04/19/2013
                  (epoch_st EQ '2009-12-06/19:19:14'), $ ; KDCS 04/19/2013
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2011-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2010-01-23/17:24:07') OR $ ; KDCS 05/01/2013
                  (epoch_st EQ '2010-01-27/16:11:07') OR $ ; KDCS 05/01/2013
                  (epoch_st EQ '2010-03-28/20:57:59') OR $ ; KDCS 05/01/2013
                  (epoch_st EQ '2010-04-30/11:36:56') OR $ ; KDCS 05/01/2013
                  (epoch_st EQ '2010-05-08/04:22:55') OR $ ; KDCS 05/20/2013
                  (epoch_st EQ '2010-06-02/21:55:51') OR $ ; KDCS 05/01/2013
                  (epoch_st EQ '2010-06-12/19:51:51') OR $ ; KDCS 05/01/2013
                  (epoch_st EQ '2010-06-12/20:24:51') OR $ ; KDCS 05/01/2013
                  (epoch_st EQ '2010-06-30/14:49:49') OR $ ; KDCS 05/01/2013
                  (epoch_st EQ '2010-09-07/15:40:41') OR $ ; KDCS 05/01/2013
                  (epoch_st EQ '2010-09-11/08:00:41') OR $ ; KDCS 05/14/2013
                  (epoch_st EQ '2010-10-26/16:51:36') OR $ ; KDCS 05/14/2013
                  (epoch_st EQ '2010-12-31/16:05:29'), $ ;;KDCS 05/14/2013
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2012-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2011-05-23/02:32:17') OR $ ; KDCS 05/03/2013
                  (epoch_st eq '2011-06-05/19:02:16') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2011-06-28/16:47:16') OR $ ; KDCS 05/03/2013
                  (epoch_st EQ '2011-07-09/13:16:15') OR $ ; KDCS 05/03/2013
                  (epoch_st EQ '2011-07-09/13:26:15') OR $ ; KDCS 05/03/2013
                  (epoch_st EQ '2011-07-09/19:36:15') OR $ ; KDCS 05/03/2013
                  (epoch_st EQ '2011-08-29/12:38:11') OR $ ; KDCS 05/03/2013
                  (epoch_st EQ '2011-08-29/12:39:11') OR $ ; KDCS 05/03/2013
                  (epoch_st EQ '2011-10-03/08:45:16'), $ ; KDCS 05/03/2013
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2013-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2012-04-30/04:51:02') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2012-04-30/04:54:02') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2012-04-30/04:58:02') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2012-04-30/04:59:02') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2012-05-19/00:12:01') OR $ ; KDCS 05/06/2013
                  (epoch_st EQ '2012-06-18/12:33:00') OR $ ; KDCS 05/16/2013
                  (epoch_st EQ '2012-08-22/07:40:54') OR $ ; KDCS 05/06/2013
                  (epoch_st EQ '2012-11-12/11:43:46'), $ ; KDCS 05/16/2013
                  bad_count)
ENDIF ELSE BEGIN                ; 2013
    IF temp_epoch LT '2013-02-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-01-06/15:19:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:29:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/15:30:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/15:36:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:39:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/15:45:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:47:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:54:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:56:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/15:59:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/16:24:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/16:35:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:02:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/17:04:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:06:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:08:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:09:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:19:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/17:24:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/18:20:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-06/18:22:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/18:29:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-06/22:23:40') OR $ ; KDCS 03/26/2013
                      (epoch_st EQ '2013-01-16/22:50:40') OR $ ; KDCS 03/13/2013
                      (epoch_st EQ '2013-01-27/16:44:39'), $ ; KDCS 03/13/2013
                      bad_count)
    ENDIF ELSE IF temp_epoch LT '2013-03-01/00:00:00' THEN BEGIN 
        bad_i = where((epoch_st EQ '2013-02-12/02:42:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-12/06:08:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-12/14:36:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/13:54:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/14:50:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:03:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:18:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:33:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:41:37') OR $ ; KDCS 04/17/2013
                      (epoch_st EQ '2013-02-19/15:45:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:53:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/15:56:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/16:02:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/16:20:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-19/16:22:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-20/12:34:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-21/06:42:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-21/06:47:37') OR $ ; KDCS 04/16/2013
                      (epoch_st EQ '2013-02-21/06:50:37'), $ ; KDCS 04/16/2013
                      bad_count)
    ENDIF 
ENDELSE 
END 
