; Lorna Ellis
; 01/15/2014
; check_ns_outliers_a.pro

; This is a procedure to check outliers for STA (just to make files
; smaller).

; input : epoch1   : dblarr of epoch times
; output: bad_i    : index of bad times
;         bad_count: number of bad times

; This is for with V09 which uses 'ESA_table_A_2009_08_17.txt'. There
; is also a V10 option that was created for if we switch to 'ESA_table_A_Toni_fall_2012_v3.txt'.

PRO check_ns_outliers_a, small_epoch1, bad_i, bad_count
compile_opt strictarrsubs

IF finite(small_epoch1[0] EQ 0) THEN BEGIN 
    good_i = where(finite(small_epoch1) EQ 1, good_count)
    IF good_count EQ 0 THEN stop ; problem! No good values. Shouldn't get here.
    temp_epoch = time_string(small_epoch1[good_i[0]])
ENDIF ELSE temp_epoch = time_string(small_epoch1[0])

epoch_st = time_string(small_epoch1)

IF temp_epoch LT '2012-01-01/00:00:00' THEN BEGIN 
    bad_count = 0
ENDIF ELSE IF temp_epoch LT '2013-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2012-04-30/04:51:02') OR $ ; KDCS 06/08/2013
                  (epoch_st EQ '2012-04-30/04:54:02') OR $ ; KDCS 06/08/2013
                  (epoch_st EQ '2012-04-30/04:59:02'), $ ; KDCS 06/08/2013
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2014-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2013-11-06/01:26:13') OR $ ; KDCS 01/14/2014
                  (epoch_st EQ '2013-11-06/01:27:13'), $ ; KDCS 01/14/2014
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2015-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2014-03-14/23:31:54') OR $ ; KDCS 06/02/2014
                  (epoch_st EQ '2014-05-11/14:40:47') OR $ ; KDCS 07/10/2014
                  (epoch_st EQ '2014-08-03/00:24:38') OR $ ; KDCS 12/03/2014
                  (epoch_st EQ '2014-08-11/21:07:37') OR $ ; KDCS 12/03/2014
                  (epoch_st EQ '2014-12-03/20:10:25'), $ ; KDCS 02/15/2015
                  bad_count)
ENDIF ELSE IF temp_epoch LT '2016-01-01/00:00:00' THEN BEGIN 
    bad_i = where((epoch_st EQ '2015-11-19/00:38:23') OR $ ; KDCS 01/14/2014
                  (epoch_st EQ '2015-11-22/01:30:22'), $ ; KDCS 01/14/2014
                  bad_count)
ENDIF 
END 
