; Lorna Ellis
; July 23, 2007
; calculate_pri0_pri0_3_ratio.pro

; This program reads a Level1 CDF and creates a daily ratio of
; sw pri 0 to sw pro 0-3. 

; Input: satellite ('A' or 'B')
; Output: ratio (array of 128 values)

; 11/07/2007 Added check for if only one record.
; 05/26/2009 Put in splat environment. Changed input to sat
; 05/27/2015 Add closed_entrance keyword.
; 05/29/2015 Check for -1 or infinite values.

PRO calculate_pri0_pri0_3_ratio, sat, ratio, closed_entrance = closed_entrance
compile_opt strictarrsubs

prod = sat+'10/0-3' ; sw priority
pla_plot_en_spec, [prod], 'Counts', /nodisplay

; find each priority
pri_0_name = 'ST'+sat+'_PLA_ENSPEC_COUNTS_SW_PRIORITY_00'
pri_1_name = 'ST'+sat+'_PLA_ENSPEC_COUNTS_SW_PRIORITY_01'
pri_2_name = 'ST'+sat+'_PLA_ENSPEC_COUNTS_SW_PRIORITY_02'
pri_3_name = 'ST'+sat+'_PLA_ENSPEC_COUNTS_SW_PRIORITY_03'
get_data, pri_0_name, pri_t, pri_0
get_data, pri_1_name, pri_t, pri_1
get_data, pri_2_name, pri_t, pri_2
get_data, pri_3_name, pri_t, pri_3

; remove fill values
invalid = where(pri_0 EQ -1, count)
IF count GT 0 THEN pri_0[invalid] = 0
invalid = where(pri_1 EQ -1, count)
IF count GT 0 THEN pri_1[invalid] = 0
invalid = where(pri_2 EQ -1, count)
IF count GT 0 THEN pri_2[invalid] = 0
invalid = where(pri_3 EQ -1, count)
IF count GT 0 THEN pri_3[invalid] = 0
invalid = where(finite(pri_0) EQ 0, count)
IF count GT 0 THEN pri_0[invalid] = 0
invalid = where(finite(pri_1) EQ 0, count)
IF count GT 0 THEN pri_1[invalid] = 0
invalid = where(finite(pri_2) EQ 0, count)
IF count GT 0 THEN pri_2[invalid] = 0
invalid = where(finite(pri_3) EQ 0, count)
IF count GT 0 THEN pri_3[invalid] = 0

IF keyword_set(closed_entrance) THEN BEGIN 
    IF closed_entrance EQ 1 THEN BEGIN 
        esa_cm_dc = 'ST'+sat+'_Analog_HK_esa_cm_dc'
        get_data, esa_cm_dc, hk_t, hk_d
        bad_i = where(hk_d LT 50, bad_count)
        FOR ii = 0L, bad_count-1 DO BEGIN
            index = bad_i[ii]
            invalid = where((hk_t[index] GE pri_t) AND (hk_t[index] LT (pri_t+300)), count)
            IF count GT 0 THEN BEGIN 
                pri_0[invalid, *] = 0
                pri_1[invalid, *] = 0
                pri_2[invalid, *] = 0
                pri_3[invalid, *] = 0
            ENDIF 
        ENDFOR 
    ENDIF 
ENDIF 

; sum over time
IF n_elements(pri_0) GT 128 THEN BEGIN 
    pri_0 = total(pri_0, 1)
    pri_1 = total(pri_1, 1)
    pri_2 = total(pri_2, 1)
    pri_3 = total(pri_3, 1)
ENDIF 

; add
total = pri_0+pri_1+pri_2+pri_3

; divide
ratio = pri_0/total
END 
