;+
;PROCEDURE: calc_proton_raw_ascii_norm
;PURPOSE: A subroutine of calc_proton_bulk_v2.  Raw results are printed to an ascii file.
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 25 November 2009
;
;MODIFICATION HISTORY:
;	23 November 2009:  created
;	25 November 2009:  added column to alpha output indicating likely s or main channel data 
;
;-



PRO calc_proton_raw_ascii_norm, sat, epoch5, num_records5, density, avg_v, temp_K, v_th, good_fit, std_error, NS

	TAB = STRING(9B)
	label_time = time_struct(epoch5(0))
	label_year = STRING(label_time.year, FORMAT = '(I04)')
	label_month = STRING(label_time.month, FORMAT = '(I02)')
	label_day = STRING(label_time.date, FORMAT = '(I02)')
	outfile_5 = '~/splat/splat_user/Output/'+'PLA_ST'+sat+'_L2_1DMax_'+label_year+label_month+label_day+'_'+string(label_time.doy, format = '(I3.3)')+'_5min_raw.txt'
	openw, out_lun_5, outfile_5, /GET_LUN
	line = ' '
	temp_string = 'YEAR'+tab+'DOY'+tab+'hour'+tab+'min'+tab+'sec'+tab+'date and time'+tab+$
		'ST'+sat+' Np [1/cc]'+tab+'ST'+sat+' Vp [km/s]'+tab+'ST'+sat+' Tkin [deg K]'+tab+ $
		'ST'+sat+' v_th [km/s]'+tab+'N/S Angle'+tab+'Red. Chi_sq'+tab+'Error'
	printf, out_lun_5, temp_string

	FOR nn=0L, num_records5-1 DO BEGIN

	;IF FINITE(avg_v(nn)) EQ 1 THEN avg_v(nn) = ROUND(avg_v(nn))

		apid_time = time_struct(epoch5(nn))
		YEAR = STRING(apid_time.year, FORMAT = '(I04)')
		DOY = STRING(apid_time.doy, FORMAT = '(I03)')
		HOUR = STRING(apid_time.hour, FORMAT = '(I02)')
		MIN = STRING (apid_time.min, FORMAT = '(I02)')
		SEC = STRING(apid_time.sec, FORMAT = '(I2.2)')
		Np = STRING(density(nn), FORMAT = '(F0.2)')
		V_bulk = STRING(avg_v(nn), FORMAT = '(F0.1)')
		T = STRING(temp_K(nn), FORMAT = '(E10.2)')
		V_TEMP = STRING(v_th(nn), FORMAT = '(F0.1)')
		FIT_GOOD = STRING(good_fit(nn), FORMAT = '(F0.2)')
		ERROR = STRING(std_error(nn), FORMAT = '(I1)')
		NS_angle = STRING(NS(nn), FORMAT = '(F0.1)')
		
		;temp_string = YEAR+tab+DOY+tab+HOUR+tab+MIN+tab+SEC+tab+STRING(apid_time.month, format ='(I2.2)')+'/'+$
		;STRING(apid_time.date, format = '(I2.2)')+'/'+string(apid_time.year, format = '(I4.4)')+' '+$
		;STRING(apid_time.hour, format = '(I2.2)')+':'+STRING(apid_time.min, format = '(I2.2)')+':'+$
		;STRING(apid_time.sec, format = '(I2.2)')+tab+Np+tab+V_bulk+tab+T+tab+V_TEMP+tab+NS_angle+tab+FIT_GOOD+tab+ERROR
		
		temp_string = YEAR+tab+DOY+tab+HOUR+tab+MIN+tab+SEC+tab+STRING(apid_time.year, format ='(I04)')+'-'+$
		STRING(apid_time.month, format = '(I02)')+'-'+string(apid_time.date, format = '(I02)')+'/'+$
		STRING(apid_time.hour, format = '(I02)')+':'+STRING(apid_time.min, format = '(I02)')+':'+$
		STRING(apid_time.sec, format = '(I02)')+tab+Np+tab+V_bulk+tab+T+tab+V_TEMP+tab+NS_angle+tab+FIT_GOOD+tab+ERROR
		IF apid_time.year NE 1970 THEN printf, out_lun_5, temp_string
	ENDFOR

	CLOSE, out_lun_5
	FREE_LUN, out_lun_5

END


