;+
;PROCEDURE: calc_proton_raw_ascii
;PURPOSE: A subroutine of calc_proton_bulk_v2.  Raw results are printed to an ascii file.
;
;CREATED BY: K. Simunac
;
;LAST MODIFICATION: 25 November 2009
;
;MODIFICATION HISTORY:
;	23 November 2009:  created
;	25 November 2009:  added column to alpha output indicating likely s or main channel data 
;
;-



PRO calc_proton_raw_ascii, sat, epoch1, num_records1, density, avg_v, temp_K, v_th, good_fit, $
	avg_v_alpha, density_alpha, v_th_alpha, good_fit_alpha, expected_peak_channel
compile_opt strictarrsubs

	TAB = STRING(9B)
	label_time = time_struct(epoch1(0))
	label_year = STRING(label_time.year, FORMAT = '(I04)')
	label_month = STRING(label_time.month, FORMAT = '(I02)')
	label_day = STRING(label_time.date, FORMAT = '(I02)')
	outfile_5 = '/home/ksimunac/Output/'+'PLA_ST'+sat+'_L2_1DMax_'+label_year+label_month+label_day+'_'+string(label_time.doy, format = '(I3.3)')+'_raw.txt'
	openw, out_lun_5, outfile_5, /GET_LUN
	line = ' '
	temp_string = 'YEAR'+tab+'DOY'+tab+'hour'+tab+'min'+tab+'sec'+tab+'date and time'+tab+$
		'ST'+sat+' Np [1/cc]'+tab+'ST'+sat+' Vp [km/s]'+tab+'ST'+sat+' Tkin [deg K]'+tab+ $
		'ST'+sat+' v_th [km/s]'+tab+'Red. Chi_sq'+tab+'Va [km/s]'+tab+'Na [1/cc]'+tab+'Vtha [km/s]'+tab+'expected peak channel'
	printf, out_lun_5, temp_string

	FOR nn=0L, num_records1-1 DO BEGIN
		apid_time = time_struct(epoch1(nn))
		YEAR = STRING(apid_time.year, FORMAT = '(I04)')
		DOY = STRING(apid_time.doy, FORMAT = '(I03)')
		HOUR = STRING(apid_time.hour, FORMAT = '(I02)')
		MIN = STRING (apid_time.min, FORMAT = '(I02)')
		SEC = STRING(apid_time.sec, FORMAT = '(I2.2)')
		Np = STRING(density(nn), FORMAT = '(F0.2)')
		V_bulk = STRING(round(avg_v(nn)), FORMAT = '(I4)')
		T = STRING(temp_K(nn), FORMAT = '(E10.2)')
		V_TEMP = STRING(v_th(nn), FORMAT = '(F0.1)')
		FIT_GOOD = STRING(good_fit(nn), FORMAT = '(F0.2)')
		V_alpha = STRING(round(avg_v_alpha(nn)), FORMAT ='(I4)')
		Na = STRING(density_alpha(nn), FORMAT = '(F0.3)')
		Vtha = STRING(v_th_alpha(nn), FORMAT = '(F0.1)')
		A_fit_good = STRING(good_fit_alpha(nn), FORMAT = '(F0.2)')
		expected_peak = STRING(expected_peak_channel(nn), FORMAT = '(I2)')

		temp_string = YEAR+tab+DOY+tab+HOUR+tab+MIN+tab+SEC+tab+STRING(apid_time.month, format ='(I2.2)')+'/'+$
		STRING(apid_time.date, format = '(I2.2)')+'/'+string(apid_time.year, format = '(I4.4)')+' '+$
		STRING(apid_time.hour, format = '(I2.2)')+':'+STRING(apid_time.min, format = '(I2.2)')+':'+$
		STRING(apid_time.sec, format = '(I2.2)')+tab+Np+tab+V_bulk+tab+T+tab+V_TEMP+tab+FIT_GOOD+tab+V_alpha+tab+Na+tab+Vtha+tab+expected_peak

		IF apid_time.year NE 1970 THEN printf, out_lun_5, temp_string
	ENDFOR

	CLOSE, out_lun_5
	FREE_LUN, out_lun_5

END


